/*
 * Decompiled with CFR 0.152.
 */
package elucent.eidolon.ritual;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import elucent.eidolon.Registry;
import elucent.eidolon.codex.Page;
import elucent.eidolon.codex.RitualPage;
import elucent.eidolon.gui.jei.RecipeWrappers;
import elucent.eidolon.ritual.AllureRitual;
import elucent.eidolon.ritual.CrystalRitual;
import elucent.eidolon.ritual.DaylightRitual;
import elucent.eidolon.ritual.DeceitRitual;
import elucent.eidolon.ritual.HealthRequirement;
import elucent.eidolon.ritual.IRequirement;
import elucent.eidolon.ritual.IRitualItemFocus;
import elucent.eidolon.ritual.ItemRequirement;
import elucent.eidolon.ritual.MoonlightRitual;
import elucent.eidolon.ritual.MultiItemSacrifice;
import elucent.eidolon.ritual.PurifyRitual;
import elucent.eidolon.ritual.RepellingRitual;
import elucent.eidolon.ritual.Ritual;
import elucent.eidolon.ritual.SanguineRitual;
import elucent.eidolon.ritual.SummonRitual;
import elucent.eidolon.util.StackUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.entity.EntityType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionUtils;
import net.minecraft.potion.Potions;
import net.minecraft.tags.ITag;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.Tags;

public class RitualRegistry {
    static Map<ResourceLocation, Ritual> rituals = new HashMap<ResourceLocation, Ritual>();
    static BiMap<Object, Ritual> matches = HashBiMap.create();
    public static Ritual CRYSTAL_RITUAL;
    public static Ritual SUMMON_ZOMBIE;
    public static Ritual SUMMON_SKELETON;
    public static Ritual SUMMON_PHANTOM;
    public static Ritual SUMMON_HUSK;
    public static Ritual SUMMON_DROWNED;
    public static Ritual SUMMON_STRAY;
    public static Ritual SUMMON_WITHER_SKELETON;
    public static Ritual SUMMON_WRAITH;
    public static Ritual ALLURE_RITUAL;
    public static Ritual REPELLING_RITUAL;
    public static Ritual DECEIT_RITUAL;
    public static Ritual DAYLIGHT_RITUAL;
    public static Ritual MOONLIGHT_RITUAL;
    public static Ritual PURIFY_RITUAL;
    public static Ritual SANGUINE_SWORD;
    public static Ritual SANGUINE_AMULET;

    public static void register(ItemStack sacrifice, Ritual ritual) {
        ResourceLocation name = ritual.getRegistryName();
        assert (name != null);
        rituals.put(name, ritual);
        matches.put((Object)sacrifice, (Object)ritual);
    }

    public static Ritual register(Item sacrifice, Ritual ritual) {
        ResourceLocation name = ritual.getRegistryName();
        assert (name != null);
        rituals.put(name, ritual);
        matches.put((Object)sacrifice, (Object)ritual);
        return ritual;
    }

    public static Ritual register(Block sacrifice, Ritual ritual) {
        ResourceLocation name = ritual.getRegistryName();
        assert (name != null);
        rituals.put(name, ritual);
        matches.put((Object)Item.func_150898_a((Block)sacrifice), (Object)ritual);
        return ritual;
    }

    public static Ritual register(ITag<Item> sacrifice, Ritual ritual) {
        ResourceLocation name = ritual.getRegistryName();
        assert (name != null);
        rituals.put(name, ritual);
        matches.put(sacrifice, (Object)ritual);
        return ritual;
    }

    public static Ritual register(MultiItemSacrifice sacrifice, Ritual ritual) {
        ResourceLocation name = ritual.getRegistryName();
        assert (name != null);
        rituals.put(name, ritual);
        matches.put((Object)sacrifice, (Object)ritual);
        return ritual;
    }

    public static Page getDefaultPage(Ritual ritual, Object sacrifice) {
        ArrayList<RitualPage.RitualIngredient> inputs = new ArrayList<RitualPage.RitualIngredient>();
        ArrayList<ItemStack> foci = new ArrayList<ItemStack>();
        if (sacrifice instanceof MultiItemSacrifice) {
            for (Object o : ((MultiItemSacrifice)sacrifice).items) {
                foci.add(StackUtil.stackFromObject(o));
            }
        }
        int slot = 0;
        for (IRequirement r : ritual.getRequirements()) {
            if (r instanceof ItemRequirement) {
                inputs.add(new RitualPage.RitualIngredient(StackUtil.stackFromObject(((ItemRequirement)r).getMatch()), false));
            }
            ++slot;
        }
        Iterator iter = foci.iterator();
        block2: while (iter.hasNext()) {
            ItemStack focus = (ItemStack)iter.next();
            for (RitualPage.RitualIngredient input : inputs) {
                if (!ItemStack.func_179545_c((ItemStack)focus, (ItemStack)input.stack) || !ItemStack.func_77970_a((ItemStack)focus, (ItemStack)input.stack) || input.isFocus) continue;
                input.isFocus = true;
                iter.remove();
                continue block2;
            }
        }
        ItemStack center = StackUtil.stackFromObject(sacrifice instanceof MultiItemSacrifice ? ((MultiItemSacrifice)sacrifice).main : sacrifice);
        return new RitualPage(ritual, center, inputs.toArray(new RitualPage.RitualIngredient[inputs.size()]));
    }

    public static List<RecipeWrappers.RitualRecipe> getWrappedRecipes() {
        ArrayList<RecipeWrappers.RitualRecipe> wrappers = new ArrayList<RecipeWrappers.RitualRecipe>();
        for (Map.Entry<ResourceLocation, Ritual> entry : rituals.entrySet()) {
            Object sacrifice = matches.inverse().getOrDefault((Object)entry.getValue(), null);
            Page page = null;
            wrappers.add(new RecipeWrappers.RitualRecipe(entry.getValue(), page, sacrifice));
        }
        return wrappers;
    }

    public static Ritual find(ResourceLocation name) {
        return rituals.get(name);
    }

    static boolean matches(World world, BlockPos pos, Object match, ItemStack sacrifice) {
        if (match instanceof ItemStack) {
            if (ItemStack.func_77989_b((ItemStack)((ItemStack)match), (ItemStack)sacrifice)) {
                return true;
            }
        } else if (match instanceof Block) {
            if (Item.func_150898_a((Block)((Block)match)) == sacrifice.func_77973_b()) {
                return true;
            }
        } else if (match instanceof Item) {
            if ((Item)match == sacrifice.func_77973_b()) {
                return true;
            }
        } else if (match instanceof ITag) {
            if (((ITag)match).func_230235_a_((Object)sacrifice.func_77973_b())) {
                return true;
            }
        } else if (match instanceof MultiItemSacrifice) {
            if (!RitualRegistry.matches(world, pos, ((MultiItemSacrifice)match).main, sacrifice)) {
                return false;
            }
            ArrayList<Object> matches = new ArrayList<Object>();
            matches.addAll(((MultiItemSacrifice)match).items);
            ArrayList<ItemStack> items = new ArrayList<ItemStack>();
            List<IRitualItemFocus> foci = Ritual.getTilesWithinAABB(IRitualItemFocus.class, world, Ritual.getDefaultBounds(pos));
            for (IRitualItemFocus focus : foci) {
                items.add(focus.provide());
            }
            if (items.size() != matches.size()) {
                return false;
            }
            for (int i = 0; i < matches.size(); ++i) {
                int before = matches.size();
                for (int j = 0; j < items.size(); ++j) {
                    ItemStack item;
                    Object m = matches.get(i);
                    if (!RitualRegistry.matches(world, pos, m, item = (ItemStack)items.get(j))) continue;
                    matches.remove(i--);
                    items.remove(j--);
                    break;
                }
                if (matches.size() != before) continue;
                return false;
            }
            return matches.size() == 0;
        }
        return false;
    }

    public static Ritual find(World world, BlockPos pos, ItemStack sacrifice) {
        for (Map.Entry entry : matches.entrySet()) {
            if (!RitualRegistry.matches(world, pos, entry.getKey(), sacrifice)) continue;
            return (Ritual)entry.getValue();
        }
        return null;
    }

    public static void init() {
        CRYSTAL_RITUAL = RitualRegistry.register(Items.field_196106_bc, new CrystalRitual().setRegistryName("eidolon", "crystal").addRequirement(new ItemRequirement((ITag<Item>)Tags.Items.DUSTS_REDSTONE)).addRequirement(new ItemRequirement((ITag<Item>)Tags.Items.DUSTS_REDSTONE)));
        SUMMON_ZOMBIE = RitualRegistry.register(new MultiItemSacrifice(Items.field_196155_l, Items.field_151078_bh), new SummonRitual(EntityType.field_200725_aD).setRegistryName("eidolon", "summon_zombie").addRequirement(new ItemRequirement((Item)Registry.SOUL_SHARD.get())).addRequirement(new ItemRequirement(Items.field_151078_bh)).addRequirement(new ItemRequirement(Items.field_151078_bh)));
        SUMMON_SKELETON = RitualRegistry.register(new MultiItemSacrifice(Items.field_196155_l, Items.field_151103_aS), new SummonRitual(EntityType.field_200741_ag).setRegistryName("eidolon", "summon_skeleton").addRequirement(new ItemRequirement((Item)Registry.SOUL_SHARD.get())).addRequirement(new ItemRequirement(Items.field_151103_aS)).addRequirement(new ItemRequirement(Items.field_151103_aS)));
        SUMMON_PHANTOM = RitualRegistry.register(new MultiItemSacrifice(Items.field_196155_l, Items.field_204840_eX), new SummonRitual(EntityType.field_203097_aH).setRegistryName("eidolon", "summon_phantom").addRequirement(new ItemRequirement((Item)Registry.SOUL_SHARD.get())).addRequirement(new ItemRequirement(Items.field_204840_eX)).addRequirement(new ItemRequirement(Items.field_204840_eX)));
        SUMMON_WITHER_SKELETON = RitualRegistry.register(new MultiItemSacrifice(Items.field_196155_l, Blocks.field_150425_aM), new SummonRitual(EntityType.field_200722_aA).setRegistryName("eidolon", "summon_wither_skeleton").addRequirement(new ItemRequirement(Items.field_151103_aS)).addRequirement(new ItemRequirement(Blocks.field_150425_aM)).addRequirement(new ItemRequirement((Item)Registry.SOUL_SHARD.get())));
        SUMMON_HUSK = RitualRegistry.register(new MultiItemSacrifice(Items.field_196155_l, Tags.Items.SAND), new SummonRitual(EntityType.field_200763_C).setRegistryName("eidolon", "summon_husk").addRequirement(new ItemRequirement(Items.field_151078_bh)).addRequirement(new ItemRequirement((ITag<Item>)Tags.Items.SAND)).addRequirement(new ItemRequirement((Item)Registry.SOUL_SHARD.get())));
        SUMMON_DROWNED = RitualRegistry.register(new MultiItemSacrifice(Items.field_196155_l, Tags.Items.DUSTS_PRISMARINE), new SummonRitual(EntityType.field_204724_o).setRegistryName("eidolon", "summon_drowned").addRequirement(new ItemRequirement(Items.field_151078_bh)).addRequirement(new ItemRequirement((ITag<Item>)Tags.Items.DUSTS_PRISMARINE)).addRequirement(new ItemRequirement((Item)Registry.SOUL_SHARD.get())));
        SUMMON_STRAY = RitualRegistry.register(new MultiItemSacrifice(Items.field_196155_l, Items.field_151007_F), new SummonRitual(EntityType.field_200750_ap).setRegistryName("eidolon", "summon_stray").addRequirement(new ItemRequirement(Items.field_151103_aS)).addRequirement(new ItemRequirement(Items.field_151007_F)).addRequirement(new ItemRequirement((Item)Registry.SOUL_SHARD.get())));
        SUMMON_WRAITH = RitualRegistry.register(new MultiItemSacrifice(Items.field_196155_l, Registry.TATTERED_CLOTH.get()), new SummonRitual((EntityType)Registry.WRAITH.get()).setRegistryName("eidolon", "summon_wraith").addRequirement(new ItemRequirement((Item)Registry.SOUL_SHARD.get())).addRequirement(new ItemRequirement((Item)Registry.TATTERED_CLOTH.get())).addRequirement(new ItemRequirement((Item)Registry.TATTERED_CLOTH.get())));
        DECEIT_RITUAL = RitualRegistry.register((ITag<Item>)Tags.Items.GEMS_EMERALD, new DeceitRitual().setRegistryName("eidolon", "deceit").addRequirement(new ItemRequirement((ITag<Item>)Tags.Items.GEMS_EMERALD)).addRequirement(new ItemRequirement(Items.field_151071_bq)).addRequirement(new ItemRequirement((ITag<Item>)Tags.Items.MUSHROOMS)).addRequirement(new ItemRequirement((Item)Registry.SOUL_SHARD.get())).addRequirement(new ItemRequirement((Item)Registry.SOUL_SHARD.get())));
        ALLURE_RITUAL = RitualRegistry.register(Items.field_221912_fn, new AllureRitual().setRegistryName("eidolon", "allure").addRequirement(new ItemRequirement(Items.field_151153_ao)).addRequirement(new ItemRequirement(Items.field_222078_li)).addRequirement(new ItemRequirement(Items.field_222078_li)).addRequirement(new ItemRequirement((Item)Registry.SOUL_SHARD.get())).addRequirement(new ItemRequirement((Item)Registry.SOUL_SHARD.get())));
        REPELLING_RITUAL = RitualRegistry.register(Items.field_205157_eZ, new RepellingRitual().setRegistryName("eidolon", "repelling").addRequirement(new ItemRequirement((ITag<Item>)Tags.Items.INGOTS_IRON)).addRequirement(new ItemRequirement(Items.field_151116_aA)).addRequirement(new ItemRequirement((ITag<Item>)Tags.Items.GEMS_QUARTZ)).addRequirement(new ItemRequirement((Item)Registry.SOUL_SHARD.get())).addRequirement(new ItemRequirement((Item)Registry.SOUL_SHARD.get())));
        DAYLIGHT_RITUAL = RitualRegistry.register(Items.field_221908_fl, new DaylightRitual().setRegistryName("eidolon", "daylight").addRequirement(new ItemRequirement(Items.field_196155_l)).addRequirement(new ItemRequirement(Items.field_151014_N)).addRequirement(new ItemRequirement((Item)Registry.SOUL_SHARD.get())).addRequirement(new ItemRequirement((Item)Registry.SOUL_SHARD.get())));
        MOONLIGHT_RITUAL = RitualRegistry.register((ITag<Item>)Tags.Items.DYES_BLACK, new MoonlightRitual().setRegistryName("eidolon", "moonlight").addRequirement(new ItemRequirement(Items.field_151126_ay)).addRequirement(new ItemRequirement(Items.field_151070_bp)).addRequirement(new ItemRequirement((Item)Registry.SOUL_SHARD.get())).addRequirement(new ItemRequirement((Item)Registry.SOUL_SHARD.get())));
        PURIFY_RITUAL = RitualRegistry.register(Items.field_151060_bw, new PurifyRitual().setRegistryName("eidolon", "purify").addRequirement(new ItemRequirement((Block)Registry.ENCHANTED_ASH.get())).addRequirement(new ItemRequirement((Block)Registry.ENCHANTED_ASH.get())).addRequirement(new ItemRequirement(PotionUtils.func_185188_a((ItemStack)new ItemStack((IItemProvider)Items.field_151068_bn), (Potion)Potions.field_185250_v))).addRequirement(new ItemRequirement((Item)Registry.SOUL_SHARD.get())).addRequirement(new ItemRequirement((Item)Registry.SOUL_SHARD.get())));
        SANGUINE_SWORD = RitualRegistry.register(new MultiItemSacrifice(PotionUtils.func_185188_a((ItemStack)new ItemStack((IItemProvider)Items.field_151068_bn), (Potion)Potions.field_185252_x), Items.field_151040_l), new SanguineRitual(new ItemStack((IItemProvider)Registry.SAPPING_SWORD.get())).setRegistryName("eidolon", "sanguine_sapping_sword").addRequirement(new ItemRequirement((Item)Registry.SHADOW_GEM.get())).addRequirement(new ItemRequirement((Item)Registry.SOUL_SHARD.get())).addRequirement(new ItemRequirement((Item)Registry.SOUL_SHARD.get())).addRequirement(new ItemRequirement(Items.field_151040_l)).addRequirement(new ItemRequirement(Items.field_151075_bm)).addRequirement(new ItemRequirement(Items.field_151075_bm)).addRequirement(new ItemRequirement(Items.field_151073_bk)).addRequirement(new HealthRequirement(20.0f)));
        SANGUINE_AMULET = RitualRegistry.register(new MultiItemSacrifice(PotionUtils.func_185188_a((ItemStack)new ItemStack((IItemProvider)Items.field_151068_bn), (Potion)Potions.field_185252_x), Registry.BASIC_AMULET.get()), new SanguineRitual(new ItemStack((IItemProvider)Registry.SANGUINE_AMULET.get())).setRegistryName("eidolon", "sanguine_sanguine_amulet").addRequirement(new ItemRequirement((ITag<Item>)Tags.Items.GEMS_DIAMOND)).addRequirement(new ItemRequirement((ITag<Item>)Tags.Items.DUSTS_REDSTONE)).addRequirement(new ItemRequirement((ITag<Item>)Tags.Items.DUSTS_REDSTONE)).addRequirement(new ItemRequirement((Item)Registry.BASIC_AMULET.get())).addRequirement(new ItemRequirement((ITag<Item>)Tags.Items.DUSTS_REDSTONE)).addRequirement(new ItemRequirement((ITag<Item>)Tags.Items.DUSTS_REDSTONE)).addRequirement(new ItemRequirement((Item)Registry.LESSER_SOUL_GEM.get())).addRequirement(new HealthRequirement(40.0f)));
    }
}

