/*
 * Decompiled with CFR 0.152.
 */
package elucent.eidolon.recipe;

import elucent.eidolon.Registry;
import elucent.eidolon.codex.CruciblePage;
import elucent.eidolon.codex.Page;
import elucent.eidolon.gui.jei.RecipeWrappers;
import elucent.eidolon.recipe.CrucibleRecipe;
import elucent.eidolon.tile.CrucibleTileEntity;
import elucent.eidolon.util.StackUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.Tags;

public class CrucibleRegistry {
    static Map<ResourceLocation, Page> linkedPages = new HashMap<ResourceLocation, Page>();
    static Map<ResourceLocation, CrucibleRecipe> recipes = new HashMap<ResourceLocation, CrucibleRecipe>();

    public static void register(CrucibleRecipe recipe) {
        ResourceLocation loc = recipe.getRegistryName();
        assert (loc != null);
        recipes.put(loc, recipe);
    }

    public static void condense(List<ItemStack> stacks) {
        Iterator<ItemStack> iter = stacks.iterator();
        ItemStack last = ItemStack.field_190927_a;
        while (iter.hasNext()) {
            ItemStack i = iter.next();
            if (!ItemStack.func_179545_c((ItemStack)i, (ItemStack)last) || !ItemStack.func_77970_a((ItemStack)i, (ItemStack)last) || last.func_190916_E() + i.func_190916_E() > last.func_77976_d()) {
                last = i;
                continue;
            }
            last.func_190917_f(i.func_190916_E());
            iter.remove();
        }
    }

    public static Page getDefaultPage(CrucibleRecipe recipe) {
        ArrayList<CruciblePage.CrucibleStep> steps = new ArrayList<CruciblePage.CrucibleStep>();
        for (CrucibleRecipe.Step step : recipe.getSteps()) {
            List<ItemStack> stacks = StackUtil.stacksFromObjects(step.matches);
            CrucibleRegistry.condense(stacks);
            steps.add(new CruciblePage.CrucibleStep(step.stirs, stacks.toArray(new ItemStack[stacks.size()])));
        }
        return new CruciblePage(recipe.result.func_77946_l(), steps.toArray(new CruciblePage.CrucibleStep[steps.size()]));
    }

    public static void linkPage(ResourceLocation recipe, Page page) {
        linkedPages.put(recipe, page);
    }

    public static List<RecipeWrappers.Crucible> getWrappedRecipes() {
        ArrayList<RecipeWrappers.Crucible> wrappers = new ArrayList<RecipeWrappers.Crucible>();
        for (Map.Entry<ResourceLocation, CrucibleRecipe> entry : recipes.entrySet()) {
            Page page = linkedPages.getOrDefault(entry.getKey(), null);
            wrappers.add(new RecipeWrappers.Crucible(entry.getValue(), page));
        }
        return wrappers;
    }

    public static CrucibleRecipe find(ResourceLocation loc) {
        return recipes.get(loc);
    }

    public static CrucibleRecipe find(List<CrucibleTileEntity.CrucibleStep> steps) {
        for (CrucibleRecipe recipe : recipes.values()) {
            if (!recipe.matches(steps)) continue;
            return recipe;
        }
        return null;
    }

    public static void init() {
        CrucibleRegistry.register(new CrucibleRecipe(new ItemStack((IItemProvider)Registry.ARCANE_GOLD_INGOT.get(), 2)).setRegistryName("eidolon", "arcane_gold").addStep(Tags.Items.DUSTS_REDSTONE, Tags.Items.DUSTS_REDSTONE, Registry.SOUL_SHARD.get()).addStep(Tags.Items.INGOTS_GOLD, Tags.Items.INGOTS_GOLD));
        CrucibleRegistry.register(new CrucibleRecipe(new ItemStack((IItemProvider)Registry.LESSER_SOUL_GEM.get())).setRegistryName("eidolon", "lesser_soul_gem").addStep(Tags.Items.DUSTS_REDSTONE, Tags.Items.DUSTS_REDSTONE, Tags.Items.GEMS_LAPIS, Tags.Items.GEMS_LAPIS).addStirringStep(2, Registry.SOUL_SHARD.get(), Registry.SOUL_SHARD.get(), Registry.SOUL_SHARD.get(), Registry.SOUL_SHARD.get()).addStep(Tags.Items.GEMS_QUARTZ));
        CrucibleRegistry.register(new CrucibleRecipe(new ItemStack((IItemProvider)Registry.SHADOW_GEM.get())).setRegistryName("eidolon", "shadow_gem").addStep(Items.field_151044_h).addStirringStep(1, Items.field_151073_bk, Registry.DEATH_ESSENCE.get()).addStirringStep(1, Registry.SOUL_SHARD.get(), Registry.SOUL_SHARD.get(), Registry.DEATH_ESSENCE.get()).addStep(Tags.Items.GEMS_DIAMOND));
        CrucibleRegistry.register(new CrucibleRecipe(new ItemStack((IItemProvider)Registry.SULFUR.get(), 2)).setRegistryName("eidolon", "sulfur").addStep(Items.field_151044_h, Registry.ENCHANTED_ASH.get()));
        CrucibleRegistry.register(new CrucibleRecipe(new ItemStack((IItemProvider)Registry.ENDER_CALX.get(), 2)).setRegistryName("eidolon", "ender_calx").addStep(Tags.Items.ENDER_PEARLS, Registry.ENCHANTED_ASH.get()));
        CrucibleRegistry.register(new CrucibleRecipe(new ItemStack((IItemProvider)Items.field_151116_aA, 1)).setRegistryName("eidolon", "leather_from_flesh").addStep(Registry.ENCHANTED_ASH.get(), Registry.ENCHANTED_ASH.get()).addStirringStep(2, Items.field_151078_bh));
        CrucibleRegistry.register(new CrucibleRecipe(new ItemStack((IItemProvider)Items.field_151078_bh, 1)).setRegistryName("eidolon", "rotten_beef").addStep(Items.field_151082_bd, Tags.Items.MUSHROOMS));
        CrucibleRegistry.register(new CrucibleRecipe(new ItemStack((IItemProvider)Items.field_151078_bh, 1)).setRegistryName("eidolon", "rotten_pork").addStep(Items.field_151147_al, Tags.Items.MUSHROOMS));
        CrucibleRegistry.register(new CrucibleRecipe(new ItemStack((IItemProvider)Items.field_151078_bh, 1)).setRegistryName("eidolon", "rotten_mutton").addStep(Items.field_179561_bm, Tags.Items.MUSHROOMS));
        CrucibleRegistry.register(new CrucibleRecipe(new ItemStack((IItemProvider)Items.field_151078_bh, 1)).setRegistryName("eidolon", "rotten_chicken").addStep(Items.field_151076_bf, Tags.Items.MUSHROOMS));
        CrucibleRegistry.register(new CrucibleRecipe(new ItemStack((IItemProvider)Items.field_151078_bh, 1)).setRegistryName("eidolon", "rotten_rabbit").addStep(Items.field_179558_bo, Tags.Items.MUSHROOMS));
        CrucibleRegistry.register(new CrucibleRecipe(new ItemStack((IItemProvider)Items.field_151016_H, 4)).setRegistryName("eidolon", "gunpowder").addStep(Registry.SULFUR.get(), Items.field_196106_bc).addStirringStep(1, Items.field_196155_l));
        CrucibleRegistry.register(new CrucibleRecipe(new ItemStack((IItemProvider)Items.field_151153_ao, 1)).setRegistryName("eidolon", "gilded_apple").addStep(Tags.Items.INGOTS_GOLD, Tags.Items.INGOTS_GOLD).addStirringStep(2, Registry.ENCHANTED_ASH.get()).addStep(Items.field_151034_e));
        CrucibleRegistry.register(new CrucibleRecipe(new ItemStack((IItemProvider)Items.field_151150_bK, 1)).setRegistryName("eidolon", "gilded_carrot").addStep(Tags.Items.NUGGETS_GOLD, Tags.Items.NUGGETS_GOLD).addStirringStep(2, Registry.ENCHANTED_ASH.get()).addStep(Items.field_151172_bF));
        CrucibleRegistry.register(new CrucibleRecipe(new ItemStack((IItemProvider)Items.field_151060_bw, 1)).setRegistryName("eidolon", "gilded_melon").addStep(Tags.Items.NUGGETS_GOLD, Tags.Items.NUGGETS_GOLD).addStirringStep(2, Registry.ENCHANTED_ASH.get()).addStep(Items.field_151127_ba));
        CrucibleRegistry.register(new CrucibleRecipe(new ItemStack((IItemProvider)Registry.DEATH_ESSENCE.get(), 4)).setRegistryName("eidolon", "death_essence").addStep(Registry.ZOMBIE_HEART.get(), Items.field_151078_bh).addStirringStep(2, Items.field_196106_bc, Items.field_196106_bc).addStep(Items.field_196155_l));
        CrucibleRegistry.register(new CrucibleRecipe(new ItemStack((IItemProvider)Registry.CRIMSON_ESSENCE.get(), 4)).setRegistryName("eidolon", "crimson_essence_fungus").addStep(Items.field_234722_bw_, Items.field_151075_bm).addStirringStep(1, Registry.SULFUR.get()));
        CrucibleRegistry.register(new CrucibleRecipe(new ItemStack((IItemProvider)Registry.CRIMSON_ESSENCE.get(), 2)).setRegistryName("eidolon", "crimson_essence_roots").addStep(Items.field_234724_by_, Items.field_151075_bm).addStirringStep(1, Registry.SULFUR.get()));
        CrucibleRegistry.register(new CrucibleRecipe(new ItemStack((IItemProvider)Registry.CRIMSON_ESSENCE.get(), 2)).setRegistryName("eidolon", "crimson_essence_vines").addStep(Items.field_234718_bB_, Items.field_151075_bm).addStirringStep(1, Registry.SULFUR.get()));
        CrucibleRegistry.register(new CrucibleRecipe(new ItemStack((IItemProvider)Registry.FUNGUS_SPROUTS.get(), 2)).setRegistryName("eidolon", "fungus_sprouts").addStep(Tags.Items.MUSHROOMS).addStirringStep(2, Items.field_196106_bc).addStep(Items.field_151014_N));
        CrucibleRegistry.register(new CrucibleRecipe(new ItemStack((IItemProvider)Registry.WARPED_SPROUTS.get(), 2)).setRegistryName("eidolon", "warped_sprouts").addStep(Blocks.field_235373_mm_).addStirringStep(2, Registry.ENDER_CALX.get()).addStep(Items.field_151075_bm));
        CrucibleRegistry.register(new CrucibleRecipe(new ItemStack((IItemProvider)Registry.POLISHED_PLANKS.getBlock(), 32)).setRegistryName("eidolon", "polished_planks").addStep(ItemTags.field_199905_b, ItemTags.field_199905_b, ItemTags.field_199905_b, ItemTags.field_199905_b, ItemTags.field_199905_b, ItemTags.field_199905_b, ItemTags.field_199905_b, ItemTags.field_199905_b, ItemTags.field_199905_b, ItemTags.field_199905_b, ItemTags.field_199905_b, ItemTags.field_199905_b, ItemTags.field_199905_b, ItemTags.field_199905_b, ItemTags.field_199905_b, ItemTags.field_199905_b, ItemTags.field_199905_b, ItemTags.field_199905_b, ItemTags.field_199905_b, ItemTags.field_199905_b, ItemTags.field_199905_b, ItemTags.field_199905_b, ItemTags.field_199905_b, ItemTags.field_199905_b, ItemTags.field_199905_b, ItemTags.field_199905_b, ItemTags.field_199905_b, ItemTags.field_199905_b, ItemTags.field_199905_b, ItemTags.field_199905_b, ItemTags.field_199905_b, ItemTags.field_199905_b).addStirringStep(1, Registry.SOUL_SHARD.get(), Registry.ENCHANTED_ASH.get()));
    }
}

