/*
 * Decompiled with CFR 0.152.
 */
package elucent.eidolon.recipe;

import elucent.eidolon.tile.CrucibleTileEntity;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tags.ITag;
import net.minecraft.util.ResourceLocation;

public class CrucibleRecipe {
    List<Step> steps = new ArrayList<Step>();
    ResourceLocation registryName;
    ItemStack result;

    public ItemStack getResult() {
        return this.result;
    }

    public CrucibleRecipe(ItemStack result) {
        this.result = result;
    }

    public List<Step> getSteps() {
        return this.steps;
    }

    public ResourceLocation getRegistryName() {
        return this.registryName;
    }

    public CrucibleRecipe setRegistryName(String domain, String path) {
        this.registryName = new ResourceLocation(domain, path);
        return this;
    }

    public CrucibleRecipe setRegistryName(ResourceLocation registryName) {
        this.registryName = registryName;
        return this;
    }

    public CrucibleRecipe addStep(Object ... matches) {
        this.addStirringStep(0, matches);
        return this;
    }

    public CrucibleRecipe addStep(int stirs) {
        this.addStirringStep(stirs, new Object[0]);
        return this;
    }

    public CrucibleRecipe addStirringStep(int stirs, Object ... matches) {
        this.steps.add(new Step(stirs, Arrays.asList(matches)));
        return this;
    }

    static boolean matches(Object match, ItemStack sacrifice) {
        return match instanceof ItemStack ? ItemStack.func_77989_b((ItemStack)((ItemStack)match), (ItemStack)sacrifice) : (match instanceof Item ? (Item)match == sacrifice.func_77973_b() : (match instanceof Block ? ((Block)match).func_199767_j() == sacrifice.func_77973_b() : match instanceof ITag && ((ITag)match).func_230235_a_((Object)sacrifice.func_77973_b())));
    }

    public boolean matches(List<CrucibleTileEntity.CrucibleStep> items) {
        if (this.steps.size() != items.size()) {
            return false;
        }
        ArrayList<Object> matchList = new ArrayList<Object>();
        ArrayList<ItemStack> itemList = new ArrayList<ItemStack>();
        for (int i = 0; i < this.steps.size(); ++i) {
            Step correct = this.steps.get(i);
            CrucibleTileEntity.CrucibleStep provided = items.get(i);
            if (correct.stirs != provided.getStirs()) {
                return false;
            }
            matchList.clear();
            itemList.clear();
            matchList.addAll(correct.matches);
            itemList.addAll(provided.getContents());
            block1: for (int j = 0; j < matchList.size(); ++j) {
                for (int k = 0; k < itemList.size(); ++k) {
                    if (!CrucibleRecipe.matches(matchList.get(j), (ItemStack)itemList.get(k))) continue;
                    matchList.remove(j--);
                    itemList.remove(k--);
                    continue block1;
                }
            }
            if (matchList.size() == 0) continue;
            return false;
        }
        return true;
    }

    public static class Step {
        public List<Object> matches = new ArrayList<Object>();
        public int stirs;

        public Step(int stirs, List<Object> matches) {
            this.stirs = stirs;
            this.matches.addAll(matches);
        }
    }
}

