/*
 * Decompiled with CFR 0.152.
 */
package elucent.eidolon.potion;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import elucent.eidolon.Registry;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.DisplayEffectsScreen;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.attributes.ModifiableAttributeInstance;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.EffectType;
import net.minecraft.potion.Effects;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.gui.ForgeIngameGui;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.extensions.IForgeEffect;
import net.minecraftforge.event.entity.living.LivingHealEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;

public class ChilledEffect
extends Effect
implements IForgeEffect {
    protected static final ResourceLocation ICONS_TEXTURE = new ResourceLocation("eidolon", "textures/gui/icons.png");
    protected static final ResourceLocation EFFECT_TEXTURE = new ResourceLocation("eidolon", "textures/mob_effect/chilled.png");

    static int packColor(int alpha, int red, int green, int blue) {
        return alpha << 24 | red << 16 | green << 8 | blue;
    }

    public ChilledEffect() {
        super(EffectType.HARMFUL, ChilledEffect.packColor(255, 147, 189, 245));
        MinecraftForge.EVENT_BUS.addListener(this::chill);
        DistExecutor.unsafeCallWhenOn((Dist)Dist.CLIENT, () -> () -> {
            MinecraftForge.EVENT_BUS.addListener(ChilledEffect::renderChill);
            return null;
        });
    }

    @SubscribeEvent
    public void chill(LivingHealEvent event) {
        LivingEntity e = event.getEntityLiving();
        if (e.func_70644_a((Effect)this)) {
            event.setCanceled(true);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void renderInventoryEffect(EffectInstance effect, DisplayEffectsScreen<?> gui, MatrixStack mStack, int x, int y, float z) {
        Minecraft mc = Minecraft.func_71410_x();
        mc.func_110434_K().func_110577_a(EFFECT_TEXTURE);
        gui.func_238474_b_(mStack, x, y, 0, 0, 18, 18);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void renderHUDEffect(EffectInstance effect, AbstractGui gui, MatrixStack mStack, int x, int y, float z, float alpha) {
        Minecraft mc = Minecraft.func_71410_x();
        mc.func_110434_K().func_110577_a(EFFECT_TEXTURE);
        gui.func_238474_b_(mStack, x, y, 0, 0, 18, 18);
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void renderChill(RenderGameOverlayEvent.Post event) {
        Minecraft mc = Minecraft.func_71410_x();
        ClientPlayerEntity player = mc.field_71439_g;
        if (event.getType() == RenderGameOverlayEvent.ElementType.HEALTH && player.func_70644_a((Effect)Registry.CHILLED_EFFECT.get())) {
            MatrixStack mStack = event.getMatrixStack();
            mStack.func_227860_a_();
            mStack.func_227861_a_(0.0, 0.0, 0.01);
            int health = MathHelper.func_76123_f((float)player.func_110143_aJ());
            float absorb = MathHelper.func_76123_f((float)player.func_110139_bj());
            ModifiableAttributeInstance attrMaxHealth = player.func_110148_a(Attributes.field_233818_a_);
            float healthMax = (float)attrMaxHealth.func_111126_e();
            int ticks = mc.field_71456_v.func_73834_c();
            int regen = -1;
            if (player.func_70644_a(Effects.field_76428_l)) {
                regen = ticks % 25;
            }
            Random rand = new Random();
            rand.setSeed(ticks * 312871);
            int left = event.getWindow().func_198107_o() / 2 - 91;
            int top = event.getWindow().func_198087_p() - ForgeIngameGui.left_height;
            int healthRows = MathHelper.func_76123_f((float)((healthMax + absorb) / 2.0f / 10.0f));
            int rowHeight = Math.max(10 - (healthRows - 2), 3);
            RenderSystem.pushTextureAttributes();
            mc.func_110434_K().func_110577_a(ICONS_TEXTURE);
            for (int i = MathHelper.func_76123_f((float)(healthMax / 2.0f)) - 1; i >= 0; --i) {
                int row = MathHelper.func_76123_f((float)((float)(i + 1) / 10.0f)) - 1;
                int x = left + i % 10 * 8;
                int y = top + rowHeight - 1;
                if (health <= 4) {
                    y += rand.nextInt(2);
                }
                if (i == regen) {
                    y -= 2;
                }
                RenderSystem.disableAlphaTest();
                RenderSystem.enableBlend();
                if (i * 2 + 1 < health) {
                    mc.field_71456_v.func_238474_b_(mStack, x, y, 0, 0, 9, 9);
                } else if (i * 2 + 1 == health) {
                    mc.field_71456_v.func_238474_b_(mStack, x, y, 9, 0, 9, 9);
                }
                RenderSystem.disableBlend();
                RenderSystem.enableAlphaTest();
            }
            RenderSystem.popAttributes();
            mStack.func_227865_b_();
        }
    }
}

