/*
 * Decompiled with CFR 0.152.
 */
package elucent.eidolon.network;

import elucent.eidolon.capability.IKnowledge;
import elucent.eidolon.capability.KnowledgeProvider;
import elucent.eidolon.entity.ChantCasterEntity;
import elucent.eidolon.spell.Sign;
import elucent.eidolon.spell.Signs;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;

public class AttemptCastPacket {
    List<Sign> signs = new ArrayList<Sign>();
    UUID uuid;

    public AttemptCastPacket(PlayerEntity player, List<Sign> signs) {
        this.signs.addAll(signs);
        this.uuid = player.func_110124_au();
    }

    public AttemptCastPacket(UUID uuid, List<Sign> signs) {
        this.signs.addAll(signs);
        this.uuid = uuid;
    }

    public static void encode(AttemptCastPacket object, PacketBuffer buffer) {
        buffer.writeInt(object.signs.size());
        for (int i = 0; i < object.signs.size(); ++i) {
            buffer.func_211400_a(object.signs.get(i).getRegistryName().toString(), 255);
        }
        buffer.func_179252_a(object.uuid);
    }

    public static AttemptCastPacket decode(PacketBuffer buffer) {
        int n = buffer.readInt();
        ArrayList<Sign> signs = new ArrayList<Sign>();
        for (int i = 0; i < n; ++i) {
            signs.add(Signs.find(new ResourceLocation(buffer.func_150789_c(255))));
        }
        return new AttemptCastPacket(buffer.func_179253_g(), signs);
    }

    public static void consume(AttemptCastPacket packet, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            PlayerEntity player;
            assert (((NetworkEvent.Context)ctx.get()).getDirection() == NetworkDirection.PLAY_TO_SERVER);
            World world = ((NetworkEvent.Context)ctx.get()).getSender().field_70170_p;
            if (world != null && (player = world.func_217371_b(packet.uuid)) != null) {
                List<Sign> signs = packet.signs;
                IKnowledge knowledge = (IKnowledge)player.getCapability(KnowledgeProvider.CAPABILITY, null).resolve().get();
                for (Sign sign : signs) {
                    if (knowledge.knowsSign(sign)) continue;
                    return;
                }
                Vector3d placement = player.func_213303_ch().func_72441_c(0.0, (double)(player.func_213302_cg() * 2.0f / 3.0f), 0.0).func_178787_e(player.func_70040_Z());
                ChantCasterEntity entity = new ChantCasterEntity(world, player, signs);
                entity.func_70107_b(placement.field_72450_a, placement.field_72448_b, placement.field_72449_c);
                world.func_217376_c((Entity)entity);
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

