/*
 * Decompiled with CFR 0.152.
 */
package elucent.eidolon.item.curio;

import com.mojang.blaze3d.matrix.MatrixStack;
import elucent.eidolon.Registry;
import elucent.eidolon.item.ItemBase;
import elucent.eidolon.item.curio.EidolonCurio;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RenderTooltipEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;

public class SanguineAmuletItem
extends ItemBase {
    public SanguineAmuletItem(Item.Properties properties) {
        super(properties);
        DistExecutor.unsafeCallWhenOn((Dist)Dist.CLIENT, () -> () -> {
            MinecraftForge.EVENT_BUS.addListener(SanguineAmuletItem::addTooltip);
            MinecraftForge.EVENT_BUS.addListener(SanguineAmuletItem::renderTooltip);
            return null;
        });
    }

    static int getCharge(ItemStack stack) {
        if (stack.func_77942_o() && stack.func_77978_p().func_74764_b("charge")) {
            return stack.func_77978_p().func_74762_e("charge");
        }
        return 0;
    }

    static void addCharge(ItemStack stack, int diff) {
        int newCharge = MathHelper.func_76125_a((int)(SanguineAmuletItem.getCharge(stack) + diff), (int)0, (int)40);
        stack.func_196082_o().func_74768_a("charge", newCharge);
    }

    static void setCharge(ItemStack stack, int charge) {
        int newCharge = MathHelper.func_76125_a((int)charge, (int)0, (int)40);
        stack.func_196082_o().func_74768_a("charge", newCharge);
    }

    public ICapabilityProvider initCapabilities(final ItemStack stack, CompoundNBT unused) {
        return new EidolonCurio(stack){

            public void curioTick(String type, int index, LivingEntity entity) {
                if (!entity.field_70170_p.field_72995_K) {
                    if (entity.field_70173_aa % 80 == 0 && entity.func_110143_aJ() == entity.func_110138_aP() && entity instanceof PlayerEntity && ((PlayerEntity)entity).func_71024_bL().func_75116_a() >= 18 && SanguineAmuletItem.getCharge(stack) < 40) {
                        PlayerEntity player = (PlayerEntity)entity;
                        float f = player.func_71024_bL().func_75115_e() > 0.0f ? Math.min(4.0f * player.func_71024_bL().func_75115_e(), 16.0f) : 4.0f;
                        player.func_71020_j(f);
                        SanguineAmuletItem.addCharge(stack, 1);
                    }
                    if (entity.field_70173_aa % 10 == 0 && SanguineAmuletItem.getCharge(stack) > 0 && entity.func_110143_aJ() < entity.func_110138_aP()) {
                        int taken = (int)Math.min(1.0f, entity.func_110138_aP() - entity.func_110143_aJ());
                        SanguineAmuletItem.addCharge(stack, -taken);
                        entity.func_70691_i((float)taken);
                    }
                }
            }

            public boolean canSync(String identifier, int index, LivingEntity livingEntity) {
                return true;
            }

            @Nonnull
            public CompoundNBT writeSyncData() {
                CompoundNBT nbt = new CompoundNBT();
                nbt.func_74768_a("charge", SanguineAmuletItem.getCharge(stack));
                return nbt;
            }

            public void readSyncData(CompoundNBT compound) {
                SanguineAmuletItem.setCharge(stack, compound.func_74762_e("charge"));
            }

            public boolean canRightClickEquip() {
                return true;
            }
        };
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void addTooltip(ItemTooltipEvent event) {
        if (event.getItemStack().func_77973_b() == Registry.SANGUINE_AMULET.get()) {
            int charge = SanguineAmuletItem.getCharge(event.getItemStack());
            if (charge > 0) {
                event.getToolTip().add(new StringTextComponent(" "));
            }
            for (int i = 0; i < charge; i += 20) {
                event.getToolTip().add(new StringTextComponent(" "));
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public static void renderTooltip(RenderTooltipEvent.PostText event) {
        ItemStack stack = event.getStack();
        if (stack.func_77973_b() == Registry.SANGUINE_AMULET.get()) {
            Minecraft mc = Minecraft.func_71410_x();
            mc.func_110434_K().func_110577_a(new ResourceLocation("minecraft", "textures/gui/icons.png"));
            int charge = SanguineAmuletItem.getCharge(event.getStack());
            int rows = (charge + 19) / 20;
            for (int i = 0; i < charge; i += 20) {
                for (int j = 0; j < MathHelper.func_76125_a((int)(charge - i), (int)0, (int)20); j += 2) {
                    if (charge - (i + j) == 1) {
                        MatrixStack matrixStack = event.getMatrixStack();
                        int n = event.getX() - 1 + j / 2 * 8;
                        int n2 = event.getY();
                        int n3 = event.getLines().size() - rows;
                        event.getFontRenderer().getClass();
                        AbstractGui.func_238463_a_((MatrixStack)matrixStack, (int)n, (int)(n2 + n3 * (9 + 1) + i / 20 * 9 + 2), (float)61.0f, (float)0.0f, (int)9, (int)9, (int)256, (int)256);
                        continue;
                    }
                    MatrixStack matrixStack = event.getMatrixStack();
                    int n = event.getX() - 1 + j / 2 * 8;
                    int n4 = event.getY();
                    int n5 = event.getLines().size() - rows;
                    event.getFontRenderer().getClass();
                    AbstractGui.func_238463_a_((MatrixStack)matrixStack, (int)n, (int)(n4 + n5 * (9 + 1) + i / 20 * 9 + 2), (float)52.0f, (float)0.0f, (int)9, (int)9, (int)256, (int)256);
                }
            }
        }
    }
}

