/*
 * Decompiled with CFR 0.152.
 */
package elucent.eidolon.item.curio;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import elucent.eidolon.Registry;
import elucent.eidolon.item.ItemBase;
import elucent.eidolon.item.curio.EidolonCurio;
import java.util.UUID;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import top.theillusivec4.curios.api.CuriosApi;

public class GravityBeltItem
extends ItemBase {
    UUID ATTR_ID = new UUID(6937061617091731127L, 7120126291930051139L);

    public GravityBeltItem(Item.Properties properties) {
        super(properties);
        MinecraftForge.EVENT_BUS.addListener(GravityBeltItem::onFall);
    }

    @SubscribeEvent
    public static void onFall(LivingFallEvent event) {
        if (CuriosApi.getCuriosHelper().findEquippedCurio((Item)Registry.GRAVITY_BELT.get(), event.getEntityLiving()).isPresent()) {
            event.setDistance(event.getDistance() / 4.0f);
        }
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, CompoundNBT unused) {
        return new EidolonCurio(stack){

            public Multimap<Attribute, AttributeModifier> getAttributeModifiers(String identifier) {
                HashMultimap map = HashMultimap.create();
                map.put((Object)ForgeMod.ENTITY_GRAVITY.get(), (Object)new AttributeModifier(GravityBeltItem.this.ATTR_ID, "eidolon:gravity_belt", (double)-0.6f, AttributeModifier.Operation.MULTIPLY_TOTAL));
                return map;
            }

            public boolean canRightClickEquip() {
                return true;
            }
        };
    }
}

