/*
 * Decompiled with CFR 0.152.
 */
package elucent.eidolon.capability;

import elucent.eidolon.capability.IReputation;
import elucent.eidolon.capability.ReputationEntry;
import java.util.Map;
import java.util.UUID;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.capabilities.Capability;

public class ReputationStorage
implements Capability.IStorage<IReputation> {
    public INBT writeNBT(Capability<IReputation> capability, IReputation instance, Direction side) {
        CompoundNBT data = new CompoundNBT();
        CompoundNBT reps = new CompoundNBT();
        for (Map.Entry<UUID, Map<ResourceLocation, ReputationEntry>> e : instance.getReputationMap().entrySet()) {
            CompoundNBT tag = new CompoundNBT();
            for (Map.Entry<ResourceLocation, ReputationEntry> e2 : e.getValue().entrySet()) {
                CompoundNBT entry = new CompoundNBT();
                entry.func_74780_a("rep", e2.getValue().reputation);
                if (e2.getValue().lock != null) {
                    entry.func_74778_a("lock", e2.getValue().lock.toString());
                }
                tag.func_218657_a(e2.getKey().toString(), (INBT)entry);
            }
            reps.func_218657_a(e.getKey().toString(), (INBT)tag);
        }
        CompoundNBT times = new CompoundNBT();
        for (Map.Entry<UUID, Long> e : instance.getPrayerTimes().entrySet()) {
            times.func_74772_a(e.getKey().toString(), e.getValue().longValue());
        }
        data.func_218657_a("reps", (INBT)reps);
        data.func_218657_a("times", (INBT)times);
        return data;
    }

    public void readNBT(Capability<IReputation> capability, IReputation instance, Direction side, INBT nbt) {
        UUID uuid;
        CompoundNBT data = (CompoundNBT)nbt;
        instance.getReputationMap().clear();
        if (data.func_74764_b("reps")) {
            CompoundNBT reps = data.func_74775_l("reps");
            for (String uuidString : reps.func_150296_c()) {
                uuid = UUID.fromString(uuidString);
                CompoundNBT tag = reps.func_74775_l(uuidString);
                for (String deity : tag.func_150296_c()) {
                    CompoundNBT entry = tag.func_74775_l(deity);
                    instance.setReputation(uuid, new ResourceLocation(deity), entry.func_74769_h("rep"));
                    if (!entry.func_74764_b("lock")) continue;
                    instance.lock(uuid, new ResourceLocation(deity), new ResourceLocation(entry.func_74779_i("lock")));
                }
            }
        }
        if (data.func_74764_b("times")) {
            CompoundNBT times = data.func_74775_l("times");
            for (String uuidString : times.func_150296_c()) {
                uuid = UUID.fromString(uuidString);
                instance.pray(uuid, times.func_74763_f(uuidString));
            }
        }
    }
}

