/*
 * Decompiled with CFR 0.152.
 */
package mcjty.restrictions.blocks;

import java.util.List;
import mcjty.lib.tileentity.GenericTileEntity;
import mcjty.restrictions.items.GlassBoots;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.AxisAlignedBB;

public class BaseTileEntity
extends GenericTileEntity
implements ITickableTileEntity {
    private AxisAlignedBB aabb = null;
    private final double speed;

    public BaseTileEntity(TileEntityType<?> type, double speed) {
        super(type);
        this.speed = speed;
    }

    public void setPowerInput(int powered) {
        if (this.powerLevel != powered) {
            this.powerLevel = powered;
            this.func_70296_d();
            BlockState state = this.field_145850_b.func_180495_p(this.func_174877_v());
            this.field_145850_b.func_184138_a(this.func_174877_v(), state, state, 2);
        }
    }

    protected AxisAlignedBB getBox() {
        if (this.aabb == null) {
            assert (this.field_145850_b != null);
            Direction direction = (Direction)this.field_145850_b.func_180495_p(this.func_174877_v()).func_177229_b((Property)BlockStateProperties.field_208155_H);
            this.aabb = new AxisAlignedBB(this.func_174877_v().func_177972_a(direction));
            if (this.powerLevel > 1) {
                this.aabb = this.aabb.func_111270_a(new AxisAlignedBB(this.func_174877_v().func_177967_a(direction, this.powerLevel)));
            }
        }
        return this.aabb;
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket packet) {
        int oldpower = this.powerLevel;
        this.load(packet.func_148857_g());
        if (oldpower != this.powerLevel) {
            this.aabb = null;
        }
    }

    public void saveClientDataToNBT(CompoundNBT tagCompound) {
        this.func_189515_b(tagCompound);
    }

    public void func_73660_a() {
        block5: {
            Direction direction;
            block4: {
                assert (this.field_145850_b != null);
                direction = (Direction)this.field_145850_b.func_180495_p(this.func_174877_v()).func_177229_b((Property)BlockStateProperties.field_208155_H);
                if (this.field_145850_b.field_72995_K) break block4;
                if (this.powerLevel <= 0) break block5;
                List entities = this.field_145850_b.func_217357_a(Entity.class, this.getBox());
                for (Entity entity : entities) {
                    entity.func_70024_g((double)direction.func_82601_c() * this.speed, (double)direction.func_96559_d() * this.speed, (double)direction.func_82599_e() * this.speed);
                    if (direction != Direction.UP || !(entity.func_213322_ci().field_72448_b > -0.5)) continue;
                    entity.field_70143_R = 1.0f;
                }
                break block5;
            }
            if (this.powerLevel > 0) {
                List entities = this.field_145850_b.func_217357_a(PlayerEntity.class, this.getBox());
                for (Entity entity : entities) {
                    ItemStack boots = ((PlayerEntity)entity).func_184582_a(EquipmentSlotType.FEET);
                    if (!boots.func_190926_b() && boots.func_77973_b() instanceof GlassBoots) continue;
                    entity.func_70024_g((double)direction.func_82601_c() * this.speed, (double)direction.func_96559_d() * this.speed, (double)direction.func_82599_e() * this.speed);
                    if (direction != Direction.UP || !(entity.func_213322_ci().field_72448_b > -0.5)) continue;
                    entity.field_70143_R = 1.0f;
                }
            }
        }
    }
}

