/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsbuilder.shapes;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.util.math.BlockPos;

public enum ShapeRotation {
    NONE("None"),
    X("X"),
    Y("Y"),
    Z("Z");

    private final String code;
    private static final Map<String, ShapeRotation> MAP;

    private ShapeRotation(String code) {
        this.code = code;
    }

    public String getCode() {
        return this.code;
    }

    public static ShapeRotation getByName(String name) {
        return MAP.get(name);
    }

    public BlockPos transformDimension(BlockPos p) {
        switch (this) {
            case NONE: {
                return p;
            }
            case X: {
                return new BlockPos(p.func_177958_n(), p.func_177952_p(), p.func_177956_o());
            }
            case Y: {
                return new BlockPos(p.func_177952_p(), p.func_177956_o(), p.func_177958_n());
            }
            case Z: {
                return new BlockPos(p.func_177956_o(), p.func_177958_n(), p.func_177952_p());
            }
        }
        return p;
    }

    static {
        MAP = new HashMap<String, ShapeRotation>();
        for (ShapeRotation operation : ShapeRotation.values()) {
            MAP.put(operation.getCode(), operation);
        }
    }
}

