/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsbuilder.modules.shield.client;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import mcjty.lib.base.StyleConfig;
import mcjty.lib.blocks.BaseBlock;
import mcjty.lib.container.GenericContainer;
import mcjty.lib.gui.GenericGuiContainer;
import mcjty.lib.gui.Window;
import mcjty.lib.gui.events.DefaultSelectionEvent;
import mcjty.lib.gui.events.SelectionEvent;
import mcjty.lib.gui.layout.HorizontalAlignment;
import mcjty.lib.gui.widgets.AbstractContainerWidget;
import mcjty.lib.gui.widgets.Button;
import mcjty.lib.gui.widgets.ChoiceLabel;
import mcjty.lib.gui.widgets.ColorSelector;
import mcjty.lib.gui.widgets.EnergyBar;
import mcjty.lib.gui.widgets.ImageChoiceLabel;
import mcjty.lib.gui.widgets.Label;
import mcjty.lib.gui.widgets.Panel;
import mcjty.lib.gui.widgets.Slider;
import mcjty.lib.gui.widgets.TextField;
import mcjty.lib.gui.widgets.ToggleButton;
import mcjty.lib.gui.widgets.Widget;
import mcjty.lib.gui.widgets.WidgetList;
import mcjty.lib.gui.widgets.Widgets;
import mcjty.lib.network.PacketGetListFromServer;
import mcjty.lib.tileentity.GenericTileEntity;
import mcjty.lib.typed.TypedMap;
import mcjty.lib.varia.RedstoneMode;
import mcjty.rftoolsbuilder.modules.shield.DamageTypeMode;
import mcjty.rftoolsbuilder.modules.shield.ShieldConfiguration;
import mcjty.rftoolsbuilder.modules.shield.ShieldModule;
import mcjty.rftoolsbuilder.modules.shield.ShieldRenderingMode;
import mcjty.rftoolsbuilder.modules.shield.ShieldTexture;
import mcjty.rftoolsbuilder.modules.shield.blocks.ShieldProjectorTileEntity;
import mcjty.rftoolsbuilder.modules.shield.filters.PlayerFilter;
import mcjty.rftoolsbuilder.modules.shield.filters.ShieldFilter;
import mcjty.rftoolsbuilder.setup.RFToolsBuilderMessages;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.util.ResourceLocation;

public class GuiShield
extends GenericGuiContainer<ShieldProjectorTileEntity, GenericContainer> {
    public static final int SHIELD_WIDTH = 256;
    public static final int SHIELD_HEIGHT = 224;
    public static final String ACTION_PASS = "Pass";
    public static final String ACTION_SOLID = "Solid";
    public static final String ACTION_DAMAGE = "Damage";
    public static final String ACTION_SOLIDDAMAGE = "SolDmg";
    public static final String DAMAGETYPE_GENERIC = DamageTypeMode.DAMAGETYPE_GENERIC.getDescription();
    public static final String DAMAGETYPE_PLAYER = DamageTypeMode.DAMAGETYPE_PLAYER.getDescription();
    private EnergyBar energyBar;
    private ChoiceLabel shieldTextures;
    private ChoiceLabel visibilityOptions;
    private ChoiceLabel actionOptions;
    private ChoiceLabel typeOptions;
    private ChoiceLabel damageType;
    private WidgetList filterList;
    private TextField player;
    private Button addFilter;
    private Button delFilter;
    private Button upFilter;
    private Button downFilter;
    private ColorSelector colorSelector;
    private List<ShieldFilter> filters = null;
    private int listDirty = 0;
    private static List<ShieldFilter> fromServer_filters = new ArrayList<ShieldFilter>();
    private static final ResourceLocation iconLocation = new ResourceLocation("rftoolsbuilder", "textures/gui/shieldprojector.png");
    private static final ResourceLocation iconGuiElements = new ResourceLocation("rftoolsbase", "textures/gui/guielements.png");

    public static void storeFiltersForClient(List<ShieldFilter> filters) {
        fromServer_filters = new ArrayList<ShieldFilter>(filters);
    }

    public GuiShield(ShieldProjectorTileEntity shieldTileEntity, GenericContainer container, PlayerInventory inventory) {
        super((GenericTileEntity)shieldTileEntity, (Container)container, inventory, ((BaseBlock)ShieldModule.SHIELD_BLOCK1.get()).getManualEntry());
        this.field_146999_f = 256;
        this.field_147000_g = 224;
    }

    public static void register() {
        GuiShield.register((ContainerType)((ContainerType)ShieldModule.CONTAINER_SHIELD.get()), GuiShield::new);
    }

    public void func_231160_c_() {
        super.func_231160_c_();
        this.energyBar = ((EnergyBar)new EnergyBar().vertical().hint(12, 141, 10, 76)).showText(false);
        this.initVisibilityMode();
        this.initShieldTextures();
        this.initActionOptions();
        this.initTypeOptions();
        ImageChoiceLabel redstoneMode = this.initRedstoneMode();
        this.initDamageType();
        this.filterList = ((WidgetList)((WidgetList)new WidgetList().name("filters")).desiredHeight(120)).event((SelectionEvent)new DefaultSelectionEvent(){

            public void select(int index) {
                GuiShield.this.selectFilter();
            }
        });
        Slider filterSlider = (Slider)((Slider)new Slider().vertical().scrollableName("filters").desiredWidth(11)).desiredHeight(120);
        Panel filterPanel = (Panel)((Panel)((Panel)Widgets.horizontal((int)3, (int)1).hint(12, 10, 154, 124)).children(new Widget[]{this.filterList, filterSlider})).filledBackground(-6381922);
        this.colorSelector = (ColorSelector)((ColorSelector)((ColorSelector)new ColorSelector().name("color")).tooltips(new String[]{"Color for the shield"})).hint(25, 177, 30, 16);
        ToggleButton light = (ToggleButton)((ToggleButton)((ToggleButton)((ToggleButton)new ToggleButton().name("light")).checkMarker(true).text("L")).tooltips(new String[]{"If pressed, light is blocked", "by the shield"})).hint(56, 177, 23, 16);
        this.player = (TextField)Widgets.textfield((int)170, (int)44, (int)80, (int)14).tooltips(new String[]{"Optional player name"});
        this.addFilter = (Button)((Button)Widgets.button((int)4, (int)6, (int)36, (int)14, (String)"Add").channel("addfilter")).tooltips(new String[]{"Add selected filter"});
        this.delFilter = (Button)((Button)Widgets.button((int)39, (int)6, (int)36, (int)14, (String)"Del").channel("delfilter")).tooltips(new String[]{"Delete selected filter"});
        this.upFilter = (Button)((Button)Widgets.button((int)4, (int)22, (int)36, (int)14, (String)"Up").channel("upfilter")).tooltips(new String[]{"Move filter up"});
        this.downFilter = (Button)((Button)Widgets.button((int)39, (int)22, (int)36, (int)14, (String)"Down").channel("downfilter")).tooltips(new String[]{"Move filter down"});
        Panel controlPanel = (Panel)((Panel)((Panel)((Panel)Widgets.positional().hint(170, 58, 80, 43)).children(new Widget[]{this.addFilter, this.delFilter, this.upFilter, this.downFilter})).filledRectThickness(-2)).filledBackground(StyleConfig.colorListBackground);
        Label lootingBonus = (Label)Widgets.label((int)160, (int)118, (int)60, (int)18, (String)"Looting:").horizontalAlignment(HorizontalAlignment.ALIGN_RIGHT);
        lootingBonus.tooltips(new String[]{"Insert dimensional shards", "for looting bonus"});
        Panel toplevel = (Panel)((Panel)Widgets.positional().background(iconLocation)).children(new Widget[]{this.energyBar, this.visibilityOptions, this.shieldTextures, redstoneMode, filterPanel, this.actionOptions, this.typeOptions, this.player, controlPanel, this.damageType, this.colorSelector, lootingBonus, light});
        toplevel.bounds(this.field_147003_i, this.field_147009_r, this.field_146999_f, this.field_147000_g);
        this.window = new Window((Screen)this, (AbstractContainerWidget)toplevel);
        this.window.bind(RFToolsBuilderMessages.INSTANCE, "redstone", (GenericTileEntity)((ShieldProjectorTileEntity)this.tileEntity), GenericTileEntity.VALUE_RSMODE.getName());
        this.window.bind(RFToolsBuilderMessages.INSTANCE, "visibility", (GenericTileEntity)((ShieldProjectorTileEntity)this.tileEntity), ShieldProjectorTileEntity.VALUE_SHIELDVISMODE.getKey().getName());
        this.window.bind(RFToolsBuilderMessages.INSTANCE, "shieldtextures", (GenericTileEntity)((ShieldProjectorTileEntity)this.tileEntity), ShieldProjectorTileEntity.VALUE_SHIELDTEXTURE.getKey().getName());
        this.window.bind(RFToolsBuilderMessages.INSTANCE, "damage", (GenericTileEntity)((ShieldProjectorTileEntity)this.tileEntity), ShieldProjectorTileEntity.VALUE_DAMAGEMODE.getKey().getName());
        this.window.bind(RFToolsBuilderMessages.INSTANCE, "color", (GenericTileEntity)((ShieldProjectorTileEntity)this.tileEntity), ShieldProjectorTileEntity.VALUE_COLOR.getKey().getName());
        this.window.bind(RFToolsBuilderMessages.INSTANCE, "light", (GenericTileEntity)((ShieldProjectorTileEntity)this.tileEntity), ShieldProjectorTileEntity.VALUE_LIGHT.getKey().getName());
        this.window.event("addfilter", (source, params) -> this.addNewFilter());
        this.window.event("delfilter", (source, params) -> this.removeSelectedFilter());
        this.window.event("upfilter", (source, params) -> this.moveFilterUp());
        this.window.event("downfilter", (source, params) -> this.moveFilterDown());
        this.listDirty = 0;
        this.requestFilters();
    }

    private void selectFilter() {
        int selected = this.filterList.getSelected();
        if (selected != -1) {
            boolean damage;
            ShieldFilter shieldFilter = this.filters.get(selected);
            boolean solid = (shieldFilter.getAction() & 1) != 0;
            boolean bl = damage = (shieldFilter.getAction() & 2) != 0;
            if (solid && damage) {
                this.actionOptions.choice(ACTION_SOLIDDAMAGE);
            } else if (solid) {
                this.actionOptions.choice(ACTION_SOLID);
            } else if (damage) {
                this.actionOptions.choice(ACTION_DAMAGE);
            } else {
                this.actionOptions.choice(ACTION_PASS);
            }
            String type = shieldFilter.getFilterName();
            if ("default".equals(type)) {
                this.typeOptions.choice("All");
            } else if ("animal".equals(type)) {
                this.typeOptions.choice("Passive");
            } else if ("hostile".equals(type)) {
                this.typeOptions.choice("Hostile");
            } else if ("player".equals(type)) {
                this.typeOptions.choice("Player");
            } else if ("item".equals(type)) {
                this.typeOptions.choice("Item");
            }
            if (shieldFilter instanceof PlayerFilter) {
                this.player.text(((PlayerFilter)shieldFilter).getName());
            } else {
                this.player.text("");
            }
        }
    }

    private void requestFilters() {
        RFToolsBuilderMessages.INSTANCE.sendToServer((Object)new PacketGetListFromServer(((ShieldProjectorTileEntity)this.tileEntity).func_174877_v(), ShieldProjectorTileEntity.CMD_GETFILTERS.getName()));
    }

    private void requestListsIfNeeded() {
        --this.listDirty;
        if (this.listDirty <= 0) {
            this.requestFilters();
            this.listDirty = 20;
        }
    }

    private void populateFilters() {
        ArrayList<ShieldFilter> newFilters = new ArrayList<ShieldFilter>(fromServer_filters);
        if (newFilters.equals(this.filters)) {
            return;
        }
        this.filters = new ArrayList<ShieldFilter>(newFilters);
        this.filterList.removeChildren();
        for (ShieldFilter filter : this.filters) {
            boolean damage;
            PlayerFilter playerFilter;
            String n = "player".equals(filter.getFilterName()) ? ((playerFilter = (PlayerFilter)filter).getName() == null || playerFilter.getName().isEmpty() ? "players" : "player " + playerFilter.getName()) : filter.getFilterName();
            Panel panel = Widgets.horizontal();
            panel.children(new Widget[]{((Label)((Label)Widgets.label((String)n).color(StyleConfig.colorTextInListNormal)).horizontalAlignment(HorizontalAlignment.ALIGN_LEFT)).desiredWidth(85)});
            boolean solid = (filter.getAction() & 1) != 0;
            boolean bl = damage = (filter.getAction() & 2) != 0;
            String actionName = solid && damage ? ACTION_SOLIDDAMAGE : (solid ? ACTION_SOLID : (damage ? ACTION_DAMAGE : ACTION_PASS));
            panel.children(new Widget[]{((Label)Widgets.label((String)actionName).color(StyleConfig.colorTextInListNormal)).horizontalAlignment(HorizontalAlignment.ALIGN_LEFT)});
            this.filterList.children(new Widget[]{panel});
        }
    }

    private void moveFilterUp() {
        this.sendServerCommandTyped(RFToolsBuilderMessages.INSTANCE, ShieldProjectorTileEntity.CMD_UPFILTER, TypedMap.builder().put(ShieldProjectorTileEntity.PARAM_SELECTED, (Object)this.filterList.getSelected()).build());
        this.listDirty = 0;
    }

    private void moveFilterDown() {
        this.sendServerCommandTyped(RFToolsBuilderMessages.INSTANCE, ShieldProjectorTileEntity.CMD_DOWNFILTER, TypedMap.builder().put(ShieldProjectorTileEntity.PARAM_SELECTED, (Object)this.filterList.getSelected()).build());
        this.listDirty = 0;
    }

    private void addNewFilter() {
        String actionName = this.actionOptions.getCurrentChoice();
        int action = ACTION_PASS.equals(actionName) ? 0 : (ACTION_SOLID.equals(actionName) ? 1 : (ACTION_SOLIDDAMAGE.equals(actionName) ? 3 : 2));
        String filterName = this.typeOptions.getCurrentChoice();
        String type = "All".equals(filterName) ? "default" : ("Passive".equals(filterName) ? "animal" : ("Hostile".equals(filterName) ? "hostile" : ("Item".equals(filterName) ? "item" : "player")));
        String playerName = this.player.getText();
        int selected = this.filterList.getSelected();
        this.sendServerCommandTyped(RFToolsBuilderMessages.INSTANCE, ShieldProjectorTileEntity.CMD_ADDFILTER, TypedMap.builder().put(ShieldProjectorTileEntity.PARAM_ACTION, (Object)action).put(ShieldProjectorTileEntity.PARAM_TYPE, (Object)type).put(ShieldProjectorTileEntity.PARAM_PLAYER, (Object)playerName).put(ShieldProjectorTileEntity.PARAM_SELECTED, (Object)this.filterList.getSelected()).build());
        this.listDirty = 0;
    }

    private void removeSelectedFilter() {
        this.sendServerCommandTyped(RFToolsBuilderMessages.INSTANCE, ShieldProjectorTileEntity.CMD_DELFILTER, TypedMap.builder().put(ShieldProjectorTileEntity.PARAM_SELECTED, (Object)this.filterList.getSelected()).build());
        this.listDirty = 0;
    }

    private ImageChoiceLabel initRedstoneMode() {
        ImageChoiceLabel redstoneMode = ((ImageChoiceLabel)new ImageChoiceLabel().name("redstone")).choice(RedstoneMode.REDSTONE_IGNORED.getDescription(), "Redstone mode:\nIgnored", iconGuiElements, 0, 0).choice(RedstoneMode.REDSTONE_OFFREQUIRED.getDescription(), "Redstone mode:\nOff to activate", iconGuiElements, 16, 0).choice(RedstoneMode.REDSTONE_ONREQUIRED.getDescription(), "Redstone mode:\nOn to activate", iconGuiElements, 32, 0);
        redstoneMode.hint(62, 200, 16, 16);
        redstoneMode.setCurrentChoice(((ShieldProjectorTileEntity)this.tileEntity).getRSMode().ordinal());
        return redstoneMode;
    }

    private void initVisibilityMode() {
        this.visibilityOptions = (ChoiceLabel)((ChoiceLabel)new ChoiceLabel().name("visibility")).hint(25, 161, 54, 14);
        for (ShieldRenderingMode m : ShieldRenderingMode.values()) {
            if (!((Boolean)ShieldConfiguration.allowInvisibleShield.get()).booleanValue() && m == ShieldRenderingMode.INVISIBLE) continue;
            this.visibilityOptions.choices(new String[]{m.getDescription()});
        }
        if (((Boolean)ShieldConfiguration.allowInvisibleShield.get()).booleanValue()) {
            this.visibilityOptions.choiceTooltip(ShieldRenderingMode.INVISIBLE.getDescription(), new String[]{"Shield is completely invisible"});
        }
        this.visibilityOptions.choiceTooltip(ShieldRenderingMode.SHIELD.getDescription(), new String[]{"Default shield texture"});
        this.visibilityOptions.choiceTooltip(ShieldRenderingMode.TRANSP.getDescription(), new String[]{"Transparent shield texture"});
        this.visibilityOptions.choiceTooltip(ShieldRenderingMode.SOLID.getDescription(), new String[]{"Solid shield texture"});
        this.visibilityOptions.choiceTooltip(ShieldRenderingMode.MIMIC.getDescription(), new String[]{"Use the texture from the supplied block"});
    }

    private void initShieldTextures() {
        this.shieldTextures = (ChoiceLabel)((ChoiceLabel)new ChoiceLabel().name("shieldtextures")).hint(45, 143, 34, 14);
        for (ShieldTexture m : ShieldTexture.values()) {
            this.shieldTextures.choices(new String[]{m.getDescription()});
        }
    }

    private void initActionOptions() {
        this.actionOptions = (ChoiceLabel)new ChoiceLabel().hint(170, 12, 80, 14);
        this.actionOptions.choices(new String[]{ACTION_PASS, ACTION_SOLID, ACTION_DAMAGE, ACTION_SOLIDDAMAGE});
        this.actionOptions.choiceTooltip(ACTION_PASS, new String[]{"Entity that matches this filter", "can pass through"});
        this.actionOptions.choiceTooltip(ACTION_SOLID, new String[]{"Entity that matches this filter", "cannot pass"});
        this.actionOptions.choiceTooltip(ACTION_DAMAGE, new String[]{"Entity that matches this filter", "can pass but gets damage"});
        this.actionOptions.choiceTooltip(ACTION_SOLIDDAMAGE, new String[]{"Entity that matches this filter", "cannot pass and gets damage"});
    }

    private void initTypeOptions() {
        this.typeOptions = (ChoiceLabel)new ChoiceLabel().hint(170, 28, 80, 14);
        this.typeOptions.choices(new String[]{"All", "Passive", "Hostile", "Item", "Player"});
        this.typeOptions.choiceTooltip("All", new String[]{"Matches everything"});
        this.typeOptions.choiceTooltip("Passive", new String[]{"Matches passive mobs"});
        this.typeOptions.choiceTooltip("Hostile", new String[]{"Matches hostile mobs"});
        this.typeOptions.choiceTooltip("Item", new String[]{"Matches items"});
        this.typeOptions.choiceTooltip("Player", new String[]{"Matches players", "(optionally named)"});
    }

    private void initDamageType() {
        this.damageType = (ChoiceLabel)((ChoiceLabel)new ChoiceLabel().name("damage")).hint(170, 102, 80, 14);
        this.damageType.choices(new String[]{DAMAGETYPE_GENERIC, DAMAGETYPE_PLAYER});
        this.damageType.choiceTooltip(DAMAGETYPE_GENERIC, new String[]{"Generic damage type"});
        this.damageType.choiceTooltip(DAMAGETYPE_PLAYER, new String[]{"Damage as done by a player"});
    }

    private void enableButtons() {
        int sel = this.filterList.getSelected();
        int cnt = this.filterList.getMaximum();
        this.delFilter.enabled(sel != -1 && cnt > 0);
        this.upFilter.enabled(sel > 0 && cnt > 0);
        this.downFilter.enabled(sel < cnt - 1 && sel != -1 && cnt > 0);
        if (sel == -1) {
            this.addFilter.text("Add");
        } else {
            this.addFilter.text("Ins");
        }
        this.player.enabled("Player".equals(this.typeOptions.getCurrentChoice()));
    }

    protected void func_230450_a_(@Nonnull MatrixStack matrixStack, float v, int i, int i2) {
        this.requestListsIfNeeded();
        this.populateFilters();
        this.enableButtons();
        this.drawWindow(matrixStack);
        this.colorSelector.currentColor(Integer.valueOf(((ShieldProjectorTileEntity)this.tileEntity).getShieldColor()));
        this.updateEnergyBar(this.energyBar);
    }
}

