/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsbuilder.modules.shield.blocks;

import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mcjty.lib.blocks.BaseBlock;
import mcjty.lib.blocks.RotationType;
import mcjty.lib.builder.BlockBuilder;
import mcjty.lib.builder.InfoLine;
import mcjty.lib.builder.TooltipBuilder;
import mcjty.lib.compat.theoneprobe.TOPDriver;
import mcjty.lib.crafting.INBTPreservingIngredient;
import mcjty.lib.varia.Logging;
import mcjty.rftoolsbase.modules.various.items.SmartWrenchItem;
import mcjty.rftoolsbase.tools.ManualHelper;
import mcjty.rftoolsbuilder.compat.RFToolsBuilderTOPDriver;
import mcjty.rftoolsbuilder.modules.shield.blocks.ShieldProjectorTileEntity;
import net.minecraft.block.BlockState;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.GlobalPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.Explosion;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;

public class ShieldProjectorBlock
extends BaseBlock
implements INBTPreservingIngredient {
    public ShieldProjectorBlock(Supplier<TileEntity> te, int max) {
        super(new BlockBuilder().manualEntry(ManualHelper.create((String)"rftoolsbuilder:shield/shield_intro")).topDriver((TOPDriver)RFToolsBuilderTOPDriver.DRIVER).infusable().info(new InfoLine[]{TooltipBuilder.key((String)"message.rftoolsbuilder.shiftmessage")}).infoShift(new InfoLine[]{TooltipBuilder.header(), TooltipBuilder.gold(), TooltipBuilder.parameter((String)"info", stack -> Integer.toString(max))}).tileEntitySupplier(te));
    }

    public RotationType getRotationType() {
        return RotationType.NONE;
    }

    public Collection<String> getTagsToPreserve() {
        return Collections.singleton("BlockEntityTag");
    }

    public void func_180633_a(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull BlockState state, @Nullable LivingEntity placer, @Nonnull ItemStack stack) {
        super.func_180633_a(world, pos, state, placer, stack);
        this.setOwner(world, pos, placer);
    }

    public void func_196270_a(@Nonnull BlockState state, World world, @Nonnull BlockPos pos, @Nonnull PlayerEntity player) {
        if (!world.field_72995_K) {
            this.composeDecomposeShield(world, pos, true);
        }
    }

    protected boolean wrenchUse(World world, BlockPos pos, Direction side, PlayerEntity player) {
        this.composeDecomposeShield(world, pos, false);
        return true;
    }

    protected boolean wrenchSneakSelect(World world, BlockPos pos, PlayerEntity player) {
        if (!world.field_72995_K) {
            Optional currentBlock = SmartWrenchItem.getCurrentBlock((ItemStack)player.func_184586_b(Hand.MAIN_HAND));
            if (!currentBlock.isPresent()) {
                SmartWrenchItem.setCurrentBlock((ItemStack)player.func_184586_b(Hand.MAIN_HAND), (GlobalPos)GlobalPos.func_239648_a_((RegistryKey)world.func_234923_W_(), (BlockPos)pos));
                Logging.message((PlayerEntity)player, (String)(TextFormatting.YELLOW + "Selected block"));
            } else {
                SmartWrenchItem.setCurrentBlock((ItemStack)player.func_184586_b(Hand.MAIN_HAND), null);
                Logging.message((PlayerEntity)player, (String)(TextFormatting.YELLOW + "Cleared selected block"));
            }
        }
        return true;
    }

    private void composeDecomposeShield(World world, BlockPos pos, boolean ctrl) {
        TileEntity te;
        if (!world.field_72995_K && (te = world.func_175625_s(pos)) instanceof ShieldProjectorTileEntity) {
            ((ShieldProjectorTileEntity)te).composeDecomposeShield(ctrl);
        }
    }

    public void func_196243_a(@Nonnull BlockState state, @Nonnull World world, @Nonnull BlockPos pos, @Nonnull BlockState newstate, boolean isMoving) {
        if (newstate.func_177230_c() != this) {
            this.removeShield((IWorld)world, pos);
        }
        super.func_196243_a(state, world, pos, newstate, isMoving);
    }

    public void func_176206_d(@Nonnull IWorld world, @Nonnull BlockPos pos, @Nonnull BlockState state) {
        this.removeShield(world, pos);
        super.func_176206_d(world, pos, state);
    }

    public void func_180652_a(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull Explosion explosionIn) {
        this.removeShield((IWorld)world, pos);
        super.func_180652_a(world, pos, explosionIn);
    }

    private void removeShield(IWorld world, BlockPos pos) {
        ShieldProjectorTileEntity shieldTileEntity;
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof ShieldProjectorTileEntity && !world.func_201670_d() && (shieldTileEntity = (ShieldProjectorTileEntity)te).isShieldComposed()) {
            shieldTileEntity.decomposeShield();
        }
    }
}

