/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsbuilder.modules.builder.blocks;

import java.util.ArrayDeque;
import java.util.Deque;
import javax.annotation.Nonnull;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.world.World;

public class SupportBlock
extends Block {
    public static final EnumProperty<SupportStatus> STATUS = EnumProperty.func_177709_a((String)"status", SupportStatus.class);

    public SupportBlock() {
        super(AbstractBlock.Properties.func_200945_a((Material)Material.field_151592_s).func_226896_b_().func_235828_a_((state, world, pos) -> false));
    }

    @Nonnull
    public ActionResultType func_225533_a_(@Nonnull BlockState state, World world, @Nonnull BlockPos pos, @Nonnull PlayerEntity player, @Nonnull Hand handIn, @Nonnull BlockRayTraceResult hit) {
        if (!world.field_72995_K) {
            ArrayDeque<BlockPos> todo = new ArrayDeque<BlockPos>();
            todo.add(pos);
            this.removeBlock(world, todo);
        }
        return super.func_225533_a_(state, world, pos, player, handIn, hit);
    }

    private void removeBlock(World world, Deque<BlockPos> todo) {
        while (!todo.isEmpty()) {
            BlockPos c = todo.pollFirst();
            world.func_175656_a(c, Blocks.field_150350_a.func_176223_P());
            if (world.func_180495_p(c.func_177976_e()).func_177230_c() == this) {
                todo.push(c.func_177976_e());
            }
            if (world.func_180495_p(c.func_177974_f()).func_177230_c() == this) {
                todo.push(c.func_177974_f());
            }
            if (world.func_180495_p(c.func_177977_b()).func_177230_c() == this) {
                todo.push(c.func_177977_b());
            }
            if (world.func_180495_p(c.func_177984_a()).func_177230_c() == this) {
                todo.push(c.func_177984_a());
            }
            if (world.func_180495_p(c.func_177968_d()).func_177230_c() == this) {
                todo.push(c.func_177968_d());
            }
            if (world.func_180495_p(c.func_177978_c()).func_177230_c() != this) continue;
            todo.push(c.func_177978_c());
        }
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{STATUS});
    }

    public static enum SupportStatus implements IStringSerializable
    {
        STATUS_OK("ok"),
        STATUS_WARN("warn"),
        STATUS_ERROR("error");

        private final String name;

        private SupportStatus(String name) {
            this.name = name;
        }

        public static SupportStatus max(SupportStatus error1, SupportStatus error2) {
            if (error1 == STATUS_ERROR || error2 == STATUS_ERROR) {
                return STATUS_ERROR;
            }
            if (error1 == STATUS_WARN || error2 == STATUS_WARN) {
                return STATUS_WARN;
            }
            return STATUS_OK;
        }

        public String getName() {
            return this.name;
        }

        @Nonnull
        public String func_176610_l() {
            return this.name;
        }
    }
}

