/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.kubejs.world.gen;

import dev.latvian.kubejs.event.StartupEventJS;
import dev.latvian.kubejs.world.gen.RemoveOresProperties;
import dev.latvian.kubejs.world.gen.RemoveSpawnsByCategoryProperties;
import dev.latvian.kubejs.world.gen.RemoveSpawnsByIDProperties;
import dev.latvian.kubejs.world.gen.WorldgenEntryList;
import java.util.Arrays;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.entity.EntityClassification;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.feature.ConfiguredFeature;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.OreFeatureConfig;
import net.minecraft.world.gen.feature.ReplaceBlockConfig;
import org.jetbrains.annotations.Nullable;

public class WorldgenRemoveEventJS
extends StartupEventJS {
    protected boolean verifyBiomes(WorldgenEntryList biomes) {
        return true;
    }

    public boolean isInBiomes(String[] filter) {
        WorldgenEntryList list = new WorldgenEntryList();
        list.blacklist = false;
        list.values.addAll(Arrays.asList(filter));
        return this.verifyBiomes(list);
    }

    public boolean isNotInBiomes(String[] filter) {
        WorldgenEntryList list = new WorldgenEntryList();
        list.blacklist = true;
        list.values.addAll(Arrays.asList(filter));
        return this.verifyBiomes(list);
    }

    protected static boolean checkTree(ConfiguredFeature<?, ?> configuredFeature, Predicate<IFeatureConfig> predicate) {
        return predicate.test(configuredFeature.field_222738_b) || configuredFeature.field_222738_b.func_241856_an_().anyMatch(cf -> WorldgenRemoveEventJS.checkTree(cf, predicate));
    }

    @Nullable
    public ResourceLocation getConfiguredFeatureKey(ConfiguredFeature<?, ?> feature) {
        return null;
    }

    protected void removeFeature(GenerationStage.Decoration decoration, Predicate<IFeatureConfig> predicate) {
    }

    protected void removeSpawn(RemoveSpawnsByCategoryProperties properties) {
    }

    protected void removeSpawn(RemoveSpawnsByIDProperties properties) {
    }

    public void printFeatures(@Nullable GenerationStage.Decoration type) {
    }

    public void printFeatures() {
        this.printFeatures(null);
    }

    public void removeFeatureById(GenerationStage.Decoration type, ResourceLocation[] id) {
    }

    public void removeAllFeatures(GenerationStage.Decoration type) {
        this.removeFeature(type, configuredFeature -> true);
    }

    public void removeAllFeatures() {
        for (GenerationStage.Decoration decoration : GenerationStage.Decoration.values()) {
            this.removeFeature(decoration, configuredFeature -> true);
        }
    }

    public void removeOres(Consumer<RemoveOresProperties> p) {
        RemoveOresProperties properties = new RemoveOresProperties();
        p.accept(properties);
        if (!this.verifyBiomes(properties.biomes)) {
            return;
        }
        this.removeFeature(properties._worldgenLayer, featureConfiguration -> {
            if (featureConfiguration instanceof OreFeatureConfig) {
                return properties.blocks.check(((OreFeatureConfig)featureConfiguration).field_202444_d);
            }
            if (featureConfiguration instanceof ReplaceBlockConfig) {
                return properties.blocks.check(((ReplaceBlockConfig)featureConfiguration).field_202458_b);
            }
            return false;
        });
    }

    public void printSpawns(@Nullable EntityClassification category) {
    }

    public void printSpawns() {
        this.printSpawns(null);
    }

    public void removeSpawnsByCategory(Consumer<RemoveSpawnsByCategoryProperties> p) {
        RemoveSpawnsByCategoryProperties properties = new RemoveSpawnsByCategoryProperties();
        p.accept(properties);
        if (this.verifyBiomes(properties.biomes)) {
            this.removeSpawn(properties);
        }
    }

    public void removeSpawnsByID(Consumer<RemoveSpawnsByIDProperties> p) {
        RemoveSpawnsByIDProperties properties = new RemoveSpawnsByIDProperties();
        p.accept(properties);
        if (this.verifyBiomes(properties.biomes)) {
            this.removeSpawn(properties);
        }
    }

    public void removeAllSpawns() {
    }
}

