/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.kubejs.util;

import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tags.ITag;
import net.minecraft.tags.ITagCollection;
import net.minecraft.tags.TagCollectionManager;
import net.minecraft.util.ResourceLocation;

public class Tags {
    public static ITagCollection<Item> items() {
        return TagCollectionManager.func_242178_a().func_241836_b();
    }

    public static ITagCollection<Block> blocks() {
        return TagCollectionManager.func_242178_a().func_241835_a();
    }

    public static ITagCollection<Fluid> fluids() {
        return TagCollectionManager.func_242178_a().func_241837_c();
    }

    public static ITagCollection<EntityType<?>> entityTypes() {
        return TagCollectionManager.func_242178_a().func_241838_d();
    }

    public static Collection<ResourceLocation> byItemStack(ItemStack stack) {
        return Tags.byItem(stack.func_77973_b());
    }

    public static Collection<ResourceLocation> byItem(Item item) {
        return Tags.forType(item, Tags.items());
    }

    public static Collection<ResourceLocation> byBlockState(BlockState state) {
        return Tags.forType(state.func_177230_c(), Tags.blocks());
    }

    public static Collection<ResourceLocation> byBlock(Block block) {
        return Tags.forType(block, Tags.blocks());
    }

    public static Collection<ResourceLocation> byFluid(Fluid fluid) {
        return Tags.forType(fluid, Tags.fluids());
    }

    public static Collection<ResourceLocation> byEntity(Entity entity) {
        return Tags.forType(entity.func_200600_R(), Tags.entityTypes());
    }

    public static Collection<ResourceLocation> byEntityType(EntityType<?> entityType) {
        return Tags.forType(entityType, Tags.entityTypes());
    }

    public static <T> Collection<ResourceLocation> forType(T item, ITagCollection<T> tags) {
        HashSet list = Sets.newHashSet();
        for (Map.Entry entry : tags.func_241833_a().entrySet()) {
            if (!((ITag)entry.getValue()).func_230235_a_(item)) continue;
            list.add((ResourceLocation)entry.getKey());
        }
        return list;
    }
}

