/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.kubejs.util;

import dev.latvian.kubejs.KubeJS;
import dev.latvian.kubejs.util.MapJS;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.CompressedStreamTools;
import org.jetbrains.annotations.Nullable;

public class NBTUtilsJS {
    @Nullable
    public static MapJS read(File file) throws IOException {
        KubeJS.verifyFilePath(file);
        if (!file.exists()) {
            return null;
        }
        return MapJS.of(CompressedStreamTools.func_74796_a((InputStream)new FileInputStream(file)));
    }

    public static void write(File file, @Nullable MapJS nbt) throws IOException {
        KubeJS.verifyFilePath(file);
        if (nbt == null) {
            file.delete();
            return;
        }
        CompressedStreamTools.func_74799_a((CompoundNBT)nbt.toNBT(), (OutputStream)new FileOutputStream(file));
    }

    @Nullable
    public static MapJS read(String file) throws IOException {
        return NBTUtilsJS.read(KubeJS.getGameDirectory().resolve(file).toFile());
    }

    public static void write(String file, @Nullable MapJS nbt) throws IOException {
        NBTUtilsJS.write(KubeJS.getGameDirectory().resolve(file).toFile(), nbt);
    }
}

