/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.kubejs.util;

import dev.latvian.kubejs.KubeJS;
import dev.latvian.kubejs.util.ConsoleJS;
import dev.latvian.kubejs.util.UtilsJS;
import java.util.Arrays;
import java.util.stream.Collectors;
import net.minecraft.util.ResourceLocation;

public abstract class BuilderBase {
    public final ResourceLocation id;
    public String translationKey;
    public String displayName;

    public BuilderBase(String s) {
        this.id = UtilsJS.getMCID(KubeJS.appendModId(s));
        this.translationKey = this.getBuilderType() + "." + this.id.func_110624_b() + "." + this.id.func_110623_a();
        this.displayName = Arrays.stream(this.id.func_110623_a().split("_")).map(UtilsJS::toTitleCase).collect(Collectors.joining(" "));
    }

    public abstract String getBuilderType();

    @Deprecated
    public void add() {
        ConsoleJS.STARTUP.setLineNumber(true);
        ConsoleJS.STARTUP.log("You no longer need to use .add() at end of " + this.getBuilderType() + " builder!");
        ConsoleJS.STARTUP.setLineNumber(false);
    }

    public BuilderBase translationKey(String key) {
        this.translationKey = key;
        return this;
    }

    public BuilderBase displayName(String name) {
        this.displayName = name;
        return this;
    }

    public ResourceLocation newID(String pre, String post) {
        if (pre.isEmpty() && post.isEmpty()) {
            return this.id;
        }
        return new ResourceLocation(this.id.func_110624_b() + ':' + pre + this.id.func_110623_a() + post);
    }
}

