/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.kubejs.server;

import dev.latvian.kubejs.server.IScheduledEventCallback;
import dev.latvian.kubejs.server.ServerJS;
import org.jetbrains.annotations.Nullable;

public class ScheduledEvent {
    private final ServerJS server;
    private final boolean usingTicks;
    private final long timer;
    private final long endTime;
    private final Object data;
    private final IScheduledEventCallback callback;

    ScheduledEvent(ServerJS s, boolean ut, long t, long e, @Nullable Object d, IScheduledEventCallback c) {
        this.usingTicks = ut;
        this.server = s;
        this.timer = t;
        this.endTime = e;
        this.data = d;
        this.callback = c;
    }

    public boolean isUsingTicks() {
        return this.usingTicks;
    }

    public ServerJS getServer() {
        return this.server;
    }

    public long getTimer() {
        return this.timer;
    }

    public long getEndTime() {
        return this.endTime;
    }

    @Nullable
    public Object getData() {
        return this.data;
    }

    public void reschedule() {
        this.reschedule(this.timer);
    }

    public long getTimerDuration() {
        return this.endTime - this.timer;
    }

    public ScheduledEvent reschedule(long timer) {
        if (this.isUsingTicks()) {
            return this.server.scheduleInTicks(timer, this.data, this.callback);
        }
        return this.server.schedule(timer, this.data, this.callback);
    }

    void call() {
        this.callback.onCallback(this);
    }
}

