/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.kubejs.item.ingredient;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import dev.latvian.kubejs.item.ItemStackJS;
import dev.latvian.kubejs.item.ingredient.IngredientJS;
import dev.latvian.kubejs.recipe.RecipeJS;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class IngredientStackJS
implements IngredientJS {
    public IngredientJS ingredient;
    private final int countOverride;
    public String ingredientKey;
    public String countKey;

    public static IngredientStackJS stackOf(IngredientJS in) {
        return in instanceof IngredientStackJS ? (IngredientStackJS)in : new IngredientStackJS(in, 1);
    }

    public IngredientStackJS(IngredientJS i, int c) {
        this.ingredient = i;
        this.countOverride = c;
        this.ingredientKey = "ingredient";
        this.countKey = "count";
    }

    public IngredientJS getIngredient() {
        return this.ingredient;
    }

    @Override
    public int getCount() {
        return this.countOverride;
    }

    @Override
    public IngredientJS withCount(int count) {
        if (count <= 0) {
            return ItemStackJS.EMPTY;
        }
        if (count == 1) {
            return this.ingredient.copy();
        }
        return count == this.countOverride ? this.copy() : new IngredientStackJS(this.ingredient, count);
    }

    @Override
    public IngredientJS copy() {
        return new IngredientStackJS(this.ingredient.copy(), this.countOverride);
    }

    @Override
    public boolean test(ItemStackJS stack) {
        return this.ingredient.test(stack);
    }

    @Override
    public boolean testVanilla(ItemStack stack) {
        return this.ingredient.testVanilla(stack);
    }

    @Override
    public boolean testVanillaItem(Item item) {
        return this.ingredient.testVanillaItem(item);
    }

    @Override
    public boolean isEmpty() {
        return this.ingredient.isEmpty();
    }

    @Override
    public boolean isInvalidRecipeIngredient() {
        return this.countOverride <= 0 || this.ingredient.isInvalidRecipeIngredient();
    }

    @Override
    public Set<ItemStackJS> getStacks() {
        return this.ingredient.getStacks();
    }

    @Override
    public Set<Item> getVanillaItems() {
        return this.ingredient.getVanillaItems();
    }

    @Override
    public IngredientJS not() {
        return new IngredientStackJS(this.ingredient.not(), this.countOverride);
    }

    @Override
    public IngredientJS filter(IngredientJS filter) {
        return new IngredientStackJS(this.ingredient.filter(filter), this.countOverride);
    }

    @Override
    public ItemStackJS getFirst() {
        return this.ingredient.getFirst().withCount(this.getCount());
    }

    public String toString() {
        return this.getCount() == 1 ? this.ingredient.toString() : this.getCount() + "x " + this.ingredient;
    }

    @Override
    public JsonElement toJson() {
        JsonElement e;
        if (RecipeJS.currentRecipe != null && (e = RecipeJS.currentRecipe.serializeIngredientStack(this)) != null) {
            return e;
        }
        if (this.countOverride == 1) {
            return this.ingredient.toJson();
        }
        JsonObject json = new JsonObject();
        json.add(this.ingredientKey, this.ingredient.toJson());
        json.addProperty(this.countKey, (Number)this.countOverride);
        return json;
    }

    @Override
    public IngredientStackJS asIngredientStack() {
        return this;
    }

    @Override
    public List<IngredientJS> unwrapStackIngredient() {
        if (this.countOverride <= 1) {
            return Collections.singletonList(this.ingredient.withCount(1));
        }
        ArrayList<IngredientJS> list = new ArrayList<IngredientJS>();
        for (int i = 0; i < this.countOverride; ++i) {
            list.add(this.ingredient.withCount(1));
        }
        return list;
    }
}

