/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.kubejs.item;

import dev.architectury.injectables.annotations.ExpectPlatform;
import dev.latvian.kubejs.CommonProperties;
import dev.latvian.kubejs.KubeJS;
import dev.latvian.kubejs.KubeJSObjects;
import dev.latvian.kubejs.KubeJSRegistries;
import dev.latvian.kubejs.block.BlockBuilder;
import dev.latvian.kubejs.block.DetectorInstance;
import dev.latvian.kubejs.core.ItemKJS;
import dev.latvian.kubejs.fluid.FluidBuilder;
import dev.latvian.kubejs.item.BlockItemJS;
import dev.latvian.kubejs.item.ItemBuilder;
import dev.latvian.kubejs.item.ItemCraftedEventJS;
import dev.latvian.kubejs.item.ItemEntityInteractEventJS;
import dev.latvian.kubejs.item.ItemLeftClickEventJS;
import dev.latvian.kubejs.item.ItemPickupEventJS;
import dev.latvian.kubejs.item.ItemRightClickEmptyEventJS;
import dev.latvian.kubejs.item.ItemRightClickEventJS;
import dev.latvian.kubejs.item.ItemSmeltedEventJS;
import dev.latvian.kubejs.item.ItemTossEventJS;
import dev.latvian.kubejs.item.forge.KubeJSItemEventHandlerImpl;
import dev.latvian.kubejs.player.InventoryChangedEventJS;
import java.util.function.Supplier;
import me.shedaniel.architectury.event.events.InteractionEvent;
import me.shedaniel.architectury.event.events.PlayerEvent;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.BlockItem;
import net.minecraft.item.BucketItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;

public class KubeJSItemEventHandler {
    public static Supplier<Item> DUMMY_FLUID_ITEM = () -> Items.field_221966_go;

    public static void init() {
        if (!CommonProperties.get().serverOnly) {
            KubeJSItemEventHandler.registry();
        }
        InteractionEvent.RIGHT_CLICK_ITEM.register(KubeJSItemEventHandler::rightClick);
        InteractionEvent.CLIENT_RIGHT_CLICK_AIR.register(KubeJSItemEventHandler::rightClickEmpty);
        InteractionEvent.CLIENT_LEFT_CLICK_AIR.register(KubeJSItemEventHandler::leftClickEmpty);
        PlayerEvent.PICKUP_ITEM_PRE.register(KubeJSItemEventHandler::pickup);
        PlayerEvent.DROP_ITEM.register(KubeJSItemEventHandler::drop);
        InteractionEvent.INTERACT_ENTITY.register(KubeJSItemEventHandler::entityInteract);
        PlayerEvent.CRAFT_ITEM.register(KubeJSItemEventHandler::crafted);
        PlayerEvent.SMELT_ITEM.register(KubeJSItemEventHandler::smelted);
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    private static BucketItem buildBucket(FluidBuilder builder) {
        return KubeJSItemEventHandlerImpl.buildBucket(builder);
    }

    private static void registry() {
        for (ItemBuilder itemBuilder : KubeJSObjects.ITEMS.values()) {
            itemBuilder.item = itemBuilder.type.createItem(itemBuilder);
            if (itemBuilder.item instanceof ItemKJS) {
                ((ItemKJS)itemBuilder.item).setItemBuilderKJS(itemBuilder);
            }
            KubeJSRegistries.items().register(itemBuilder.id, () -> builder.item);
        }
        for (BlockBuilder blockBuilder : KubeJSObjects.BLOCKS.values()) {
            if (blockBuilder.itemBuilder == null) continue;
            blockBuilder.itemBuilder.blockItem = new BlockItemJS(blockBuilder.itemBuilder);
            if (blockBuilder.itemBuilder.blockItem instanceof ItemKJS) {
                ((ItemKJS)blockBuilder.itemBuilder.blockItem).setItemBuilderKJS(blockBuilder.itemBuilder);
            }
            KubeJSRegistries.items().register(blockBuilder.id, () -> builder.itemBuilder.blockItem);
        }
        for (FluidBuilder fluidBuilder : KubeJSObjects.FLUIDS.values()) {
            fluidBuilder.bucketItem = KubeJSItemEventHandler.buildBucket(fluidBuilder);
            KubeJSRegistries.items().register(fluidBuilder.newID("", "_bucket"), () -> builder.bucketItem);
        }
        for (DetectorInstance detectorInstance : KubeJSObjects.DETECTORS.values()) {
            detectorInstance.item = KubeJSRegistries.items().register(KubeJS.id("detector_" + detectorInstance.id), () -> new BlockItem(detector.block.get(), new Item.Properties().func_200916_a(KubeJS.tab)));
        }
        if (!CommonProperties.get().serverOnly) {
            DUMMY_FLUID_ITEM = KubeJSRegistries.items().register(KubeJS.id("dummy_fluid_item"), () -> new Item(new Item.Properties().func_200917_a(1).func_200916_a(KubeJS.tab)));
        }
    }

    private static ActionResult<ItemStack> rightClick(PlayerEntity player, Hand hand) {
        if (!player.func_184811_cZ().func_185141_a(player.func_184586_b(hand).func_77973_b()) && new ItemRightClickEventJS(player, hand).post("item.right_click")) {
            return ActionResult.func_226248_a_((Object)player.func_184586_b(hand));
        }
        return ActionResult.func_226250_c_((Object)ItemStack.field_190927_a);
    }

    private static void rightClickEmpty(PlayerEntity player, Hand hand) {
        if (player != null && player.field_70170_p != null) {
            new ItemRightClickEmptyEventJS(player, hand).post("item.right_click_empty");
        }
    }

    private static void leftClickEmpty(PlayerEntity player, Hand hand) {
        if (player != null && player.field_70170_p != null) {
            new ItemLeftClickEventJS(player, hand).post("item.left_click");
        }
    }

    private static ActionResultType pickup(PlayerEntity player, ItemEntity entity, ItemStack stack) {
        if (player != null && entity != null && player.field_70170_p != null && new ItemPickupEventJS(player, entity, stack).post("item.pickup")) {
            return ActionResultType.FAIL;
        }
        return ActionResultType.PASS;
    }

    private static ActionResultType drop(PlayerEntity player, ItemEntity entity) {
        if (player != null && entity != null && player.field_70170_p != null && new ItemTossEventJS(player, entity).post("item.toss")) {
            return ActionResultType.FAIL;
        }
        return ActionResultType.PASS;
    }

    private static ActionResultType entityInteract(PlayerEntity player, Entity entity, Hand hand) {
        if (player != null && entity != null && player.field_70170_p != null && new ItemEntityInteractEventJS(player, entity, hand).post("item.entity_interact")) {
            return ActionResultType.FAIL;
        }
        return ActionResultType.PASS;
    }

    private static void crafted(PlayerEntity player, ItemStack crafted, IInventory grid) {
        if (player instanceof ServerPlayerEntity && !crafted.func_190926_b()) {
            new ItemCraftedEventJS(player, crafted, grid).post("item.crafted");
            new InventoryChangedEventJS((ServerPlayerEntity)player, crafted, -1).post("player.inventory.changed");
        }
    }

    private static void smelted(PlayerEntity player, ItemStack smelted) {
        if (player instanceof ServerPlayerEntity && !smelted.func_190926_b()) {
            new ItemSmeltedEventJS(player, smelted).post("item.smelted");
            new InventoryChangedEventJS((ServerPlayerEntity)player, smelted, -1).post("player.inventory.changed");
        }
    }
}

