/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.kubejs.integration.jei;

import dev.latvian.kubejs.KubeJS;
import dev.latvian.kubejs.event.EventJS;
import java.util.Collection;
import java.util.HashSet;
import java.util.function.Predicate;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.runtime.IJeiRuntime;
import net.minecraft.util.ResourceLocation;

public class RemoveJEICategoriesEvent
extends EventJS {
    private final IJeiRuntime runtime;
    private final HashSet<ResourceLocation> categoriesRemoved;
    private final Collection<IRecipeCategory<?>> allCategories;

    public RemoveJEICategoriesEvent(IJeiRuntime r) {
        this.runtime = r;
        this.categoriesRemoved = new HashSet();
        this.allCategories = this.runtime.getRecipeManager().getRecipeCategories();
    }

    public Collection<IRecipeCategory<?>> getCategories() {
        return this.allCategories;
    }

    public void remove(String ... categoriesToYeet) {
        for (String toYeet : categoriesToYeet) {
            this.categoriesRemoved.add(new ResourceLocation(toYeet));
        }
    }

    public void yeet(String ... categoriesToRemove) {
        this.remove(categoriesToRemove);
    }

    public Collection<ResourceLocation> getCategoryIds() {
        HashSet<ResourceLocation> set = new HashSet<ResourceLocation>();
        for (IRecipeCategory<?> allCategory : this.allCategories) {
            ResourceLocation uid = allCategory.getUid();
            set.add(uid);
        }
        return set;
    }

    public void removeIf(Predicate<IRecipeCategory<?>> filter) {
        this.allCategories.stream().filter(filter).map(IRecipeCategory::getUid).map(ResourceLocation::toString).forEach(xva$0 -> this.yeet((String)xva$0));
    }

    public void yeetIf(Predicate<IRecipeCategory<?>> filter) {
        this.removeIf(filter);
    }

    @Override
    protected void afterPosted(boolean result) {
        for (ResourceLocation category : this.categoriesRemoved) {
            try {
                this.runtime.getRecipeManager().hideRecipeCategory(category);
            }
            catch (Exception e) {
                KubeJS.LOGGER.warn("Failed to yeet recipe category {}!", (Object)category);
            }
        }
    }
}

