/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.kubejs.core;

import com.google.gson.JsonElement;
import dev.latvian.kubejs.CommonProperties;
import dev.latvian.kubejs.loot.BlockLootEventJS;
import dev.latvian.kubejs.loot.ChestLootEventJS;
import dev.latvian.kubejs.loot.EntityLootEventJS;
import dev.latvian.kubejs.loot.FishingLootEventJS;
import dev.latvian.kubejs.loot.GenericLootEventJS;
import dev.latvian.kubejs.loot.GiftLootEventJS;
import dev.latvian.kubejs.script.ScriptType;
import dev.latvian.kubejs.server.ServerJS;
import dev.latvian.kubejs.server.ServerSettings;
import dev.latvian.kubejs.util.ConsoleJS;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;

public interface LootTablesKJS {
    default public void applyKJS0(Map<ResourceLocation, JsonElement> map, BiConsumer<ResourceLocation, JsonElement> action) {
        HashMap<ResourceLocation, JsonElement> map1 = new HashMap<ResourceLocation, JsonElement>(map);
        new GenericLootEventJS(map1).post(ScriptType.SERVER, "generic.loot_tables");
        new BlockLootEventJS(map1).post(ScriptType.SERVER, "block.loot_tables");
        new EntityLootEventJS(map1).post(ScriptType.SERVER, "entity.loot_tables");
        new GiftLootEventJS(map1).post(ScriptType.SERVER, "gift.loot_tables");
        new FishingLootEventJS(map1).post(ScriptType.SERVER, "fishing.loot_tables");
        new ChestLootEventJS(map1).post(ScriptType.SERVER, "chest.loot_tables");
        for (Map.Entry entry : map1.entrySet()) {
            try {
                action.accept((ResourceLocation)entry.getKey(), (JsonElement)entry.getValue());
            }
            catch (Exception ex) {
                ConsoleJS.SERVER.error("Failed to load loot table " + entry.getKey() + ": " + ex + "\nJson: " + entry.getValue());
            }
        }
        ServerSettings.exportData();
        if (CommonProperties.get().announceReload && ServerJS.instance != null && !CommonProperties.get().hideServerScriptErrors) {
            if (ScriptType.SERVER.errors.isEmpty()) {
                ServerJS.instance.tell((ITextComponent)new StringTextComponent("Reloaded with no KubeJS errors!").func_240699_a_(TextFormatting.GREEN));
            } else {
                ServerJS.instance.tell((ITextComponent)new StringTextComponent("KubeJS errors found [" + ScriptType.SERVER.errors.size() + "]! Run '/kubejs errors' for more info").func_240699_a_(TextFormatting.DARK_RED));
            }
        }
    }
}

