/*
 * Decompiled with CFR 0.152.
 */
package com.mowmaster.pedestals.util.compat.jei.color_pallet;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mowmaster.pedestals.blocks.PedestalBlock;
import com.mowmaster.pedestals.item.ItemColorPallet;
import com.mowmaster.pedestals.recipes.ColoredPedestalRecipe;
import java.util.Collections;
import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;

public class ColorPedestalRecipeCategory
implements IRecipeCategory<ColoredPedestalRecipe> {
    private final String localizedName;
    private final IDrawable background;
    private final IDrawable icon;
    public static final ResourceLocation PEDESTAL_TEXTURE = new ResourceLocation("pedestals:textures/gui/jei/coloredpedestal.png");
    public static final ResourceLocation UID = new ResourceLocation("pedestals", "coloredpedestals");

    public ColorPedestalRecipeCategory(IGuiHelper guiHelper) {
        this.icon = guiHelper.createDrawableIngredient((Object)new ItemStack((IItemProvider)ItemColorPallet.COLORPALLET_DEFAULT.getItem()));
        this.background = guiHelper.createDrawable(PEDESTAL_TEXTURE, 0, 0, 118, 35);
        this.localizedName = I18n.func_135052_a((String)"pedestals.recipe_category_coloredpedestals", (Object[])new Object[0]);
    }

    public ResourceLocation getUid() {
        return new ResourceLocation("pedestals", "coloredpedestals");
    }

    public Class<? extends ColoredPedestalRecipe> getRecipeClass() {
        return ColoredPedestalRecipe.class;
    }

    public String getTitle() {
        return this.localizedName;
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setIngredients(ColoredPedestalRecipe recipe, IIngredients ingredients) {
        ingredients.setInputIngredients(Collections.singletonList(recipe.getIngredient()));
        ingredients.setOutput(VanillaTypes.ITEM, (Object)recipe.getResult());
    }

    public void setRecipe(IRecipeLayout recipeLayout, ColoredPedestalRecipe recipe, IIngredients ingredients) {
        recipeLayout.getItemStacks().init(0, true, 50, 14);
        recipeLayout.getItemStacks().set(0, new ItemStack((IItemProvider)PedestalBlock.I_PEDESTAL_333));
        recipeLayout.getItemStacks().init(1, true, 5, 14);
        int color = recipe.getColor();
        ItemStack pallet = new ItemStack((IItemProvider)ItemColorPallet.COLORPALLET);
        CompoundNBT nbt = new CompoundNBT();
        nbt.func_74768_a("color", color);
        pallet.func_77982_d(nbt);
        recipeLayout.getItemStacks().set(1, pallet);
        recipeLayout.getItemStacks().init(2, false, 95, 14);
        recipeLayout.getItemStacks().set(2, (List)ingredients.getOutputs(VanillaTypes.ITEM).get(0));
    }

    public void draw(ColoredPedestalRecipe recipe, MatrixStack matrixStack, double mouseX, double mouseY) {
        this.background.draw(matrixStack);
    }
}

