/*
 * Decompiled with CFR 0.152.
 */
package com.mowmaster.pedestals.tiles.render;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mowmaster.pedestals.tiles.PedestalTileEntity;
import javax.annotation.Nonnull;
import net.minecraft.block.DirectionalBlock;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.item.ItemStack;
import net.minecraft.state.Property;
import net.minecraft.util.Direction;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.world.World;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.fml.client.registry.ClientRegistry;

public class RenderPedestal
extends TileEntityRenderer<PedestalTileEntity> {
    public RenderPedestal(TileEntityRendererDispatcher rendererDispatcher) {
        super(rendererDispatcher);
    }

    public void render(@Nonnull PedestalTileEntity tileEntityIn, float partialTicks, MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int combinedLightIn, int combinedOverlayIn) {
        if (!tileEntityIn.func_145837_r()) {
            Direction facing = (Direction)tileEntityIn.func_195044_w().func_177229_b((Property)DirectionalBlock.field_176387_N);
            ItemStack stack = tileEntityIn.getItemInPedestalOverride();
            ItemStack coin = tileEntityIn.getCoinOnPedestal();
            World world = tileEntityIn.func_145831_w();
            if (facing == Direction.UP) {
                RenderPedestal.renderTile(world, matrixStackIn, bufferIn, coin, stack, combinedLightIn, combinedOverlayIn);
            }
            if (facing == Direction.DOWN) {
                matrixStackIn.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(180.0f));
                matrixStackIn.func_227861_a_(0.0, -1.0, 0.0);
                matrixStackIn.func_227861_a_(-1.0, 0.0, 0.0);
                RenderPedestal.renderTile(world, matrixStackIn, bufferIn, coin, stack, combinedLightIn, combinedOverlayIn);
            }
            if (facing == Direction.NORTH) {
                matrixStackIn.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(270.0f));
                matrixStackIn.func_227861_a_(0.0, -1.0, 0.0);
                RenderPedestal.renderTile(world, matrixStackIn, bufferIn, coin, stack, combinedLightIn, combinedOverlayIn);
            }
            if (facing == Direction.EAST) {
                matrixStackIn.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(270.0f));
                matrixStackIn.func_227861_a_(-1.0, 0.0, 0.0);
                RenderPedestal.renderTile(world, matrixStackIn, bufferIn, coin, stack, combinedLightIn, combinedOverlayIn);
            }
            if (facing == Direction.SOUTH) {
                matrixStackIn.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(90.0f));
                matrixStackIn.func_227861_a_(0.0, 0.0, -1.0);
                RenderPedestal.renderTile(world, matrixStackIn, bufferIn, coin, stack, combinedLightIn, combinedOverlayIn);
            }
            if (facing == Direction.WEST) {
                matrixStackIn.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(90.0f));
                matrixStackIn.func_227861_a_(0.0, -1.0, 0.0);
                RenderPedestal.renderTile(world, matrixStackIn, bufferIn, coin, stack, combinedLightIn, combinedOverlayIn);
            }
        }
    }

    public static void renderTile(World worldIn, MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, ItemStack coin, ItemStack item, int combinedLightIn, int combinedOverlayIn) {
        RenderPedestal.renderItemRotating(worldIn, matrixStackIn, bufferIn, item, combinedLightIn, combinedOverlayIn);
        RenderPedestal.renderCoin(worldIn, coin, matrixStackIn, bufferIn, 0.5f, 0.475f, 0.3125f, 0.0f, 0.0f, 0.0f, 0.0f, combinedLightIn, combinedOverlayIn);
        RenderPedestal.renderCoin(worldIn, coin, matrixStackIn, bufferIn, 0.3125f, 0.475f, 0.5f, 90.0f, 0.0f, 1.0f, 0.0f, combinedLightIn, combinedOverlayIn);
        RenderPedestal.renderCoin(worldIn, coin, matrixStackIn, bufferIn, 0.5f, 0.475f, 0.6875f, 180.0f, 0.0f, 1.0f, 0.0f, combinedLightIn, combinedOverlayIn);
        RenderPedestal.renderCoin(worldIn, coin, matrixStackIn, bufferIn, 0.6875f, 0.475f, 0.5f, 270.0f, 0.0f, 1.0f, 0.0f, combinedLightIn, combinedOverlayIn);
    }

    public static void renderItemRotating(World worldIn, MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, ItemStack itemStack, int combinedLightIn, int combinedOverlayIn) {
        if (!itemStack.func_190926_b()) {
            matrixStackIn.func_227860_a_();
            matrixStackIn.func_227861_a_(0.5, 1.0, 0.5);
            matrixStackIn.func_227862_a_(0.75f, 0.75f, 0.75f);
            long time = System.currentTimeMillis();
            float angle = time / 25L % 360L;
            matrixStackIn.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(angle));
            ItemRenderer renderer = Minecraft.func_71410_x().func_175599_af();
            IBakedModel baked = renderer.func_184393_a(itemStack, worldIn, null);
            renderer.func_229111_a_(itemStack, ItemCameraTransforms.TransformType.GROUND, true, matrixStackIn, bufferIn, combinedLightIn, combinedOverlayIn, baked);
            matrixStackIn.func_227865_b_();
        }
    }

    public static void renderCoin(World worldIn, ItemStack itemCoin, MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, float x, float y, float z, float angle, float xr, float yr, float zr, int combinedLightIn, int combinedOverlayIn) {
        if (!itemCoin.func_190926_b()) {
            matrixStackIn.func_227860_a_();
            matrixStackIn.func_227861_a_((double)x, (double)y, (double)z);
            matrixStackIn.func_227862_a_(0.1875f, 0.1875f, 0.1875f);
            matrixStackIn.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(angle));
            ItemRenderer renderer = Minecraft.func_71410_x().func_175599_af();
            IBakedModel baked = renderer.func_184393_a(itemCoin, worldIn, null);
            renderer.func_229111_a_(itemCoin, ItemCameraTransforms.TransformType.FIXED, true, matrixStackIn, bufferIn, combinedLightIn, combinedOverlayIn, baked);
            matrixStackIn.func_227865_b_();
        }
    }

    public static void init(ModelRegistryEvent event) {
        ClientRegistry.bindTileEntityRenderer(PedestalTileEntity.PEDESTALTYPE, RenderPedestal::new);
    }
}

