/*
 * Decompiled with CFR 0.152.
 */
package com.mowmaster.pedestals.tiles;

import com.mowmaster.pedestals.api.filter.IFilterBase;
import com.mowmaster.pedestals.api.upgrade.IUpgradeBase;
import com.mowmaster.pedestals.blocks.PedestalBlock;
import com.mowmaster.pedestals.crafting.CraftingPedestals;
import com.mowmaster.pedestals.item.ItemPedestalUpgrades;
import com.mowmaster.pedestals.item.pedestalFilters.ItemFilterBase;
import com.mowmaster.pedestals.item.pedestalUpgrades.ItemUpgradeBaseEnergy;
import com.mowmaster.pedestals.item.pedestalUpgrades.ItemUpgradeBaseFluid;
import com.mowmaster.pedestals.item.pedestalUpgrades.ItemUpgradeEnergyExport;
import com.mowmaster.pedestals.item.pedestalUpgrades.ItemUpgradeEnergyImport;
import com.mowmaster.pedestals.item.pedestalUpgrades.ItemUpgradeFluidExport;
import com.mowmaster.pedestals.item.pedestalUpgrades.ItemUpgradeFluidImport;
import com.mowmaster.pedestals.item.pedestalUpgrades.ItemUpgradeItemTank;
import com.mowmaster.pedestals.network.PacketHandler;
import com.mowmaster.pedestals.network.PacketParticles;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.SwordItem;
import net.minecraft.item.ToolItem;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.state.Property;
import net.minecraft.tags.ITag;
import net.minecraft.tags.ItemTags;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.LockCode;
import net.minecraft.world.World;
import net.minecraftforge.common.ToolType;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.registries.IForgeRegistry;

public class PedestalTileEntity
extends TileEntity
implements ITickableTileEntity {
    private LazyOptional<IItemHandler> handler = LazyOptional.of(this::createHandler);
    private LazyOptional<IItemHandler> privateHandler = LazyOptional.of(this::createHandlerPedestalPrivate);
    private LazyOptional<IEnergyStorage> energyHandler = LazyOptional.of(this::createHandlerEnergy);
    private LazyOptional<IFluidHandler> fluidHandler = LazyOptional.of(this::createHandlerFluid);
    private List<ItemStack> stacksList = new ArrayList<ItemStack>();
    private static final int[] SLOTS_ALLSIDES = new int[]{0};
    private int storedValueForUpgrades = 0;
    private boolean boolLight = false;
    private final List<BlockPos> storedLocations = new ArrayList<BlockPos>();
    private LockCode lockCode;
    ResourceLocation grabTools = new ResourceLocation("pedestals", "pedestal_tool_whitelist");
    ITag<Item> GET_TOOLS = ItemTags.func_199903_a().func_199910_a(this.grabTools);
    ResourceLocation grabNotTools = new ResourceLocation("pedestals", "pedestal_tool_blacklist");
    ITag<Item> GET_NOTTOOLS = ItemTags.func_199903_a().func_199910_a(this.grabNotTools);
    ResourceLocation filtersBreakTheseUpgrades = new ResourceLocation("pedestals", "filter_broke_these_upgrades");
    ITag<Item> FILTER_BROKE_UPGRADES = ItemTags.func_199903_a().func_199910_a(this.filtersBreakTheseUpgrades);
    int partTicker = 0;
    int impTicker = 0;
    int pedTicker = 0;
    private static Block[] pedArray = new Block[]{PedestalBlock.PEDESTAL_000, PedestalBlock.PEDESTAL_001, PedestalBlock.PEDESTAL_002, PedestalBlock.PEDESTAL_003, PedestalBlock.PEDESTAL_010, PedestalBlock.PEDESTAL_011, PedestalBlock.PEDESTAL_012, PedestalBlock.PEDESTAL_013, PedestalBlock.PEDESTAL_020, PedestalBlock.PEDESTAL_021, PedestalBlock.PEDESTAL_022, PedestalBlock.PEDESTAL_023, PedestalBlock.PEDESTAL_030, PedestalBlock.PEDESTAL_031, PedestalBlock.PEDESTAL_032, PedestalBlock.PEDESTAL_033, PedestalBlock.PEDESTAL_100, PedestalBlock.PEDESTAL_101, PedestalBlock.PEDESTAL_102, PedestalBlock.PEDESTAL_103, PedestalBlock.PEDESTAL_110, PedestalBlock.PEDESTAL_111, PedestalBlock.PEDESTAL_112, PedestalBlock.PEDESTAL_113, PedestalBlock.PEDESTAL_120, PedestalBlock.PEDESTAL_121, PedestalBlock.PEDESTAL_122, PedestalBlock.PEDESTAL_123, PedestalBlock.PEDESTAL_130, PedestalBlock.PEDESTAL_131, PedestalBlock.PEDESTAL_132, PedestalBlock.PEDESTAL_133, PedestalBlock.PEDESTAL_200, PedestalBlock.PEDESTAL_201, PedestalBlock.PEDESTAL_202, PedestalBlock.PEDESTAL_203, PedestalBlock.PEDESTAL_210, PedestalBlock.PEDESTAL_211, PedestalBlock.PEDESTAL_212, PedestalBlock.PEDESTAL_213, PedestalBlock.PEDESTAL_220, PedestalBlock.PEDESTAL_221, PedestalBlock.PEDESTAL_222, PedestalBlock.PEDESTAL_223, PedestalBlock.PEDESTAL_230, PedestalBlock.PEDESTAL_231, PedestalBlock.PEDESTAL_232, PedestalBlock.PEDESTAL_233, PedestalBlock.PEDESTAL_300, PedestalBlock.PEDESTAL_301, PedestalBlock.PEDESTAL_302, PedestalBlock.PEDESTAL_303, PedestalBlock.PEDESTAL_310, PedestalBlock.PEDESTAL_311, PedestalBlock.PEDESTAL_312, PedestalBlock.PEDESTAL_313, PedestalBlock.PEDESTAL_320, PedestalBlock.PEDESTAL_321, PedestalBlock.PEDESTAL_322, PedestalBlock.PEDESTAL_323, PedestalBlock.PEDESTAL_330, PedestalBlock.PEDESTAL_331, PedestalBlock.PEDESTAL_332, PedestalBlock.PEDESTAL_333};
    private static final ResourceLocation RESLOC_TILE_PEDESTAL = new ResourceLocation("pedestals", "tile/pedestal");
    public static TileEntityType<PedestalTileEntity> PEDESTALTYPE = TileEntityType.Builder.func_223042_a(PedestalTileEntity::new, (Block[])pedArray).func_206865_a(null);

    public PedestalTileEntity() {
        super(PEDESTALTYPE);
        this.lockCode = LockCode.field_180162_a;
    }

    public IEnergyStorage createHandlerEnergy() {
        return new IEnergyStorage(){

            public int receiveEnergy(int maxReceive, boolean simulate) {
                if (PedestalTileEntity.this.hasCoin() && PedestalTileEntity.this.getCoinOnPedestal().func_77973_b() instanceof ItemUpgradeEnergyImport) {
                    ItemUpgradeBaseEnergy itemE = (ItemUpgradeBaseEnergy)PedestalTileEntity.this.getCoinOnPedestal().func_77973_b();
                    return itemE.fillEnergy(PedestalTileEntity.this.getCoinOnPedestal(), maxReceive, simulate);
                }
                return 0;
            }

            public int extractEnergy(int maxExtract, boolean simulate) {
                if (PedestalTileEntity.this.hasCoin() && PedestalTileEntity.this.getCoinOnPedestal().func_77973_b() instanceof ItemUpgradeEnergyExport) {
                    ItemUpgradeBaseEnergy itemE = (ItemUpgradeBaseEnergy)PedestalTileEntity.this.getCoinOnPedestal().func_77973_b();
                    if (itemE.removeEnergy(PedestalTileEntity.this.getCoinOnPedestal(), maxExtract, simulate)) {
                        return maxExtract;
                    }
                    return itemE.getEnergyStored(PedestalTileEntity.this.getCoinOnPedestal());
                }
                return 0;
            }

            public int getEnergyStored() {
                if (PedestalTileEntity.this.hasCoin() && PedestalTileEntity.this.getCoinOnPedestal().func_77973_b() instanceof ItemUpgradeBaseEnergy) {
                    ItemUpgradeBaseEnergy itemE = (ItemUpgradeBaseEnergy)PedestalTileEntity.this.getCoinOnPedestal().func_77973_b();
                    return itemE.getEnergyStored(PedestalTileEntity.this.getCoinOnPedestal());
                }
                return 0;
            }

            public int getMaxEnergyStored() {
                if (PedestalTileEntity.this.hasCoin() && PedestalTileEntity.this.getCoinOnPedestal().func_77973_b() instanceof ItemUpgradeBaseEnergy) {
                    ItemUpgradeBaseEnergy itemE = (ItemUpgradeBaseEnergy)PedestalTileEntity.this.getCoinOnPedestal().func_77973_b();
                    return itemE.getEnergyBuffer(PedestalTileEntity.this.getCoinOnPedestal());
                }
                return 0;
            }

            public boolean canExtract() {
                return PedestalTileEntity.this.hasCoin() && PedestalTileEntity.this.getCoinOnPedestal().func_77973_b() instanceof ItemUpgradeEnergyExport;
            }

            public boolean canReceive() {
                return PedestalTileEntity.this.hasCoin() && PedestalTileEntity.this.getCoinOnPedestal().func_77973_b() instanceof ItemUpgradeEnergyImport;
            }
        };
    }

    public IFluidHandler createHandlerFluid() {
        return new IFluidHandler(){

            @Nonnull
            public FluidStack getFluidInTank(int i) {
                ItemStack coin = PedestalTileEntity.this.getCoinOnPedestal();
                return coin.func_77973_b() instanceof ItemUpgradeBaseFluid ? ((ItemUpgradeBaseFluid)coin.func_77973_b()).getFluidStored(coin) : FluidStack.EMPTY;
            }

            public int getTanks() {
                return 1;
            }

            @Nonnull
            public FluidStack drain(int i, IFluidHandler.FluidAction fluidAction) {
                ItemStack coin = PedestalTileEntity.this.getCoinOnPedestal();
                if (coin.func_77973_b() instanceof ItemUpgradeFluidExport) {
                    ItemUpgradeFluidExport coinFluid = (ItemUpgradeFluidExport)coin.func_77973_b();
                    FluidStack coinFluidStored = coinFluid.getFluidStored(coin);
                    int storedCoinFluidSpace = coinFluid.availableFluidSpaceInCoin(coin);
                    int getMainTransferRate = coinFluid.getFluidTransferRate(coin);
                    int transferRate = getMainTransferRate <= storedCoinFluidSpace ? getMainTransferRate : storedCoinFluidSpace;
                    FluidStack fluidToDrain = new FluidStack(coinFluidStored.getFluid(), transferRate, coinFluidStored.getTag());
                    if (coinFluid.hasFluidInCoin(coin) && fluidToDrain.getAmount() > 0) {
                        if (fluidAction != IFluidHandler.FluidAction.SIMULATE) {
                            if (coinFluid.removeFluid(PedestalTileEntity.this.getTile(), coin, fluidToDrain, true)) {
                                coinFluid.removeFluid(PedestalTileEntity.this.getTile(), coin, fluidToDrain, false);
                                return fluidToDrain;
                            }
                            return FluidStack.EMPTY;
                        }
                        return fluidToDrain;
                    }
                }
                return FluidStack.EMPTY;
            }

            @Nonnull
            public FluidStack drain(FluidStack fluidStack, IFluidHandler.FluidAction fluidAction) {
                ItemStack coin = PedestalTileEntity.this.getCoinOnPedestal();
                if (coin.func_77973_b() instanceof ItemUpgradeFluidExport) {
                    ItemUpgradeFluidExport coinFluid = (ItemUpgradeFluidExport)coin.func_77973_b();
                    FluidStack coinFluidStored = coinFluid.getFluidStored(coin);
                    int storedCoinFluidSpace = coinFluid.availableFluidSpaceInCoin(coin);
                    int getMainTransferRate = coinFluid.getFluidTransferRate(coin);
                    int transferRate = getMainTransferRate <= storedCoinFluidSpace ? getMainTransferRate : storedCoinFluidSpace;
                    FluidStack fluidToDrain = new FluidStack(coinFluidStored.getFluid(), transferRate, coinFluidStored.getTag());
                    if (coinFluid.hasFluidInCoin(coin) && fluidToDrain.getAmount() > 0) {
                        if (fluidAction != IFluidHandler.FluidAction.SIMULATE) {
                            if (coinFluid.removeFluid(PedestalTileEntity.this.getTile(), coin, fluidToDrain, true)) {
                                coinFluid.removeFluid(PedestalTileEntity.this.getTile(), coin, fluidToDrain, false);
                                return fluidToDrain;
                            }
                            return FluidStack.EMPTY;
                        }
                        return fluidToDrain;
                    }
                }
                return FluidStack.EMPTY;
            }

            public int getTankCapacity(int i) {
                ItemStack coin = PedestalTileEntity.this.getCoinOnPedestal();
                return coin.func_77973_b() instanceof ItemUpgradeBaseFluid ? ((ItemUpgradeBaseFluid)coin.func_77973_b()).getFluidbuffer(coin) : 0;
            }

            public boolean isFluidValid(int i, @Nonnull FluidStack fluidStack) {
                ItemStack coin = PedestalTileEntity.this.getCoinOnPedestal();
                if (coin.func_77973_b() instanceof ItemUpgradeBaseFluid) {
                    FluidStack inCoin = ((ItemUpgradeBaseFluid)coin.func_77973_b()).getFluidStored(coin);
                    return inCoin.isFluidEqual(fluidStack) || inCoin.isEmpty() && ((ItemUpgradeBaseFluid)coin.func_77973_b()).canRecieveFluid(PedestalTileEntity.this.func_145831_w(), PedestalTileEntity.this.func_174877_v(), fluidStack);
                }
                return false;
            }

            public int fill(FluidStack fluidStack, IFluidHandler.FluidAction fluidAction) {
                ItemStack coin = PedestalTileEntity.this.getCoinOnPedestal();
                if (coin.func_77973_b() instanceof ItemUpgradeFluidImport) {
                    int transferRate;
                    ItemUpgradeFluidImport coinFluid = (ItemUpgradeFluidImport)coin.func_77973_b();
                    FluidStack coinFluidStored = coinFluid.getFluidStored(coin);
                    int storedCoinFluidSpace = coinFluid.availableFluidSpaceInCoin(coin);
                    int getMainTransferRate = coinFluid.getFluidTransferRate(coin);
                    int n = transferRate = getMainTransferRate <= storedCoinFluidSpace ? getMainTransferRate : storedCoinFluidSpace;
                    if ((coinFluidStored.isFluidEqual(fluidStack) || coinFluidStored.isEmpty() && coinFluid.canRecieveFluid(PedestalTileEntity.this.func_145831_w(), PedestalTileEntity.this.func_174877_v(), fluidStack)) && storedCoinFluidSpace > 0) {
                        if (fluidAction != IFluidHandler.FluidAction.SIMULATE) {
                            FluidStack fluidToStore = new FluidStack(fluidStack.getFluid(), transferRate, fluidStack.getTag());
                            if (coinFluid.addFluid(PedestalTileEntity.this.getTile(), coin, fluidToStore, true)) {
                                coinFluid.addFluid(PedestalTileEntity.this.getTile(), coin, fluidToStore, false);
                                return fluidToStore.getAmount();
                            }
                            return 0;
                        }
                        return transferRate;
                    }
                }
                return 0;
            }
        };
    }

    public void update() {
        this.func_70296_d();
        this.field_145850_b.func_184138_a(this.field_174879_c, this.func_195044_w(), this.func_195044_w(), 2);
        this.field_145850_b.func_184138_a(this.field_174879_c, this.func_195044_w(), this.func_195044_w(), 1);
    }

    public IItemHandler createHandler() {
        return new ItemStackHandler(1){

            protected void onLoad() {
                super.onLoad();
            }

            protected void onContentsChanged(int slot) {
                PedestalTileEntity.this.update();
            }

            public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
                ItemStack filterOnPedestal = PedestalTileEntity.this.getFilterInPedestal();
                if (filterOnPedestal.func_77973_b() instanceof IFilterBase) {
                    IFilterBase IFB = (IFilterBase)filterOnPedestal.func_77973_b();
                    return IFB.canAcceptItem(PedestalTileEntity.this.getTile(), stack);
                }
                ItemStack coinOnPedestal = PedestalTileEntity.this.getCoinOnPedestal();
                if (coinOnPedestal.func_77973_b() instanceof IUpgradeBase) {
                    IUpgradeBase IUB = (IUpgradeBase)PedestalTileEntity.this.getCoinOnPedestal().func_77973_b();
                    return IUB.customIsValid(PedestalTileEntity.this.getTile(), slot, stack);
                }
                return slot == 0;
            }

            public int getSlots() {
                return 1;
            }

            protected int getStackLimit(int slot, @Nonnull ItemStack stack) {
                ItemStack filterOnPedestal = PedestalTileEntity.this.getFilterInPedestal();
                if (filterOnPedestal.func_77973_b() instanceof IFilterBase) {
                    IFilterBase IFB = (IFilterBase)filterOnPedestal.func_77973_b();
                    return IFB.canAcceptCount(PedestalTileEntity.this.getTile(), PedestalTileEntity.this.func_145831_w(), PedestalTileEntity.this.func_174877_v(), PedestalTileEntity.this.getItemInPedestal(), stack);
                }
                ItemStack coinOnPedestal = PedestalTileEntity.this.getCoinOnPedestal();
                if (coinOnPedestal.func_77973_b() instanceof IUpgradeBase) {
                    IUpgradeBase IUB = (IUpgradeBase)PedestalTileEntity.this.getCoinOnPedestal().func_77973_b();
                    return IUB.canAcceptCount(PedestalTileEntity.this.field_145850_b, PedestalTileEntity.this.field_174879_c, PedestalTileEntity.this.getItemInPedestal(), stack);
                }
                return super.getStackLimit(slot, stack);
            }

            public int getSlotLimit(int slot) {
                IUpgradeBase IUB;
                ItemStack coinOnPedestal = PedestalTileEntity.this.getCoinOnPedestal();
                if (coinOnPedestal.func_77973_b() instanceof IUpgradeBase && (IUB = (IUpgradeBase)PedestalTileEntity.this.getCoinOnPedestal().func_77973_b()).customSlotLimit(PedestalTileEntity.this.getTile()) != -1) {
                    return IUB.customSlotLimit(PedestalTileEntity.this.getTile());
                }
                return super.getSlotLimit(slot);
            }

            @Nonnull
            public ItemStack getStackInSlot(int slot) {
                IUpgradeBase IUB;
                if (slot == -1) {
                    return super.getStackInSlot(0);
                }
                if (PedestalTileEntity.this.getCoinOnPedestal().func_77973_b() instanceof IUpgradeBase && !(IUB = (IUpgradeBase)PedestalTileEntity.this.getCoinOnPedestal().func_77973_b()).customStackInSlot(PedestalTileEntity.this.getTile(), super.getStackInSlot(slot)).func_77973_b().equals(Items.field_221747_dJ)) {
                    return IUB.customStackInSlot(PedestalTileEntity.this.getTile(), super.getStackInSlot(slot));
                }
                return super.getStackInSlot(slot);
            }

            @Nonnull
            public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
                if (slot == -1) {
                    return super.insertItem(0, stack, simulate);
                }
                if (PedestalTileEntity.this.getCoinOnPedestal().func_77973_b() instanceof IUpgradeBase) {
                    IUpgradeBase IUB = (IUpgradeBase)PedestalTileEntity.this.getCoinOnPedestal().func_77973_b();
                    if (!IUB.customInsertItem(PedestalTileEntity.this.getTile(), stack, true).func_77973_b().equals(Items.field_221747_dJ)) {
                        return IUB.customInsertItem(PedestalTileEntity.this.getTile(), stack, simulate);
                    }
                    return super.insertItem(slot, stack, simulate);
                }
                return super.insertItem(slot, stack, simulate);
            }

            @Nonnull
            public ItemStack extractItem(int slot, int amount, boolean simulate) {
                if (slot == -1) {
                    return super.extractItem(0, amount, simulate);
                }
                if (PedestalTileEntity.this.getCoinOnPedestal().func_77973_b() instanceof IUpgradeBase) {
                    IUpgradeBase IUB = (IUpgradeBase)PedestalTileEntity.this.getCoinOnPedestal().func_77973_b();
                    if (!IUB.customExtractItem(PedestalTileEntity.this.getTile(), amount, true).func_77973_b().equals(Items.field_221747_dJ)) {
                        return IUB.customExtractItem(PedestalTileEntity.this.getTile(), amount, simulate);
                    }
                    return IUB.canSendItem(PedestalTileEntity.this.getTile()) ? super.extractItem(slot, amount, simulate) : ItemStack.field_190927_a;
                }
                return super.extractItem(slot, amount, simulate);
            }
        };
    }

    public PedestalTileEntity getTile() {
        return this;
    }

    private IItemHandler createHandlerPedestalPrivate() {
        return new ItemStackHandler(11){

            protected void onLoad() {
                if (this.getSlots() < 11) {
                    for (int i = 0; i < this.getSlots(); ++i) {
                        PedestalTileEntity.this.stacksList.add(i, this.getStackInSlot(i));
                    }
                    this.setSize(11);
                    for (int j = 0; j < PedestalTileEntity.this.stacksList.size(); ++j) {
                        this.setStackInSlot(j, (ItemStack)PedestalTileEntity.this.stacksList.get(j));
                    }
                }
                super.onLoad();
            }

            protected void onContentsChanged(int slot) {
                if (PedestalTileEntity.this.stacksList.size() <= 0) {
                    PedestalTileEntity.this.update();
                }
            }

            public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
                if (!(slot != 0 || !(stack.func_77973_b() instanceof IUpgradeBase) || PedestalTileEntity.this.hasCoin() || PedestalTileEntity.this.hasFilter() && PedestalTileEntity.this.FILTER_BROKE_UPGRADES.func_230235_a_((Object)stack.func_77973_b()))) {
                    return true;
                }
                if (slot == 1 && stack.func_77973_b().equals(Items.field_221695_cJ) && !PedestalTileEntity.this.hasLight()) {
                    return true;
                }
                if (slot == 2 && stack.func_77973_b().equals(ItemPedestalUpgrades.SPEED) && PedestalTileEntity.this.getSpeed() < 5) {
                    return true;
                }
                if (slot == 3 && stack.func_77973_b().equals(ItemPedestalUpgrades.CAPACITY) && PedestalTileEntity.this.getCapacity() < 5) {
                    return true;
                }
                if (slot == 4 && stack.func_77973_b().equals(ItemPedestalUpgrades.RANGE) && PedestalTileEntity.this.getRange() < 5) {
                    return true;
                }
                if (slot == 5 && (stack.func_77973_b() instanceof ToolItem || stack.func_77973_b() instanceof SwordItem || stack.getToolTypes().contains(ToolType.get((String)"sword")) || stack.getToolTypes().contains(ToolType.PICKAXE) || stack.getToolTypes().contains(ToolType.HOE) || stack.getToolTypes().contains(ToolType.AXE) || stack.getToolTypes().contains(ToolType.SHOVEL) || PedestalTileEntity.this.GET_TOOLS.func_230235_a_((Object)stack.func_77973_b())) && !PedestalTileEntity.this.GET_NOTTOOLS.func_230235_a_((Object)stack.func_77973_b()) && !PedestalTileEntity.this.hasTool()) {
                    return true;
                }
                if (!(slot != 6 || !(stack.func_77973_b() instanceof IFilterBase) || stack.func_77973_b().equals(ItemFilterBase.BASEFILTER) || PedestalTileEntity.this.hasFilter() || PedestalTileEntity.this.hasCoin() && PedestalTileEntity.this.FILTER_BROKE_UPGRADES.func_230235_a_((Object)PedestalTileEntity.this.getCoinOnPedestal().func_77973_b()))) {
                    return true;
                }
                if (slot == 7 && stack.func_77973_b().equals(Items.field_221764_cr) && !PedestalTileEntity.this.hasTorch()) {
                    return true;
                }
                if (slot == 8 && stack.func_77973_b().equals(ItemPedestalUpgrades.ROUNDROBIN) && !PedestalTileEntity.this.hasRRobin()) {
                    return true;
                }
                if (slot == 9 && stack.func_77973_b().equals(ItemPedestalUpgrades.SOUNDMUFFLER)) {
                    return true;
                }
                return slot == 10 && stack.func_77973_b().equals(ItemPedestalUpgrades.PARTICLEDIFFUSER);
            }
        };
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.handler.cast();
        }
        if (cap == CapabilityEnergy.ENERGY && this.getCoinOnPedestal().func_77973_b() instanceof ItemUpgradeBaseEnergy) {
            return this.energyHandler.cast();
        }
        if (cap == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY && this.getCoinOnPedestal().func_77973_b() instanceof ItemUpgradeBaseFluid) {
            return this.fluidHandler.cast();
        }
        return super.getCapability(cap, side);
    }

    public int getSlotSizeLimit() {
        IItemHandler h = (IItemHandler)this.handler.orElse(null);
        return h.getSlotLimit(0);
    }

    public void spawnItemStack(World worldIn, double x, double y, double z, ItemStack stack) {
        Random RANDOM = new Random();
        double d0 = EntityType.field_200765_E.func_220333_h();
        double d1 = 1.0 - d0;
        double d2 = d0 / 2.0;
        double d3 = Math.floor(x) + RANDOM.nextDouble() * d1 + d2;
        double d4 = Math.floor(y) + RANDOM.nextDouble() * d1;
        double d5 = Math.floor(z) + RANDOM.nextDouble() * d1 + d2;
        while (!stack.func_190926_b()) {
            ItemEntity itementity = new ItemEntity(worldIn, d3, d4, d5, stack.func_77979_a(RANDOM.nextInt(21) + 10));
            float f = 0.05f;
            itementity.func_213293_j(RANDOM.nextGaussian() * (double)0.05f, RANDOM.nextGaussian() * (double)0.05f + (double)0.2f, RANDOM.nextGaussian() * (double)0.05f);
            worldIn.func_217376_c((Entity)itementity);
        }
    }

    public void dropInventoryItems(World worldIn, BlockPos pos) {
        IItemHandler h = (IItemHandler)this.handler.orElse(null);
        for (int i = 0; i < h.getSlots(); ++i) {
            this.spawnItemStack(worldIn, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), h.getStackInSlot(-1));
        }
    }

    public void dropInventoryItemsPrivate(World worldIn, BlockPos pos) {
        IItemHandler ph = (IItemHandler)this.privateHandler.orElse(null);
        for (int i = 0; i < ph.getSlots(); ++i) {
            if (i == 0 && this.hasCoin()) {
                IUpgradeBase coin = (IUpgradeBase)ph.getStackInSlot(0).func_77973_b();
                ItemStack actualCoin = ph.getStackInSlot(0);
                coin.removePlayerFromCoin(actualCoin);
                coin.removeWorkQueueFromCoin(actualCoin);
                coin.removeWorkQueueTwoFromCoin(actualCoin);
                coin.removeStoredIntFromCoin(actualCoin);
                coin.removeStoredIntTwoFromCoin(actualCoin);
                coin.removeFilterQueueHandler(actualCoin);
                coin.removeFilterBlock(actualCoin);
                coin.removeInventoryQueue(actualCoin);
                coin.removeCraftingQueue(actualCoin);
            }
            this.spawnItemStack(worldIn, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), ph.getStackInSlot(i));
        }
    }

    public int maxStackSize() {
        return 64;
    }

    public int getStoredValueForUpgrades() {
        return this.storedValueForUpgrades;
    }

    public void setStoredValueForUpgrades(int value) {
        this.storedValueForUpgrades = value;
        this.update();
    }

    public int getNumberOfStoredLocations() {
        return this.storedLocations.size();
    }

    public boolean storeNewLocation(BlockPos pos) {
        boolean returner = false;
        if (this.getNumberOfStoredLocations() < 8) {
            this.storedLocations.add(pos);
            returner = true;
        }
        this.update();
        return returner;
    }

    public BlockPos getStoredPositionAt(int index) {
        BlockPos sendToPos = this.func_174877_v();
        if (index < this.getNumberOfStoredLocations()) {
            sendToPos = this.storedLocations.get(index);
        }
        return sendToPos;
    }

    public boolean removeLocation(BlockPos pos) {
        boolean returner = false;
        if (this.getNumberOfStoredLocations() >= 1) {
            this.storedLocations.remove(pos);
            returner = true;
        }
        this.update();
        return returner;
    }

    public boolean isAlreadyLinked(BlockPos pos) {
        return this.storedLocations.contains(pos);
    }

    public List<BlockPos> getLocationList() {
        return this.storedLocations;
    }

    public int getLinkingRange() {
        int range = 8;
        switch (this.getRange()) {
            case 0: {
                range = this.getRange() > 0 ? 8 : 8;
                break;
            }
            case 1: {
                range = this.getRange() > 0 ? 12 : 8;
                break;
            }
            case 2: {
                range = this.getRange() > 0 ? 16 : 8;
                break;
            }
            case 3: {
                range = this.getRange() > 0 ? 32 : 8;
                break;
            }
            case 4: {
                range = this.getRange() > 0 ? 48 : 8;
                break;
            }
            case 5: {
                range = this.getRange() > 0 ? 64 : 8;
                break;
            }
            default: {
                range = 8;
            }
        }
        return range;
    }

    public boolean isPedestalInRange(PedestalTileEntity pedestalCurrent, BlockPos pedestalToBeLinked) {
        int range = pedestalCurrent.getLinkingRange();
        int x = pedestalToBeLinked.func_177958_n();
        int y = pedestalToBeLinked.func_177956_o();
        int z = pedestalToBeLinked.func_177952_p();
        int x1 = pedestalCurrent.func_174877_v().func_177958_n();
        int y1 = pedestalCurrent.func_174877_v().func_177956_o();
        int z1 = pedestalCurrent.func_174877_v().func_177952_p();
        int xF = Math.abs(Math.subtractExact(x, x1));
        int yF = Math.abs(Math.subtractExact(y, y1));
        int zF = Math.abs(Math.subtractExact(z, z1));
        return xF <= range && yF <= range && zF <= range;
    }

    public boolean hasItem() {
        IItemHandler h = (IItemHandler)this.handler.orElse(null);
        return !h.getStackInSlot(0).func_190926_b();
    }

    public ItemStack getItemInPedestal() {
        IItemHandler h = (IItemHandler)this.handler.orElse(null);
        if (this.hasItem()) {
            return h.getStackInSlot(0);
        }
        return ItemStack.field_190927_a;
    }

    public ItemStack getItemInPedestalOverride() {
        IItemHandler h = (IItemHandler)this.handler.orElse(null);
        return h.getStackInSlot(-1);
    }

    public ItemStack removeItem(int numToRemove) {
        IItemHandler h = (IItemHandler)this.handler.orElse(null);
        ItemStack stack = h.extractItem(0, numToRemove, false);
        return stack;
    }

    public ItemStack removeItemOverride(int numToRemove) {
        IItemHandler h = (IItemHandler)this.handler.orElse(null);
        ItemStack stack = h.extractItem(-1, numToRemove, false);
        return stack;
    }

    public ItemStack removeItem() {
        IItemHandler h = (IItemHandler)this.handler.orElse(null);
        ItemStack stack = h.extractItem(0, this.getItemInPedestal().func_77976_d(), false);
        return stack;
    }

    public ItemStack removeItemOverride() {
        IItemHandler h = (IItemHandler)this.handler.orElse(null);
        ItemStack stack = h.extractItem(-1, h.getStackInSlot(0).func_190916_E(), false);
        return stack;
    }

    public boolean addItem(ItemStack itemFromBlock) {
        IItemHandler h = (IItemHandler)this.handler.orElse(null);
        if (this.hasItem()) {
            if (ItemHandlerHelper.canItemStacksStack((ItemStack)this.getItemInPedestal(), (ItemStack)itemFromBlock)) {
                h.insertItem(0, itemFromBlock.func_77946_l(), false);
            }
        } else {
            h.insertItem(0, itemFromBlock.func_77946_l(), false);
        }
        return true;
    }

    public boolean addItemOverride(ItemStack itemFromBlock) {
        IItemHandler h = (IItemHandler)this.handler.orElse(null);
        ItemStack overrideInPedestal = this.getItemInPedestalOverride();
        if (!overrideInPedestal.func_190926_b()) {
            if (ItemStack.func_179545_c((ItemStack)overrideInPedestal, (ItemStack)itemFromBlock)) {
                return h.insertItem(-1, itemFromBlock.func_77946_l(), false).func_190926_b();
            }
        } else {
            return h.insertItem(-1, itemFromBlock.func_77946_l(), false).func_190926_b();
        }
        this.update();
        return false;
    }

    public ItemStack addItemStackOverride(ItemStack itemFromBlock) {
        IItemHandler h = (IItemHandler)this.handler.orElse(null);
        return h.insertItem(-1, itemFromBlock.func_77946_l(), false);
    }

    public boolean addItem(ItemStack itemFromBlock, boolean simulate) {
        IItemHandler h = (IItemHandler)this.handler.orElse(null);
        if (this.hasItem()) {
            if (ItemHandlerHelper.canItemStacksStack((ItemStack)this.getItemInPedestal(), (ItemStack)itemFromBlock)) {
                if (!simulate) {
                    h.insertItem(0, itemFromBlock.func_77946_l(), false);
                }
                return true;
            }
        } else {
            if (!simulate) {
                h.insertItem(0, itemFromBlock.func_77946_l(), false);
            }
            return true;
        }
        return false;
    }

    public ItemStack addItemCustom(ItemStack itemstackIn, boolean simulate) {
        IItemHandler h = (IItemHandler)this.handler.orElse(null);
        return h.insertItem(0, itemstackIn.func_77946_l(), simulate);
    }

    public int getItemTransferRate() {
        int itemRate = 4;
        switch (this.getCapacity()) {
            case 0: {
                itemRate = this.getCapacity() > 0 ? 4 : 4;
                break;
            }
            case 1: {
                itemRate = this.getCapacity() > 0 ? 8 : 4;
                break;
            }
            case 2: {
                itemRate = this.getCapacity() > 0 ? 16 : 4;
                break;
            }
            case 3: {
                itemRate = this.getCapacity() > 0 ? 32 : 4;
                break;
            }
            case 4: {
                itemRate = this.getCapacity() > 0 ? 48 : 4;
                break;
            }
            case 5: {
                itemRate = this.getCapacity() > 0 ? 64 : 4;
                break;
            }
            default: {
                itemRate = 4;
            }
        }
        return itemRate;
    }

    public void collideWithPedestal(World world, PedestalTileEntity tilePedestal, BlockPos posPedestal, BlockState state, Entity entityIn) {
        Item coinInPed;
        if (!world.field_72995_K && entityIn instanceof ItemEntity && tilePedestal.hasCoin() && (coinInPed = tilePedestal.getCoinOnPedestal().func_77973_b()) instanceof IUpgradeBase) {
            ((IUpgradeBase)coinInPed).actionOnCollideWithBlock(tilePedestal, (Entity)((ItemEntity)entityIn));
        }
    }

    public boolean hasCoin() {
        IItemHandler ph = (IItemHandler)this.privateHandler.orElse(null);
        return !ph.getStackInSlot(0).func_190926_b();
    }

    public ItemStack getCoinOnPedestal() {
        IItemHandler ph = (IItemHandler)this.privateHandler.orElse(null);
        return ph.getStackInSlot(0);
    }

    public ItemStack removeCoin() {
        IItemHandler ph = (IItemHandler)this.privateHandler.orElse(null);
        ItemStack stack = ph.getStackInSlot(0);
        if (stack.func_77973_b() instanceof IUpgradeBase) {
            IUpgradeBase coin = (IUpgradeBase)stack.func_77973_b();
            coin.removePlayerFromCoin(stack);
            coin.removeWorkQueueFromCoin(stack);
            coin.removeWorkQueueTwoFromCoin(stack);
            coin.removeStoredIntFromCoin(stack);
            coin.removeStoredIntTwoFromCoin(stack);
            coin.removeFilterQueueHandler(stack);
            coin.removeFilterBlock(stack);
            coin.removeInventoryQueue(stack);
            coin.removeCraftingQueue(stack);
            coin.removeOutputIngredientMap(stack);
            coin.removeFilterChangeUpdated(stack);
            coin.removeToolChangeUpdated(stack);
        }
        ph.extractItem(0, stack.func_190916_E(), false);
        return stack;
    }

    public boolean addCoin(PlayerEntity player, ItemStack coinFromBlock, boolean simulate) {
        if (this.hasCoin()) {
            return false;
        }
        IItemHandler ph = (IItemHandler)this.privateHandler.orElse(null);
        ItemStack coinItem = coinFromBlock.func_77946_l();
        coinItem.func_190920_e(1);
        if (!this.hasCoin() && ph.isItemValid(0, coinItem)) {
            if (!simulate) {
                ((IUpgradeBase)coinFromBlock.func_77973_b()).setPlayerOnCoin(coinFromBlock, player);
                ph.insertItem(0, coinItem, false);
            }
            return true;
        }
        return false;
    }

    public boolean addSpeed(ItemStack speedUpgrade) {
        IItemHandler ph = (IItemHandler)this.privateHandler.orElse(null);
        ItemStack itemFromBlock = speedUpgrade.func_77946_l();
        itemFromBlock.func_190920_e(1);
        if (this.getSpeed() < 5) {
            ph.insertItem(2, itemFromBlock, false);
            return true;
        }
        return false;
    }

    public ItemStack removeSpeed(int count) {
        IItemHandler ph = (IItemHandler)this.privateHandler.orElse(null);
        if (this.hasSpeed()) {
            return ph.extractItem(2, count, false);
        }
        return ItemStack.field_190927_a;
    }

    public ItemStack removeSpeed() {
        IItemHandler ph = (IItemHandler)this.privateHandler.orElse(null);
        if (this.hasSpeed()) {
            return ph.extractItem(2, ph.getStackInSlot(2).func_190916_E(), false);
        }
        return ItemStack.field_190927_a;
    }

    public boolean hasSpeed() {
        IItemHandler ph = (IItemHandler)this.privateHandler.orElse(null);
        return !ph.getStackInSlot(2).func_190926_b();
    }

    public int getSpeed() {
        IItemHandler ph = (IItemHandler)this.privateHandler.orElse(null);
        return ph.getStackInSlot(2).func_190916_E();
    }

    public int getOperationSpeed() {
        int speed = 20;
        switch (this.getSpeed()) {
            case 0: {
                speed = this.getSpeed() > 0 ? 20 : 20;
                break;
            }
            case 1: {
                speed = this.getSpeed() > 0 ? 10 : 20;
                break;
            }
            case 2: {
                speed = this.getSpeed() > 0 ? 5 : 20;
                break;
            }
            case 3: {
                speed = this.getSpeed() > 0 ? 3 : 20;
                break;
            }
            case 4: {
                speed = this.getSpeed() > 0 ? 2 : 20;
                break;
            }
            case 5: {
                speed = this.getSpeed() > 0 ? 1 : 20;
                break;
            }
            default: {
                speed = 20;
            }
        }
        return speed;
    }

    public boolean addCapacity(ItemStack capacityUpgrade) {
        IItemHandler ph = (IItemHandler)this.privateHandler.orElse(null);
        ItemStack itemFromBlock = capacityUpgrade.func_77946_l();
        itemFromBlock.func_190920_e(1);
        if (this.getCapacity() < 5) {
            ph.insertItem(3, itemFromBlock, false);
            return true;
        }
        return false;
    }

    public ItemStack removeCapacity(int count) {
        IItemHandler ph = (IItemHandler)this.privateHandler.orElse(null);
        if (this.hasCapacity()) {
            return ph.extractItem(3, count, false);
        }
        return ItemStack.field_190927_a;
    }

    public ItemStack removeCapacity() {
        IItemHandler ph = (IItemHandler)this.privateHandler.orElse(null);
        if (this.hasCapacity()) {
            return ph.extractItem(3, ph.getStackInSlot(3).func_190916_E(), false);
        }
        return ItemStack.field_190927_a;
    }

    public boolean hasCapacity() {
        IItemHandler ph = (IItemHandler)this.privateHandler.orElse(null);
        return !ph.getStackInSlot(3).func_190926_b();
    }

    public int getCapacity() {
        IItemHandler ph = (IItemHandler)this.privateHandler.orElse(null);
        return ph.getStackInSlot(3).func_190916_E();
    }

    public boolean addRange(ItemStack rangeUpgrade) {
        IItemHandler ph = (IItemHandler)this.privateHandler.orElse(null);
        ItemStack itemFromBlock = rangeUpgrade.func_77946_l();
        itemFromBlock.func_190920_e(1);
        if (this.getRange() < 5) {
            ph.insertItem(4, itemFromBlock, false);
            return true;
        }
        return false;
    }

    public ItemStack removeRange(int count) {
        IItemHandler ph = (IItemHandler)this.privateHandler.orElse(null);
        if (this.hasRange()) {
            return ph.extractItem(4, count, false);
        }
        return ItemStack.field_190927_a;
    }

    public ItemStack removeRange() {
        IItemHandler ph = (IItemHandler)this.privateHandler.orElse(null);
        if (this.hasRange()) {
            return ph.extractItem(4, ph.getStackInSlot(4).func_190916_E(), false);
        }
        return ItemStack.field_190927_a;
    }

    public int getPedestalTransferRange() {
        return this.getRange();
    }

    public boolean hasRange() {
        IItemHandler ph = (IItemHandler)this.privateHandler.orElse(null);
        return !ph.getStackInSlot(4).func_190926_b();
    }

    public int getRange() {
        IItemHandler ph = (IItemHandler)this.privateHandler.orElse(null);
        return ph.getStackInSlot(4).func_190916_E();
    }

    public boolean addLight() {
        if (this.hasLight()) {
            return false;
        }
        this.boolLight = true;
        BlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
        boolean watered = (Boolean)state.func_177229_b((Property)PedestalBlock.WATERLOGGED);
        Direction dir = (Direction)state.func_177229_b((Property)PedestalBlock.field_176387_N);
        int filterState = (Integer)state.func_177229_b((Property)PedestalBlock.FILTER_STATUS);
        BlockState newstate = (BlockState)((BlockState)((BlockState)((BlockState)state.func_206870_a((Property)PedestalBlock.field_176387_N, (Comparable)dir)).func_206870_a((Property)PedestalBlock.WATERLOGGED, (Comparable)Boolean.valueOf(watered))).func_206870_a((Property)PedestalBlock.LIT, (Comparable)Boolean.valueOf(true))).func_206870_a((Property)PedestalBlock.FILTER_STATUS, (Comparable)Integer.valueOf(filterState));
        IItemHandler ph = (IItemHandler)this.privateHandler.orElse(null);
        ph.insertItem(1, new ItemStack((IItemProvider)Items.field_221695_cJ, 1), false);
        this.field_145850_b.func_184138_a(this.field_174879_c, state, newstate, 3);
        this.field_145850_b.func_180501_a(this.field_174879_c, newstate, 3);
        this.field_145850_b.func_225319_b(this.field_174879_c, state, newstate);
        return true;
    }

    public boolean hasLight() {
        IItemHandler ph = (IItemHandler)this.privateHandler.orElse(null);
        return !ph.getStackInSlot(1).func_190926_b();
    }

    public boolean addColor(ItemStack stack) {
        if (!(this.hasCoin() || this.hasItem() || this.hasLight() || this.hasSpeed() || this.hasCapacity() || this.hasRange() || this.getNumberOfStoredLocations() > 0)) {
            int intColor = stack.func_77978_p().func_74762_e("color");
            BlockState replacestate = CraftingPedestals.instance().getResult(intColor);
            BlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
            if (replacestate.func_177230_c().equals(state.func_177230_c())) {
                return false;
            }
            boolean watered = (Boolean)state.func_177229_b((Property)PedestalBlock.WATERLOGGED);
            Direction dir = (Direction)state.func_177229_b((Property)PedestalBlock.field_176387_N);
            boolean lit = (Boolean)state.func_177229_b((Property)PedestalBlock.LIT);
            int filterState = (Integer)state.func_177229_b((Property)PedestalBlock.FILTER_STATUS);
            BlockState newstate = (BlockState)((BlockState)((BlockState)((BlockState)replacestate.func_206870_a((Property)PedestalBlock.field_176387_N, (Comparable)dir)).func_206870_a((Property)PedestalBlock.WATERLOGGED, (Comparable)Boolean.valueOf(watered))).func_206870_a((Property)PedestalBlock.LIT, (Comparable)Boolean.valueOf(lit))).func_206870_a((Property)PedestalBlock.FILTER_STATUS, (Comparable)Integer.valueOf(filterState));
            this.field_145850_b.func_184138_a(this.field_174879_c, state, newstate, 3);
            this.field_145850_b.func_180501_a(this.field_174879_c, newstate, 3);
            return true;
        }
        return false;
    }

    public boolean addTool(ItemStack tool, boolean simulate) {
        IItemHandler ph = (IItemHandler)this.privateHandler.orElse(null);
        ItemStack itemFromBlock = tool.func_77946_l();
        itemFromBlock.func_190920_e(1);
        if (!this.hasTool() && ph.isItemValid(5, itemFromBlock)) {
            if (!simulate) {
                ph.insertItem(5, itemFromBlock, false);
            }
            return true;
        }
        return false;
    }

    public boolean hasTool() {
        IItemHandler ph = (IItemHandler)this.privateHandler.orElse(null);
        return !ph.getStackInSlot(5).func_190926_b();
    }

    public ItemStack getToolOnPedestal() {
        IItemHandler ph = (IItemHandler)this.privateHandler.orElse(null);
        return ph.getStackInSlot(5);
    }

    public ItemStack removeTool() {
        IItemHandler ph = (IItemHandler)this.privateHandler.orElse(null);
        return ph.extractItem(5, ph.getStackInSlot(5).func_190916_E(), false);
    }

    public boolean hasFilter() {
        IItemHandler ph = (IItemHandler)this.privateHandler.orElse(null);
        return !ph.getStackInSlot(6).func_190926_b();
    }

    public ItemStack getFilterInPedestal() {
        IItemHandler ph = (IItemHandler)this.privateHandler.orElse(null);
        return ph.getStackInSlot(6);
    }

    public ItemStack removeFilter(boolean updateBlock) {
        IItemHandler ph = (IItemHandler)this.privateHandler.orElse(null);
        if (updateBlock) {
            BlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
            int filterState = 0;
            boolean watered = (Boolean)state.func_177229_b((Property)PedestalBlock.WATERLOGGED);
            Direction dir = (Direction)state.func_177229_b((Property)PedestalBlock.field_176387_N);
            boolean lit = (Boolean)state.func_177229_b((Property)PedestalBlock.LIT);
            BlockState newstate = (BlockState)((BlockState)((BlockState)((BlockState)state.func_206870_a((Property)PedestalBlock.field_176387_N, (Comparable)dir)).func_206870_a((Property)PedestalBlock.WATERLOGGED, (Comparable)Boolean.valueOf(watered))).func_206870_a((Property)PedestalBlock.LIT, (Comparable)Boolean.valueOf(lit))).func_206870_a((Property)PedestalBlock.FILTER_STATUS, (Comparable)Integer.valueOf(filterState));
            this.field_145850_b.func_184138_a(this.field_174879_c, state, newstate, 3);
            this.field_145850_b.func_180501_a(this.field_174879_c, newstate, 3);
            this.field_145850_b.func_225319_b(this.field_174879_c, state, newstate);
        }
        if (this.hasCoin() && this.getCoinOnPedestal().func_77973_b() instanceof IUpgradeBase) {
            IUpgradeBase coin = (IUpgradeBase)this.getCoinOnPedestal().func_77973_b();
            coin.setFilterChangeUpdate(this.getCoinOnPedestal());
        }
        return ph.extractItem(6, ph.getStackInSlot(6).func_190916_E(), false);
    }

    public boolean addFilter(ItemStack filter, boolean simulate) {
        if (this.hasFilter()) {
            return false;
        }
        BlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
        boolean watered = (Boolean)state.func_177229_b((Property)PedestalBlock.WATERLOGGED);
        Direction dir = (Direction)state.func_177229_b((Property)PedestalBlock.field_176387_N);
        boolean lit = (Boolean)state.func_177229_b((Property)PedestalBlock.LIT);
        int filterState = (Integer)state.func_177229_b((Property)PedestalBlock.FILTER_STATUS);
        if (filter.func_77973_b() instanceof IFilterBase) {
            filterState = ((IFilterBase)filter.func_77973_b()).getFilterTypeFromNBT(filter) ? 2 : 1;
        }
        BlockState newstate = (BlockState)((BlockState)((BlockState)((BlockState)state.func_206870_a((Property)PedestalBlock.field_176387_N, (Comparable)dir)).func_206870_a((Property)PedestalBlock.WATERLOGGED, (Comparable)Boolean.valueOf(watered))).func_206870_a((Property)PedestalBlock.LIT, (Comparable)Boolean.valueOf(lit))).func_206870_a((Property)PedestalBlock.FILTER_STATUS, (Comparable)Integer.valueOf(filterState));
        IItemHandler ph = (IItemHandler)this.privateHandler.orElse(null);
        ItemStack filterItem = filter.func_77946_l();
        filterItem.func_190920_e(1);
        if (!this.hasFilter() && ph.isItemValid(6, filterItem)) {
            if (!simulate) {
                ph.insertItem(6, filterItem, false);
                this.field_145850_b.func_184138_a(this.field_174879_c, state, newstate, 3);
                this.field_145850_b.func_180501_a(this.field_174879_c, newstate, 3);
                this.field_145850_b.func_225319_b(this.field_174879_c, state, newstate);
                if (this.hasCoin() && this.getCoinOnPedestal().func_77973_b() instanceof IUpgradeBase) {
                    IUpgradeBase coin = (IUpgradeBase)this.getCoinOnPedestal().func_77973_b();
                    coin.setFilterChangeUpdate(this.getCoinOnPedestal());
                }
            }
            return true;
        }
        return false;
    }

    public boolean updateFilter(ItemStack filter, boolean updateBlock) {
        if (this.hasFilter()) {
            IItemHandler ph;
            int filterState;
            ItemStack oldStack = this.getFilterInPedestal().func_77946_l();
            BlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
            int newFilterState = filterState = ((Integer)state.func_177229_b((Property)PedestalBlock.FILTER_STATUS)).intValue();
            if (filter.func_77973_b() instanceof IFilterBase) {
                int n = newFilterState = ((IFilterBase)filter.func_77973_b()).getFilterTypeFromNBT(filter) ? 2 : 1;
                if (filter.func_77942_o()) {
                    oldStack.func_77982_d(filter.func_77978_p());
                    if (this.hasCoin() && this.getCoinOnPedestal().func_77973_b() instanceof IUpgradeBase) {
                        IUpgradeBase coin = (IUpgradeBase)this.getCoinOnPedestal().func_77973_b();
                        coin.setFilterChangeUpdate(this.getCoinOnPedestal());
                    }
                }
            }
            if ((ph = (IItemHandler)this.privateHandler.orElse(null)).isItemValid(6, filter)) {
                if (updateBlock) {
                    this.removeFilter(false);
                    ph.insertItem(6, oldStack, false);
                    if (newFilterState != filterState) {
                        boolean watered = (Boolean)state.func_177229_b((Property)PedestalBlock.WATERLOGGED);
                        Direction dir = (Direction)state.func_177229_b((Property)PedestalBlock.field_176387_N);
                        boolean lit = (Boolean)state.func_177229_b((Property)PedestalBlock.LIT);
                        BlockState newstate = (BlockState)((BlockState)((BlockState)((BlockState)state.func_206870_a((Property)PedestalBlock.field_176387_N, (Comparable)dir)).func_206870_a((Property)PedestalBlock.WATERLOGGED, (Comparable)Boolean.valueOf(watered))).func_206870_a((Property)PedestalBlock.LIT, (Comparable)Boolean.valueOf(lit))).func_206870_a((Property)PedestalBlock.FILTER_STATUS, (Comparable)Integer.valueOf(newFilterState));
                        this.field_145850_b.func_184138_a(this.field_174879_c, state, newstate, 3);
                        this.field_145850_b.func_180501_a(this.field_174879_c, newstate, 3);
                        this.field_145850_b.func_225319_b(this.field_174879_c, state, newstate);
                        if (this.hasCoin() && this.getCoinOnPedestal().func_77973_b() instanceof IUpgradeBase) {
                            IUpgradeBase coin = (IUpgradeBase)this.getCoinOnPedestal().func_77973_b();
                            coin.setFilterChangeUpdate(this.getCoinOnPedestal());
                        }
                    }
                }
                return true;
            }
        }
        return false;
    }

    public boolean hasTorch() {
        IItemHandler ph = (IItemHandler)this.privateHandler.orElse(null);
        return !ph.getStackInSlot(7).func_190926_b();
    }

    public ItemStack removeTorch() {
        IItemHandler ph = (IItemHandler)this.privateHandler.orElse(null);
        return ph.extractItem(7, ph.getStackInSlot(7).func_190916_E(), false);
    }

    public boolean addTorch() {
        IItemHandler ph = (IItemHandler)this.privateHandler.orElse(null);
        ItemStack itemFromBlock = new ItemStack((IItemProvider)Items.field_221764_cr);
        itemFromBlock.func_190920_e(1);
        if (!this.hasTorch() && ph.isItemValid(7, itemFromBlock)) {
            ph.insertItem(7, itemFromBlock, false);
            return true;
        }
        return false;
    }

    public boolean isPedestalBlockPowered(World world, BlockPos pos) {
        boolean returner = world.func_175640_z(pos);
        if (this.hasTorch()) {
            return !returner;
        }
        return returner;
    }

    public boolean addRRobin(ItemStack roundRobin) {
        IItemHandler ph = (IItemHandler)this.privateHandler.orElse(null);
        ItemStack itemFromBlock = roundRobin.func_77946_l();
        itemFromBlock.func_190920_e(1);
        if (!this.hasRRobin()) {
            ph.insertItem(8, itemFromBlock, false);
            return true;
        }
        return false;
    }

    public ItemStack removeRRobin() {
        IItemHandler ph = (IItemHandler)this.privateHandler.orElse(null);
        if (this.hasRRobin()) {
            return ph.extractItem(8, ph.getStackInSlot(8).func_190916_E(), false);
        }
        return ItemStack.field_190927_a;
    }

    public boolean hasRRobin() {
        IItemHandler ph = (IItemHandler)this.privateHandler.orElse(null);
        return !ph.getStackInSlot(8).func_190926_b();
    }

    public boolean addMuffler(ItemStack muffler) {
        IItemHandler ph = (IItemHandler)this.privateHandler.orElse(null);
        ItemStack itemFromBlock = muffler.func_77946_l();
        itemFromBlock.func_190920_e(1);
        if (!this.hasMuffler()) {
            ph.insertItem(9, itemFromBlock, false);
            return true;
        }
        return false;
    }

    public ItemStack removeMuffler() {
        IItemHandler ph = (IItemHandler)this.privateHandler.orElse(null);
        if (this.hasMuffler()) {
            return ph.extractItem(9, ph.getStackInSlot(9).func_190916_E(), false);
        }
        return ItemStack.field_190927_a;
    }

    public boolean hasMuffler() {
        IItemHandler ph = (IItemHandler)this.privateHandler.orElse(null);
        return !ph.getStackInSlot(9).func_190926_b();
    }

    public ItemStack addParticleDiffuser(ItemStack particle) {
        IItemHandler ph = (IItemHandler)this.privateHandler.orElse(null);
        ItemStack itemFromBlock = particle.func_77946_l();
        itemFromBlock.func_190920_e(1);
        if (!this.hasParticleDiffuser()) {
            return ph.insertItem(10, itemFromBlock, false);
        }
        return ItemStack.field_190927_a;
    }

    public ItemStack removeParticleDiffuser() {
        IItemHandler ph = (IItemHandler)this.privateHandler.orElse(null);
        if (this.hasParticleDiffuser()) {
            return ph.extractItem(10, ph.getStackInSlot(10).func_190916_E(), false);
        }
        return ItemStack.field_190927_a;
    }

    public boolean hasParticleDiffuser() {
        IItemHandler ph = (IItemHandler)this.privateHandler.orElse(null);
        return !ph.getStackInSlot(10).func_190926_b();
    }

    public boolean canSendItemInPedestal(PedestalTileEntity pedestal) {
        if (pedestal.hasItem()) {
            if (this.hasCoin()) {
                Item coin = this.getCoinOnPedestal().func_77973_b();
                if (coin instanceof IUpgradeBase) {
                    return ((IUpgradeBase)coin).canSendItem(pedestal);
                }
            } else {
                return true;
            }
        }
        return false;
    }

    public boolean isSamePedestal(BlockPos pedestalToBeLinked) {
        BlockPos thisPedestal = this.func_174877_v();
        return thisPedestal.equals((Object)pedestalToBeLinked);
    }

    public boolean canLinkToPedestalNetwork(BlockPos pedestalToBeLinked) {
        return this.field_145850_b.func_180495_p(pedestalToBeLinked).func_177230_c() instanceof PedestalBlock;
    }

    public int canAcceptItems(World worldIn, BlockPos posPedestal, ItemStack itemsIncoming) {
        Item filterInPed;
        int canAccept = 0;
        int pedestalAccept = 0;
        boolean isTank = false;
        if (this.hasCoin()) {
            Item coinInPed = this.getCoinOnPedestal().func_77973_b();
            if (coinInPed instanceof IUpgradeBase) {
                pedestalAccept = ((IUpgradeBase)coinInPed).canAcceptCount(worldIn, posPedestal, this.getItemInPedestal(), itemsIncoming);
            }
            if (coinInPed instanceof ItemUpgradeItemTank && ((ItemUpgradeItemTank)coinInPed).availableStorageSpace(this) > 0) {
                isTank = true;
            }
        }
        if (this.getItemInPedestal().func_190926_b() || this.getItemInPedestal().equals(ItemStack.field_190927_a)) {
            canAccept = itemsIncoming.func_77976_d();
        } else if (ItemHandlerHelper.canItemStacksStack((ItemStack)this.getItemInPedestal(), (ItemStack)itemsIncoming) && (itemsIncoming.func_77976_d() > 1 || isTank)) {
            int allowed = this.getSlotSizeLimit();
            if (allowed > itemsIncoming.func_77976_d() && !isTank) {
                allowed = itemsIncoming.func_77976_d();
            }
            if (this.getItemInPedestal().func_190916_E() < allowed) {
                canAccept = allowed - this.getItemInPedestal().func_190916_E();
            }
        }
        if (this.hasFilter() && (filterInPed = this.getFilterInPedestal().func_77973_b()) instanceof IFilterBase) {
            pedestalAccept = ((IFilterBase)filterInPed).canAcceptCount(this.getTile(), itemsIncoming);
        }
        if (canAccept > pedestalAccept && (this.hasFilter() || this.hasCoin())) {
            canAccept = pedestalAccept;
        }
        return canAccept;
    }

    public boolean hasFilter(PedestalTileEntity pedestalSendingTo) {
        Item filterInPedestal;
        boolean returner = false;
        if (pedestalSendingTo.hasFilter() && (filterInPedestal = pedestalSendingTo.getFilterInPedestal().func_77973_b()) instanceof IFilterBase) {
            returner = true;
        }
        return returner;
    }

    public Boolean canSendItemInPedestal() {
        Item coinInPedestal;
        boolean returner = true;
        if (this.hasCoin() && (coinInPedestal = this.getCoinOnPedestal().func_77973_b()) instanceof IUpgradeBase) {
            return ((IUpgradeBase)coinInPedestal).canSendItem(this);
        }
        return returner;
    }

    public static LazyOptional<IItemHandler> findItemHandlerPedestal(PedestalTileEntity pedestal) {
        LazyOptional cap;
        BlockPos pos;
        World world = pedestal.func_145831_w();
        TileEntity neighbourTile = world.func_175625_s(pos = pedestal.func_174877_v());
        if (neighbourTile != null && (cap = neighbourTile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, Direction.UP)).isPresent()) {
            return cap;
        }
        return LazyOptional.empty();
    }

    public boolean canSendToPedestal(BlockPos pedestalToSendTo, ItemStack itemStackIncoming) {
        boolean returner = false;
        if (this.canSendItemInPedestal().booleanValue() && this.field_145850_b.isAreaLoaded(pedestalToSendTo, 1) && !this.field_145850_b.func_175640_z(pedestalToSendTo)) {
            if (this.field_145850_b.func_180495_p(pedestalToSendTo).func_177230_c() instanceof PedestalBlock) {
                PedestalTileEntity tilePedestalToSendTo;
                if (this.canLinkToPedestalNetwork(pedestalToSendTo) && this.field_145850_b.func_175625_s(pedestalToSendTo) instanceof PedestalTileEntity && (tilePedestalToSendTo = (PedestalTileEntity)this.field_145850_b.func_175625_s(pedestalToSendTo)).canAcceptItems(this.field_145850_b, pedestalToSendTo, itemStackIncoming) > 0) {
                    Item coinInPedestal;
                    Item filterInPedestal;
                    boolean filter = true;
                    boolean coin = true;
                    if (tilePedestalToSendTo.hasFilter() && (filterInPedestal = tilePedestalToSendTo.getFilterInPedestal().func_77973_b()) instanceof IFilterBase) {
                        filter = ((IFilterBase)filterInPedestal).canAcceptItem(tilePedestalToSendTo, itemStackIncoming);
                    }
                    if (tilePedestalToSendTo.hasCoin() && (coinInPedestal = tilePedestalToSendTo.getCoinOnPedestal().func_77973_b()) instanceof IUpgradeBase) {
                        coin = ((IUpgradeBase)coinInPedestal).canAcceptItem(this.func_145831_w(), pedestalToSendTo, itemStackIncoming);
                    }
                    returner = filter && coin;
                }
            } else {
                this.removeLocation(pedestalToSendTo);
            }
        }
        return returner;
    }

    public void sendItemsToPedestal(BlockPos pedestalToSendTo) {
        if (this.field_145850_b.func_175625_s(pedestalToSendTo) instanceof PedestalTileEntity) {
            PedestalTileEntity tileToSendTo = (PedestalTileEntity)this.field_145850_b.func_175625_s(pedestalToSendTo);
            int countToSend = tileToSendTo.canAcceptItems(this.field_145850_b, pedestalToSendTo, this.getItemInPedestal());
            ItemStack copyStackToSend = this.getItemInPedestal().func_77946_l();
            if (copyStackToSend.func_190916_E() < countToSend) {
                countToSend = copyStackToSend.func_190916_E();
            }
            if (countToSend > this.getItemTransferRate()) {
                countToSend = this.getItemTransferRate();
            }
            if (countToSend >= 1) {
                copyStackToSend.func_190920_e(countToSend);
                this.removeItem(copyStackToSend.func_190916_E());
                tileToSendTo.addItem(copyStackToSend);
                if (!this.hasParticleDiffuser()) {
                    PacketHandler.sendToNearby(this.field_145850_b, this.field_174879_c, (Object)new PacketParticles(PacketParticles.EffectType.ANY_COLOR_BEAM, pedestalToSendTo.func_177958_n(), (double)pedestalToSendTo.func_177956_o(), (double)pedestalToSendTo.func_177952_p(), this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p()));
                }
            }
        }
    }

    public void transferActionItems() {
        int locations = this.getNumberOfStoredLocations();
        if (locations > 0) {
            if (this.hasRRobin()) {
                BlockPos posReceiver;
                int robinCount = this.getStoredValueForUpgrades();
                if (robinCount >= locations) {
                    this.setStoredValueForUpgrades(0);
                    robinCount = 0;
                }
                if (this.canSendToPedestal(posReceiver = this.getStoredPositionAt(robinCount), this.getItemInPedestal())) {
                    this.sendItemsToPedestal(posReceiver);
                }
                this.setStoredValueForUpgrades(++robinCount);
            } else {
                for (int i = 0; i < locations; ++i) {
                    BlockPos posReceiver = this.getStoredPositionAt(i);
                    if (!this.canSendToPedestal(posReceiver, this.getItemInPedestal())) continue;
                    this.sendItemsToPedestal(posReceiver);
                    break;
                }
            }
        }
    }

    public void func_73660_a() {
        Item coinInPed;
        if (!this.field_145850_b.field_72995_K && this.field_145850_b.isAreaLoaded(this.field_174879_c, 1) && this.getNumberOfStoredLocations() > 0 && !this.isPedestalBlockPowered(this.func_145831_w(), this.func_174877_v()) && this.hasItem()) {
            ++this.pedTicker;
            if (this.pedTicker % this.getOperationSpeed() == 0) {
                this.transferActionItems();
                if (this.pedTicker >= 20) {
                    this.pedTicker = 0;
                }
            }
        }
        if (this.field_145850_b.isAreaLoaded(this.field_174879_c, 1) && this.hasCoin() && (coinInPed = this.getCoinOnPedestal().func_77973_b()) instanceof IUpgradeBase) {
            ++this.impTicker;
            ((IUpgradeBase)coinInPed).updateAction(this.field_145850_b, this);
            if (this.impTicker >= 2147483547) {
                this.impTicker = 0;
            }
        }
        if (this.field_145850_b.field_72995_K && !this.hasParticleDiffuser() && this.hasCoin() && (coinInPed = this.getCoinOnPedestal().func_77973_b()) instanceof IUpgradeBase) {
            ++this.partTicker;
            Random rand = new Random();
            ((IUpgradeBase)coinInPed).onRandomDisplayTick(this, this.partTicker, this.field_145850_b.func_180495_p(this.func_174877_v()), this.field_145850_b, this.func_174877_v(), rand);
            if (this.partTicker >= 2147483547) {
                this.partTicker = 0;
            }
        }
    }

    public void func_230337_a_(BlockState state, CompoundNBT nbt) {
        super.func_230337_a_(state, nbt);
        CompoundNBT invTag = nbt.func_74775_l("inv");
        CompoundNBT invTagP = nbt.func_74775_l("invp");
        this.handler.ifPresent(h -> ((INBTSerializable)h).deserializeNBT((INBT)invTag));
        this.privateHandler.ifPresent(ph -> ((INBTSerializable)ph).deserializeNBT((INBT)invTagP));
        this.storedValueForUpgrades = nbt.func_74762_e("storedUpgradeValue");
        this.boolLight = nbt.func_74767_n("boollight");
        int[] storedIX = nbt.func_74759_k("intArrayXPos");
        int[] storedIY = nbt.func_74759_k("intArrayYPos");
        int[] storedIZ = nbt.func_74759_k("intArrayZPos");
        for (int i = 0; i < storedIX.length; ++i) {
            BlockPos gotPos = new BlockPos(storedIX[i], storedIY[i], storedIZ[i]);
            this.storedLocations.add(gotPos);
        }
        this.lockCode = LockCode.func_180158_b((CompoundNBT)nbt);
    }

    public CompoundNBT func_189515_b(CompoundNBT tag) {
        super.func_189515_b(tag);
        this.handler.ifPresent(h -> {
            CompoundNBT compound = (CompoundNBT)((INBTSerializable)h).serializeNBT();
            tag.func_218657_a("inv", (INBT)compound);
        });
        this.privateHandler.ifPresent(ph -> {
            CompoundNBT compound = (CompoundNBT)((INBTSerializable)ph).serializeNBT();
            tag.func_218657_a("invp", (INBT)compound);
        });
        tag.func_74768_a("storedUpgradeValue", this.storedValueForUpgrades);
        tag.func_74757_a("boollight", this.boolLight);
        ArrayList<Integer> storedX = new ArrayList<Integer>();
        ArrayList<Integer> storedY = new ArrayList<Integer>();
        ArrayList<Integer> storedZ = new ArrayList<Integer>();
        for (int i = 0; i < this.getNumberOfStoredLocations(); ++i) {
            storedX.add(this.storedLocations.get(i).func_177958_n());
            storedY.add(this.storedLocations.get(i).func_177956_o());
            storedZ.add(this.storedLocations.get(i).func_177952_p());
        }
        tag.func_197646_b("intArrayXPos", storedX);
        tag.func_197646_b("intArrayYPos", storedY);
        tag.func_197646_b("intArrayZPos", storedZ);
        this.lockCode.func_180157_a(tag);
        return tag;
    }

    @Nullable
    public SUpdateTileEntityPacket func_189518_D_() {
        CompoundNBT nbtTagCompound = new CompoundNBT();
        this.func_189515_b(nbtTagCompound);
        int tileEntityType = 42;
        return new SUpdateTileEntityPacket(this.field_174879_c, tileEntityType, nbtTagCompound);
    }

    public CompoundNBT func_189517_E_() {
        return this.func_189515_b(new CompoundNBT());
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        super.onDataPacket(net, pkt);
        BlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
        this.handleUpdateTag(state, pkt.func_148857_g());
        this.field_145850_b.func_184138_a(this.field_174879_c, state, state, 3);
    }

    public void handleUpdateTag(BlockState state, CompoundNBT tag) {
        this.func_230337_a_(state, tag);
    }

    @SubscribeEvent
    public static void onTileEntityRegistry(RegistryEvent.Register<TileEntityType<?>> event) {
        IForgeRegistry r = event.getRegistry();
        r.register(PEDESTALTYPE.setRegistryName(RESLOC_TILE_PEDESTAL));
    }

    public void func_145843_s() {
        super.func_145843_s();
        if (this.handler != null) {
            this.handler.invalidate();
        }
        if (this.privateHandler != null) {
            this.privateHandler.invalidate();
        }
        if (this.energyHandler != null) {
            this.energyHandler.invalidate();
        }
        if (this.fluidHandler != null) {
            this.fluidHandler.invalidate();
        }
    }
}

