/*
 * Decompiled with CFR 0.152.
 */
package com.mowmaster.pedestals.recipes;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import javax.annotation.Nullable;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class SawMillRecipe
implements IRecipe<IInventory> {
    public static final IRecipeType<SawMillRecipe> recipeType = IRecipeType.func_222147_a((String)"pedestals:sawmill");
    public static final Serializer serializer = new Serializer();
    private final ResourceLocation recipeId;
    private Ingredient ingredient;
    private ItemStack result;

    public SawMillRecipe(ResourceLocation recipeId) {
        this.recipeId = recipeId;
    }

    public Ingredient getIngredient() {
        return this.ingredient;
    }

    public ItemStack getResult() {
        return this.result;
    }

    public boolean func_77569_a(IInventory inv, World worldIn) {
        ItemStack stack = inv.func_70301_a(0);
        return this.ingredient.test(stack);
    }

    public ItemStack func_77572_b(IInventory inv) {
        return ItemStack.field_190927_a;
    }

    public boolean func_194133_a(int width, int height) {
        return true;
    }

    public ItemStack func_77571_b() {
        return ItemStack.field_190927_a;
    }

    public ResourceLocation func_199560_c() {
        return this.recipeId;
    }

    public IRecipeSerializer<?> func_199559_b() {
        return serializer;
    }

    public IRecipeType<?> func_222127_g() {
        return recipeType;
    }

    public static class Serializer
    extends ForgeRegistryEntry<IRecipeSerializer<?>>
    implements IRecipeSerializer<SawMillRecipe> {
        public static ArrayList<Item> ingredientList = new ArrayList();

        public SawMillRecipe read(ResourceLocation recipeId, JsonObject json) {
            SawMillRecipe recipe = new SawMillRecipe(recipeId);
            recipe.ingredient = Ingredient.func_199802_a((JsonElement)json.get("ingredient"));
            for (ItemStack stack : recipe.ingredient.func_193365_a()) {
                if (ingredientList.contains(stack.func_77973_b())) continue;
                ingredientList.add(stack.func_77973_b());
            }
            ResourceLocation itemResourceLocation = ResourceLocation.func_195828_a((String)JSONUtils.func_151219_a((JsonObject)json.get("result").getAsJsonObject(), (String)"item", (String)"minecraft:empty"), (char)':');
            int itemAmount = JSONUtils.func_151208_a((JsonObject)json.get("result").getAsJsonObject(), (String)"count", (int)0);
            recipe.result = new ItemStack((IItemProvider)ForgeRegistries.ITEMS.getValue(itemResourceLocation), itemAmount);
            return recipe;
        }

        @Nullable
        public SawMillRecipe read(ResourceLocation recipeId, PacketBuffer buffer) {
            SawMillRecipe recipe = new SawMillRecipe(recipeId);
            recipe.ingredient = Ingredient.func_199566_b((PacketBuffer)buffer);
            recipe.result = buffer.func_150791_c();
            return recipe;
        }

        public void write(PacketBuffer buffer, SawMillRecipe recipe) {
            recipe.ingredient.func_199564_a(buffer);
            buffer.func_150788_a(recipe.getResult());
        }
    }
}

