/*
 * Decompiled with CFR 0.152.
 */
package com.mowmaster.pedestals.recipes;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mowmaster.pedestals.blocks.PedestalBlock;
import com.mowmaster.pedestals.crafting.CraftingPedestals;
import com.mowmaster.pedestals.item.ItemColorPallet;
import java.util.ArrayList;
import javax.annotation.Nullable;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class ColoredPedestalRecipe
implements IRecipe<IInventory> {
    public static final IRecipeType<ColoredPedestalRecipe> recipeType = IRecipeType.func_222147_a((String)"pedestals:coloredpedestals");
    public static final Serializer serializer = new Serializer();
    private final ResourceLocation recipeId;
    private Ingredient ingredient;
    private int color;
    private ItemStack result;

    public ColoredPedestalRecipe(ResourceLocation recipeId) {
        this.recipeId = recipeId;
    }

    public Ingredient getIngredient() {
        return this.ingredient;
    }

    public int getColor() {
        return this.color;
    }

    public ItemStack getResult() {
        return this.result;
    }

    public boolean func_77569_a(IInventory inv, World worldIn) {
        ItemStack stack = inv.func_70301_a(0);
        int count = 0;
        if (stack.func_77978_p().func_74764_b("color")) {
            count = stack.func_77978_p().func_74762_e("color");
        }
        stack.func_190916_E();
        return this.ingredient.test(stack) && count >= this.color;
    }

    public ItemStack func_77572_b(IInventory inv) {
        ItemStack stack = inv.func_70301_a(0);
        int count = 0;
        if (stack.func_77973_b() instanceof ItemColorPallet && stack.func_77978_p().func_74764_b("color")) {
            count = stack.func_77978_p().func_74762_e("color");
        }
        return new ItemStack((IItemProvider)CraftingPedestals.instance().getResult(count).func_177230_c());
    }

    public boolean func_194133_a(int width, int height) {
        return true;
    }

    public ItemStack func_77571_b() {
        return new ItemStack((IItemProvider)PedestalBlock.I_PEDESTAL_333);
    }

    public ResourceLocation func_199560_c() {
        return this.recipeId;
    }

    public IRecipeSerializer<?> func_199559_b() {
        return serializer;
    }

    public IRecipeType<?> func_222127_g() {
        return recipeType;
    }

    public static class Serializer
    extends ForgeRegistryEntry<IRecipeSerializer<?>>
    implements IRecipeSerializer<ColoredPedestalRecipe> {
        public static ArrayList<Item> ingredientList = new ArrayList();

        public ColoredPedestalRecipe read(ResourceLocation recipeId, JsonObject json) {
            ColoredPedestalRecipe recipe = new ColoredPedestalRecipe(recipeId);
            recipe.ingredient = Ingredient.func_199802_a((JsonElement)json.get("ingredient"));
            recipe.color = JSONUtils.func_151208_a((JsonObject)json.get("ingredient").getAsJsonObject(), (String)"count", (int)1);
            for (ItemStack stack : recipe.ingredient.func_193365_a()) {
                if (ingredientList.contains(stack.func_77973_b())) continue;
                ingredientList.add(stack.func_77973_b());
            }
            ResourceLocation itemResourceLocation = ResourceLocation.func_195828_a((String)JSONUtils.func_151219_a((JsonObject)json.get("result").getAsJsonObject(), (String)"item", (String)"minecraft:empty"), (char)':');
            int itemAmount = JSONUtils.func_151208_a((JsonObject)json.get("result").getAsJsonObject(), (String)"count", (int)0);
            recipe.result = new ItemStack((IItemProvider)ForgeRegistries.ITEMS.getValue(itemResourceLocation), itemAmount);
            return recipe;
        }

        @Nullable
        public ColoredPedestalRecipe read(ResourceLocation recipeId, PacketBuffer buffer) {
            ColoredPedestalRecipe recipe = new ColoredPedestalRecipe(recipeId);
            recipe.ingredient = Ingredient.func_199566_b((PacketBuffer)buffer);
            recipe.color = buffer.readInt();
            recipe.result = buffer.func_150791_c();
            return recipe;
        }

        public void write(PacketBuffer buffer, ColoredPedestalRecipe recipe) {
            recipe.ingredient.func_199564_a(buffer);
            buffer.writeInt(recipe.getColor());
            buffer.func_150788_a(recipe.getResult());
        }
    }
}

