/*
 * Decompiled with CFR 0.152.
 */
package com.mowmaster.pedestals.network;

import java.util.Random;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.network.PacketBuffer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.particles.RedstoneParticleData;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.network.NetworkEvent;

public class PacketParticles {
    private final EffectType type;
    private final double x;
    private final double y;
    private final double z;
    private final int[] args;

    public PacketParticles(EffectType type, double x, double y, double z, int ... args) {
        this.type = type;
        this.x = x;
        this.y = y;
        this.z = z;
        this.args = args;
    }

    public PacketParticles(EffectType type, BlockPos pos, int ... args) {
        this(type, pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), args);
    }

    public static PacketParticles decode(PacketBuffer buf) {
        EffectType type = EffectType.values()[buf.readByte()];
        double x = buf.readDouble();
        double y = buf.readDouble();
        double z = buf.readDouble();
        int[] args = new int[type.argCount];
        for (int i = 0; i < args.length; ++i) {
            args[i] = buf.func_150792_a();
        }
        return new PacketParticles(type, x, y, z, args);
    }

    public static void encode(PacketParticles msg, PacketBuffer buf) {
        buf.writeByte(msg.type.ordinal());
        buf.writeDouble(msg.x);
        buf.writeDouble(msg.y);
        buf.writeDouble(msg.z);
        for (int i = 0; i < msg.type.argCount; ++i) {
            buf.func_150787_b(msg.args[i]);
        }
    }

    public static enum EffectType {
        ANY_COLOR(3),
        ANY_COLOR_CENTERED(3),
        ANY_COLOR_BEAM(3);

        private final int argCount;

        private EffectType(int argCount) {
            this.argCount = argCount;
        }
    }

    public static class Handler {
        public static void handle(final PacketParticles message, Supplier<NetworkEvent.Context> ctx) {
            if (ctx.get().getDirection().getReceptionSide().isServer()) {
                ctx.get().setPacketHandled(true);
                return;
            }
            ctx.get().enqueueWork(new Runnable(){

                @Override
                public void run() {
                    Minecraft mc = Minecraft.func_71410_x();
                    ClientWorld world = mc.field_71441_e;
                    switch (message.type) {
                        case ANY_COLOR: {
                            for (int i = 0; i < 10; ++i) {
                                double d0 = message.x + 0.5;
                                double d1 = message.y + 1.0;
                                double d2 = message.z + 0.5;
                                float red = (float)message.args[0] / 255.0f;
                                float green = (float)message.args[1] / 255.0f;
                                float blue = (float)message.args[2] / 255.0f;
                                world.func_195594_a((IParticleData)new RedstoneParticleData(red, green, blue, 1.0f), d0, d1, d2, ((double)(world.field_73012_v.nextFloat() * 1.0f) - 0.5) / 3.0, ((double)(world.field_73012_v.nextFloat() * 1.0f) - 0.5) / 3.0, ((double)(world.field_73012_v.nextFloat() * 1.0f) - 0.5) / 3.0);
                            }
                            break;
                        }
                        case ANY_COLOR_CENTERED: {
                            for (int i = 0; i < 10; ++i) {
                                double d0 = message.x + 0.5;
                                double d1 = message.y + 0.5;
                                double d2 = message.z + 0.5;
                                float red = (float)message.args[0] / 255.0f;
                                float green = (float)message.args[1] / 255.0f;
                                float blue = (float)message.args[2] / 255.0f;
                                world.func_195594_a((IParticleData)new RedstoneParticleData(red, green, blue, 1.0f), d0, d1, d2, ((double)(world.field_73012_v.nextFloat() * 1.0f) - 0.5) / 3.0, ((double)(world.field_73012_v.nextFloat() * 1.0f) - 0.5) / 3.0, ((double)(world.field_73012_v.nextFloat() * 1.0f) - 0.5) / 3.0);
                            }
                            break;
                        }
                        case ANY_COLOR_BEAM: {
                            for (int z = 0; z < 10; ++z) {
                                double x1 = message.x;
                                double y1 = message.y;
                                double z1 = message.z;
                                double x2 = message.args[0];
                                double y2 = message.args[1];
                                double z2 = message.args[2];
                                double x3 = x2 - x1;
                                double y3 = y2 - y1;
                                double z3 = z2 - z1;
                                BlockPos pos = new BlockPos(x1, y1, z1);
                                Random rand = new Random();
                                world.func_195594_a((IParticleData)ParticleTypes.field_197623_p, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 1.25, (double)pos.func_177952_p() + 0.5, (double)((float)x3 + rand.nextFloat()) - 0.5, (double)((float)y3 - rand.nextFloat()), (double)((float)z3 + rand.nextFloat()) - 0.5);
                            }
                            break;
                        }
                    }
                }
            });
            ctx.get().setPacketHandled(true);
        }
    }
}

