/*
 * Decompiled with CFR 0.152.
 */
package com.mowmaster.pedestals.item.pedestalUpgrades;

import com.mowmaster.pedestals.blocks.PedestalBlock;
import com.mowmaster.pedestals.item.pedestalUpgrades.ItemUpgradeBase;
import com.mowmaster.pedestals.pedestals;
import com.mowmaster.pedestals.tiles.PedestalTileEntity;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tags.ITag;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class ItemUpgradeVoid
extends ItemUpgradeBase {
    public static final Item VOID = (Item)new ItemUpgradeVoid(new Item.Properties().func_200917_a(64).func_200916_a(pedestals.PEDESTALS_TAB)).setRegistryName(new ResourceLocation("pedestals", "coin/void"));

    public ItemUpgradeVoid(Item.Properties builder) {
        super(builder.func_200916_a(pedestals.PEDESTALS_TAB));
    }

    @Override
    public boolean canAcceptCapacity() {
        return true;
    }

    @Override
    public void updateAction(World world, PedestalTileEntity pedestal) {
        if (!world.field_72995_K) {
            ItemStack coinInPedestal = pedestal.getCoinOnPedestal();
            ItemStack itemInPedestal = pedestal.getItemInPedestal();
            BlockPos pedestalPos = pedestal.func_174877_v();
            int speed = this.getOperationSpeed(coinInPedestal);
            if (!pedestal.isPedestalBlockPowered(world, pedestalPos)) {
                if (world.func_82737_E() % (long)speed == 0L) {
                    this.upgradeAction(world, itemInPedestal, coinInPedestal, pedestalPos);
                }
                if (!itemInPedestal.equals(ItemStack.field_190927_a)) {
                    this.removeFromPedestal(world, pedestalPos, itemInPedestal.func_190916_E());
                }
            }
        }
    }

    public void upgradeAction(World world, ItemStack itemInPedestal, ItemStack coinInPedestal, BlockPos posOfPedestal) {
        int width = 0;
        int height = 1;
        BlockPos negBlockPos = this.getNegRangePosEntity(world, posOfPedestal, width, height);
        BlockPos posBlockPos = this.getPosRangePosEntity(world, posOfPedestal, width, height);
        BlockState state = world.func_180495_p(posOfPedestal);
        float damage = this.getDamageDelt(coinInPedestal);
        if (state.func_177230_c() instanceof PedestalBlock) {
            AxisAlignedBB getBox = new AxisAlignedBB(negBlockPos, posBlockPos);
            List entityList = world.func_217357_a(Entity.class, getBox);
            for (Entity getFromList : entityList) {
                if (getFromList instanceof ItemEntity) continue;
                getFromList.func_70097_a(DamageSource.field_76380_i, damage);
            }
        }
    }

    public float getDamageDelt(ItemStack coinInPedestal) {
        int capacityOver = this.getCapacityModifierOverEnchanted(coinInPedestal);
        return (float)(capacityOver * 2) + 2.0f;
    }

    @Override
    public void actionOnCollideWithBlock(World world, PedestalTileEntity tilePedestal, BlockPos posPedestal, BlockState state, Entity entityIn) {
        if (entityIn instanceof ItemEntity) {
            ItemStack stackCollidedItem = ((ItemEntity)entityIn).func_92059_d();
            if (this.canThisPedestalReceiveItemStack(tilePedestal, world, posPedestal, stackCollidedItem)) {
                entityIn.func_70106_y();
            }
        } else {
            entityIn.func_70106_y();
        }
    }

    @Override
    public void chatDetails(PlayerEntity player, PedestalTileEntity pedestal) {
        ItemStack stack = pedestal.getCoinOnPedestal();
        TranslationTextComponent name = new TranslationTextComponent(this.func_77658_a() + ".tooltip_name");
        name.func_240699_a_(TextFormatting.GOLD);
        player.func_145747_a((ITextComponent)name, Util.field_240973_b_);
        TranslationTextComponent rate = new TranslationTextComponent(this.func_77658_a() + ".chat_rate");
        rate.func_240702_b_("" + (int)(this.getDamageDelt(stack) / 2.0f) + "");
        rate.func_240699_a_(TextFormatting.GRAY);
        player.func_145747_a((ITextComponent)rate, Util.field_240973_b_);
        TranslationTextComponent speed = new TranslationTextComponent(this.func_77658_a() + ".chat_speed");
        speed.func_240702_b_(this.getOperationSpeedString(stack));
        speed.func_240699_a_(TextFormatting.RED);
        player.func_145747_a((ITextComponent)speed, Util.field_240973_b_);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        TranslationTextComponent t = new TranslationTextComponent(this.func_77658_a() + ".tooltip_name");
        t.func_240699_a_(TextFormatting.GOLD);
        tooltip.add((ITextComponent)t);
        ResourceLocation disabled = new ResourceLocation("pedestals", "enchant_limits/advanced_blacklist");
        ITag BLACKLISTED = ItemTags.func_199903_a().func_199910_a(disabled);
        if (BLACKLISTED != null) {
            if (!BLACKLISTED.func_230235_a_((Object)stack.func_77973_b())) {
                if ((this.intOperationalSpeedOver(stack) > 5 || this.getCapacityModifierOver(stack) > 5 || this.getAreaModifierUnRestricted(stack) > 5 || this.getRangeModifier(stack) > 5) && this.getAdvancedModifier(stack) <= 0) {
                    TranslationTextComponent warning = new TranslationTextComponent("pedestals.advanced_warning");
                    warning.func_240699_a_(TextFormatting.RED);
                    tooltip.add((ITextComponent)warning);
                }
            } else if (this.getAdvancedModifier(stack) > 0) {
                TranslationTextComponent disabled_warning = new TranslationTextComponent("pedestals.advanced_disabled_warning");
                disabled_warning.func_240699_a_(TextFormatting.DARK_RED);
                tooltip.add((ITextComponent)disabled_warning);
            }
        }
        TranslationTextComponent rate = new TranslationTextComponent(this.func_77658_a() + ".tooltip_rate");
        rate.func_240702_b_("" + (int)(this.getDamageDelt(stack) / 2.0f) + "");
        TranslationTextComponent speed = new TranslationTextComponent(this.func_77658_a() + ".tooltip_speed");
        speed.func_240702_b_(this.getOperationSpeedString(stack));
        rate.func_240699_a_(TextFormatting.GRAY);
        speed.func_240699_a_(TextFormatting.RED);
        tooltip.add((ITextComponent)rate);
        tooltip.add((ITextComponent)speed);
    }

    @SubscribeEvent
    public static void onItemRegistryReady(RegistryEvent.Register<Item> event) {
        event.getRegistry().register((IForgeRegistryEntry)VOID);
    }
}

