/*
 * Decompiled with CFR 0.152.
 */
package com.mowmaster.pedestals.item.pedestalUpgrades;

import com.mowmaster.pedestals.api.upgrade.IUpgradeBase;
import com.mowmaster.pedestals.enchants.EnchantmentArea;
import com.mowmaster.pedestals.enchants.EnchantmentCapacity;
import com.mowmaster.pedestals.enchants.EnchantmentOperationSpeed;
import com.mowmaster.pedestals.enchants.EnchantmentRange;
import com.mowmaster.pedestals.item.pedestalUpgrades.ItemUpgradeBase;
import com.mowmaster.pedestals.pedestals;
import com.mowmaster.pedestals.recipes.RecyclerRecipe;
import com.mowmaster.pedestals.tiles.PedestalTileEntity;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Inventory;
import net.minecraft.item.ArmorItem;
import net.minecraft.item.AxeItem;
import net.minecraft.item.HoeItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.PickaxeItem;
import net.minecraft.item.ShovelItem;
import net.minecraft.item.SwordItem;
import net.minecraft.item.TieredItem;
import net.minecraft.item.crafting.AbstractCookingRecipe;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.RecipeManager;
import net.minecraft.tags.ITag;
import net.minecraft.tags.ItemTags;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ToolType;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class ItemUpgradeRecycler
extends ItemUpgradeBase {
    public static final Item RECYCLER = (Item)new ItemUpgradeRecycler(new Item.Properties().func_200917_a(64).func_200916_a(pedestals.PEDESTALS_TAB)).setRegistryName(new ResourceLocation("pedestals", "coin/recycler"));

    public ItemUpgradeRecycler(Item.Properties builder) {
        super(builder.func_200916_a(pedestals.PEDESTALS_TAB));
    }

    @Override
    public boolean canAcceptCapacity() {
        return false;
    }

    @Override
    public boolean canAcceptAdvanced() {
        return true;
    }

    @Override
    public void updateAction(World world, PedestalTileEntity pedestal) {
        if (!world.field_72995_K) {
            ItemStack coinInPedestal = pedestal.getCoinOnPedestal();
            ItemStack itemInPedestal = pedestal.getItemInPedestal();
            BlockPos pedestalPos = pedestal.func_174877_v();
            int speed = this.getOperationSpeed(coinInPedestal);
            if (!pedestal.isPedestalBlockPowered(world, pedestalPos) && world.func_82737_E() % (long)speed == 0L && itemInPedestal.func_190926_b()) {
                if (this.hasAdvancedInventoryTargeting(coinInPedestal)) {
                    this.recyclerActionAdvanced(pedestal);
                } else {
                    this.doNormalAction(pedestal);
                }
            }
        }
    }

    public int getItemsExpDisenchantAmount(ItemStack stack) {
        int exp = 0;
        Map map = EnchantmentHelper.func_82781_a((ItemStack)stack);
        for (Map.Entry entry : map.entrySet()) {
            Enchantment enchantment = (Enchantment)entry.getKey();
            Integer integer = (Integer)entry.getValue();
            exp += enchantment.func_77321_a(integer.intValue());
        }
        return exp * stack.func_190916_E();
    }

    @Nullable
    protected AbstractCookingRecipe getNormalRecipe(World world, ItemStack stackIn) {
        Inventory inv = new Inventory(new ItemStack[]{stackIn});
        if (world == null) {
            return null;
        }
        RecipeManager recipeManager = world.func_199532_z();
        Optional optional = recipeManager.func_215371_a(IRecipeType.field_222151_c, (IInventory)inv, world);
        if (optional.isPresent()) {
            return (AbstractCookingRecipe)optional.get();
        }
        Optional optional1 = recipeManager.func_215371_a(IRecipeType.field_222150_b, (IInventory)inv, world);
        return optional1.orElse(null);
    }

    protected Collection<ItemStack> getNormalResults(AbstractCookingRecipe recipe, ItemStack stackIn) {
        Inventory inv = new Inventory(new ItemStack[]{stackIn});
        return recipe == null ? Arrays.asList(ItemStack.field_190927_a) : Collections.singleton(recipe.func_77572_b((IInventory)inv));
    }

    @Nullable
    protected RecyclerRecipe getRecipeRecycler(World world, ItemStack stackIn) {
        Inventory inv = new Inventory(new ItemStack[]{stackIn});
        return world == null ? null : (RecyclerRecipe)world.func_199532_z().func_215371_a(RecyclerRecipe.recipeType, (IInventory)inv, world).orElse(null);
    }

    protected Collection<ItemStack> getProcessResultsRecycler(RecyclerRecipe recipe) {
        return recipe == null ? Arrays.asList(ItemStack.field_190927_a) : Collections.singleton(recipe.getResult());
    }

    public void doNormalAction(PedestalTileEntity pedestal) {
        World world = pedestal.func_145831_w();
        ItemStack coinInPedestal = pedestal.getCoinOnPedestal();
        BlockPos posOfPedestal = pedestal.func_174877_v();
        BlockPos posInventory = this.getPosOfBlockBelow(world, posOfPedestal, 1);
        ItemStack itemFromInv = ItemStack.field_190927_a;
        ResourceLocation disabledRecycles = new ResourceLocation("pedestals", "recycler_blacklist");
        ITag BLACKLISTED = ItemTags.func_199903_a().func_199910_a(disabledRecycles);
        LazyOptional<IItemHandler> cap = ItemUpgradeRecycler.findItemHandlerAtPos(world, posInventory, this.getPedestalFacing(world, posOfPedestal), true);
        if (this.hasAdvancedInventoryTargeting(coinInPedestal)) {
            cap = ItemUpgradeRecycler.findItemHandlerAtPosAdvanced(world, posInventory, this.getPedestalFacing(world, posOfPedestal), true);
        }
        if (!this.isInventoryEmpty(cap) && cap.isPresent()) {
            IItemHandler handler = (IItemHandler)cap.orElse(null);
            TileEntity invToPullFrom = world.func_175625_s(posInventory);
            if (!(this.hasAdvancedInventoryTargeting(coinInPedestal) && invToPullFrom instanceof PedestalTileEntity || !(invToPullFrom instanceof PedestalTileEntity))) {
                itemFromInv = ItemStack.field_190927_a;
            } else if (handler != null) {
                int range = handler.getSlots();
                ItemStack nextItemToGrind = ItemStack.field_190927_a;
                nextItemToGrind = IntStream.range(0, range).mapToObj(arg_0 -> ((IItemHandler)handler).getStackInSlot(arg_0)).filter(itemStack -> !itemStack.func_190926_b()).findFirst().orElse(ItemStack.field_190927_a);
                Collection<ItemStack> jsonResults = this.getProcessResultsRecycler(this.getRecipeRecycler(pedestal.func_145831_w(), nextItemToGrind));
                ItemStack resultRecycler = jsonResults.iterator().next().func_190926_b() ? ItemStack.field_190927_a : jsonResults.iterator().next();
                Item getItemResultRecycler = resultRecycler.func_77973_b();
                int slotItemToGrind = this.getSlotWithMatchingStackExact(cap, nextItemToGrind);
                if (!nextItemToGrind.func_190926_b() && (nextItemToGrind.func_77973_b() instanceof IUpgradeBase || nextItemToGrind.func_77973_b() instanceof TieredItem || nextItemToGrind.func_77973_b() instanceof ArmorItem || !resultRecycler.func_190926_b()) && !BLACKLISTED.func_230235_a_((Object)nextItemToGrind.func_77973_b())) {
                    ItemStack resultSmelted;
                    Collection<ItemStack> smeltedResults = this.getNormalResults(this.getNormalRecipe(world, nextItemToGrind), nextItemToGrind);
                    ItemStack itemStack2 = resultSmelted = smeltedResults.iterator().next().func_190926_b() ? ItemStack.field_190927_a : smeltedResults.iterator().next();
                    if (!resultSmelted.func_190926_b()) {
                        ItemStack toReturn = resultSmelted.func_77946_l();
                        toReturn.func_190920_e(1);
                        if (!handler.extractItem(slotItemToGrind, toReturn.func_190916_E(), true).func_190926_b()) {
                            handler.extractItem(slotItemToGrind, toReturn.func_190916_E(), false);
                            if (!pedestal.hasMuffler()) {
                                world.func_184148_a((PlayerEntity)null, (double)posOfPedestal.func_177958_n(), (double)posOfPedestal.func_177956_o(), (double)posOfPedestal.func_177952_p(), SoundEvents.field_187680_c, SoundCategory.BLOCKS, 0.15f, 1.0f);
                            }
                            pedestal.addItemOverride(toReturn);
                        }
                    } else {
                        ItemStack toReturn = nextItemToGrind.func_77946_l();
                        if (!handler.extractItem(slotItemToGrind, toReturn.func_190916_E(), true).func_190926_b()) {
                            handler.extractItem(slotItemToGrind, toReturn.func_190916_E(), false);
                            pedestal.addItemOverride(toReturn);
                        }
                    }
                } else {
                    ItemStack toReturn = nextItemToGrind.func_77946_l();
                    if (!handler.extractItem(slotItemToGrind, toReturn.func_190916_E(), true).func_190926_b()) {
                        handler.extractItem(slotItemToGrind, toReturn.func_190916_E(), false);
                        pedestal.addItemOverride(toReturn);
                    }
                }
            }
        }
    }

    public void recyclerActionAdvanced(PedestalTileEntity pedestal) {
        World world = pedestal.func_145831_w();
        ItemStack coinInPedestal = pedestal.getCoinOnPedestal();
        BlockPos posOfPedestal = pedestal.func_174877_v();
        BlockPos posInventory = this.getPosOfBlockBelow(world, posOfPedestal, 1);
        ItemStack itemFromInv = ItemStack.field_190927_a;
        ResourceLocation disabledRecycles = new ResourceLocation("pedestals", "recycler_blacklist");
        ITag BLACKLISTED = ItemTags.func_199903_a().func_199910_a(disabledRecycles);
        LazyOptional<IItemHandler> cap = ItemUpgradeRecycler.findItemHandlerAtPos(world, posInventory, this.getPedestalFacing(world, posOfPedestal), true);
        if (this.hasAdvancedInventoryTargeting(coinInPedestal)) {
            cap = ItemUpgradeRecycler.findItemHandlerAtPosAdvanced(world, posInventory, this.getPedestalFacing(world, posOfPedestal), true);
        }
        if (!this.isInventoryEmpty(cap) && cap.isPresent()) {
            IItemHandler handler = (IItemHandler)cap.orElse(null);
            TileEntity invToPullFrom = world.func_175625_s(posInventory);
            if (!(this.hasAdvancedInventoryTargeting(coinInPedestal) && invToPullFrom instanceof PedestalTileEntity || !(invToPullFrom instanceof PedestalTileEntity))) {
                itemFromInv = ItemStack.field_190927_a;
            } else if (handler != null) {
                int range = handler.getSlots();
                ItemStack nextItemToGrind = ItemStack.field_190927_a;
                nextItemToGrind = IntStream.range(0, range).mapToObj(arg_0 -> ((IItemHandler)handler).getStackInSlot(arg_0)).filter(itemStack -> !itemStack.func_190926_b()).findFirst().orElse(ItemStack.field_190927_a);
                Item input = nextItemToGrind.func_77973_b();
                Collection<ItemStack> jsonResults = this.getProcessResultsRecycler(this.getRecipeRecycler(pedestal.func_145831_w(), nextItemToGrind));
                ItemStack resultRecycler = jsonResults.iterator().next().func_190926_b() ? ItemStack.field_190927_a : jsonResults.iterator().next();
                Item getItemResultRecycler = resultRecycler.func_77973_b();
                int slotItemToGrind = this.getSlotWithMatchingStackExact(cap, nextItemToGrind);
                if (!(!(input instanceof TieredItem) && resultRecycler.func_190926_b() || BLACKLISTED.func_230235_a_((Object)nextItemToGrind.func_77973_b()))) {
                    Ingredient repairIngredient = Ingredient.func_193369_a((ItemStack[])new ItemStack[]{resultRecycler});
                    int returnedMaxCount = resultRecycler.func_190916_E();
                    if (resultRecycler.func_190926_b()) {
                        if (input instanceof TieredItem) {
                            repairIngredient = ((TieredItem)input).func_200891_e().func_200924_f();
                        }
                        returnedMaxCount = input instanceof PickaxeItem || nextItemToGrind.getToolTypes().contains(ToolType.PICKAXE) ? 3 : (input instanceof AxeItem || nextItemToGrind.getToolTypes().contains(ToolType.AXE) ? 3 : (input instanceof SwordItem ? 2 : (input instanceof HoeItem || nextItemToGrind.getToolTypes().contains(ToolType.HOE) ? 2 : (input instanceof ShovelItem || nextItemToGrind.getToolTypes().contains(ToolType.SHOVEL) ? 1 : 1))));
                    }
                    ItemStack repairIngredientStack = repairIngredient.func_193365_a().length > 0 ? repairIngredient.func_193365_a()[0] : new ItemStack((IItemProvider)Items.field_151055_y);
                    int maxdamage = nextItemToGrind.func_77958_k();
                    int damage = nextItemToGrind.func_77952_i();
                    int durability = maxdamage - damage;
                    int devider = Math.floorDiv(maxdamage, returnedMaxCount);
                    int countToReturn = returnedMaxCount;
                    if (damage <= 0) {
                        countToReturn = returnedMaxCount;
                    } else if (durability < devider) {
                        repairIngredientStack = new ItemStack((IItemProvider)Items.field_151055_y);
                        countToReturn = 1;
                    } else {
                        int estCount = Math.floorDiv(durability, devider);
                        countToReturn = estCount == returnedMaxCount ? estCount - 1 : estCount;
                    }
                    ItemStack toReturn = repairIngredientStack.func_77946_l();
                    toReturn.func_190920_e(countToReturn);
                    repairIngredientStack.func_190920_e(countToReturn);
                    if (!handler.extractItem(slotItemToGrind, 1, true).func_190926_b()) {
                        handler.extractItem(slotItemToGrind, 1, false);
                        if (!pedestal.hasMuffler()) {
                            world.func_184148_a((PlayerEntity)null, (double)posOfPedestal.func_177958_n(), (double)posOfPedestal.func_177956_o(), (double)posOfPedestal.func_177952_p(), SoundEvents.field_219642_eu, SoundCategory.BLOCKS, 0.25f, 1.0f);
                        }
                        pedestal.addItemOverride(toReturn);
                    }
                } else if (!(!(input instanceof ArmorItem) && resultRecycler.func_190926_b() || getItemResultRecycler.equals(Items.field_221803_eL))) {
                    Ingredient repairIngredient = Ingredient.func_193369_a((ItemStack[])new ItemStack[]{resultRecycler});
                    int returnedMaxCount = resultRecycler.func_190916_E();
                    if (resultRecycler.func_190926_b()) {
                        repairIngredient = ((ArmorItem)input).func_200880_d().func_200898_c();
                        returnedMaxCount = ((ArmorItem)input).func_185083_B_().equals((Object)EquipmentSlotType.HEAD) ? 5 : (((ArmorItem)input).func_185083_B_().equals((Object)EquipmentSlotType.CHEST) ? 8 : (((ArmorItem)input).func_185083_B_().equals((Object)EquipmentSlotType.LEGS) ? 7 : (((ArmorItem)input).func_185083_B_().equals((Object)EquipmentSlotType.FEET) ? 4 : 1)));
                    }
                    ItemStack repairIngredientStack = repairIngredient.func_193365_a().length > 0 ? repairIngredient.func_193365_a()[0] : new ItemStack((IItemProvider)Items.field_151121_aF).func_200302_a((ITextComponent)new TranslationTextComponent(this.func_77658_a() + ".cloth"));
                    int maxdamage = nextItemToGrind.func_77958_k();
                    int damage = nextItemToGrind.func_77952_i();
                    int durability = maxdamage - damage;
                    int devider = Math.floorDiv(maxdamage, returnedMaxCount);
                    int countToReturn = returnedMaxCount;
                    if (damage <= 0) {
                        countToReturn = returnedMaxCount;
                    } else if (durability < devider) {
                        repairIngredientStack = new ItemStack((IItemProvider)Items.field_151121_aF).func_200302_a((ITextComponent)new TranslationTextComponent(this.func_77658_a() + ".cloth"));
                        countToReturn = 1;
                    } else {
                        int estCount = Math.floorDiv(durability, devider);
                        countToReturn = estCount == returnedMaxCount ? estCount - 1 : estCount;
                    }
                    ItemStack toReturn = repairIngredientStack.func_77946_l();
                    toReturn.func_190920_e(countToReturn);
                    repairIngredientStack.func_190920_e(countToReturn);
                    if (!handler.extractItem(slotItemToGrind, 1, true).func_190926_b()) {
                        handler.extractItem(slotItemToGrind, 1, false);
                        if (!pedestal.hasMuffler()) {
                            world.func_184148_a((PlayerEntity)null, (double)posOfPedestal.func_177958_n(), (double)posOfPedestal.func_177956_o(), (double)posOfPedestal.func_177952_p(), SoundEvents.field_219642_eu, SoundCategory.BLOCKS, 0.25f, 1.0f);
                        }
                        pedestal.addItemOverride(toReturn);
                    }
                } else {
                    this.doNormalAction(pedestal);
                }
            }
        }
    }

    @Override
    public void chatDetails(PlayerEntity player, PedestalTileEntity pedestal) {
        ItemStack stack = pedestal.getCoinOnPedestal();
        TranslationTextComponent name = new TranslationTextComponent(this.func_77658_a() + ".tooltip_name");
        name.func_240699_a_(TextFormatting.GOLD);
        player.func_145747_a((ITextComponent)name, Util.field_240973_b_);
        Map map = EnchantmentHelper.func_82781_a((ItemStack)stack);
        if (map.size() > 0 && this.getNumNonPedestalEnchants(map) > 0) {
            TranslationTextComponent enchant = new TranslationTextComponent(this.func_77658_a() + ".chat_enchants");
            enchant.func_240699_a_(TextFormatting.LIGHT_PURPLE);
            player.func_145747_a((ITextComponent)enchant, Util.field_240973_b_);
            for (Map.Entry entry : map.entrySet()) {
                Enchantment enchantment = (Enchantment)entry.getKey();
                Integer integer = (Integer)entry.getValue();
                if (enchantment instanceof EnchantmentCapacity || enchantment instanceof EnchantmentRange || enchantment instanceof EnchantmentOperationSpeed || enchantment instanceof EnchantmentArea) continue;
                TranslationTextComponent enchants = new TranslationTextComponent(" - " + enchantment.func_200305_d(integer.intValue()).getString());
                enchants.func_240699_a_(TextFormatting.GRAY);
                player.func_145747_a((ITextComponent)enchants, Util.field_240973_b_);
            }
        }
        TranslationTextComponent speed = new TranslationTextComponent(this.func_77658_a() + ".chat_speed");
        speed.func_240702_b_(this.getOperationSpeedString(stack));
        speed.func_240699_a_(TextFormatting.RED);
        player.func_145747_a((ITextComponent)speed, Util.field_240973_b_);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        TranslationTextComponent speed = new TranslationTextComponent(this.func_77658_a() + ".tooltip_speed");
        speed.func_240702_b_(this.getOperationSpeedString(stack));
        speed.func_240699_a_(TextFormatting.RED);
        tooltip.add((ITextComponent)speed);
    }

    @SubscribeEvent
    public static void onItemRegistryReady(RegistryEvent.Register<Item> event) {
        event.getRegistry().register((IForgeRegistryEntry)RECYCLER);
    }
}

