/*
 * Decompiled with CFR 0.152.
 */
package com.mowmaster.pedestals.item.pedestalUpgrades;

import com.mowmaster.pedestals.item.pedestalUpgrades.ItemUpgradeBase;
import com.mowmaster.pedestals.pedestals;
import com.mowmaster.pedestals.tiles.PedestalTileEntity;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItem;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.item.Items;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class ItemUpgradePlacer
extends ItemUpgradeBase {
    public static final Item PLACER = (Item)new ItemUpgradePlacer(new Item.Properties().func_200917_a(64).func_200916_a(pedestals.PEDESTALS_TAB)).setRegistryName(new ResourceLocation("pedestals", "coin/placer"));

    public ItemUpgradePlacer(Item.Properties builder) {
        super(builder.func_200916_a(pedestals.PEDESTALS_TAB));
    }

    @Override
    public boolean canAcceptRange() {
        return true;
    }

    public BlockState getState(Block getBlock, ItemStack itemForBlock) {
        BlockState stated = Blocks.field_150350_a.func_176223_P();
        stated = itemForBlock.func_77973_b() == Items.field_151137_ax ? Blocks.field_150488_af.func_176223_P() : getBlock.func_176223_P();
        return stated;
    }

    @Override
    public int getWorkAreaX(World world, BlockPos pos, ItemStack coin) {
        int range = this.getRangeSmall(coin);
        BlockPos posOfBlock = this.getPosOfBlockBelow(world, pos, range);
        return posOfBlock.func_177958_n();
    }

    @Override
    public int[] getWorkAreaY(World world, BlockPos pos, ItemStack coin) {
        int range = this.getRangeSmall(coin);
        BlockPos posOfBlock = this.getPosOfBlockBelow(world, pos, range);
        return new int[]{posOfBlock.func_177956_o(), 1};
    }

    @Override
    public int getWorkAreaZ(World world, BlockPos pos, ItemStack coin) {
        int range = this.getRangeSmall(coin);
        BlockPos posOfBlock = this.getPosOfBlockBelow(world, pos, range);
        return posOfBlock.func_177952_p();
    }

    @Override
    public void updateAction(World world, PedestalTileEntity pedestal) {
        if (!world.field_72995_K) {
            ItemStack coinInPedestal = pedestal.getCoinOnPedestal();
            ItemStack itemInPedestal = pedestal.getItemInPedestal();
            BlockPos pedestalPos = pedestal.func_174877_v();
            int speed = this.getOperationSpeed(coinInPedestal);
            if (!pedestal.isPedestalBlockPowered(world, pedestalPos) && world.func_82737_E() % (long)speed == 0L) {
                int range = this.getRangeSmall(coinInPedestal);
                BlockPos blockPosBelow = this.getPosOfBlockBelow(world, pedestalPos, range);
                this.placeBlock(pedestal, blockPosBelow);
            }
        }
    }

    public void placeBlock(PedestalTileEntity pedestal, BlockPos targetPos) {
        World world = pedestal.func_145831_w();
        BlockPos pedPos = pedestal.func_174877_v();
        ItemStack itemInPedestal = pedestal.getItemInPedestal();
        ItemStack coinOnPedestal = pedestal.getCoinOnPedestal();
        if (!itemInPedestal.func_190926_b()) {
            FakePlayer fakePlayer;
            Block blockBelow = world.func_180495_p(targetPos).func_177230_c();
            Item singleItemInPedestal = itemInPedestal.func_77973_b();
            if (blockBelow.equals(Blocks.field_150350_a) && !singleItemInPedestal.equals(Items.field_190931_a) && singleItemInPedestal instanceof BlockItem && ((BlockItem)singleItemInPedestal).func_179223_d() instanceof Block && !itemInPedestal.func_190926_b() && itemInPedestal.func_77973_b() instanceof BlockItem && ((BlockItem)itemInPedestal.func_77973_b()).func_179223_d() instanceof Block && (fakePlayer = (FakePlayer)this.fakePedestalPlayer(pedestal).get()) != null) {
                BlockItemUseContext blockContext;
                ActionResultType result;
                fakePlayer.func_174810_b(true);
                if (!fakePlayer.func_233580_cy_().equals((Object)new BlockPos(pedPos.func_177958_n(), pedPos.func_177956_o(), pedPos.func_177952_p()))) {
                    fakePlayer.func_70107_b((double)pedPos.func_177958_n(), (double)pedPos.func_177956_o(), (double)pedPos.func_177952_p());
                }
                if ((result = ForgeHooks.onPlaceItemIntoWorld((ItemUseContext)(blockContext = new BlockItemUseContext((PlayerEntity)fakePlayer, Hand.MAIN_HAND, itemInPedestal.func_77946_l(), new BlockRayTraceResult(Vector3d.field_186680_a, this.getPedestalFacing(world, pedPos), targetPos, false))))) == ActionResultType.CONSUME) {
                    this.removeFromPedestal(world, pedPos, 1);
                    if (!pedestal.hasMuffler()) {
                        world.func_184148_a((PlayerEntity)null, (double)targetPos.func_177958_n(), (double)targetPos.func_177956_o(), (double)targetPos.func_177952_p(), SoundEvents.field_187845_fY, SoundCategory.BLOCKS, 0.5f, 1.0f);
                    }
                }
            }
        }
    }

    public static int getRotFromSide(Direction side) {
        switch (side) {
            case UP: {
                return 0;
            }
            case DOWN: {
                return 8;
            }
            case NORTH: {
                return 0;
            }
            case SOUTH: {
                return 8;
            }
            case EAST: {
                return 4;
            }
            case WEST: {
                return 12;
            }
        }
        return 0;
    }

    @Override
    public void chatDetails(PlayerEntity player, PedestalTileEntity pedestal) {
        ItemStack stack = pedestal.getCoinOnPedestal();
        TranslationTextComponent name = new TranslationTextComponent(this.func_77658_a() + ".tooltip_name");
        name.func_240699_a_(TextFormatting.GOLD);
        player.func_145747_a((ITextComponent)name, Util.field_240973_b_);
        TranslationTextComponent range = new TranslationTextComponent(this.func_77658_a() + ".chat_range");
        range.func_240702_b_("" + this.getRangeSmall(stack) + "");
        range.func_240699_a_(TextFormatting.WHITE);
        player.func_145747_a((ITextComponent)range, Util.field_240973_b_);
        TranslationTextComponent speed = new TranslationTextComponent(this.func_77658_a() + ".chat_speed");
        speed.func_240702_b_(this.getOperationSpeedString(stack));
        speed.func_240699_a_(TextFormatting.RED);
        player.func_145747_a((ITextComponent)speed, Util.field_240973_b_);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        TranslationTextComponent range = new TranslationTextComponent(this.func_77658_a() + ".tooltip_range");
        range.func_240702_b_("" + this.getRangeSmall(stack) + "");
        TranslationTextComponent speed = new TranslationTextComponent(this.func_77658_a() + ".tooltip_speed");
        speed.func_240702_b_(this.getOperationSpeedString(stack));
        range.func_240699_a_(TextFormatting.WHITE);
        speed.func_240699_a_(TextFormatting.RED);
        tooltip.add((ITextComponent)range);
        tooltip.add((ITextComponent)speed);
    }

    @SubscribeEvent
    public static void onItemRegistryReady(RegistryEvent.Register<Item> event) {
        event.getRegistry().register((IForgeRegistryEntry)PLACER);
    }
}

