/*
 * Decompiled with CFR 0.152.
 */
package com.mowmaster.pedestals.item.pedestalUpgrades;

import com.mowmaster.pedestals.item.pedestalUpgrades.ItemUpgradeBase;
import com.mowmaster.pedestals.pedestals;
import com.mowmaster.pedestals.tiles.PedestalTileEntity;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class ItemUpgradeItemTank
extends ItemUpgradeBase {
    private int maxStored = 2000000000;
    public static final Item ITEMTANK = (Item)new ItemUpgradeItemTank(new Item.Properties().func_200917_a(64).func_200916_a(pedestals.PEDESTALS_TAB)).setRegistryName(new ResourceLocation("pedestals", "coin/itemtank"));

    public ItemUpgradeItemTank(Item.Properties builder) {
        super(builder.func_200916_a(pedestals.PEDESTALS_TAB));
    }

    @Override
    public boolean canAcceptCapacity() {
        return true;
    }

    @Override
    public boolean canAcceptOpSpeed() {
        return false;
    }

    @Override
    public int getComparatorRedstoneLevel(World worldIn, BlockPos pos) {
        PedestalTileEntity pedestal;
        ItemStack coin;
        int intItem = 0;
        TileEntity tileEntity = worldIn.func_175625_s(pos);
        if (tileEntity instanceof PedestalTileEntity && !this.getItemStored(coin = (pedestal = (PedestalTileEntity)tileEntity).getCoinOnPedestal()).func_190926_b()) {
            float f = (float)this.getItemStored(coin).func_190916_E() / (float)this.readMaxStorageFromNBT(coin);
            intItem = MathHelper.func_76141_d((float)(f * 14.0f)) + 1;
        }
        return intItem;
    }

    @Override
    public boolean customIsValid(PedestalTileEntity pedestal, int slot, @Nonnull ItemStack stack) {
        ItemStack stored = this.getItemStored(pedestal);
        ItemStack inPed = pedestal.getItemInPedestalOverride();
        if (stored.func_190926_b() && inPed.func_190926_b()) {
            return slot == 0;
        }
        if (!stored.func_190926_b() && inPed.func_190926_b()) {
            return slot == 0 ? this.doItemsMatch(stored, stack) : false;
        }
        if (stored.func_190926_b() && !inPed.func_190926_b()) {
            return slot == 0 ? this.doItemsMatch(inPed, stack) : false;
        }
        return slot == 0 ? this.doItemsMatch(inPed, stack) && this.doItemsMatch(stored, stack) : false;
    }

    @Override
    public ItemStack customInsertItem(PedestalTileEntity pedestal, ItemStack stackIn, boolean simulate) {
        ItemStack stored = this.getItemStored(pedestal);
        ItemStack inPed = pedestal.getItemInPedestalOverride();
        if (this.customIsValid(pedestal, 0, stackIn)) {
            if (stored.func_190926_b()) {
                if (!simulate) {
                    this.setItemStored(pedestal, stackIn);
                }
                return ItemStack.field_190927_a;
            }
            int itemsToAdd = this.addCountToStorage(pedestal, stackIn.func_190916_E(), true);
            if (this.availableStorageSpace(pedestal) > 0) {
                if (itemsToAdd == 0) {
                    if (!simulate) {
                        this.addCountToStorage(pedestal, stackIn.func_190916_E(), false);
                    }
                    return ItemStack.field_190927_a;
                }
                ItemStack copyStackIn = stackIn.func_77946_l();
                copyStackIn.func_190920_e(itemsToAdd);
                if (!simulate) {
                    this.addCountToStorage(pedestal, itemsToAdd, false);
                }
                int currentIn = stackIn.func_190916_E();
                int diff = currentIn - itemsToAdd;
                copyStackIn.func_190920_e(diff);
                return copyStackIn;
            }
        }
        return stackIn;
    }

    @Override
    public ItemStack customExtractItem(PedestalTileEntity pedestal, int amountOut, boolean simulate) {
        ItemStack stored = this.getItemStored(pedestal);
        ItemStack itemInPed = pedestal.getItemInPedestalOverride();
        int itemsToRemove = this.removeFromStorage(pedestal, amountOut, true);
        ItemStack itemStackToExtract = stored.func_77946_l();
        if (stored.func_190926_b()) {
            return new ItemStack((IItemProvider)Items.field_221747_dJ);
        }
        if (itemsToRemove == 0) {
            itemStackToExtract.func_190920_e(amountOut);
            if (!simulate) {
                this.removeFromStorage(pedestal, amountOut, false);
            }
            ItemStack toReturn = new ItemStack((IItemProvider)(stored.func_190926_b() ? itemInPed.func_77973_b() : itemStackToExtract.func_77973_b()), amountOut > itemStackToExtract.func_77976_d() ? itemStackToExtract.func_77976_d() : amountOut);
            toReturn.func_77982_d(stored.func_190926_b() ? itemInPed.func_77978_p() : itemStackToExtract.func_77978_p());
            return toReturn;
        }
        itemStackToExtract.func_190920_e(itemsToRemove);
        if (!simulate) {
            this.removeFromStorage(pedestal, itemsToRemove, false);
        }
        return itemStackToExtract;
    }

    @Override
    public ItemStack customStackInSlot(PedestalTileEntity pedestal, ItemStack stackFromHandler) {
        if (!stackFromHandler.func_190926_b()) {
            ItemStack stored = this.getItemStored(pedestal);
            Item getItem = stored.func_77973_b();
            ItemStack getItemStackInPedestal = pedestal.getItemInPedestalOverride();
            Item getItemInPedestal = getItemStackInPedestal.func_77973_b();
            int storedCount = stored.func_190916_E();
            if (getItemInPedestal.equals(getItem) || getItemStackInPedestal.func_190926_b()) {
                if (storedCount > 0) {
                    int amount = storedCount + pedestal.getItemInPedestalOverride().func_190916_E();
                    ItemStack getStack = new ItemStack((IItemProvider)getItem, amount);
                    return getStack;
                }
            } else {
                return getItemStackInPedestal;
            }
        }
        return ItemStack.field_190927_a;
    }

    @Override
    public int customSlotLimit(PedestalTileEntity pedestal) {
        return this.maxStorage(pedestal);
    }

    public int addCountToStorage(PedestalTileEntity pedestal, int amountIn, boolean simulate) {
        ItemStack stored = this.getItemStored(pedestal);
        int space = this.availableStorageSpace(pedestal);
        if (space >= amountIn) {
            ItemStack storedCopy = stored.func_77946_l();
            if (!simulate) {
                int current = stored.func_190916_E();
                storedCopy.func_190920_e(current + amountIn);
                this.setItemStored(pedestal, storedCopy);
            }
            return 0;
        }
        return space;
    }

    public int removeFromStorageBuffer(PedestalTileEntity pedestal, int amountOut, boolean simulate) {
        ItemStack stored = this.getItemStored(pedestal);
        int current = stored.func_190916_E();
        if (current - amountOut >= 0) {
            if (!simulate) {
                ItemStack storedCopy = stored.func_77946_l();
                storedCopy.func_190920_e(current - amountOut);
                this.setItemStored(pedestal, storedCopy);
            }
            return 0;
        }
        return current;
    }

    public int removeFromStorage(PedestalTileEntity pedestal, int amountOut, boolean simulate) {
        ItemStack stored = this.getItemStored(pedestal);
        int current = stored.func_190916_E();
        int currentActual = current + pedestal.getItemInPedestalOverride().func_190916_E();
        if (currentActual - amountOut >= 0) {
            ItemStack storedCopy = stored.func_77946_l();
            if (!simulate) {
                if (current - amountOut >= 0) {
                    storedCopy.func_190920_e(current - amountOut);
                    this.setItemStored(pedestal, storedCopy);
                } else {
                    int removeFromPedestal = amountOut - current;
                    this.setItemStored(pedestal, ItemStack.field_190927_a);
                    pedestal.removeItemOverride(removeFromPedestal);
                }
            }
            return 0;
        }
        return current;
    }

    public int getCountStored(PedestalTileEntity pedestal) {
        return this.getItemStored(pedestal).func_190916_E();
    }

    public int maxStorage(PedestalTileEntity pedestal) {
        ItemStack coin = pedestal.getCoinOnPedestal();
        return this.readMaxStorageFromNBT(coin);
    }

    public int availableStorageSpace(PedestalTileEntity pedestal) {
        return this.maxStorage(pedestal) - this.getCountStored(pedestal);
    }

    public void setItemStored(PedestalTileEntity pedestal, ItemStack stack) {
        ItemStack coin;
        int countToStore = stack.func_190916_E();
        if (stack.func_190916_E() >= stack.func_77976_d()) {
            stack.func_190920_e(stack.func_77976_d());
        }
        CompoundNBT coinNBT = (coin = pedestal.getCoinOnPedestal()).func_77942_o() ? coin.func_77978_p() : new CompoundNBT();
        stack.func_77955_b(coinNBT);
        coinNBT.func_74768_a("tankcount", countToStore);
        if (stack.func_190926_b() || stack.func_190916_E() <= 0) {
            if (coinNBT.func_74764_b("id")) {
                coinNBT.func_82580_o("id");
            }
            if (coinNBT.func_74764_b("Count")) {
                coinNBT.func_82580_o("Count");
            }
            if (coinNBT.func_74764_b("tag")) {
                coinNBT.func_82580_o("tag");
            }
            if (coinNBT.func_74764_b("ForgeCaps")) {
                coinNBT.func_82580_o("ForgeCaps");
            }
            coin.func_77982_d(coinNBT);
        }
        coin.func_77982_d(coinNBT);
        pedestal.update();
    }

    public ItemStack getItemStored(PedestalTileEntity pedestal) {
        ItemStack getItemStored;
        ItemStack coin = pedestal.getCoinOnPedestal();
        CompoundNBT compound = new CompoundNBT();
        if (coin.func_77942_o()) {
            compound = coin.func_77978_p();
        }
        if (!(getItemStored = ItemStack.func_199557_a((CompoundNBT)compound)).func_190926_b()) {
            int getItemStackCount = compound.func_74762_e("tankcount");
            getItemStored.func_190920_e(getItemStackCount);
        }
        return getItemStored;
    }

    public ItemStack getItemStored(ItemStack coin) {
        ItemStack getItemStored;
        CompoundNBT compound = new CompoundNBT();
        if (coin.func_77942_o()) {
            compound = coin.func_77978_p();
        }
        if (!(getItemStored = ItemStack.func_199557_a((CompoundNBT)compound)).func_190926_b()) {
            int getItemStackCount = compound.func_74762_e("tankcount");
            getItemStored.func_190920_e(getItemStackCount);
        }
        return getItemStored;
    }

    public boolean hasMaxStorageSet(ItemStack stack) {
        boolean returner = false;
        CompoundNBT compound = new CompoundNBT();
        if (stack.func_77942_o() && (compound = stack.func_77978_p()).func_74764_b("maxstorage")) {
            returner = true;
        }
        return returner;
    }

    public void writeMaxStorageToNBT(ItemStack stack, int value) {
        CompoundNBT compound = new CompoundNBT();
        if (stack.func_77942_o()) {
            compound = stack.func_77978_p();
        }
        compound.func_74768_a("maxstorage", value);
        stack.func_77982_d(compound);
    }

    public int readMaxStorageFromNBT(ItemStack stack) {
        int maxStorage = 0;
        if (stack.func_77942_o()) {
            CompoundNBT getCompound = stack.func_77978_p();
            maxStorage = getCompound.func_74762_e("maxstorage");
        }
        return maxStorage;
    }

    @Override
    public void updateAction(World world, PedestalTileEntity pedestal) {
        if (!world.field_72995_K) {
            ItemStack stackInPed;
            ItemStack coinInPedestal = pedestal.getCoinOnPedestal();
            ItemStack itemInPedestal = pedestal.getItemInPedestal();
            BlockPos pedestalPos = pedestal.func_174877_v();
            int getMaxStorageValue = this.getStorageBuffer(coinInPedestal);
            if (!this.hasMaxStorageSet(coinInPedestal) || this.readMaxStorageFromNBT(coinInPedestal) != getMaxStorageValue) {
                this.writeMaxStorageToNBT(coinInPedestal, getMaxStorageValue);
            }
            if (!pedestal.isPedestalBlockPowered(world, pedestalPos) && world.func_82737_E() % 20L == 0L && (stackInPed = pedestal.getItemInPedestalOverride()).func_190916_E() < stackInPed.func_77976_d()) {
                this.fillPedestalAction(pedestal);
            }
        }
    }

    public void fillPedestalAction(PedestalTileEntity pedestal) {
        ItemStack itemInPedestal = pedestal.getItemInPedestalOverride();
        int intSpace = this.intSpaceLeftInStack(itemInPedestal);
        int cobbleStored = this.getCountStored(pedestal);
        if (intSpace > 0 && cobbleStored > 0) {
            int returned = this.removeFromStorageBuffer(pedestal, intSpace, true);
            int itemsToAdd = returned == 0 ? intSpace : returned;
            ItemStack stackSpawnedItem = this.getItemStored(pedestal).func_77946_l();
            stackSpawnedItem.func_190920_e(itemsToAdd);
            ItemStack getInserted = pedestal.addItemStackOverride(stackSpawnedItem);
            if (getInserted.func_190926_b()) {
                this.removeFromStorageBuffer(pedestal, itemsToAdd, false);
            } else {
                int countUsed = itemsToAdd - getInserted.func_190916_E();
                this.removeFromStorageBuffer(pedestal, countUsed, false);
            }
        }
    }

    public void upgradeAction(World world, ItemStack itemInPedestal, ItemStack coinInPedestal, BlockPos pedestalPos) {
    }

    @Override
    public void actionOnCollideWithBlock(World world, PedestalTileEntity tilePedestal, BlockPos posPedestal, BlockState state, Entity entityIn) {
        if (entityIn instanceof ItemEntity) {
            ItemStack stored = this.getItemStored(tilePedestal);
            ItemStack stackCollidedItem = ((ItemEntity)entityIn).func_92059_d();
            if (this.canThisPedestalReceiveItemStack(tilePedestal, world, posPedestal, stackCollidedItem)) {
                if (tilePedestal.addItemCustom(stackCollidedItem, true).func_190926_b()) {
                    tilePedestal.addItemCustom(stackCollidedItem, false);
                    ((ItemEntity)entityIn).func_70106_y();
                } else {
                    ItemStack unused = tilePedestal.addItemCustom(stackCollidedItem, false).func_77946_l();
                    ((ItemEntity)entityIn).func_92058_a(unused);
                }
            }
        }
    }

    @Override
    public void chatDetails(PlayerEntity player, PedestalTileEntity pedestal) {
        ItemStack stack = pedestal.getCoinOnPedestal();
        TranslationTextComponent name = new TranslationTextComponent(this.func_77658_a() + ".tooltip_name");
        name.func_240699_a_(TextFormatting.GOLD);
        player.func_145747_a((ITextComponent)name, Util.field_240973_b_);
        ItemStack storedStack = this.getItemStored(pedestal);
        TranslationTextComponent stored = new TranslationTextComponent(this.func_77658_a() + ".chat_stored");
        if (!storedStack.func_190926_b()) {
            stored.func_240702_b_("" + storedStack.func_200301_q().getString() + " - ");
            stored.func_240702_b_("" + (storedStack.func_190916_E() + pedestal.getItemInPedestalOverride().func_190916_E()) + "");
            stored.func_240699_a_(TextFormatting.GREEN);
            player.func_145747_a((ITextComponent)stored, Util.field_240973_b_);
        } else if (!pedestal.getItemInPedestalOverride().func_190926_b()) {
            stored.func_240702_b_("" + pedestal.getItemInPedestalOverride().func_200301_q().getString() + " - ");
            stored.func_240702_b_("" + pedestal.getItemInPedestalOverride().func_190916_E() + "");
            stored.func_240699_a_(TextFormatting.GREEN);
            player.func_145747_a((ITextComponent)stored, Util.field_240973_b_);
        }
        TranslationTextComponent buffer = new TranslationTextComponent(this.func_77658_a() + ".chat_buffer");
        buffer.func_240702_b_("" + this.readMaxStorageFromNBT(stack) + "");
        buffer.func_240699_a_(TextFormatting.AQUA);
        player.func_145747_a((ITextComponent)buffer, Util.field_240973_b_);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        ItemStack storedStack = this.getItemStored(stack);
        if (!storedStack.func_190926_b()) {
            TranslationTextComponent stored = new TranslationTextComponent(this.func_77658_a() + ".chat_stored");
            stored.func_240702_b_("" + storedStack.func_200301_q().getString() + " - ");
            stored.func_240702_b_("" + storedStack.func_190916_E() + "");
            stored.func_240699_a_(TextFormatting.GREEN);
            tooltip.add((ITextComponent)stored);
        }
        TranslationTextComponent buffer = new TranslationTextComponent(this.func_77658_a() + ".chat_buffer");
        buffer.func_240702_b_("" + this.getStorageBuffer(stack) + "");
        buffer.func_240699_a_(TextFormatting.AQUA);
        tooltip.add((ITextComponent)buffer);
    }

    @SubscribeEvent
    public static void onItemRegistryReady(RegistryEvent.Register<Item> event) {
        event.getRegistry().register((IForgeRegistryEntry)ITEMTANK);
    }
}

