/*
 * Decompiled with CFR 0.152.
 */
package com.mowmaster.pedestals.item.pedestalUpgrades;

import com.mowmaster.pedestals.enchants.EnchantmentRegistry;
import com.mowmaster.pedestals.item.pedestalUpgrades.ItemUpgradeBase;
import com.mowmaster.pedestals.pedestals;
import com.mowmaster.pedestals.tiles.PedestalTileEntity;
import java.util.Collections;
import java.util.List;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import net.minecraft.block.BeehiveBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.passive.BeeEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class ItemUpgradeHarvesterBeeHives
extends ItemUpgradeBase {
    public static final Item HARVESTERHIVES = (Item)new ItemUpgradeHarvesterBeeHives(new Item.Properties().func_200917_a(64).func_200916_a(pedestals.PEDESTALS_TAB)).setRegistryName(new ResourceLocation("pedestals", "coin/harvesterhives"));

    public ItemUpgradeHarvesterBeeHives(Item.Properties builder) {
        super(builder.func_200916_a(pedestals.PEDESTALS_TAB));
    }

    @Override
    public boolean canAcceptArea() {
        return true;
    }

    @Override
    public boolean canAcceptRange() {
        return true;
    }

    @Override
    public boolean canAcceptMagnet() {
        return true;
    }

    @Override
    public boolean canAcceptAdvanced() {
        return true;
    }

    public int getAreaWidth(ItemStack stack) {
        int areaWidth = 0;
        int aW = this.getAreaModifier(stack);
        areaWidth = aW + 1;
        return areaWidth;
    }

    @Override
    public int getRangeModifier(ItemStack stack) {
        int range = 0;
        if (this.hasEnchant(stack)) {
            range = EnchantmentHelper.func_77506_a((Enchantment)EnchantmentRegistry.RANGE, (ItemStack)stack);
        }
        return range;
    }

    public int getRangeHeight(ItemStack stack) {
        return this.getHeight(stack);
    }

    public int getHeight(ItemStack stack) {
        return this.getRangeTiny(stack);
    }

    @Override
    public int getWorkAreaX(World world, BlockPos pos, ItemStack coin) {
        return this.getAreaWidth(coin);
    }

    @Override
    public int[] getWorkAreaY(World world, BlockPos pos, ItemStack coin) {
        return new int[]{this.getRangeHeight(coin), 0};
    }

    @Override
    public int getWorkAreaZ(World world, BlockPos pos, ItemStack coin) {
        return this.getAreaWidth(coin);
    }

    public static IntegerProperty getBlockPropertyHoney(BlockState blockState) {
        for (Property prop : blockState.func_235904_r_()) {
            if (prop == null || prop.func_177701_a() == null || !(prop instanceof IntegerProperty) || !prop.func_177701_a().equalsIgnoreCase("honey_level")) continue;
            return (IntegerProperty)prop;
        }
        return null;
    }

    public boolean canHarvest(World world, BlockState state) {
        boolean returner = false;
        if (state.func_235714_a_((ITag)BlockTags.field_226151_aa_)) {
            IntegerProperty propInt = ItemUpgradeHarvesterBeeHives.getBlockPropertyHoney(state);
            if (propInt == null || !(world instanceof ServerWorld)) {
                returner = false;
            } else {
                int current = (Integer)state.func_177229_b((Property)propInt);
                int max = (Integer)Collections.max(propInt.func_177700_c());
                if (current >= 5) {
                    returner = true;
                }
            }
        }
        return returner;
    }

    @Override
    public int getComparatorRedstoneLevel(World worldIn, BlockPos pos) {
        int intItem = 0;
        TileEntity tileEntity = worldIn.func_175625_s(pos);
        if (tileEntity instanceof PedestalTileEntity) {
            PedestalTileEntity pedestal = (PedestalTileEntity)tileEntity;
            ItemStack coin = pedestal.getCoinOnPedestal();
            int amount = this.workQueueSize(coin);
            int area = this.workQueueTwoSize(coin);
            if (amount > 0) {
                float f = (float)amount / (float)area;
                intItem = MathHelper.func_76141_d((float)(f * 14.0f)) + 1;
            }
        }
        return intItem;
    }

    @Override
    public void updateAction(World world, PedestalTileEntity pedestal) {
        if (!world.field_72995_K) {
            ItemStack coinInPedestal = pedestal.getCoinOnPedestal();
            ItemStack itemInPedestal = pedestal.getItemInPedestal();
            BlockPos pedestalPos = pedestal.func_174877_v();
            if (!pedestal.isPedestalBlockPowered(world, pedestalPos)) {
                BlockPos posBlockPos;
                BlockPos negBlockPos;
                AxisAlignedBB getBox;
                List itemList;
                int rangeWidth = this.getAreaWidth(coinInPedestal);
                int rangeHeight = this.getRangeHeight(coinInPedestal);
                BlockState pedestalState = world.func_180495_p(pedestalPos);
                Direction enumfacing = pedestalState.func_235901_b_((Property)BlockStateProperties.field_208155_H) ? (Direction)pedestalState.func_177229_b((Property)BlockStateProperties.field_208155_H) : Direction.UP;
                BlockPos negNums = this.getNegRangePosEntity(world, pedestalPos, rangeWidth, enumfacing == Direction.NORTH || enumfacing == Direction.EAST || enumfacing == Direction.SOUTH || enumfacing == Direction.WEST ? rangeHeight - 1 : rangeHeight);
                BlockPos posNums = this.getPosRangePosEntity(world, pedestalPos, rangeWidth, enumfacing == Direction.NORTH || enumfacing == Direction.EAST || enumfacing == Direction.SOUTH || enumfacing == Direction.WEST ? rangeHeight - 1 : rangeHeight);
                int width = this.getAreaWidth(coinInPedestal);
                int height = this.getRangeHeight(coinInPedestal);
                if (this.hasMagnetEnchant(coinInPedestal) && (itemList = world.func_217357_a(ItemEntity.class, getBox = new AxisAlignedBB(negBlockPos = this.getNegRangePosEntity(world, pedestalPos, width, height), posBlockPos = this.getPosRangePosEntity(world, pedestalPos, width, height)))).size() > 0) {
                    this.upgradeActionMagnet(pedestal, world, itemList, itemInPedestal, pedestalPos);
                }
                if (world.func_175707_a(negNums, posNums)) {
                    int speed = this.getOperationSpeed(coinInPedestal);
                    int val = this.readStoredIntTwoFromNBT(coinInPedestal);
                    if (val > 0) {
                        this.writeStoredIntTwoToNBT(coinInPedestal, val - 1);
                    } else {
                        if (this.workQueueSize(coinInPedestal) <= 0) {
                            this.buildWorkQueue(pedestal, rangeWidth, rangeHeight);
                            this.buildWorkQueueTwo(pedestal, rangeWidth, rangeHeight);
                            pedestal.update();
                        }
                        if (this.workQueueSize(coinInPedestal) > 0) {
                            List<BlockPos> workQueue = this.readWorkQueueFromNBT(coinInPedestal);
                            if (world.func_82737_E() % (long)speed == 0L) {
                                for (int i = 0; i < workQueue.size(); ++i) {
                                    BlockPos targetPos = workQueue.get(i);
                                    BlockPos blockToMinePos = new BlockPos(targetPos.func_177958_n(), targetPos.func_177956_o(), targetPos.func_177952_p());
                                    BlockState targetBlock = world.func_180495_p(blockToMinePos);
                                    if (this.canMineBlock(pedestal, blockToMinePos)) {
                                        workQueue.remove(i);
                                        this.writeWorkQueueToNBT(coinInPedestal, workQueue);
                                        this.upgradeAction(pedestal, world, itemInPedestal, coinInPedestal, pedestalPos, targetPos, targetBlock);
                                        if (this.hasAdvancedInventoryTargetingTwo(coinInPedestal)) continue;
                                        break;
                                    }
                                    workQueue.remove(i);
                                }
                                this.writeWorkQueueToNBT(coinInPedestal, workQueue);
                            }
                        } else {
                            this.writeStoredIntTwoToNBT(coinInPedestal, 100);
                        }
                    }
                }
            }
        }
    }

    public void upgradeAction(PedestalTileEntity pedestal, World world, ItemStack itemInPedestal, ItemStack coinInPedestal, BlockPos posOfPedestal, BlockPos posTarget, BlockState target) {
        if (this.canHarvest(world, target) && !target.func_177230_c().isAir(target, (IBlockReader)world, posTarget)) {
            ItemStack toolInPed = pedestal.getToolOnPedestal();
            ItemStack harvestingShears = toolInPed.func_190926_b() ? (itemInPedestal.func_190926_b() ? new ItemStack((IItemProvider)Items.field_151097_aZ, 1) : itemInPedestal) : itemInPedestal;
            FakePlayer fakePlayer = (FakePlayer)this.fakePedestalPlayer(pedestal).get();
            if (fakePlayer != null) {
                ActionResultType type;
                PlayerInteractEvent.RightClickBlock e;
                fakePlayer.func_174810_b(true);
                if (!fakePlayer.func_233580_cy_().equals((Object)new BlockPos(posOfPedestal.func_177958_n(), posOfPedestal.func_177956_o(), posOfPedestal.func_177952_p()))) {
                    fakePlayer.func_70107_b((double)posOfPedestal.func_177958_n(), (double)posOfPedestal.func_177956_o(), (double)posOfPedestal.func_177952_p());
                }
                if (!fakePlayer.func_184614_ca().equals(harvestingShears)) {
                    fakePlayer.func_184201_a(EquipmentSlotType.MAINHAND, harvestingShears);
                }
                if (!(MinecraftForge.EVENT_BUS.post((Event)(e = new PlayerInteractEvent.RightClickBlock((PlayerEntity)fakePlayer, Hand.MAIN_HAND, posTarget, new BlockRayTraceResult(new Vector3d((double)posTarget.func_177958_n(), (double)posTarget.func_177956_o(), (double)posTarget.func_177952_p()), Direction.UP, posTarget, true)))) || (type = ((BeehiveBlock)target.func_177230_c()).func_225533_a_(target, world, posTarget, (PlayerEntity)fakePlayer, Hand.MAIN_HAND, new BlockRayTraceResult(new Vector3d((double)posTarget.func_177958_n(), (double)posTarget.func_177956_o(), (double)posTarget.func_177952_p()), Direction.UP, posTarget, true))) != ActionResultType.CONSUME && type != ActionResultType.SUCCESS)) {
                    ItemStack itemInFakeBoy = ItemStack.field_190927_a;
                    itemInFakeBoy = IntStream.range(0, fakePlayer.field_71071_by.func_70302_i_()).mapToObj(arg_0 -> ((PlayerInventory)fakePlayer.field_71071_by).func_70301_a(arg_0)).filter(itemStack -> !itemStack.func_190926_b()).filter(itemStack -> !fakePlayer.func_184614_ca().func_77973_b().equals(itemInPedestal.func_77973_b())).filter(itemStack -> !itemStack.func_77973_b().equals(toolInPed.func_190926_b() ? Items.field_151097_aZ : toolInPed.func_77973_b())).findFirst().orElse(ItemStack.field_190927_a);
                    BlockPos spawnItemHere = this.getPosOfBlockBelow(world, posTarget, -1);
                    pedestal.spawnItemStack(world, spawnItemHere.func_177958_n(), spawnItemHere.func_177956_o(), spawnItemHere.func_177952_p(), itemInFakeBoy);
                    int getSlot = this.getPlayerSlotWithMatchingStackExact(fakePlayer.field_71071_by, itemInFakeBoy);
                    if (getSlot >= 0 && !fakePlayer.field_71071_by.func_70301_a(0).func_77973_b().equals(itemInPedestal.func_77973_b())) {
                        fakePlayer.field_71071_by.func_70304_b(getSlot);
                    }
                }
            }
        }
    }

    @Override
    public boolean canMineBlock(PedestalTileEntity pedestal, BlockPos blockToMinePos, PlayerEntity player) {
        World world = pedestal.func_145831_w();
        BlockPos targetPos = blockToMinePos;
        BlockPos blockToHarvestPos = new BlockPos(targetPos.func_177958_n(), targetPos.func_177956_o(), targetPos.func_177952_p());
        BlockState blockToHarvestState = world.func_180495_p(blockToHarvestPos);
        Block blockToHarvest = blockToHarvestState.func_177230_c();
        return this.canHarvest(world, blockToHarvestState) && !blockToHarvest.isAir(blockToHarvestState, (IBlockReader)world, blockToHarvestPos);
    }

    @Override
    public boolean canMineBlock(PedestalTileEntity pedestal, BlockPos blockToMinePos) {
        World world = pedestal.func_145831_w();
        BlockPos targetPos = blockToMinePos;
        BlockPos blockToHarvestPos = new BlockPos(targetPos.func_177958_n(), targetPos.func_177956_o(), targetPos.func_177952_p());
        BlockState blockToHarvestState = world.func_180495_p(blockToHarvestPos);
        Block blockToHarvest = blockToHarvestState.func_177230_c();
        return this.canHarvest(world, blockToHarvestState) && !blockToHarvest.isAir(blockToHarvestState, (IBlockReader)world, blockToHarvestPos);
    }

    @Override
    public boolean canMineBlockTwo(PedestalTileEntity pedestal, BlockPos blockToMinePos) {
        World world = pedestal.func_145831_w();
        BlockPos targetPos = blockToMinePos;
        BlockPos blockToHarvestPos = new BlockPos(targetPos.func_177958_n(), targetPos.func_177956_o(), targetPos.func_177952_p());
        BlockState blockToHarvestState = world.func_180495_p(blockToHarvestPos);
        Block blockToHarvest = blockToHarvestState.func_177230_c();
        return blockToHarvestState.func_235714_a_((ITag)BlockTags.field_226151_aa_);
    }

    @Override
    public void actionOnCollideWithBlock(PedestalTileEntity tilePedestal, Entity entityIn) {
        if (entityIn instanceof BeeEntity) {
            ((BeeEntity)entityIn).func_230260_a__(0);
        }
    }

    @Override
    public void chatDetails(PlayerEntity player, PedestalTileEntity pedestal) {
        ItemStack stack = pedestal.getCoinOnPedestal();
        TranslationTextComponent name = new TranslationTextComponent(this.func_77658_a() + ".tooltip_name");
        name.func_240699_a_(TextFormatting.GOLD);
        player.func_145747_a((ITextComponent)name, Util.field_240973_b_);
        if (this.hasMagnetEnchant(stack) && pedestal.getItemInPedestal().func_77973_b().equals(Items.field_151069_bo)) {
            TranslationTextComponent magnet = new TranslationTextComponent(this.func_77658_a() + ".chat_magnet");
            magnet.func_240699_a_(TextFormatting.DARK_RED);
            player.func_145747_a((ITextComponent)magnet, Util.field_240973_b_);
        }
        int s3 = this.getAreaWidth(stack);
        String tr = "" + (s3 + s3 + 1) + "";
        String trr = "" + this.getRangeHeight(stack) + "";
        TranslationTextComponent area = new TranslationTextComponent(this.func_77658_a() + ".chat_area");
        TranslationTextComponent areax = new TranslationTextComponent(this.func_77658_a() + ".chat_areax");
        area.func_240702_b_(tr);
        area.func_240702_b_(areax.getString());
        area.func_240702_b_(trr);
        area.func_240702_b_(areax.getString());
        area.func_240702_b_(tr);
        area.func_240699_a_(TextFormatting.WHITE);
        player.func_145747_a((ITextComponent)area, Util.field_240973_b_);
        TranslationTextComponent btm = new TranslationTextComponent(this.func_77658_a() + ".chat_btm");
        btm.func_240702_b_("" + this.workQueueSize(stack) + "");
        btm.func_240699_a_(TextFormatting.YELLOW);
        player.func_145747_a((ITextComponent)btm, Util.field_240973_b_);
        TranslationTextComponent speed = new TranslationTextComponent(this.func_77658_a() + ".chat_speed");
        speed.func_240702_b_(this.getOperationSpeedString(stack));
        speed.func_240699_a_(TextFormatting.RED);
        player.func_145747_a((ITextComponent)speed, Util.field_240973_b_);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        int s3 = this.getAreaWidth(stack);
        String tr = "" + (s3 + s3 + 1) + "";
        String trr = "" + this.getRangeHeight(stack) + "";
        TranslationTextComponent area = new TranslationTextComponent(this.func_77658_a() + ".tooltip_area");
        TranslationTextComponent areax = new TranslationTextComponent(this.func_77658_a() + ".tooltip_areax");
        area.func_240702_b_(tr);
        area.func_240702_b_(areax.getString());
        area.func_240702_b_(trr);
        area.func_240702_b_(areax.getString());
        area.func_240702_b_(tr);
        TranslationTextComponent speed = new TranslationTextComponent(this.func_77658_a() + ".tooltip_speed");
        speed.func_240702_b_(this.getOperationSpeedString(stack));
        area.func_240699_a_(TextFormatting.WHITE);
        speed.func_240699_a_(TextFormatting.RED);
        tooltip.add((ITextComponent)area);
        tooltip.add((ITextComponent)speed);
    }

    @SubscribeEvent
    public static void onItemRegistryReady(RegistryEvent.Register<Item> event) {
        event.getRegistry().register((IForgeRegistryEntry)HARVESTERHIVES);
    }
}

