/*
 * Decompiled with CFR 0.152.
 */
package com.mowmaster.pedestals.item.pedestalUpgrades;

import com.mowmaster.pedestals.item.pedestalUpgrades.ItemUpgradeBaseFluid;
import com.mowmaster.pedestals.pedestals;
import com.mowmaster.pedestals.tiles.PedestalTileEntity;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tags.ITag;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class ItemUpgradeFluidTank
extends ItemUpgradeBaseFluid {
    public static final Item FLUIDTANK = (Item)new ItemUpgradeFluidTank(new Item.Properties().func_200917_a(64).func_200916_a(pedestals.PEDESTALS_TAB)).setRegistryName(new ResourceLocation("pedestals", "coin/fluidtank"));

    public ItemUpgradeFluidTank(Item.Properties builder) {
        super(builder.func_200916_a(pedestals.PEDESTALS_TAB));
    }

    @Override
    public boolean canAcceptCapacity() {
        return true;
    }

    @Override
    public boolean canAcceptOpSpeed() {
        return false;
    }

    @Override
    public int getFluidbuffer(ItemStack stack) {
        int fluidBuffer = 10000;
        switch (this.getCapacityModifier(stack)) {
            case 0: {
                fluidBuffer = 100000;
                break;
            }
            case 1: {
                fluidBuffer = 250000;
                break;
            }
            case 2: {
                fluidBuffer = 500000;
                break;
            }
            case 3: {
                fluidBuffer = 1000000;
                break;
            }
            case 4: {
                fluidBuffer = 5000000;
                break;
            }
            case 5: {
                fluidBuffer = 10000000;
                break;
            }
            default: {
                fluidBuffer = 100000;
            }
        }
        return fluidBuffer;
    }

    @Override
    public int getWorkAreaX(World world, BlockPos pos, ItemStack coin) {
        return 0;
    }

    @Override
    public int[] getWorkAreaY(World world, BlockPos pos, ItemStack coin) {
        return new int[]{0, 0};
    }

    @Override
    public int getWorkAreaZ(World world, BlockPos pos, ItemStack coin) {
        return 0;
    }

    @Override
    public void updateAction(World world, PedestalTileEntity pedestal) {
        if (!world.field_72995_K) {
            ItemStack coinInPedestal = pedestal.getCoinOnPedestal();
            ItemStack itemInPedestal = pedestal.getItemInPedestal();
            BlockPos pedestalPos = pedestal.func_174877_v();
            int getMaxFluidValue = this.getFluidbuffer(coinInPedestal);
            if (!this.hasMaxFluidSet(coinInPedestal) || this.readMaxFluidFromNBT(coinInPedestal) != getMaxFluidValue) {
                this.setMaxFluid(coinInPedestal, getMaxFluidValue);
            }
            if (!pedestal.isPedestalBlockPowered(world, pedestalPos) && this.hasFluidInCoin(coinInPedestal)) {
                this.upgradeActionSendFluid(pedestal);
            }
        }
    }

    @Override
    public void chatDetails(PlayerEntity player, PedestalTileEntity pedestal) {
        ItemStack stack = pedestal.getCoinOnPedestal();
        TranslationTextComponent name = new TranslationTextComponent(this.func_77658_a() + ".tooltip_name");
        name.func_240699_a_(TextFormatting.GOLD);
        player.func_145747_a((ITextComponent)name, Util.field_240973_b_);
        FluidStack fluidStored = this.getFluidStored(stack);
        TranslationTextComponent fluidLabel = new TranslationTextComponent(this.func_77658_a() + ".chat_fluidlabel");
        if (!fluidStored.isEmpty()) {
            TranslationTextComponent fluid = new TranslationTextComponent(this.func_77658_a() + ".chat_fluid");
            TranslationTextComponent fluidSplit = new TranslationTextComponent(this.func_77658_a() + ".chat_fluidseperator");
            fluid.func_240702_b_("" + fluidStored.getDisplayName().getString() + "");
            fluid.func_240702_b_(fluidSplit.getString());
            fluid.func_240702_b_("" + fluidStored.getAmount() + "");
            fluid.func_240702_b_(fluidLabel.getString());
            fluid.func_240699_a_(TextFormatting.BLUE);
            player.func_145747_a((ITextComponent)fluid, Util.field_240973_b_);
        }
        TranslationTextComponent rate = new TranslationTextComponent(this.func_77658_a() + ".chat_rate");
        rate.func_240702_b_("" + this.getFluidTransferRate(stack) + "");
        rate.func_240702_b_(fluidLabel.getString());
        rate.func_240699_a_(TextFormatting.GRAY);
        player.func_145747_a((ITextComponent)rate, Util.field_240973_b_);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        TranslationTextComponent t = new TranslationTextComponent(this.func_77658_a() + ".tooltip_name");
        t.func_240699_a_(TextFormatting.GOLD);
        tooltip.add((ITextComponent)t);
        ResourceLocation disabled = new ResourceLocation("pedestals", "enchant_limits/advanced_blacklist");
        ITag BLACKLISTED = ItemTags.func_199903_a().func_199910_a(disabled);
        if (BLACKLISTED != null) {
            if (!BLACKLISTED.func_230235_a_((Object)stack.func_77973_b())) {
                if ((this.intOperationalSpeedOver(stack) > 5 || this.getCapacityModifierOver(stack) > 5 || this.getAreaModifierUnRestricted(stack) > 5 || this.getRangeModifier(stack) > 5) && this.getAdvancedModifier(stack) <= 0) {
                    TranslationTextComponent warning = new TranslationTextComponent("pedestals.advanced_warning");
                    warning.func_240699_a_(TextFormatting.RED);
                    tooltip.add((ITextComponent)warning);
                }
            } else if (this.getAdvancedModifier(stack) > 0) {
                TranslationTextComponent disabled_warning = new TranslationTextComponent("pedestals.advanced_disabled_warning");
                disabled_warning.func_240699_a_(TextFormatting.DARK_RED);
                tooltip.add((ITextComponent)disabled_warning);
            }
        }
        FluidStack fluidStored = this.getFluidStored(stack);
        TranslationTextComponent fluidLabel = new TranslationTextComponent(this.func_77658_a() + ".chat_fluidlabel");
        if (!fluidStored.isEmpty()) {
            TranslationTextComponent fluid = new TranslationTextComponent(this.func_77658_a() + ".chat_fluid");
            TranslationTextComponent fluidSplit = new TranslationTextComponent(this.func_77658_a() + ".chat_fluidseperator");
            fluid.func_240702_b_("" + fluidStored.getDisplayName().getString() + "");
            fluid.func_240702_b_(fluidSplit.getString());
            fluid.func_240702_b_("" + fluidStored.getAmount() + "");
            fluid.func_240702_b_(fluidLabel.getString());
            fluid.func_240699_a_(TextFormatting.BLUE);
            tooltip.add((ITextComponent)fluid);
        }
        TranslationTextComponent fluidcapacity = new TranslationTextComponent(this.func_77658_a() + ".tooltip_fluidcapacity");
        fluidcapacity.func_240702_b_("" + this.getFluidbuffer(stack) + "");
        fluidcapacity.func_240702_b_(fluidLabel.getString());
        fluidcapacity.func_240699_a_(TextFormatting.AQUA);
        tooltip.add((ITextComponent)fluidcapacity);
        TranslationTextComponent rate = new TranslationTextComponent(this.func_77658_a() + ".tooltip_rate");
        rate.func_240702_b_("" + this.getFluidTransferRate(stack) + "");
        rate.func_240702_b_(fluidLabel.getString());
        rate.func_240699_a_(TextFormatting.GRAY);
        tooltip.add((ITextComponent)rate);
    }

    @SubscribeEvent
    public static void onItemRegistryReady(RegistryEvent.Register<Item> event) {
        event.getRegistry().register((IForgeRegistryEntry)FLUIDTANK);
    }
}

