/*
 * Decompiled with CFR 0.152.
 */
package com.mowmaster.pedestals.item.pedestalUpgrades;

import com.mowmaster.pedestals.item.pedestalUpgrades.ItemUpgradeBaseFluid;
import com.mowmaster.pedestals.pedestals;
import com.mowmaster.pedestals.tiles.PedestalTileEntity;
import java.util.List;
import java.util.Optional;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tags.ITag;
import net.minecraft.tags.ItemTags;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class ItemUpgradeFluidExport
extends ItemUpgradeBaseFluid {
    public static final Item FLUIDEXPORT = (Item)new ItemUpgradeFluidExport(new Item.Properties().func_200917_a(64).func_200916_a(pedestals.PEDESTALS_TAB)).setRegistryName(new ResourceLocation("pedestals", "coin/fluidexport"));

    public ItemUpgradeFluidExport(Item.Properties builder) {
        super(builder.func_200916_a(pedestals.PEDESTALS_TAB));
    }

    @Override
    public boolean canAcceptCapacity() {
        return true;
    }

    @Override
    public boolean canAcceptAdvanced() {
        return true;
    }

    @Override
    public boolean canSendItem(PedestalTileEntity tile) {
        Optional fluidContainerItemIn;
        if (tile != null && (fluidContainerItemIn = FluidUtil.getFluidHandler((ItemStack)tile.getItemInPedestal()).resolve()).isPresent()) {
            int currentAmount;
            int capacity = ((IFluidHandlerItem)fluidContainerItemIn.get()).getTankCapacity(0);
            return capacity == (currentAmount = ((IFluidHandlerItem)fluidContainerItemIn.get()).getFluidInTank(0).getAmount());
        }
        return true;
    }

    @Override
    public int canAcceptCount(World world, BlockPos pos, ItemStack inPedestal, ItemStack itemStackIncoming) {
        return inPedestal.func_190926_b() ? (this.getFluidInItem(itemStackIncoming).isEmpty() ? 1 : itemStackIncoming.func_77976_d()) : 0;
    }

    @Override
    public int getWorkAreaX(World world, BlockPos pos, ItemStack coin) {
        return 0;
    }

    @Override
    public int[] getWorkAreaY(World world, BlockPos pos, ItemStack coin) {
        return new int[]{0, 0};
    }

    @Override
    public int getWorkAreaZ(World world, BlockPos pos, ItemStack coin) {
        return 0;
    }

    public FluidStack getFluidInItem(ItemStack itemInPedestal) {
        if (FluidUtil.getFluidHandler((ItemStack)itemInPedestal).isPresent()) {
            FluidStack fluidInItem = FluidUtil.getFluidContained((ItemStack)itemInPedestal).orElse(FluidStack.EMPTY);
            return fluidInItem;
        }
        return FluidStack.EMPTY;
    }

    @Override
    public void updateAction(World world, PedestalTileEntity pedestal) {
        if (!world.field_72995_K) {
            ItemStack coinInPedestal = pedestal.getCoinOnPedestal();
            ItemStack itemInPedestal = pedestal.getItemInPedestal();
            BlockPos pedestalPos = pedestal.func_174877_v();
            int getMaxFluidValue = this.getFluidbuffer(coinInPedestal);
            if (!this.hasMaxFluidSet(coinInPedestal) || this.readMaxFluidFromNBT(coinInPedestal) != getMaxFluidValue) {
                this.setMaxFluid(coinInPedestal, getMaxFluidValue);
            }
            int speed = this.getOperationSpeed(coinInPedestal);
            if (!pedestal.isPedestalBlockPowered(world, pedestalPos) && world.func_82737_E() % (long)speed == 0L) {
                this.upgradeActionItem(pedestal);
                this.upgradeActionBlock(pedestal);
            }
        }
    }

    public void upgradeActionItem(PedestalTileEntity pedestal) {
        Optional fluidContainerItemIn;
        FluidStack fluidInCoin;
        ItemStack coinInPedestal = pedestal.getCoinOnPedestal();
        ItemStack itemInPedestal = pedestal.getItemInPedestal();
        if (!itemInPedestal.func_190926_b() && !(fluidInCoin = this.getFluidStored(coinInPedestal)).isEmpty() && (fluidContainerItemIn = FluidUtil.getFluidHandler((ItemStack)itemInPedestal).resolve()).isPresent()) {
            IFluidHandlerItem fluidHandlerItem = (IFluidHandlerItem)fluidContainerItemIn.get();
            int tanks = ((IFluidHandlerItem)fluidContainerItemIn.get()).getTanks();
            if (tanks > 1) {
                FluidStack fluidMatching = FluidStack.EMPTY;
                fluidMatching = IntStream.range(0, tanks).mapToObj(arg_0 -> ((IFluidHandlerItem)fluidHandlerItem).getFluidInTank(arg_0)).filter(fluidStack -> fluidInCoin.isFluidEqual(fluidStack)).findFirst().orElse(FluidStack.EMPTY);
                if (!fluidMatching.isEmpty()) {
                    int transferRate;
                    FluidStack matchedFluid = fluidMatching;
                    int value = 0;
                    for (int location = 0; location < tanks; ++location) {
                        if (!fluidHandlerItem.getFluidInTank(location).isFluidEqual(matchedFluid)) continue;
                        value = location;
                        break;
                    }
                    int getTankCapacity = fluidHandlerItem.getTankCapacity(value);
                    int tankCurrentlyStored = fluidMatching.getAmount();
                    int spaceInTank = getTankCapacity - tankCurrentlyStored;
                    int amountInCoin = fluidInCoin.getAmount();
                    int rate = this.getFluidTransferRate(coinInPedestal);
                    int actualCoinRate = spaceInTank >= rate ? rate : spaceInTank;
                    int n = transferRate = amountInCoin >= actualCoinRate ? actualCoinRate : amountInCoin;
                    if (spaceInTank >= transferRate) {
                        FluidStack estFluidToFill = new FluidStack(fluidMatching, transferRate);
                        int fluidToActuallyFill = fluidHandlerItem.fill(estFluidToFill, IFluidHandler.FluidAction.SIMULATE);
                        if (!fluidMatching.isEmpty() && this.removeFluid(pedestal, coinInPedestal, fluidToActuallyFill, true)) {
                            estFluidToFill = new FluidStack(fluidMatching, fluidToActuallyFill);
                            int fluidDrained = fluidHandlerItem.fill(estFluidToFill, IFluidHandler.FluidAction.SIMULATE);
                            ItemStack returnerStack = fluidHandlerItem.getContainer();
                            if (!returnerStack.func_190926_b()) {
                                this.removeFluid(pedestal, coinInPedestal, fluidDrained, false);
                                pedestal.removeItemOverride();
                                pedestal.addItem(returnerStack);
                            }
                        }
                    }
                }
            } else {
                FluidStack fluidInTank = fluidHandlerItem.getFluidInTank(tanks - 1);
                if (!fluidInCoin.isEmpty() || fluidInCoin.isFluidEqual(fluidInTank)) {
                    FluidStack estFluidToFill;
                    int fluidToActuallyFill;
                    int transferRate;
                    int getTankCapacity = fluidHandlerItem.getTankCapacity(tanks - 1);
                    int tankCurrentlyStored = fluidInTank.getAmount();
                    int spaceInTank = getTankCapacity - tankCurrentlyStored;
                    int amountInCoin = fluidInCoin.getAmount();
                    int rate = this.getFluidTransferRate(coinInPedestal);
                    int actualCoinRate = spaceInTank >= rate ? rate : spaceInTank;
                    int n = transferRate = amountInCoin >= actualCoinRate ? actualCoinRate : amountInCoin;
                    if (spaceInTank >= transferRate && (fluidToActuallyFill = fluidHandlerItem.fill(estFluidToFill = new FluidStack(fluidInCoin, transferRate), IFluidHandler.FluidAction.SIMULATE)) > 0 && this.removeFluid(pedestal, coinInPedestal, fluidToActuallyFill, true)) {
                        estFluidToFill = new FluidStack(fluidInCoin, fluidToActuallyFill);
                        int fluidDrained = fluidHandlerItem.fill(estFluidToFill, IFluidHandler.FluidAction.EXECUTE);
                        ItemStack returnerStack = fluidHandlerItem.getContainer();
                        if (!returnerStack.func_190926_b()) {
                            this.removeFluid(pedestal, coinInPedestal, fluidDrained, false);
                            pedestal.removeItemOverride();
                            pedestal.addItem(returnerStack);
                        }
                    }
                }
            }
        }
    }

    public void upgradeActionBlock(PedestalTileEntity pedestal) {
        IFluidHandler handler;
        World world = pedestal.func_145831_w();
        BlockPos posPedestal = pedestal.func_174877_v();
        ItemStack coinInPedestal = pedestal.getCoinOnPedestal();
        BlockPos posInventory = this.getPosOfBlockBelow(world, posPedestal, 1);
        ItemStack itemFromPedestal = ItemStack.field_190927_a;
        LazyOptional<IFluidHandler> cap = ItemUpgradeFluidExport.findFluidHandlerAtPos(world, posInventory, this.getPedestalFacing(world, posPedestal), true);
        TileEntity invToPushTo = world.func_175625_s(posInventory);
        if (invToPushTo instanceof PedestalTileEntity) {
            itemFromPedestal = ItemStack.field_190927_a;
        } else if (cap.isPresent() && (handler = (IFluidHandler)cap.orElse(null)) != null) {
            int tanks = handler.getTanks();
            FluidStack fluidInCoin = this.getFluidStored(coinInPedestal);
            if (tanks > 1) {
                FluidStack fluidCheckedMatching = FluidStack.EMPTY;
                fluidCheckedMatching = IntStream.range(0, tanks).mapToObj(arg_0 -> ((IFluidHandler)handler).getFluidInTank(arg_0)).filter(fluidStack -> fluidStack.isFluidEqual(fluidInCoin)).findFirst().orElse(FluidStack.EMPTY);
                if (!fluidCheckedMatching.isEmpty()) {
                    FluidStack estFluidToFill;
                    int fluidToActuallyFill;
                    int transferRate;
                    FluidStack matchedFluid = fluidCheckedMatching;
                    int value = 0;
                    for (int location = 0; location < tanks; ++location) {
                        if (!handler.getFluidInTank(location).isFluidEqual(matchedFluid)) continue;
                        value = location;
                        break;
                    }
                    int getTankCapacity = handler.getTankCapacity(value);
                    int tankCurrentlyStored = matchedFluid.getAmount();
                    int spaceInTank = getTankCapacity - tankCurrentlyStored;
                    int amountInCoin = fluidInCoin.getAmount();
                    int rate = this.getFluidTransferRate(coinInPedestal);
                    int actualCoinRate = spaceInTank >= rate ? rate : spaceInTank;
                    int n = transferRate = amountInCoin >= actualCoinRate ? actualCoinRate : amountInCoin;
                    if (spaceInTank >= transferRate && (fluidToActuallyFill = handler.fill(estFluidToFill = new FluidStack(fluidInCoin, transferRate), IFluidHandler.FluidAction.SIMULATE)) > 0 && this.removeFluid(pedestal, coinInPedestal, fluidToActuallyFill, true)) {
                        estFluidToFill = new FluidStack(fluidInCoin, fluidToActuallyFill);
                        int fluidDrained = handler.fill(estFluidToFill, IFluidHandler.FluidAction.EXECUTE);
                        this.removeFluid(pedestal, coinInPedestal, fluidDrained, false);
                    }
                } else {
                    FluidStack estFluidToFill;
                    int fluidToActuallyFill;
                    int transferRate;
                    int value = 0;
                    for (int location = 0; location < tanks; ++location) {
                        if (!handler.getFluidInTank(location).isEmpty()) continue;
                        value = location;
                        break;
                    }
                    FluidStack emptyTank = handler.getFluidInTank(value);
                    int getTankCapacity = handler.getTankCapacity(value);
                    int tankCurrentlyStored = emptyTank.getAmount();
                    int spaceInTank = getTankCapacity - tankCurrentlyStored;
                    int amountInCoin = fluidInCoin.getAmount();
                    int rate = this.getFluidTransferRate(coinInPedestal);
                    int actualCoinRate = spaceInTank >= rate ? rate : spaceInTank;
                    int n = transferRate = amountInCoin >= actualCoinRate ? actualCoinRate : amountInCoin;
                    if (spaceInTank >= transferRate && (fluidToActuallyFill = handler.fill(estFluidToFill = new FluidStack(fluidInCoin, transferRate), IFluidHandler.FluidAction.SIMULATE)) > 0 && this.removeFluid(pedestal, coinInPedestal, fluidToActuallyFill, true)) {
                        estFluidToFill = new FluidStack(fluidInCoin, fluidToActuallyFill);
                        int fluidDrained = handler.fill(estFluidToFill, IFluidHandler.FluidAction.EXECUTE);
                        this.removeFluid(pedestal, coinInPedestal, fluidDrained, false);
                    }
                }
            } else {
                FluidStack fluidInTank = handler.getFluidInTank(tanks - 1);
                if (fluidInTank.isEmpty() || fluidInCoin.isFluidEqual(fluidInTank)) {
                    FluidStack estFluidToFill;
                    int fluidToActuallyFill;
                    int transferRate;
                    int getTankCapacity = handler.getTankCapacity(tanks - 1);
                    int tankCurrentlyStored = fluidInTank.getAmount();
                    int spaceInTank = getTankCapacity - tankCurrentlyStored;
                    int amountInCoin = fluidInCoin.getAmount();
                    int rate = this.getFluidTransferRate(coinInPedestal);
                    int actualCoinRate = spaceInTank >= rate ? rate : spaceInTank;
                    int n = transferRate = amountInCoin >= actualCoinRate ? actualCoinRate : amountInCoin;
                    if (spaceInTank >= transferRate && (fluidToActuallyFill = handler.fill(estFluidToFill = new FluidStack(fluidInCoin, transferRate), IFluidHandler.FluidAction.SIMULATE)) > 0 && this.removeFluid(pedestal, coinInPedestal, fluidToActuallyFill, true)) {
                        estFluidToFill = new FluidStack(fluidInCoin, fluidToActuallyFill);
                        int fluidDrained = handler.fill(estFluidToFill, IFluidHandler.FluidAction.EXECUTE);
                        this.removeFluid(pedestal, coinInPedestal, fluidDrained, false);
                    }
                }
            }
        }
    }

    @Override
    public void chatDetails(PlayerEntity player, PedestalTileEntity pedestal) {
        ItemStack stack = pedestal.getCoinOnPedestal();
        TranslationTextComponent name = new TranslationTextComponent(this.func_77658_a() + ".tooltip_name");
        name.func_240699_a_(TextFormatting.GOLD);
        player.func_145747_a((ITextComponent)name, Util.field_240973_b_);
        FluidStack fluidStored = this.getFluidStored(stack);
        TranslationTextComponent fluidLabel = new TranslationTextComponent(this.func_77658_a() + ".chat_fluidlabel");
        if (!fluidStored.isEmpty()) {
            TranslationTextComponent fluid = new TranslationTextComponent(this.func_77658_a() + ".chat_fluid");
            TranslationTextComponent fluidSplit = new TranslationTextComponent(this.func_77658_a() + ".chat_fluidseperator");
            fluid.func_240702_b_("" + fluidStored.getDisplayName().getString() + "");
            fluid.func_240702_b_(fluidSplit.getString());
            fluid.func_240702_b_("" + fluidStored.getAmount() + "");
            fluid.func_240702_b_(fluidLabel.getString());
            fluid.func_240699_a_(TextFormatting.BLUE);
            player.func_145747_a((ITextComponent)fluid, Util.field_240973_b_);
        }
        TranslationTextComponent rate = new TranslationTextComponent(this.func_77658_a() + ".chat_rate");
        rate.func_240702_b_("" + this.getFluidTransferRate(stack) + "");
        rate.func_240702_b_(fluidLabel.getString());
        rate.func_240699_a_(TextFormatting.GRAY);
        player.func_145747_a((ITextComponent)rate, Util.field_240973_b_);
        TranslationTextComponent speed = new TranslationTextComponent(this.func_77658_a() + ".chat_speed");
        speed.func_240702_b_(this.getOperationSpeedString(stack));
        speed.func_240699_a_(TextFormatting.RED);
        player.func_145747_a((ITextComponent)speed, Util.field_240973_b_);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        TranslationTextComponent t = new TranslationTextComponent(this.func_77658_a() + ".tooltip_name");
        t.func_240699_a_(TextFormatting.GOLD);
        tooltip.add((ITextComponent)t);
        ResourceLocation disabled = new ResourceLocation("pedestals", "enchant_limits/advanced_blacklist");
        ITag BLACKLISTED = ItemTags.func_199903_a().func_199910_a(disabled);
        if (BLACKLISTED != null) {
            if (!BLACKLISTED.func_230235_a_((Object)stack.func_77973_b())) {
                if ((this.intOperationalSpeedOver(stack) > 5 || this.getCapacityModifierOver(stack) > 5 || this.getAreaModifierUnRestricted(stack) > 5 || this.getRangeModifier(stack) > 5) && this.getAdvancedModifier(stack) <= 0) {
                    TranslationTextComponent warning = new TranslationTextComponent("pedestals.advanced_warning");
                    warning.func_240699_a_(TextFormatting.RED);
                    tooltip.add((ITextComponent)warning);
                }
            } else if (this.getAdvancedModifier(stack) > 0) {
                TranslationTextComponent disabled_warning = new TranslationTextComponent("pedestals.advanced_disabled_warning");
                disabled_warning.func_240699_a_(TextFormatting.DARK_RED);
                tooltip.add((ITextComponent)disabled_warning);
            }
        }
        FluidStack fluidStored = this.getFluidStored(stack);
        TranslationTextComponent fluidLabel = new TranslationTextComponent(this.func_77658_a() + ".chat_fluidlabel");
        if (!fluidStored.isEmpty()) {
            TranslationTextComponent fluid = new TranslationTextComponent(this.func_77658_a() + ".chat_fluid");
            TranslationTextComponent fluidSplit = new TranslationTextComponent(this.func_77658_a() + ".chat_fluidseperator");
            fluid.func_240702_b_("" + fluidStored.getDisplayName().getString() + "");
            fluid.func_240702_b_(fluidSplit.getString());
            fluid.func_240702_b_("" + fluidStored.getAmount() + "");
            fluid.func_240702_b_(fluidLabel.getString());
            fluid.func_240699_a_(TextFormatting.BLUE);
            tooltip.add((ITextComponent)fluid);
        }
        TranslationTextComponent fluidcapacity = new TranslationTextComponent(this.func_77658_a() + ".tooltip_fluidcapacity");
        fluidcapacity.func_240702_b_("" + this.getFluidbuffer(stack) + "");
        fluidcapacity.func_240702_b_(fluidLabel.getString());
        fluidcapacity.func_240699_a_(TextFormatting.AQUA);
        tooltip.add((ITextComponent)fluidcapacity);
        TranslationTextComponent rate = new TranslationTextComponent(this.func_77658_a() + ".tooltip_rate");
        rate.func_240702_b_("" + this.getFluidTransferRate(stack) + "");
        rate.func_240702_b_(fluidLabel.getString());
        rate.func_240699_a_(TextFormatting.GRAY);
        tooltip.add((ITextComponent)rate);
        TranslationTextComponent speed = new TranslationTextComponent(this.func_77658_a() + ".tooltip_speed");
        speed.func_240702_b_(this.getOperationSpeedString(stack));
        speed.func_240699_a_(TextFormatting.RED);
        tooltip.add((ITextComponent)speed);
    }

    @SubscribeEvent
    public static void onItemRegistryReady(RegistryEvent.Register<Item> event) {
        event.getRegistry().register((IForgeRegistryEntry)FLUIDEXPORT);
    }
}

