/*
 * Decompiled with CFR 0.152.
 */
package com.mowmaster.pedestals.item.pedestalUpgrades;

import com.mowmaster.pedestals.item.pedestalUpgrades.ItemUpgradeBaseFluid;
import com.mowmaster.pedestals.pedestals;
import com.mowmaster.pedestals.tiles.PedestalTileEntity;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.FlowingFluidBlock;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.BucketItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tags.ITag;
import net.minecraft.tags.ItemTags;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class ItemUpgradeFluidDrain
extends ItemUpgradeBaseFluid {
    public static final Item FLUIDDRAIN = (Item)new ItemUpgradeFluidDrain(new Item.Properties().func_200917_a(64).func_200916_a(pedestals.PEDESTALS_TAB)).setRegistryName(new ResourceLocation("pedestals", "coin/fluiddrain"));

    public ItemUpgradeFluidDrain(Item.Properties builder) {
        super(builder.func_200916_a(pedestals.PEDESTALS_TAB));
    }

    @Override
    public boolean canAcceptRange() {
        return true;
    }

    @Override
    public boolean canAcceptArea() {
        return true;
    }

    @Override
    public boolean canAcceptCapacity() {
        return true;
    }

    public int getHeight(ItemStack stack) {
        return this.getRangeLarge(stack);
    }

    public int getWidth(ItemStack stack) {
        return this.getAreaModifier(stack);
    }

    @Override
    public int getWorkAreaX(World world, BlockPos pos, ItemStack coin) {
        return this.getWidth(coin);
    }

    @Override
    public int[] getWorkAreaY(World world, BlockPos pos, ItemStack coin) {
        return new int[]{this.getHeight(coin), 0};
    }

    @Override
    public int getWorkAreaZ(World world, BlockPos pos, ItemStack coin) {
        return this.getWidth(coin);
    }

    @Override
    public int getComparatorRedstoneLevel(World worldIn, BlockPos pos) {
        int intItem = 0;
        TileEntity tileEntity = worldIn.func_175625_s(pos);
        if (tileEntity instanceof PedestalTileEntity) {
            PedestalTileEntity pedestal = (PedestalTileEntity)tileEntity;
            int width = this.getWidth(pedestal.getCoinOnPedestal());
            int height = this.getHeight(pedestal.getCoinOnPedestal());
            int amount = this.blocksToFillInArea(pedestal, width, height);
            int area = Math.multiplyExact(Math.multiplyExact(amount, amount), height);
            if (amount > 0) {
                float f = (float)amount / (float)area;
                intItem = MathHelper.func_76141_d((float)(f * 14.0f)) + 1;
            }
        }
        return intItem;
    }

    @Override
    public void updateAction(World world, PedestalTileEntity pedestal) {
        if (!world.field_72995_K) {
            ItemStack coinInPedestal = pedestal.getCoinOnPedestal();
            ItemStack itemInPedestal = pedestal.getItemInPedestal();
            BlockPos pedestalPos = pedestal.func_174877_v();
            int getMaxFluidValue = this.getFluidbuffer(coinInPedestal);
            if (!this.hasMaxFluidSet(coinInPedestal) || this.readMaxFluidFromNBT(coinInPedestal) != getMaxFluidValue) {
                this.setMaxFluid(coinInPedestal, getMaxFluidValue);
            }
            int rangeWidth = this.getWidth(coinInPedestal);
            int rangeHeight = this.getHeight(coinInPedestal);
            int speed = this.getOperationSpeed(coinInPedestal);
            BlockState pedestalState = world.func_180495_p(pedestalPos);
            Direction enumfacing = pedestalState.func_235901_b_((Property)BlockStateProperties.field_208155_H) ? (Direction)pedestalState.func_177229_b((Property)BlockStateProperties.field_208155_H) : Direction.UP;
            BlockPos negNums = this.getNegRangePosEntity(world, pedestalPos, rangeWidth, enumfacing == Direction.NORTH || enumfacing == Direction.EAST || enumfacing == Direction.SOUTH || enumfacing == Direction.WEST ? rangeHeight - 1 : rangeHeight);
            BlockPos posNums = this.getPosRangePosEntity(world, pedestalPos, rangeWidth, enumfacing == Direction.NORTH || enumfacing == Direction.EAST || enumfacing == Direction.SOUTH || enumfacing == Direction.WEST ? rangeHeight - 1 : rangeHeight);
            FluidStack fluidInCoin = this.getFluidStored(coinInPedestal);
            if (fluidInCoin.getAmount() >= 1000 && world.func_175707_a(negNums, posNums) && !pedestal.isPedestalBlockPowered(world, pedestalPos)) {
                int val = this.readStoredIntTwoFromNBT(coinInPedestal);
                if (val > 0) {
                    this.writeStoredIntTwoToNBT(coinInPedestal, val - 1);
                } else {
                    if (this.workQueueSize(coinInPedestal) <= 0) {
                        this.buildWorkQueue(pedestal, rangeWidth, rangeHeight);
                    }
                    if (this.workQueueSize(coinInPedestal) > 0) {
                        if (this.getFluidStored(coinInPedestal).getAmount() >= 1000) {
                            List<BlockPos> workQueue = this.readWorkQueueFromNBT(coinInPedestal);
                            if (world.func_82737_E() % (long)speed == 0L) {
                                for (int i = 0; i < workQueue.size(); ++i) {
                                    BlockPos targetPos = workQueue.get(i);
                                    BlockPos blockToPumpPos = new BlockPos(targetPos.func_177958_n(), targetPos.func_177956_o(), targetPos.func_177952_p());
                                    BlockState targetFluidState = world.func_180495_p(blockToPumpPos);
                                    Block targetFluidBlock = targetFluidState.func_177230_c();
                                    if (this.canMineBlock(pedestal, blockToPumpPos)) {
                                        workQueue.remove(i);
                                        this.writeWorkQueueToNBT(coinInPedestal, workQueue);
                                        this.upgradeAction(pedestal, targetPos, itemInPedestal, coinInPedestal);
                                        if (this.hasAdvancedInventoryTargetingTwo(coinInPedestal)) continue;
                                        break;
                                    }
                                    workQueue.remove(i);
                                }
                                this.writeWorkQueueToNBT(coinInPedestal, workQueue);
                            }
                        }
                    } else {
                        this.writeStoredIntTwoToNBT(coinInPedestal, (rangeWidth * 2 + 1) * 20 + 20);
                    }
                }
            }
        }
    }

    @Override
    public boolean canMineBlock(PedestalTileEntity pedestal, BlockPos blockToMinePos, PlayerEntity player) {
        World world = pedestal.func_145831_w();
        BlockPos blockToPumpPos = new BlockPos(blockToMinePos.func_177958_n(), blockToMinePos.func_177956_o(), blockToMinePos.func_177952_p());
        return this.canPlaceFluidBlock(world, blockToPumpPos);
    }

    @Override
    public boolean canMineBlock(PedestalTileEntity pedestal, BlockPos blockToMinePos) {
        World world = pedestal.func_145831_w();
        BlockPos blockToPumpPos = new BlockPos(blockToMinePos.func_177958_n(), blockToMinePos.func_177956_o(), blockToMinePos.func_177952_p());
        return this.canPlaceFluidBlock(world, blockToPumpPos);
    }

    public boolean canPlaceFluidBlock(World world, BlockPos targetPos) {
        BlockState targetFluidState = world.func_180495_p(targetPos);
        Block targetFluidBlock = targetFluidState.func_177230_c();
        if (targetFluidBlock.equals(Blocks.field_150350_a)) {
            return true;
        }
        return targetFluidBlock instanceof FlowingFluidBlock && (Integer)targetFluidState.func_177229_b((Property)FlowingFluidBlock.field_176367_b) != 0;
    }

    public boolean placeFluid(PedestalTileEntity pedestal, FakePlayer player, BlockPos targetBlock, FluidStack fluidIn, boolean simulate) {
        BucketItem bucketItem;
        FluidStack fluidToBucket;
        Item bucket;
        World world = pedestal.func_145831_w();
        ItemStack coinInPedestal = pedestal.getCoinOnPedestal();
        if (this.removeFluid(pedestal, coinInPedestal, 1000, true) && (bucket = (fluidToBucket = new FluidStack(fluidIn.getFluid(), 1000, fluidIn.getTag())).getFluid().func_204524_b()) instanceof BucketItem && (bucketItem = (BucketItem)bucket).func_180616_a((PlayerEntity)player, world, targetBlock, (BlockRayTraceResult)null)) {
            if (!simulate) {
                bucketItem.func_203792_a(world, new ItemStack((IItemProvider)bucketItem), targetBlock);
            }
            return true;
        }
        return false;
    }

    public ItemStack getBucket(FluidStack fluidIn) {
        FluidStack fluidForBucket;
        Item bucketItem;
        if (!fluidIn.isEmpty() && (bucketItem = (fluidForBucket = new FluidStack(fluidIn.getFluid(), 1000, fluidIn.getTag())).getFluid().func_204524_b()) instanceof BucketItem && ((BucketItem)bucketItem != null || (BucketItem)bucketItem != Items.field_190931_a)) {
            return new ItemStack((IItemProvider)((BucketItem)bucketItem));
        }
        return ItemStack.field_190927_a;
    }

    public void upgradeAction(PedestalTileEntity pedestal, BlockPos targetPos, ItemStack itemInPedestal, ItemStack coinInPedestal) {
        FakePlayer fakePlayer;
        World world = pedestal.func_145831_w();
        BlockPos pedestalPos = pedestal.func_174877_v();
        FluidStack fluidInCoin = this.getFluidStored(coinInPedestal);
        if (!fluidInCoin.isEmpty() && this.canPlaceFluidBlock(world, targetPos) && this.removeFluid(pedestal, coinInPedestal, 1000, true) && (fakePlayer = (FakePlayer)this.fakePedestalPlayer(pedestal).get()) != null) {
            fakePlayer.func_174810_b(true);
            fakePlayer.func_70107_b((double)pedestalPos.func_177958_n(), (double)pedestalPos.func_177956_o(), (double)pedestalPos.func_177952_p());
            ItemStack getBucketOfFluid = this.getBucket(fluidInCoin);
            fakePlayer.func_184201_a(EquipmentSlotType.MAINHAND, getBucketOfFluid);
            if (world.func_175660_a((PlayerEntity)fakePlayer, targetPos) && this.placeFluid(pedestal, fakePlayer, targetPos, fluidInCoin, true)) {
                this.removeFluid(pedestal, coinInPedestal, 1000, false);
                this.placeFluid(pedestal, fakePlayer, targetPos, fluidInCoin, false);
                if (!pedestal.hasMuffler()) {
                    world.func_184148_a((PlayerEntity)null, (double)targetPos.func_177958_n(), (double)targetPos.func_177956_o(), (double)targetPos.func_177952_p(), SoundEvents.field_187624_K, SoundCategory.BLOCKS, 0.5f, 1.0f);
                }
            }
        }
    }

    public int blocksToFillInArea(PedestalTileEntity pedestal, int width, int height) {
        World world = pedestal.func_145831_w();
        BlockPos pedestalPos = pedestal.func_174877_v();
        ItemStack coinInPedestal = pedestal.getCoinOnPedestal();
        FluidStack fluidInCoin = this.getFluidStored(coinInPedestal);
        int validBlocks = 0;
        BlockState pedestalState = world.func_180495_p(pedestalPos);
        Direction enumfacing = pedestalState.func_235901_b_((Property)BlockStateProperties.field_208155_H) ? (Direction)pedestalState.func_177229_b((Property)BlockStateProperties.field_208155_H) : Direction.UP;
        BlockPos negNums = this.getNegRangePosEntity(world, pedestalPos, width, enumfacing == Direction.NORTH || enumfacing == Direction.EAST || enumfacing == Direction.SOUTH || enumfacing == Direction.WEST ? height - 1 : height);
        BlockPos posNums = this.getPosRangePosEntity(world, pedestalPos, width, enumfacing == Direction.NORTH || enumfacing == Direction.EAST || enumfacing == Direction.SOUTH || enumfacing == Direction.WEST ? height - 1 : height);
        int i = 0;
        while (!this.resetCurrentPosInt(i, enumfacing == Direction.DOWN ? negNums.func_177982_a(0, 1, 0) : negNums, enumfacing != Direction.UP ? posNums.func_177982_a(0, 1, 0) : posNums)) {
            BlockPos targetPos = this.getPosOfNextBlock(i, enumfacing == Direction.DOWN ? negNums.func_177982_a(0, 1, 0) : negNums, enumfacing != Direction.UP ? posNums.func_177982_a(0, 1, 0) : posNums);
            BlockPos blockToFillPos = new BlockPos(targetPos.func_177958_n(), targetPos.func_177956_o(), targetPos.func_177952_p());
            FakePlayer fakePlayer = (FakePlayer)this.fakePedestalPlayer(pedestal).get();
            if (fakePlayer != null) {
                fakePlayer.func_174810_b(true);
                fakePlayer.func_70107_b((double)pedestalPos.func_177958_n(), (double)pedestalPos.func_177956_o(), (double)pedestalPos.func_177952_p());
                if (world.func_175660_a((PlayerEntity)fakePlayer, blockToFillPos) && this.placeFluid(pedestal, fakePlayer, blockToFillPos, fluidInCoin, true)) {
                    ++validBlocks;
                }
            }
            ++i;
        }
        return validBlocks;
    }

    @Override
    public void chatDetails(PlayerEntity player, PedestalTileEntity pedestal) {
        ItemStack stack = pedestal.getCoinOnPedestal();
        TranslationTextComponent name = new TranslationTextComponent(this.func_77658_a() + ".tooltip_name");
        name.func_240699_a_(TextFormatting.GOLD);
        player.func_145747_a((ITextComponent)name, Util.field_240973_b_);
        int s3 = this.getWidth(stack);
        int s4 = this.getHeight(stack);
        String tr = "" + (s3 + s3 + 1) + "";
        String trr = "" + s4 + "";
        TranslationTextComponent area = new TranslationTextComponent(this.func_77658_a() + ".chat_area");
        TranslationTextComponent areax = new TranslationTextComponent(this.func_77658_a() + ".chat_areax");
        area.func_240702_b_(tr);
        area.func_240702_b_(areax.getString());
        area.func_240702_b_(trr);
        area.func_240702_b_(areax.getString());
        area.func_240702_b_(tr);
        area.func_240699_a_(TextFormatting.WHITE);
        player.func_145747_a((ITextComponent)area, Util.field_240973_b_);
        FluidStack fluidStored = this.getFluidStored(stack);
        TranslationTextComponent fluidLabel = new TranslationTextComponent(this.func_77658_a() + ".chat_fluidlabel");
        if (!fluidStored.isEmpty()) {
            TranslationTextComponent fluid = new TranslationTextComponent(this.func_77658_a() + ".chat_fluid");
            TranslationTextComponent fluidSplit = new TranslationTextComponent(this.func_77658_a() + ".chat_fluidseperator");
            fluid.func_240702_b_("" + fluidStored.getDisplayName().getString() + "");
            fluid.func_240702_b_(fluidSplit.getString());
            fluid.func_240702_b_("" + fluidStored.getAmount() + "");
            fluid.func_240702_b_(fluidLabel.getString());
            fluid.func_240699_a_(TextFormatting.BLUE);
            player.func_145747_a((ITextComponent)fluid, Util.field_240973_b_);
        }
        TranslationTextComponent btm = new TranslationTextComponent(this.func_77658_a() + ".chat_btm");
        btm.func_240702_b_("" + this.blocksToFillInArea(pedestal, this.getWidth(pedestal.getCoinOnPedestal()), this.getHeight(pedestal.getCoinOnPedestal())) + "");
        btm.func_240699_a_(TextFormatting.YELLOW);
        player.func_145747_a((ITextComponent)btm, Util.field_240973_b_);
        TranslationTextComponent speed = new TranslationTextComponent(this.func_77658_a() + ".chat_speed");
        speed.func_240702_b_(this.getOperationSpeedString(stack));
        speed.func_240699_a_(TextFormatting.RED);
        player.func_145747_a((ITextComponent)speed, Util.field_240973_b_);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        TranslationTextComponent t = new TranslationTextComponent(this.func_77658_a() + ".tooltip_name");
        t.func_240699_a_(TextFormatting.GOLD);
        tooltip.add((ITextComponent)t);
        ResourceLocation disabled = new ResourceLocation("pedestals", "enchant_limits/advanced_blacklist");
        ITag BLACKLISTED = ItemTags.func_199903_a().func_199910_a(disabled);
        if (BLACKLISTED != null) {
            if (!BLACKLISTED.func_230235_a_((Object)stack.func_77973_b())) {
                if ((this.intOperationalSpeedOver(stack) > 5 || this.getCapacityModifierOver(stack) > 5 || this.getAreaModifierUnRestricted(stack) > 5 || this.getRangeModifier(stack) > 5) && this.getAdvancedModifier(stack) <= 0) {
                    TranslationTextComponent warning = new TranslationTextComponent("pedestals.advanced_warning");
                    warning.func_240699_a_(TextFormatting.RED);
                    tooltip.add((ITextComponent)warning);
                }
            } else if (this.getAdvancedModifier(stack) > 0) {
                TranslationTextComponent disabled_warning = new TranslationTextComponent("pedestals.advanced_disabled_warning");
                disabled_warning.func_240699_a_(TextFormatting.DARK_RED);
                tooltip.add((ITextComponent)disabled_warning);
            }
        }
        FluidStack fluidStored = this.getFluidStored(stack);
        TranslationTextComponent fluidLabel = new TranslationTextComponent(this.func_77658_a() + ".chat_fluidlabel");
        if (!fluidStored.isEmpty()) {
            TranslationTextComponent fluid = new TranslationTextComponent(this.func_77658_a() + ".chat_fluid");
            TranslationTextComponent fluidSplit = new TranslationTextComponent(this.func_77658_a() + ".chat_fluidseperator");
            fluid.func_240702_b_("" + fluidStored.getDisplayName().getString() + "");
            fluid.func_240702_b_(fluidSplit.getString());
            fluid.func_240702_b_("" + fluidStored.getAmount() + "");
            fluid.func_240702_b_(fluidLabel.getString());
            fluid.func_240699_a_(TextFormatting.BLUE);
            tooltip.add((ITextComponent)fluid);
        }
        int s3 = this.getWidth(stack);
        int s4 = this.getHeight(stack);
        String tr = "" + (s3 + s3 + 1) + "";
        String trr = "" + s4 + "";
        TranslationTextComponent area = new TranslationTextComponent(this.func_77658_a() + ".tooltip_area");
        TranslationTextComponent areax = new TranslationTextComponent(this.func_77658_a() + ".tooltip_areax");
        area.func_240702_b_(tr);
        area.func_240702_b_(areax.getString());
        area.func_240702_b_(trr);
        area.func_240702_b_(areax.getString());
        area.func_240702_b_(tr);
        area.func_240699_a_(TextFormatting.WHITE);
        tooltip.add((ITextComponent)area);
        TranslationTextComponent fluidcapacity = new TranslationTextComponent(this.func_77658_a() + ".tooltip_fluidcapacity");
        fluidcapacity.func_240702_b_("" + this.getFluidbuffer(stack) + "");
        fluidcapacity.func_240702_b_(fluidLabel.getString());
        fluidcapacity.func_240699_a_(TextFormatting.AQUA);
        tooltip.add((ITextComponent)fluidcapacity);
        TranslationTextComponent speed = new TranslationTextComponent(this.func_77658_a() + ".tooltip_speed");
        speed.func_240702_b_(this.getOperationSpeedString(stack));
        speed.func_240699_a_(TextFormatting.RED);
        tooltip.add((ITextComponent)speed);
    }

    @SubscribeEvent
    public static void onItemRegistryReady(RegistryEvent.Register<Item> event) {
        event.getRegistry().register((IForgeRegistryEntry)FLUIDDRAIN);
    }
}

