/*
 * Decompiled with CFR 0.152.
 */
package com.mowmaster.pedestals.item.pedestalUpgrades;

import com.mowmaster.pedestals.item.pedestalUpgrades.ItemUpgradeBase;
import com.mowmaster.pedestals.pedestals;
import com.mowmaster.pedestals.tiles.PedestalTileEntity;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class ItemUpgradeExport
extends ItemUpgradeBase {
    public static final Item EXPORT = (Item)new ItemUpgradeExport(new Item.Properties().func_200917_a(64).func_200916_a(pedestals.PEDESTALS_TAB)).setRegistryName(new ResourceLocation("pedestals", "coin/export"));

    public ItemUpgradeExport(Item.Properties builder) {
        super(builder.func_200916_a(pedestals.PEDESTALS_TAB));
    }

    @Override
    public boolean canAcceptCapacity() {
        return true;
    }

    @Override
    public boolean canAcceptAdvanced() {
        return true;
    }

    private int getNextSlotEmptyOrMatching(LazyOptional<IItemHandler> cap, ItemStack stackInPedestal) {
        IItemHandler handler;
        AtomicInteger slot = new AtomicInteger(-1);
        if (cap.isPresent() && (handler = (IItemHandler)cap.orElse(null)) != null) {
            int range = handler.getSlots();
            for (int i = 0; i < range; ++i) {
                ItemStack stackInSlot = handler.getStackInSlot(i);
                int maxSizeSlot = handler.getSlotLimit(i);
                if (maxSizeSlot <= 0 || stackInSlot.func_77976_d() <= 1) continue;
                if (this.doItemsMatch(stackInSlot, stackInPedestal) && stackInSlot.func_190916_E() < handler.getSlotLimit(i)) {
                    slot.set(i);
                    break;
                }
                if (stackInSlot.func_190926_b()) {
                    slot.set(i);
                    break;
                }
                if (i != range) continue;
                slot.set(i);
            }
        }
        return slot.get();
    }

    @Override
    public void updateAction(World world, PedestalTileEntity pedestal) {
        if (!world.field_72995_K) {
            ItemStack coinInPedestal = pedestal.getCoinOnPedestal();
            ItemStack itemInPedestal = pedestal.getItemInPedestal();
            BlockPos pedestalPos = pedestal.func_174877_v();
            int speed = this.getOperationSpeed(coinInPedestal);
            if (!pedestal.isPedestalBlockPowered(world, pedestalPos) && world.func_82737_E() % (long)speed == 0L) {
                this.upgradeAction(world, pedestalPos, coinInPedestal);
            }
        }
    }

    public void upgradeAction(World world, BlockPos posOfPedestal, ItemStack coinInPedestal) {
        TileEntity invToPushTo;
        BlockPos posInventory = this.getPosOfBlockBelow(world, posOfPedestal, 1);
        int upgradeTransferRate = this.getItemTransferRate(coinInPedestal);
        ItemStack itemFromPedestal = ItemStack.field_190927_a;
        LazyOptional<IItemHandler> cap = ItemUpgradeExport.findItemHandlerAtPos(world, posInventory, this.getPedestalFacing(world, posOfPedestal), true);
        if (this.hasAdvancedInventoryTargeting(coinInPedestal)) {
            cap = ItemUpgradeExport.findItemHandlerAtPosAdvanced(world, posInventory, this.getPedestalFacing(world, posOfPedestal), true);
        }
        if ((invToPushTo = world.func_175625_s(posInventory)) instanceof PedestalTileEntity) {
            itemFromPedestal = ItemStack.field_190927_a;
        } else {
            itemFromPedestal = this.getStackInPedestal(world, posOfPedestal);
            if (!itemFromPedestal.func_190926_b() && !itemFromPedestal.equals(ItemStack.field_190927_a) && cap.isPresent()) {
                IItemHandler handler = (IItemHandler)cap.orElse(null);
                int i = this.getNextSlotEmptyOrMatching(cap, itemFromPedestal);
                if (handler != null && i >= 0 && handler.isItemValid(i, itemFromPedestal)) {
                    itemFromPedestal = this.getStackInPedestal(world, posOfPedestal).func_77946_l();
                    ItemStack itemFromInventory = handler.getStackInSlot(i);
                    int spaceInInventoryStack = handler.getSlotLimit(i) - itemFromInventory.func_190916_E();
                    int allowedTransferRate = upgradeTransferRate;
                    if (handler.getSlotLimit(i) <= allowedTransferRate) {
                        allowedTransferRate = handler.getSlotLimit(i);
                    }
                    if (allowedTransferRate > spaceInInventoryStack) {
                        allowedTransferRate = spaceInInventoryStack;
                    }
                    if (allowedTransferRate > itemFromPedestal.func_190916_E()) {
                        allowedTransferRate = itemFromPedestal.func_190916_E();
                    }
                    itemFromPedestal.func_190920_e(allowedTransferRate);
                    if (ItemHandlerHelper.insertItem((IItemHandler)handler, (ItemStack)itemFromPedestal, (boolean)true).equals(ItemStack.field_190927_a)) {
                        this.removeFromPedestal(world, posOfPedestal, allowedTransferRate);
                        ItemHandlerHelper.insertItem((IItemHandler)handler, (ItemStack)itemFromPedestal, (boolean)false);
                    }
                }
            }
        }
    }

    @Override
    public void chatDetails(PlayerEntity player, PedestalTileEntity pedestal) {
        ItemStack stack = pedestal.getCoinOnPedestal();
        TranslationTextComponent name = new TranslationTextComponent(this.func_77658_a() + ".tooltip_name");
        name.func_240699_a_(TextFormatting.GOLD);
        player.func_145747_a((ITextComponent)name, Util.field_240973_b_);
        TranslationTextComponent rate = new TranslationTextComponent(this.func_77658_a() + ".chat_rate");
        rate.func_240702_b_("" + this.getItemTransferRate(stack) + "");
        rate.func_240699_a_(TextFormatting.GRAY);
        player.func_145747_a((ITextComponent)rate, Util.field_240973_b_);
        TranslationTextComponent speed = new TranslationTextComponent(this.func_77658_a() + ".chat_speed");
        speed.func_240702_b_(this.getOperationSpeedString(stack));
        speed.func_240699_a_(TextFormatting.RED);
        player.func_145747_a((ITextComponent)speed, Util.field_240973_b_);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        TranslationTextComponent rate = new TranslationTextComponent(this.func_77658_a() + ".tooltip_rate");
        rate.func_240702_b_("" + this.getItemTransferRate(stack) + "");
        TranslationTextComponent speed = new TranslationTextComponent(this.func_77658_a() + ".tooltip_speed");
        speed.func_240702_b_(this.getOperationSpeedString(stack));
        rate.func_240699_a_(TextFormatting.GRAY);
        speed.func_240699_a_(TextFormatting.RED);
        tooltip.add((ITextComponent)rate);
        tooltip.add((ITextComponent)speed);
    }

    @SubscribeEvent
    public static void onItemRegistryReady(RegistryEvent.Register<Item> event) {
        event.getRegistry().register((IForgeRegistryEntry)EXPORT);
    }
}

