/*
 * Decompiled with CFR 0.152.
 */
package com.mowmaster.pedestals.item.pedestalUpgrades;

import com.mowmaster.pedestals.item.pedestalUpgrades.ItemUpgradeBaseExp;
import com.mowmaster.pedestals.pedestals;
import com.mowmaster.pedestals.tiles.PedestalTileEntity;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class ItemUpgradeExpTank
extends ItemUpgradeBaseExp {
    public static final Item XPTANK = (Item)new ItemUpgradeExpTank(new Item.Properties().func_200917_a(64).func_200916_a(pedestals.PEDESTALS_TAB)).setRegistryName(new ResourceLocation("pedestals", "coin/xptank"));

    public ItemUpgradeExpTank(Item.Properties builder) {
        super(builder.func_200916_a(pedestals.PEDESTALS_TAB));
    }

    @Override
    public boolean canAcceptCapacity() {
        return true;
    }

    @Override
    public int getExpBuffer(ItemStack stack) {
        int capacityOver = this.getCapacityModifierOverEnchanted(stack);
        int overEnchanted = capacityOver * 5 + 20000;
        switch (capacityOver) {
            case 0: {
                return 100;
            }
            case 1: {
                return 250;
            }
            case 2: {
                return 500;
            }
            case 3: {
                return 750;
            }
            case 4: {
                return 1000;
            }
            case 5: {
                return 1250;
            }
            case 6: {
                return 1500;
            }
            case 7: {
                return 1750;
            }
            case 8: {
                return 2000;
            }
            case 9: {
                return 3000;
            }
            case 10: {
                return 4000;
            }
            case 11: {
                return 5000;
            }
            case 12: {
                return 6000;
            }
            case 13: {
                return 7000;
            }
            case 14: {
                return 8000;
            }
            case 15: {
                return 9000;
            }
            case 16: {
                return 10000;
            }
            case 17: {
                return 12500;
            }
            case 18: {
                return 15000;
            }
            case 19: {
                return 17500;
            }
            case 20: {
                return 20000;
            }
        }
        return overEnchanted > 21800 ? 21800 : overEnchanted;
    }

    @Override
    public void updateAction(World world, PedestalTileEntity pedestal) {
        if (!world.field_72995_K) {
            ItemStack coinInPedestal = pedestal.getCoinOnPedestal();
            ItemStack itemInPedestal = pedestal.getItemInPedestal();
            BlockPos pedestalPos = pedestal.func_174877_v();
            if (!pedestal.isPedestalBlockPowered(world, pedestalPos)) {
                int getMaxXpValue = this.getExpCountByLevel(this.getExpBuffer(coinInPedestal));
                if (!this.hasMaxXpSet(coinInPedestal) || this.readMaxXpFromNBT(coinInPedestal) != getMaxXpValue) {
                    this.setMaxXP(coinInPedestal, getMaxXpValue);
                }
                this.upgradeActionSendExp(pedestal);
            }
        }
    }

    @Override
    public void chatDetails(PlayerEntity player, PedestalTileEntity pedestal) {
        ItemStack stack = pedestal.getCoinOnPedestal();
        TranslationTextComponent name = new TranslationTextComponent(this.func_77658_a() + ".tooltip_name");
        name.func_240699_a_(TextFormatting.GOLD);
        player.func_145747_a((ITextComponent)name, Util.field_240973_b_);
        TranslationTextComponent xpstored = new TranslationTextComponent(this.func_77658_a() + ".chat_xp");
        xpstored.func_240702_b_("" + this.getExpLevelFromCount(this.getXPStored(stack)) + "");
        xpstored.func_240699_a_(TextFormatting.GREEN);
        player.func_145747_a((ITextComponent)xpstored, Util.field_240973_b_);
        TranslationTextComponent rate = new TranslationTextComponent(this.func_77658_a() + ".chat_rate");
        rate.func_240702_b_(this.getExpTransferRateString(stack));
        rate.func_240699_a_(TextFormatting.GRAY);
        player.func_145747_a((ITextComponent)rate, Util.field_240973_b_);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        TranslationTextComponent rate = new TranslationTextComponent(this.func_77658_a() + ".tooltip_rate");
        rate.func_240702_b_(this.getExpTransferRateString(stack));
        rate.func_240699_a_(TextFormatting.GRAY);
        tooltip.add((ITextComponent)rate);
    }

    @SubscribeEvent
    public static void onItemRegistryReady(RegistryEvent.Register<Item> event) {
        event.getRegistry().register((IForgeRegistryEntry)XPTANK);
    }
}

