/*
 * Decompiled with CFR 0.152.
 */
package com.mowmaster.pedestals.item.pedestalUpgrades;

import com.google.common.collect.Maps;
import com.mowmaster.pedestals.enchants.EnchantmentArea;
import com.mowmaster.pedestals.enchants.EnchantmentCapacity;
import com.mowmaster.pedestals.enchants.EnchantmentOperationSpeed;
import com.mowmaster.pedestals.enchants.EnchantmentRange;
import com.mowmaster.pedestals.item.pedestalUpgrades.ItemUpgradeBaseExp;
import com.mowmaster.pedestals.pedestals;
import com.mowmaster.pedestals.tiles.PedestalTileEntity;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.EnchantedBookItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class ItemUpgradeExpGrindstone
extends ItemUpgradeBaseExp {
    public static final Item XPGRINDSTONE = (Item)new ItemUpgradeExpGrindstone(new Item.Properties().func_200917_a(64).func_200916_a(pedestals.PEDESTALS_TAB)).setRegistryName(new ResourceLocation("pedestals", "coin/xpgrindstone"));

    public ItemUpgradeExpGrindstone(Item.Properties builder) {
        super(builder.func_200916_a(pedestals.PEDESTALS_TAB));
    }

    @Override
    public boolean canAcceptCapacity() {
        return true;
    }

    @Override
    public boolean canAcceptAdvanced() {
        return true;
    }

    @Override
    public void updateAction(World world, PedestalTileEntity pedestal) {
        if (!world.field_72995_K) {
            ItemStack coinInPedestal = pedestal.getCoinOnPedestal();
            ItemStack itemInPedestal = pedestal.getItemInPedestal();
            BlockPos pedestalPos = pedestal.func_174877_v();
            int getMaxXpValue = this.getExpCountByLevel(this.getExpBuffer(coinInPedestal));
            if (!this.hasMaxXpSet(coinInPedestal) || this.readMaxXpFromNBT(coinInPedestal) != getMaxXpValue) {
                this.setMaxXP(coinInPedestal, getMaxXpValue);
            }
            this.upgradeActionSendExp(pedestal);
            int speed = this.getOperationSpeed(coinInPedestal);
            if (!pedestal.isPedestalBlockPowered(world, pedestalPos) && world.func_82737_E() % (long)speed == 0L && itemInPedestal.func_190926_b()) {
                this.grindstoneAction(pedestal);
            }
        }
    }

    public int getItemsExpDisenchantAmount(ItemStack stack) {
        int exp = 0;
        Map map = EnchantmentHelper.func_82781_a((ItemStack)stack);
        for (Map.Entry entry : map.entrySet()) {
            Enchantment enchantment = (Enchantment)entry.getKey();
            Integer integer = (Integer)entry.getValue();
            exp += enchantment.func_77321_a(integer.intValue());
        }
        return exp * stack.func_190916_E();
    }

    public void grindstoneAction(PedestalTileEntity pedestal) {
        World world = pedestal.func_145831_w();
        ItemStack coinInPedestal = pedestal.getCoinOnPedestal();
        BlockPos posOfPedestal = pedestal.func_174877_v();
        BlockPos posInventory = this.getPosOfBlockBelow(world, posOfPedestal, 1);
        ItemStack itemFromInv = ItemStack.field_190927_a;
        LazyOptional<IItemHandler> cap = ItemUpgradeExpGrindstone.findItemHandlerAtPos(world, posInventory, this.getPedestalFacing(world, posOfPedestal), true);
        if (this.hasAdvancedInventoryTargeting(coinInPedestal)) {
            cap = ItemUpgradeExpGrindstone.findItemHandlerAtPosAdvanced(world, posInventory, this.getPedestalFacing(world, posOfPedestal), true);
        }
        if (!this.isInventoryEmpty(cap) && cap.isPresent()) {
            IItemHandler handler = (IItemHandler)cap.orElse(null);
            TileEntity invToPullFrom = world.func_175625_s(posInventory);
            if (!(this.hasAdvancedInventoryTargeting(coinInPedestal) && invToPullFrom instanceof PedestalTileEntity || !(invToPullFrom instanceof PedestalTileEntity))) {
                itemFromInv = ItemStack.field_190927_a;
            } else if (handler != null) {
                ItemStack toReturn;
                int i = this.getNextSlotWithEnchantedItem(pedestal, cap, this.getStackInPedestal(world, posOfPedestal));
                if (i >= 0) {
                    int xpDisenchant;
                    int currentlyStoredExp;
                    itemFromInv = handler.getStackInSlot(i);
                    int maxXp = this.readMaxXpFromNBT(coinInPedestal);
                    if (maxXp - (currentlyStoredExp = this.getXPStored(coinInPedestal)) >= (xpDisenchant = this.getItemsExpDisenchantAmount(itemFromInv))) {
                        LinkedHashMap enchantsNone = Maps.newLinkedHashMap();
                        ItemStack stackToReturn = itemFromInv.func_77973_b() instanceof EnchantedBookItem ? new ItemStack((IItemProvider)Items.field_151122_aG, 1) : itemFromInv.func_77946_l();
                        EnchantmentHelper.func_82782_a((Map)enchantsNone, (ItemStack)stackToReturn);
                        if (!stackToReturn.func_190926_b()) {
                            int getExpLeftInPedestal = currentlyStoredExp + xpDisenchant;
                            this.setXPStored(coinInPedestal, getExpLeftInPedestal);
                            ItemStack toReturn2 = stackToReturn.func_77946_l();
                            if (!handler.extractItem(i, toReturn2.func_190916_E(), true).func_190926_b()) {
                                handler.extractItem(i, toReturn2.func_190916_E(), false);
                                if (!pedestal.hasMuffler()) {
                                    world.func_184148_a((PlayerEntity)null, (double)posOfPedestal.func_177958_n(), (double)posOfPedestal.func_177956_o(), (double)posOfPedestal.func_177952_p(), SoundEvents.field_219642_eu, SoundCategory.BLOCKS, 0.25f, 1.0f);
                                }
                                pedestal.addItem(toReturn2);
                            }
                        }
                    }
                } else if (i >= 0 && !handler.extractItem(i, (toReturn = (itemFromInv = handler.getStackInSlot(i)).func_77946_l()).func_190916_E(), true).func_190926_b()) {
                    handler.extractItem(i, toReturn.func_190916_E(), false);
                    pedestal.addItemOverride(toReturn);
                }
            }
        }
    }

    public int getNextSlotWithEnchantedItem(PedestalTileEntity pedestal, LazyOptional<IItemHandler> cap, ItemStack stackInPedestal) {
        AtomicInteger slot = new AtomicInteger(-1);
        if (cap.isPresent()) {
            cap.ifPresent(itemHandler -> {
                int range = itemHandler.getSlots();
                for (int i = 0; i < range; ++i) {
                    ItemStack stackInSlot = itemHandler.getStackInSlot(i);
                    if (stackInSlot.func_190926_b() || !stackInSlot.func_77948_v() && !(stackInSlot.func_77973_b() instanceof EnchantedBookItem) || pedestal.canAcceptItems(pedestal.func_145831_w(), pedestal.func_174877_v(), stackInSlot) <= 0 || itemHandler.extractItem(i, 1, true).equals(ItemStack.field_190927_a)) continue;
                    if (stackInPedestal.func_190926_b()) {
                        slot.set(i);
                        break;
                    }
                    if (!this.doItemsMatch(stackInPedestal, stackInSlot)) continue;
                    slot.set(i);
                    break;
                }
            });
        }
        return slot.get();
    }

    @Override
    public int getExpBuffer(ItemStack stack) {
        int capacityOver = this.getCapacityModifierOverEnchanted(stack);
        int overEnchanted = capacityOver * 5 + 30;
        return overEnchanted >= this.maxLVLStored ? this.maxLVLStored : overEnchanted;
    }

    @Override
    public void chatDetails(PlayerEntity player, PedestalTileEntity pedestal) {
        ItemStack stack = pedestal.getCoinOnPedestal();
        TranslationTextComponent name = new TranslationTextComponent(this.func_77658_a() + ".tooltip_name");
        name.func_240699_a_(TextFormatting.GOLD);
        player.func_145747_a((ITextComponent)name, Util.field_240973_b_);
        TranslationTextComponent xpstored = new TranslationTextComponent(this.func_77658_a() + ".chat_xp");
        xpstored.func_240702_b_("" + this.getExpLevelFromCount(this.getXPStored(stack)) + "");
        xpstored.func_240699_a_(TextFormatting.GREEN);
        player.func_145747_a((ITextComponent)xpstored, Util.field_240973_b_);
        TranslationTextComponent rate = new TranslationTextComponent(this.func_77658_a() + ".chat_rate");
        rate.func_240702_b_(this.getExpTransferRateString(stack));
        rate.func_240699_a_(TextFormatting.GRAY);
        player.func_145747_a((ITextComponent)rate, Util.field_240973_b_);
        Map map = EnchantmentHelper.func_82781_a((ItemStack)stack);
        if (map.size() > 0 && this.getNumNonPedestalEnchants(map) > 0) {
            TranslationTextComponent enchant = new TranslationTextComponent(this.func_77658_a() + ".chat_enchants");
            enchant.func_240699_a_(TextFormatting.LIGHT_PURPLE);
            player.func_145747_a((ITextComponent)enchant, Util.field_240973_b_);
            for (Map.Entry entry : map.entrySet()) {
                Enchantment enchantment = (Enchantment)entry.getKey();
                Integer integer = (Integer)entry.getValue();
                if (enchantment instanceof EnchantmentCapacity || enchantment instanceof EnchantmentRange || enchantment instanceof EnchantmentOperationSpeed || enchantment instanceof EnchantmentArea) continue;
                TranslationTextComponent enchants = new TranslationTextComponent(" - " + enchantment.func_200305_d(integer.intValue()).getString());
                enchants.func_240699_a_(TextFormatting.GRAY);
                player.func_145747_a((ITextComponent)enchants, Util.field_240973_b_);
            }
        }
        TranslationTextComponent speed = new TranslationTextComponent(this.func_77658_a() + ".chat_speed");
        speed.func_240702_b_(this.getOperationSpeedString(stack));
        speed.func_240699_a_(TextFormatting.RED);
        player.func_145747_a((ITextComponent)speed, Util.field_240973_b_);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        TranslationTextComponent rate = new TranslationTextComponent(this.func_77658_a() + ".tooltip_rate");
        rate.func_240702_b_(this.getExpTransferRateString(stack));
        rate.func_240699_a_(TextFormatting.GRAY);
        tooltip.add((ITextComponent)rate);
        TranslationTextComponent speed = new TranslationTextComponent(this.func_77658_a() + ".tooltip_speed");
        speed.func_240702_b_(this.getOperationSpeedString(stack));
        speed.func_240699_a_(TextFormatting.RED);
        tooltip.add((ITextComponent)speed);
    }

    @SubscribeEvent
    public static void onItemRegistryReady(RegistryEvent.Register<Item> event) {
        event.getRegistry().register((IForgeRegistryEntry)XPGRINDSTONE);
    }
}

