/*
 * Decompiled with CFR 0.152.
 */
package com.mowmaster.pedestals.item.pedestalUpgrades;

import com.mowmaster.pedestals.enchants.EnchantmentRegistry;
import com.mowmaster.pedestals.item.pedestalUpgrades.ItemUpgradeBaseExp;
import com.mowmaster.pedestals.pedestals;
import com.mowmaster.pedestals.tiles.PedestalTileEntity;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ExperienceOrbEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.Util;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class ItemUpgradeExpCollector
extends ItemUpgradeBaseExp {
    public static final Item XPMAGNET = (Item)new ItemUpgradeExpCollector(new Item.Properties().func_200917_a(64).func_200916_a(pedestals.PEDESTALS_TAB)).setRegistryName(new ResourceLocation("pedestals", "coin/xpmagnet"));

    public ItemUpgradeExpCollector(Item.Properties builder) {
        super(builder.func_200916_a(pedestals.PEDESTALS_TAB));
    }

    @Override
    public boolean canAcceptCapacity() {
        return true;
    }

    @Override
    public boolean canAcceptArea() {
        return true;
    }

    @Override
    public boolean canAcceptRange() {
        return true;
    }

    @Override
    public boolean canAcceptAdvanced() {
        return true;
    }

    public int getAreaWidth(ItemStack stack) {
        int areaWidth = 0;
        int aW = this.getAreaModifier(stack);
        areaWidth = aW + 1;
        return areaWidth;
    }

    @Override
    public int getRangeModifier(ItemStack stack) {
        int range = 0;
        if (this.hasEnchant(stack)) {
            range = EnchantmentHelper.func_77506_a((Enchantment)EnchantmentRegistry.RANGE, (ItemStack)stack);
        }
        return range;
    }

    public int getRangeHeight(ItemStack stack) {
        return this.getHeight(stack);
    }

    public int getHeight(ItemStack stack) {
        return this.getRangeTiny(stack);
    }

    @Override
    public int getWorkAreaX(World world, BlockPos pos, ItemStack coin) {
        return this.getAreaWidth(coin);
    }

    @Override
    public int[] getWorkAreaY(World world, BlockPos pos, ItemStack coin) {
        return new int[]{this.getRangeHeight(coin), 0};
    }

    @Override
    public int getWorkAreaZ(World world, BlockPos pos, ItemStack coin) {
        return this.getAreaWidth(coin);
    }

    public int getSuckiRate(ItemStack stack) {
        int capacityOver = this.getCapacityModifierOverEnchanted(stack);
        int overEnchanted = capacityOver * 5;
        int suckiRate = 1;
        switch (capacityOver) {
            case 0: {
                suckiRate = 1;
                break;
            }
            case 1: {
                suckiRate = 5;
                break;
            }
            case 2: {
                suckiRate = 10;
                break;
            }
            case 3: {
                suckiRate = 15;
                break;
            }
            case 4: {
                suckiRate = 20;
                break;
            }
            case 5: {
                suckiRate = 25;
                break;
            }
            default: {
                suckiRate = overEnchanted > this.maxLVLStored ? this.maxLVLStored : overEnchanted;
            }
        }
        return suckiRate;
    }

    @Override
    public void updateAction(World world, PedestalTileEntity pedestal) {
        if (!world.field_72995_K) {
            ItemStack coinInPedestal = pedestal.getCoinOnPedestal();
            ItemStack itemInPedestal = pedestal.getItemInPedestal();
            BlockPos pedestalPos = pedestal.func_174877_v();
            int speed = this.getOperationSpeed(coinInPedestal);
            if (!pedestal.isPedestalBlockPowered(world, pedestalPos)) {
                int getMaxXpValue = this.getExpCountByLevel(this.getExpBuffer(coinInPedestal));
                if (!this.hasMaxXpSet(coinInPedestal)) {
                    this.setMaxXP(coinInPedestal, getMaxXpValue);
                }
                this.upgradeActionSendExp(pedestal);
                if (world.func_82737_E() % (long)speed == 0L && this.spaceForXP(coinInPedestal) > 0) {
                    this.upgradeAction(pedestal, world, coinInPedestal, pedestalPos);
                }
            }
        }
    }

    public void upgradeAction(PedestalTileEntity pedestal, World world, ItemStack coinInPedestal, BlockPos posOfPedestal) {
        int width = this.getAreaWidth(coinInPedestal);
        int height = this.getRangeHeight(coinInPedestal);
        BlockPos negBlockPos = this.getNegRangePosEntity(world, posOfPedestal, width, height);
        BlockPos posBlockPos = this.getPosRangePosEntity(world, posOfPedestal, width, height);
        AxisAlignedBB getBox = new AxisAlignedBB(negBlockPos, posBlockPos);
        List xpList = world.func_217357_a(ExperienceOrbEntity.class, getBox);
        for (ExperienceOrbEntity getXPFromList : xpList) {
            TileEntity pedestalInv;
            if (!pedestal.hasMuffler()) {
                world.func_184148_a((PlayerEntity)null, (double)posOfPedestal.func_177958_n(), (double)posOfPedestal.func_177956_o(), (double)posOfPedestal.func_177952_p(), SoundEvents.field_187604_bf, SoundCategory.BLOCKS, 0.15f, 1.0f);
            }
            if ((pedestalInv = world.func_175625_s(posOfPedestal)) instanceof PedestalTileEntity) {
                int currentlyStoredExp = this.getXPStored(coinInPedestal);
                int value = getXPFromList.func_70526_d();
                if (value > 0 && currentlyStoredExp < this.readMaxXpFromNBT(coinInPedestal)) {
                    getXPFromList.field_70530_e = 0;
                    getXPFromList.func_70106_y();
                    this.setXPStored(coinInPedestal, currentlyStoredExp + value);
                }
            }
            if (this.hasAdvancedInventoryTargetingTwo(coinInPedestal)) continue;
            break;
        }
        int widthP = 0;
        int heightP = 1;
        BlockPos negBlockPosP = this.getNegRangePosEntity(world, posOfPedestal, widthP, heightP);
        BlockPos posBlockPosP = this.getPosRangePosEntity(world, posOfPedestal, widthP, heightP);
        AxisAlignedBB getBoxP = new AxisAlignedBB(negBlockPosP, posBlockPosP);
        List entityList = world.func_217357_a(Entity.class, getBoxP);
        for (Entity getFromList : entityList) {
            int transferRate;
            int value;
            int currentlyStoredExp;
            if (!(getFromList instanceof PlayerEntity)) continue;
            PlayerEntity getPlayer = (PlayerEntity)getFromList;
            ItemStack coin = pedestal.getCoinOnPedestal();
            if (getPlayer.func_213453_ef() || (currentlyStoredExp = this.getXPStored(coin)) >= this.readMaxXpFromNBT(coin) || (value = ItemUpgradeExpCollector.removeXp(getPlayer, transferRate = this.getExpCountByLevel(this.getSuckiRate(coin)))) <= 0) continue;
            if (!pedestal.hasMuffler()) {
                world.func_184148_a((PlayerEntity)null, (double)posOfPedestal.func_177958_n(), (double)posOfPedestal.func_177956_o(), (double)posOfPedestal.func_177952_p(), SoundEvents.field_187664_bz, SoundCategory.BLOCKS, 0.15f, 1.0f);
            }
            this.setXPStored(coin, currentlyStoredExp + value);
        }
    }

    @Override
    public void actionOnCollideWithBlock(World world, PedestalTileEntity tilePedestal, BlockPos posPedestal, BlockState state, Entity entityIn) {
        if (entityIn instanceof ExperienceOrbEntity) {
            int currentlyStoredExp;
            ItemStack coin = tilePedestal.getCoinOnPedestal();
            ExperienceOrbEntity getXPFromList = (ExperienceOrbEntity)entityIn;
            if (!tilePedestal.hasMuffler()) {
                world.func_184148_a((PlayerEntity)null, (double)posPedestal.func_177958_n(), (double)posPedestal.func_177956_o(), (double)posPedestal.func_177952_p(), SoundEvents.field_187604_bf, SoundCategory.BLOCKS, 0.15f, 1.0f);
            }
            if ((currentlyStoredExp = this.getXPStored(coin)) < this.readMaxXpFromNBT(coin)) {
                int value = getXPFromList.func_70526_d();
                getXPFromList.func_70106_y();
                this.setXPStored(coin, currentlyStoredExp + value);
                tilePedestal.update();
            }
        }
    }

    @Override
    public int getExpBuffer(ItemStack stack) {
        int capacityOver = this.getCapacityModifierOverEnchanted(stack);
        int overEnchanted = capacityOver * 5 + 30;
        return overEnchanted >= this.maxLVLStored ? this.maxLVLStored : overEnchanted;
    }

    @Override
    public void chatDetails(PlayerEntity player, PedestalTileEntity pedestal) {
        ItemStack stack = pedestal.getCoinOnPedestal();
        TranslationTextComponent name = new TranslationTextComponent(this.func_77658_a() + ".tooltip_name");
        name.func_240699_a_(TextFormatting.GOLD);
        player.func_145747_a((ITextComponent)name, Util.field_240973_b_);
        TranslationTextComponent xpstored = new TranslationTextComponent(this.func_77658_a() + ".chat_xp");
        xpstored.func_240702_b_("" + this.getExpLevelFromCount(this.getXPStored(stack)) + "");
        xpstored.func_240699_a_(TextFormatting.GREEN);
        player.func_145747_a((ITextComponent)xpstored, Util.field_240973_b_);
        int s3 = this.getAreaWidth(stack);
        String trr = "" + (s3 + s3 + 1) + "";
        String trrr = "" + this.getRangeHeight(stack) + "";
        TranslationTextComponent area = new TranslationTextComponent(this.func_77658_a() + ".chat_area");
        TranslationTextComponent areax = new TranslationTextComponent(this.func_77658_a() + ".chat_areax");
        area.func_240702_b_(trr);
        area.func_240702_b_(areax.getString());
        area.func_240702_b_(trrr);
        area.func_240702_b_(areax.getString());
        area.func_240702_b_(trr);
        area.func_240699_a_(TextFormatting.WHITE);
        player.func_145747_a((ITextComponent)area, Util.field_240973_b_);
        TranslationTextComponent rate = new TranslationTextComponent(this.func_77658_a() + ".chat_rate");
        rate.func_240702_b_(this.getExpTransferRateString(stack));
        rate.func_240699_a_(TextFormatting.GRAY);
        player.func_145747_a((ITextComponent)rate, Util.field_240973_b_);
        TranslationTextComponent speed = new TranslationTextComponent(this.func_77658_a() + ".chat_speed");
        speed.func_240702_b_(this.getOperationSpeedString(stack));
        speed.func_240699_a_(TextFormatting.RED);
        player.func_145747_a((ITextComponent)speed, Util.field_240973_b_);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        int s3 = this.getAreaWidth(stack);
        String trr = "" + (s3 + s3 + 1) + "";
        String trrr = "" + this.getRangeHeight(stack) + "";
        TranslationTextComponent area = new TranslationTextComponent(this.func_77658_a() + ".tooltip_area");
        TranslationTextComponent areax = new TranslationTextComponent(this.func_77658_a() + ".tooltip_areax");
        area.func_240702_b_(trr);
        area.func_240702_b_(areax.getString());
        area.func_240702_b_(trrr);
        area.func_240702_b_(areax.getString());
        area.func_240702_b_(trr);
        TranslationTextComponent speed = new TranslationTextComponent(this.func_77658_a() + ".tooltip_speed");
        speed.func_240702_b_(this.getOperationSpeedString(stack));
        area.func_240699_a_(TextFormatting.WHITE);
        TranslationTextComponent rate = new TranslationTextComponent(this.func_77658_a() + ".tooltip_rate");
        rate.func_240702_b_(this.getExpTransferRateString(stack));
        rate.func_240699_a_(TextFormatting.GRAY);
        speed.func_240699_a_(TextFormatting.RED);
        tooltip.add((ITextComponent)area);
        tooltip.add((ITextComponent)rate);
        tooltip.add((ITextComponent)speed);
    }

    @SubscribeEvent
    public static void onItemRegistryReady(RegistryEvent.Register<Item> event) {
        event.getRegistry().register((IForgeRegistryEntry)XPMAGNET);
    }
}

