/*
 * Decompiled with CFR 0.152.
 */
package com.mowmaster.pedestals.item.pedestalUpgrades;

import com.mowmaster.pedestals.enchants.EnchantmentArea;
import com.mowmaster.pedestals.enchants.EnchantmentCapacity;
import com.mowmaster.pedestals.enchants.EnchantmentOperationSpeed;
import com.mowmaster.pedestals.enchants.EnchantmentRange;
import com.mowmaster.pedestals.item.pedestalUpgrades.ItemUpgradeBase;
import com.mowmaster.pedestals.pedestals;
import com.mowmaster.pedestals.tiles.PedestalTileEntity;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.EnderChestInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class ItemUpgradeEnderFilteredExporter
extends ItemUpgradeBase {
    public static final Item ENDERFEXPORT = (Item)new ItemUpgradeEnderFilteredExporter(new Item.Properties().func_200917_a(64).func_200916_a(pedestals.PEDESTALS_TAB)).setRegistryName(new ResourceLocation("pedestals", "coin/enderfilteredexport"));

    public ItemUpgradeEnderFilteredExporter(Item.Properties builder) {
        super(builder.func_200916_a(pedestals.PEDESTALS_TAB));
    }

    @Override
    public boolean canAcceptAdvanced() {
        return super.canAcceptAdvanced();
    }

    @Override
    public void updateAction(World world, PedestalTileEntity pedestal) {
        if (!world.field_72995_K) {
            ItemStack coinInPedestal = pedestal.getCoinOnPedestal();
            ItemStack itemInPedestal = pedestal.getItemInPedestal();
            BlockPos pedestalPos = pedestal.func_174877_v();
            int speed = this.getOperationSpeed(coinInPedestal);
            if (!pedestal.isPedestalBlockPowered(world, pedestalPos) && world.func_82737_E() % (long)speed == 0L) {
                this.upgradeAction(pedestal, world, pedestalPos, itemInPedestal, coinInPedestal);
            }
        }
    }

    public void upgradeAction(PedestalTileEntity pedestal, World world, BlockPos posOfPedestal, ItemStack itemInPedestal, ItemStack coinInPedestal) {
        ServerWorld sworld = world.func_73046_m().func_71218_a(world.func_234923_W_());
        PlayerEntity player = sworld.func_217371_b(this.getPlayerFromCoin(coinInPedestal));
        if (player != null && itemInPedestal.func_190926_b()) {
            if (this.hasAdvancedInventoryTargeting(coinInPedestal)) {
                ItemStack toImport = ItemStack.field_190927_a;
                TileEntity senderPedestalCheck = world.func_175625_s(posOfPedestal);
                if (senderPedestalCheck instanceof PedestalTileEntity) {
                    int i;
                    PedestalTileEntity senderPedestal = (PedestalTileEntity)senderPedestalCheck;
                    List<BlockPos> getRecievers = senderPedestal.getLocationList();
                    if (getRecievers.size() > 0) {
                        AtomicInteger slot = new AtomicInteger(0);
                        while (slot.get() < getRecievers.size()) {
                            BlockPos receiverConnection = getRecievers.get(slot.get());
                            TileEntity pedestalRec = world.func_175625_s(receiverConnection);
                            if (pedestalRec instanceof PedestalTileEntity) {
                                PedestalTileEntity receiverPedestal = (PedestalTileEntity)pedestalRec;
                                if (receiverPedestal.hasFilter(senderPedestal)) {
                                    Item coinInPed = receiverPedestal.getCoinOnPedestal().func_77973_b();
                                    int range = player.field_71071_by.func_70302_i_();
                                    ItemStack itemInInv = ItemStack.field_190927_a;
                                    itemInInv = IntStream.range(0, range).mapToObj(arg_0 -> ((PlayerInventory)player.field_71071_by).func_70301_a(arg_0)).filter(itemStack -> !itemStack.func_190926_b()).filter(itemStack -> this.canAcceptItem(world, receiverConnection, (ItemStack)itemStack)).filter(itemStack -> this.canAcceptCount(world, receiverConnection, ((PedestalTileEntity)world.func_175625_s(receiverConnection)).getItemInPedestal(), (ItemStack)itemStack) > 0).filter(itemStack -> this.passesItemFilter(pedestal, (ItemStack)itemStack)).findFirst().orElse(ItemStack.field_190927_a);
                                    if (!itemInInv.func_190926_b()) {
                                        toImport = itemInInv.func_77946_l();
                                        break;
                                    }
                                } else {
                                    int range = player.field_71071_by.func_70302_i_();
                                    ItemStack itemInInv = ItemStack.field_190927_a;
                                    itemInInv = IntStream.range(0, range).mapToObj(arg_0 -> ((PlayerInventory)player.field_71071_by).func_70301_a(arg_0)).filter(itemStack -> !itemStack.func_190926_b()).filter(itemStack -> senderPedestal.canSendToPedestal(receiverConnection, (ItemStack)itemStack)).filter(itemStack -> this.passesItemFilter(pedestal, (ItemStack)itemStack)).findFirst().orElse(ItemStack.field_190927_a);
                                    if (!itemInInv.func_190926_b()) {
                                        toImport = itemInInv.func_77946_l();
                                        break;
                                    }
                                }
                            }
                            slot.set(slot.get() + 1);
                        }
                    }
                    if ((i = this.getPlayerSlotWithMatchingStackExact(player.field_71071_by, toImport)) >= 0) {
                        int maxStackSizeAllowedInPedestal = 0;
                        int roomLeftInPedestal = 0;
                        ItemStack senderBelowInvStack = player.field_71071_by.func_70301_a(i);
                        ItemStack itemFromPedestal = this.getStackInPedestal(world, posOfPedestal);
                        if (senderBelowInvStack != null && !senderBelowInvStack.func_190926_b() && senderBelowInvStack.func_77973_b() != Items.field_190931_a) {
                            int transferRate;
                            maxStackSizeAllowedInPedestal = itemFromPedestal.func_190926_b() || itemFromPedestal.equals(ItemStack.field_190927_a) ? 64 : itemFromPedestal.func_77976_d();
                            roomLeftInPedestal = maxStackSizeAllowedInPedestal - itemFromPedestal.func_190916_E();
                            int itemCountInInv = senderBelowInvStack.func_190916_E();
                            int allowedTransferRate = transferRate = 64;
                            if (roomLeftInPedestal < transferRate) {
                                allowedTransferRate = roomLeftInPedestal;
                            }
                            if (itemCountInInv < allowedTransferRate) {
                                allowedTransferRate = itemCountInInv;
                            }
                            ItemStack copyIncoming = senderBelowInvStack.func_77946_l();
                            copyIncoming.func_190920_e(allowedTransferRate);
                            this.addToPedestal(world, posOfPedestal, copyIncoming);
                            ItemStack stackToSetInEnder = senderBelowInvStack.func_77946_l();
                            stackToSetInEnder.func_190920_e(senderBelowInvStack.func_190916_E() - allowedTransferRate);
                            player.field_71071_by.func_70299_a(i, stackToSetInEnder);
                        }
                    }
                }
            } else {
                ItemStack toImport = ItemStack.field_190927_a;
                TileEntity senderPedestalCheck = world.func_175625_s(posOfPedestal);
                if (senderPedestalCheck instanceof PedestalTileEntity) {
                    int i;
                    PedestalTileEntity senderPedestal = (PedestalTileEntity)senderPedestalCheck;
                    List<BlockPos> getRecievers = senderPedestal.getLocationList();
                    if (getRecievers.size() > 0) {
                        AtomicInteger slot = new AtomicInteger(0);
                        while (slot.get() < getRecievers.size()) {
                            BlockPos receiverConnection = getRecievers.get(slot.get());
                            TileEntity pedestalRec = world.func_175625_s(receiverConnection);
                            if (pedestalRec instanceof PedestalTileEntity) {
                                PedestalTileEntity receiverPedestal = (PedestalTileEntity)pedestalRec;
                                if (receiverPedestal.hasFilter(senderPedestal)) {
                                    Item coinInPed = receiverPedestal.getCoinOnPedestal().func_77973_b();
                                    int range = player.func_71005_bN().func_70302_i_();
                                    ItemStack itemInInv = ItemStack.field_190927_a;
                                    itemInInv = IntStream.range(0, range).mapToObj(arg_0 -> ((EnderChestInventory)player.func_71005_bN()).func_70301_a(arg_0)).filter(itemStack -> !itemStack.func_190926_b()).filter(itemStack -> this.canAcceptItem(world, receiverConnection, (ItemStack)itemStack)).filter(itemStack -> this.canAcceptCount(world, receiverConnection, ((PedestalTileEntity)world.func_175625_s(receiverConnection)).getItemInPedestal(), (ItemStack)itemStack) > 0).filter(itemStack -> this.passesItemFilter(pedestal, (ItemStack)itemStack)).findFirst().orElse(ItemStack.field_190927_a);
                                    if (!itemInInv.func_190926_b()) {
                                        toImport = itemInInv.func_77946_l();
                                        break;
                                    }
                                } else {
                                    int range = player.func_71005_bN().func_70302_i_();
                                    ItemStack itemInInv = ItemStack.field_190927_a;
                                    itemInInv = IntStream.range(0, range).mapToObj(arg_0 -> ((EnderChestInventory)player.func_71005_bN()).func_70301_a(arg_0)).filter(itemStack -> !itemStack.func_190926_b()).filter(itemStack -> senderPedestal.canSendToPedestal(receiverConnection, (ItemStack)itemStack)).filter(itemStack -> this.passesItemFilter(pedestal, (ItemStack)itemStack)).findFirst().orElse(ItemStack.field_190927_a);
                                    if (!itemInInv.func_190926_b()) {
                                        toImport = itemInInv.func_77946_l();
                                        break;
                                    }
                                }
                            }
                            slot.set(slot.get() + 1);
                        }
                    }
                    if ((i = this.getEnderChestSlotWithMatchingStackExact(player.func_71005_bN(), toImport)) >= 0) {
                        int maxStackSizeAllowedInPedestal = 0;
                        int roomLeftInPedestal = 0;
                        ItemStack senderBelowInvStack = player.func_71005_bN().func_70301_a(i);
                        ItemStack itemFromPedestal = this.getStackInPedestal(world, posOfPedestal);
                        if (senderBelowInvStack != null && !senderBelowInvStack.func_190926_b() && senderBelowInvStack.func_77973_b() != Items.field_190931_a) {
                            int transferRate;
                            maxStackSizeAllowedInPedestal = itemFromPedestal.func_190926_b() || itemFromPedestal.equals(ItemStack.field_190927_a) ? 64 : itemFromPedestal.func_77976_d();
                            roomLeftInPedestal = maxStackSizeAllowedInPedestal - itemFromPedestal.func_190916_E();
                            int itemCountInInv = senderBelowInvStack.func_190916_E();
                            int allowedTransferRate = transferRate = 64;
                            if (roomLeftInPedestal < transferRate) {
                                allowedTransferRate = roomLeftInPedestal;
                            }
                            if (itemCountInInv < allowedTransferRate) {
                                allowedTransferRate = itemCountInInv;
                            }
                            ItemStack copyIncoming = senderBelowInvStack.func_77946_l();
                            copyIncoming.func_190920_e(allowedTransferRate);
                            this.addToPedestal(world, posOfPedestal, copyIncoming);
                            ItemStack stackToSetInEnder = senderBelowInvStack.func_77946_l();
                            stackToSetInEnder.func_190920_e(senderBelowInvStack.func_190916_E() - allowedTransferRate);
                            player.func_71005_bN().func_70299_a(i, stackToSetInEnder);
                        }
                    }
                }
            }
        }
    }

    @Override
    public void chatDetails(PlayerEntity player, PedestalTileEntity pedestal) {
        ItemStack coin = pedestal.getCoinOnPedestal();
        TranslationTextComponent name = new TranslationTextComponent(this.func_77658_a() + ".tooltip_name");
        name.func_240699_a_(TextFormatting.GOLD);
        player.func_145747_a((ITextComponent)name, Util.field_240973_b_);
        Map map = EnchantmentHelper.func_82781_a((ItemStack)coin);
        if (map.size() > 0 && this.getNumNonPedestalEnchants(map) > 0) {
            TranslationTextComponent enchant = new TranslationTextComponent(this.func_77658_a() + ".chat_enchants");
            enchant.func_240699_a_(TextFormatting.LIGHT_PURPLE);
            player.func_145747_a((ITextComponent)enchant, Util.field_240973_b_);
            for (Map.Entry entry : map.entrySet()) {
                Enchantment enchantment = (Enchantment)entry.getKey();
                Integer integer = (Integer)entry.getValue();
                if (enchantment instanceof EnchantmentCapacity || enchantment instanceof EnchantmentRange || enchantment instanceof EnchantmentOperationSpeed || enchantment instanceof EnchantmentArea) continue;
                TranslationTextComponent enchants = new TranslationTextComponent(" - " + enchantment.func_200305_d(integer.intValue()).getString());
                enchants.func_240699_a_(TextFormatting.GRAY);
                player.func_145747_a((ITextComponent)enchants, Util.field_240973_b_);
            }
        }
        TranslationTextComponent speed = new TranslationTextComponent(this.func_77658_a() + ".chat_speed");
        speed.func_240702_b_(this.getOperationSpeedString(coin));
        speed.func_240699_a_(TextFormatting.RED);
        player.func_145747_a((ITextComponent)speed, Util.field_240973_b_);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        TranslationTextComponent speed = new TranslationTextComponent(this.func_77658_a() + ".tooltip_speed");
        speed.func_240702_b_(this.getOperationSpeedString(stack));
        speed.func_240699_a_(TextFormatting.RED);
        tooltip.add((ITextComponent)speed);
    }

    @SubscribeEvent
    public static void onItemRegistryReady(RegistryEvent.Register<Item> event) {
        event.getRegistry().register((IForgeRegistryEntry)ENDERFEXPORT);
    }
}

