/*
 * Decompiled with CFR 0.152.
 */
package com.mowmaster.pedestals.item.pedestalUpgrades;

import com.mowmaster.pedestals.enchants.EnchantmentArea;
import com.mowmaster.pedestals.enchants.EnchantmentCapacity;
import com.mowmaster.pedestals.enchants.EnchantmentOperationSpeed;
import com.mowmaster.pedestals.enchants.EnchantmentRange;
import com.mowmaster.pedestals.item.pedestalUpgrades.ItemUpgradeBase;
import com.mowmaster.pedestals.pedestals;
import com.mowmaster.pedestals.tiles.PedestalTileEntity;
import java.util.List;
import java.util.Map;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.EnderChestInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class ItemUpgradeEnderExporter
extends ItemUpgradeBase {
    public static final Item ENDEREXPORT = (Item)new ItemUpgradeEnderExporter(new Item.Properties().func_200917_a(64).func_200916_a(pedestals.PEDESTALS_TAB)).setRegistryName(new ResourceLocation("pedestals", "coin/enderexport"));

    public ItemUpgradeEnderExporter(Item.Properties builder) {
        super(builder.func_200916_a(pedestals.PEDESTALS_TAB));
    }

    @Override
    public boolean canAcceptAdvanced() {
        return super.canAcceptAdvanced();
    }

    @Override
    public void updateAction(World world, PedestalTileEntity pedestal) {
        if (!world.field_72995_K) {
            ItemStack coinInPedestal = pedestal.getCoinOnPedestal();
            ItemStack itemInPedestal = pedestal.getItemInPedestal();
            BlockPos pedestalPos = pedestal.func_174877_v();
            int speed = this.getOperationSpeed(coinInPedestal);
            if (!pedestal.isPedestalBlockPowered(world, pedestalPos) && world.func_82737_E() % (long)speed == 0L) {
                this.upgradeAction(pedestal, world, pedestalPos, itemInPedestal, coinInPedestal);
            }
        }
    }

    public void upgradeAction(PedestalTileEntity pedestal, World world, BlockPos posOfPedestal, ItemStack itemInPedestal, ItemStack coinInPedestal) {
        ServerWorld sworld = world.func_73046_m().func_71218_a(world.func_234923_W_());
        PlayerEntity player = sworld.func_217371_b(this.getPlayerFromCoin(coinInPedestal));
        if (player != null && itemInPedestal.func_190926_b()) {
            if (this.hasAdvancedInventoryTargeting(coinInPedestal)) {
                ItemStack itemInPlayer = ItemStack.field_190927_a;
                itemInPlayer = IntStream.range(0, player.field_71071_by.func_70302_i_()).mapToObj(arg_0 -> ((PlayerInventory)player.field_71071_by).func_70301_a(arg_0)).filter(itemStack -> !itemStack.func_190926_b()).filter(itemStack -> this.passesItemFilter(pedestal, (ItemStack)itemStack)).findFirst().orElse(ItemStack.field_190927_a);
                if (!itemInPlayer.func_190926_b()) {
                    this.addToPedestal(world, posOfPedestal, itemInPlayer);
                    int getSlot = this.getPlayerSlotWithMatchingStackExact(player.field_71071_by, itemInPlayer);
                    player.field_71071_by.func_70304_b(getSlot);
                }
            } else {
                ItemStack itemInEnderChest = ItemStack.field_190927_a;
                itemInEnderChest = IntStream.range(0, player.func_71005_bN().func_70302_i_()).mapToObj(arg_0 -> ((EnderChestInventory)player.func_71005_bN()).func_70301_a(arg_0)).filter(itemStack -> !itemStack.func_190926_b()).filter(itemStack -> this.passesItemFilter(pedestal, (ItemStack)itemStack)).findFirst().orElse(ItemStack.field_190927_a);
                if (!itemInEnderChest.func_190926_b()) {
                    this.addToPedestal(world, posOfPedestal, itemInEnderChest);
                    int getSlot = this.getEnderChestSlotWithMatchingStackExact(player.func_71005_bN(), itemInEnderChest);
                    player.func_71005_bN().func_70304_b(getSlot);
                }
            }
        }
    }

    @Override
    public void chatDetails(PlayerEntity player, PedestalTileEntity pedestal) {
        ItemStack coin = pedestal.getCoinOnPedestal();
        TranslationTextComponent name = new TranslationTextComponent(this.func_77658_a() + ".tooltip_name");
        name.func_240699_a_(TextFormatting.GOLD);
        player.func_145747_a((ITextComponent)name, Util.field_240973_b_);
        Map map = EnchantmentHelper.func_82781_a((ItemStack)coin);
        if (map.size() > 0 && this.getNumNonPedestalEnchants(map) > 0) {
            TranslationTextComponent enchant = new TranslationTextComponent(this.func_77658_a() + ".chat_enchants");
            enchant.func_240699_a_(TextFormatting.LIGHT_PURPLE);
            player.func_145747_a((ITextComponent)enchant, Util.field_240973_b_);
            for (Map.Entry entry : map.entrySet()) {
                Enchantment enchantment = (Enchantment)entry.getKey();
                Integer integer = (Integer)entry.getValue();
                if (enchantment instanceof EnchantmentCapacity || enchantment instanceof EnchantmentRange || enchantment instanceof EnchantmentOperationSpeed || enchantment instanceof EnchantmentArea) continue;
                TranslationTextComponent enchants = new TranslationTextComponent(" - " + enchantment.func_200305_d(integer.intValue()).getString());
                enchants.func_240699_a_(TextFormatting.GRAY);
                player.func_145747_a((ITextComponent)enchants, Util.field_240973_b_);
            }
        }
        TranslationTextComponent speed = new TranslationTextComponent(this.func_77658_a() + ".chat_speed");
        speed.func_240702_b_(this.getOperationSpeedString(coin));
        speed.func_240699_a_(TextFormatting.RED);
        player.func_145747_a((ITextComponent)speed, Util.field_240973_b_);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        TranslationTextComponent speed = new TranslationTextComponent(this.func_77658_a() + ".tooltip_speed");
        speed.func_240702_b_(this.getOperationSpeedString(stack));
        speed.func_240699_a_(TextFormatting.RED);
        tooltip.add((ITextComponent)speed);
    }

    @SubscribeEvent
    public static void onItemRegistryReady(RegistryEvent.Register<Item> event) {
        event.getRegistry().register((IForgeRegistryEntry)ENDEREXPORT);
    }
}

