/*
 * Decompiled with CFR 0.152.
 */
package com.mowmaster.pedestals.item.pedestalUpgrades;

import com.mowmaster.pedestals.enchants.EnchantmentArea;
import com.mowmaster.pedestals.enchants.EnchantmentCapacity;
import com.mowmaster.pedestals.enchants.EnchantmentOperationSpeed;
import com.mowmaster.pedestals.enchants.EnchantmentRange;
import com.mowmaster.pedestals.enchants.EnchantmentRegistry;
import com.mowmaster.pedestals.item.pedestalUpgrades.ItemUpgradeBase;
import com.mowmaster.pedestals.network.PacketHandler;
import com.mowmaster.pedestals.network.PacketParticles;
import com.mowmaster.pedestals.pedestals;
import com.mowmaster.pedestals.tiles.PedestalTileEntity;
import com.mowmaster.pedestals.util.PedestalUtils;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.CropsBlock;
import net.minecraft.block.IGrowable;
import net.minecraft.block.KelpTopBlock;
import net.minecraft.block.StemBlock;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.ToolType;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class ItemUpgradeEffectHarvester
extends ItemUpgradeBase {
    public static final Item HARVESTER = (Item)new ItemUpgradeEffectHarvester(new Item.Properties().func_200917_a(64).func_200916_a(pedestals.PEDESTALS_TAB)).setRegistryName(new ResourceLocation("pedestals", "coin/harvester"));

    public ItemUpgradeEffectHarvester(Item.Properties builder) {
        super(builder.func_200916_a(pedestals.PEDESTALS_TAB));
    }

    @Override
    public boolean canAcceptArea() {
        return true;
    }

    @Override
    public boolean canAcceptRange() {
        return true;
    }

    @Override
    public boolean canAcceptMagnet() {
        return true;
    }

    @Override
    public boolean canAcceptAdvanced() {
        return true;
    }

    public int getAreaWidth(ItemStack stack) {
        int areaWidth = 0;
        int aW = this.getAreaModifier(stack);
        areaWidth = aW + 1;
        return areaWidth;
    }

    public int getHeight(ItemStack stack) {
        return this.getRangeTiny(stack);
    }

    @Override
    public int getWorkAreaX(World world, BlockPos pos, ItemStack coin) {
        return this.getAreaWidth(coin);
    }

    @Override
    public int[] getWorkAreaY(World world, BlockPos pos, ItemStack coin) {
        return new int[]{this.getHeight(coin), 0};
    }

    @Override
    public int getWorkAreaZ(World world, BlockPos pos, ItemStack coin) {
        return this.getAreaWidth(coin);
    }

    public static IntegerProperty getBlockPropertyAge(BlockState blockState) {
        for (Property prop : blockState.func_235904_r_()) {
            if (prop == null || prop.func_177701_a() == null || !(prop instanceof IntegerProperty) || !prop.func_177701_a().equalsIgnoreCase("age")) continue;
            return (IntegerProperty)prop;
        }
        return null;
    }

    public boolean canHarvest(World world, BlockState state) {
        boolean returner = false;
        IntegerProperty propInt = ItemUpgradeEffectHarvester.getBlockPropertyAge(state);
        if (propInt == null || !(world instanceof ServerWorld)) {
            returner = false;
        } else if (state.func_177230_c() instanceof KelpTopBlock) {
            returner = true;
        } else if (state.func_177230_c() instanceof StemBlock) {
            returner = false;
        } else {
            int current = (Integer)state.func_177229_b((Property)propInt);
            int min = (Integer)Collections.min(propInt.func_177700_c());
            int max = (Integer)Collections.max(propInt.func_177700_c());
            if (current == max) {
                returner = true;
            }
        }
        return returner;
    }

    @Override
    public int getComparatorRedstoneLevel(World worldIn, BlockPos pos) {
        int intItem = 0;
        TileEntity tileEntity = worldIn.func_175625_s(pos);
        if (tileEntity instanceof PedestalTileEntity) {
            PedestalTileEntity pedestal = (PedestalTileEntity)tileEntity;
            ItemStack coin = pedestal.getCoinOnPedestal();
            int amount = this.workQueueSize(coin);
            int area = this.workQueueTwoSize(coin);
            if (amount > 0) {
                float f = (float)amount / (float)area;
                intItem = MathHelper.func_76141_d((float)(f * 14.0f)) + 1;
            }
        }
        return intItem;
    }

    @Override
    public void updateAction(World world, PedestalTileEntity pedestal) {
        if (!world.field_72995_K) {
            ItemStack coinInPedestal = pedestal.getCoinOnPedestal();
            ItemStack itemInPedestal = pedestal.getItemInPedestal();
            BlockPos pedestalPos = pedestal.func_174877_v();
            if (!pedestal.isPedestalBlockPowered(world, pedestalPos)) {
                BlockPos posNums;
                int rangeWidth = this.getAreaWidth(coinInPedestal);
                int rangeHeight = this.getHeight(coinInPedestal);
                BlockState pedestalState = world.func_180495_p(pedestalPos);
                Direction enumfacing = pedestalState.func_235901_b_((Property)BlockStateProperties.field_208155_H) ? (Direction)pedestalState.func_177229_b((Property)BlockStateProperties.field_208155_H) : Direction.UP;
                BlockPos negNums = this.getNegRangePosEntity(world, pedestalPos, rangeWidth, enumfacing == Direction.NORTH || enumfacing == Direction.EAST || enumfacing == Direction.SOUTH || enumfacing == Direction.WEST ? rangeHeight - 1 : rangeHeight);
                if (world.func_175707_a(negNums, posNums = this.getPosRangePosEntity(world, pedestalPos, rangeWidth, enumfacing == Direction.NORTH || enumfacing == Direction.EAST || enumfacing == Direction.SOUTH || enumfacing == Direction.WEST ? rangeHeight - 1 : rangeHeight))) {
                    AxisAlignedBB getBox;
                    List itemList;
                    if (this.hasMagnetEnchant(coinInPedestal) && (itemList = world.func_217357_a(ItemEntity.class, getBox = new AxisAlignedBB(negNums, posNums))).size() > 0) {
                        List<ItemStack> stackCurrent = this.readFilterQueueFromNBT(coinInPedestal);
                        if (stackCurrent.size() <= 0) {
                            stackCurrent = this.buildFilterQueue(pedestal);
                            this.writeFilterQueueToNBT(coinInPedestal, stackCurrent);
                        }
                        this.upgradeActionMagnet(pedestal, world, itemList, itemInPedestal, pedestalPos);
                    }
                    int speed = this.getOperationSpeed(coinInPedestal);
                    int val = this.readStoredIntTwoFromNBT(coinInPedestal);
                    if (val > 0) {
                        if (world.func_82737_E() % 5L == 0L) {
                            BlockPos directionalPos = this.getPosOfBlockBelow(world, pedestalPos, 0);
                            if (!pedestal.hasParticleDiffuser()) {
                                PacketHandler.sendToNearby(world, pedestalPos, (Object)new PacketParticles(PacketParticles.EffectType.ANY_COLOR, directionalPos.func_177958_n(), (double)directionalPos.func_177956_o(), (double)directionalPos.func_177952_p(), 145, 145, 145));
                            }
                        }
                        this.writeStoredIntTwoToNBT(coinInPedestal, val - 1);
                    } else {
                        if (this.workQueueSize(coinInPedestal) <= 0) {
                            this.buildWorkQueue(pedestal, rangeWidth, rangeHeight);
                            this.buildWorkQueueTwo(pedestal, rangeWidth, rangeHeight);
                            if (itemInPedestal.func_190926_b()) {
                                pedestal.update();
                            }
                        }
                        if (this.workQueueSize(coinInPedestal) > 0) {
                            List<BlockPos> workQueue = this.readWorkQueueFromNBT(coinInPedestal);
                            if (world.func_82737_E() % (long)speed == 0L) {
                                for (int i = 0; i < workQueue.size(); ++i) {
                                    BlockPos targetPos = workQueue.get(i);
                                    BlockPos blockToMinePos = new BlockPos(targetPos.func_177958_n(), targetPos.func_177956_o(), targetPos.func_177952_p());
                                    BlockState targetBlock = world.func_180495_p(blockToMinePos);
                                    if (this.canMineBlock(pedestal, blockToMinePos)) {
                                        workQueue.remove(i);
                                        this.writeWorkQueueToNBT(coinInPedestal, workQueue);
                                        this.upgradeAction(pedestal, targetPos, targetBlock);
                                        if (this.hasAdvancedInventoryTargetingTwo(coinInPedestal)) continue;
                                        break;
                                    }
                                    workQueue.remove(i);
                                }
                                this.writeWorkQueueToNBT(coinInPedestal, workQueue);
                            }
                        } else {
                            int delay = rangeWidth * rangeWidth * rangeHeight;
                            this.writeStoredIntTwoToNBT(coinInPedestal, delay < 100 ? 100 : delay);
                        }
                    }
                }
            }
        }
    }

    public Item getSeed(World world, BlockState targetState, BlockPos targetPos) {
        CropsBlock crop;
        ItemStack getSeedDropped;
        Item seed = null;
        if (targetState.func_177230_c() instanceof CropsBlock && !(getSeedDropped = (crop = (CropsBlock)targetState.func_177230_c()).func_185473_a((IBlockReader)world, targetPos, targetState)).func_190926_b()) {
            seed = getSeedDropped.func_77973_b();
        }
        return seed;
    }

    public void upgradeAction(PedestalTileEntity pedestal, BlockPos posTarget, BlockState target) {
        FakePlayer fakePlayer;
        World world = pedestal.func_145831_w();
        ItemStack coinInPedestal = pedestal.getCoinOnPedestal();
        ItemStack toolInPedestal = pedestal.getToolOnPedestal();
        BlockPos posOfPedestal = pedestal.func_174877_v();
        if (this.canHarvest(world, target) && !target.func_177230_c().isAir(target, (IBlockReader)world, posTarget) && (fakePlayer = (FakePlayer)this.fakePedestalPlayer(pedestal).get()) != null) {
            ItemStack harvestingHoe;
            fakePlayer.func_174810_b(true);
            if (!fakePlayer.func_233580_cy_().equals((Object)new BlockPos(posOfPedestal.func_177958_n(), posOfPedestal.func_177956_o(), posOfPedestal.func_177952_p()))) {
                fakePlayer.func_70107_b((double)posOfPedestal.func_177958_n(), (double)posOfPedestal.func_177956_o(), (double)posOfPedestal.func_177952_p());
            }
            ItemStack itemStack = harvestingHoe = pedestal.hasTool() ? pedestal.getToolOnPedestal() : new ItemStack((IItemProvider)Items.field_151012_L, 1);
            if (!fakePlayer.func_184614_ca().equals(harvestingHoe)) {
                fakePlayer.func_184201_a(EquipmentSlotType.MAINHAND, harvestingHoe);
            }
            if (!pedestal.hasTool()) {
                harvestingHoe = this.getToolDefaultEnchanted(coinInPedestal, harvestingHoe);
            }
            ToolType tool = target.getHarvestTool();
            int toolLevel = fakePlayer.func_184614_ca().getHarvestLevel(tool, (PlayerEntity)fakePlayer, target);
            if (this.hasAdvancedInventoryTargeting(coinInPedestal)) {
                if (ForgeEventFactory.doPlayerHarvestCheck((PlayerEntity)fakePlayer, (BlockState)target, (boolean)true)) {
                    ServerWorld sworld = world.func_73046_m().func_71218_a(world.func_234923_W_());
                    Item targetSeed = this.getSeed(world, target, posTarget);
                    List targetDrops = Block.func_220070_a((BlockState)target, (ServerWorld)sworld, (BlockPos)posTarget, null);
                    IntegerProperty propInt = ItemUpgradeEffectHarvester.getBlockPropertyAge(target);
                    int min = (Integer)Collections.min(propInt.func_177700_c());
                    target.func_177230_c().func_176208_a(world, posTarget, target, (PlayerEntity)fakePlayer);
                    for (ItemStack itemStack2 : targetDrops) {
                        if (targetSeed != null && itemStack2.func_77973_b().equals(targetSeed)) {
                            itemStack2.func_190918_g(1);
                            targetSeed = null;
                        }
                        PedestalUtils.spawnItemStackInWorld(world, posTarget, itemStack2);
                    }
                    target.func_215706_a(sworld, posTarget, ItemStack.field_190927_a);
                    world.func_175656_a(posTarget, (BlockState)target.func_206870_a((Property)propInt, (Comparable)Integer.valueOf(min)));
                    if (!pedestal.hasParticleDiffuser()) {
                        PacketHandler.sendToNearby(world, posOfPedestal, (Object)new PacketParticles(PacketParticles.EffectType.ANY_COLOR, posTarget.func_177958_n(), (double)posTarget.func_177956_o(), (double)posTarget.func_177952_p(), 255, 164, 0));
                    }
                }
            } else if (ForgeEventFactory.doPlayerHarvestCheck((PlayerEntity)fakePlayer, (BlockState)target, (boolean)true)) {
                target.func_177230_c().func_180657_a(world, (PlayerEntity)fakePlayer, posTarget, target, null, fakePlayer.func_184614_ca());
                target.func_177230_c().func_176208_a(world, posTarget, target, (PlayerEntity)fakePlayer);
                if (!pedestal.hasParticleDiffuser()) {
                    PacketHandler.sendToNearby(world, posOfPedestal, (Object)new PacketParticles(PacketParticles.EffectType.ANY_COLOR, posTarget.func_177958_n(), (double)posTarget.func_177956_o(), (double)posTarget.func_177952_p(), 255, 164, 0));
                }
                world.func_217377_a(posTarget, false);
            }
        }
    }

    @Override
    public boolean canMineBlock(PedestalTileEntity pedestal, BlockPos blockToMinePos, PlayerEntity player) {
        World world = pedestal.func_145831_w();
        BlockPos targetPos = blockToMinePos;
        BlockPos blockToHarvestPos = new BlockPos(targetPos.func_177958_n(), targetPos.func_177956_o(), targetPos.func_177952_p());
        BlockState blockToHarvestState = world.func_180495_p(blockToHarvestPos);
        Block blockToHarvest = blockToHarvestState.func_177230_c();
        return this.canHarvest(world, blockToHarvestState) && !blockToHarvest.isAir(blockToHarvestState, (IBlockReader)world, blockToHarvestPos);
    }

    @Override
    public boolean canMineBlock(PedestalTileEntity pedestal, BlockPos blockToMinePos) {
        World world = pedestal.func_145831_w();
        BlockPos targetPos = blockToMinePos;
        BlockPos blockToHarvestPos = new BlockPos(targetPos.func_177958_n(), targetPos.func_177956_o(), targetPos.func_177952_p());
        BlockState blockToHarvestState = world.func_180495_p(blockToHarvestPos);
        Block blockToHarvest = blockToHarvestState.func_177230_c();
        return this.canHarvest(world, blockToHarvestState) && !blockToHarvest.isAir(blockToHarvestState, (IBlockReader)world, blockToHarvestPos);
    }

    @Override
    public boolean canMineBlockTwo(PedestalTileEntity pedestal, BlockPos blockToMinePos) {
        BlockPos targetPos;
        BlockPos blockToGrowPos;
        World world = pedestal.func_145831_w();
        BlockState blockToGrowState = world.func_180495_p(blockToGrowPos = new BlockPos((targetPos = blockToMinePos).func_177958_n(), targetPos.func_177956_o(), targetPos.func_177952_p()));
        Block blockToGrow = blockToGrowState.func_177230_c();
        return blockToGrow instanceof IGrowable || blockToGrow instanceof IPlantable;
    }

    @Override
    public void onPedestalNeighborChanged(PedestalTileEntity pedestal) {
        ItemStack coin = pedestal.getCoinOnPedestal();
        List<ItemStack> stackIn = this.buildFilterQueue(pedestal);
        if (this.filterQueueSize(coin) > 0) {
            List<ItemStack> stackCurrent = this.readFilterQueueFromNBT(coin);
            if (!this.doesFilterAndQueueMatch(stackIn, stackCurrent)) {
                this.writeFilterQueueToNBT(coin, stackIn);
            }
        } else {
            this.writeFilterQueueToNBT(coin, stackIn);
        }
    }

    @Override
    public ItemStack getFilterReturnStack(List<ItemStack> stack, ItemStack incoming) {
        int range = stack.size();
        ItemStack itemFromInv = ItemStack.field_190927_a;
        itemFromInv = IntStream.range(0, range).mapToObj(stack::get).filter(itemStack -> !itemStack.func_190926_b()).filter(itemStack -> itemStack.func_77973_b().equals(incoming.func_77973_b())).findFirst().orElse(ItemStack.field_190927_a);
        return itemFromInv;
    }

    @Override
    public void chatDetails(PlayerEntity player, PedestalTileEntity pedestal) {
        ItemStack stack = pedestal.getCoinOnPedestal();
        TranslationTextComponent name = new TranslationTextComponent(this.func_77658_a() + ".tooltip_name");
        name.func_240699_a_(TextFormatting.GOLD);
        player.func_145747_a((ITextComponent)name, Util.field_240973_b_);
        int s3 = this.getAreaWidth(stack);
        String tr = "" + (s3 + s3 + 1) + "";
        TranslationTextComponent area = new TranslationTextComponent(this.func_77658_a() + ".chat_area");
        TranslationTextComponent areax = new TranslationTextComponent(this.func_77658_a() + ".chat_areax");
        area.func_240702_b_(tr);
        area.func_240702_b_(areax.getString());
        area.func_240702_b_("" + this.getHeight(stack) + "");
        area.func_240702_b_(areax.getString());
        area.func_240702_b_(tr);
        area.func_240699_a_(TextFormatting.WHITE);
        player.func_145747_a((ITextComponent)area, Util.field_240973_b_);
        TranslationTextComponent btm = new TranslationTextComponent(this.func_77658_a() + ".chat_btm");
        btm.func_240702_b_("" + this.workQueueSize(stack) + "");
        btm.func_240699_a_(TextFormatting.YELLOW);
        player.func_145747_a((ITextComponent)btm, Util.field_240973_b_);
        ItemStack toolStack = pedestal.hasTool() ? pedestal.getToolOnPedestal() : new ItemStack((IItemProvider)Items.field_151012_L);
        TranslationTextComponent tool = new TranslationTextComponent(this.func_77658_a() + ".chat_tool");
        tool.func_230529_a_(toolStack.func_200301_q());
        tool.func_240699_a_(TextFormatting.BLUE);
        player.func_145747_a((ITextComponent)tool, Util.field_240973_b_);
        Map map = EnchantmentHelper.func_82781_a((ItemStack)(pedestal.hasTool() ? pedestal.getToolOnPedestal() : stack));
        if (this.hasAdvancedInventoryTargeting(stack)) {
            map.put(EnchantmentRegistry.ADVANCED, 1);
        }
        if (map.size() > 0 && this.getNumNonPedestalEnchants(map) > 0) {
            TranslationTextComponent enchant = new TranslationTextComponent(this.func_77658_a() + ".chat_enchants");
            enchant.func_240699_a_(TextFormatting.LIGHT_PURPLE);
            player.func_145747_a((ITextComponent)enchant, Util.field_240973_b_);
            for (Map.Entry entry : map.entrySet()) {
                Enchantment enchantment = (Enchantment)entry.getKey();
                Integer integer = (Integer)entry.getValue();
                if (enchantment instanceof EnchantmentCapacity || enchantment instanceof EnchantmentRange || enchantment instanceof EnchantmentOperationSpeed || enchantment instanceof EnchantmentArea) continue;
                TranslationTextComponent enchants = new TranslationTextComponent(" - " + enchantment.func_200305_d(integer.intValue()).getString());
                enchants.func_240699_a_(TextFormatting.GRAY);
                player.func_145747_a((ITextComponent)enchants, Util.field_240973_b_);
            }
        }
        TranslationTextComponent speed = new TranslationTextComponent(this.func_77658_a() + ".chat_speed");
        speed.func_240702_b_(this.getOperationSpeedString(stack));
        speed.func_240699_a_(TextFormatting.RED);
        player.func_145747_a((ITextComponent)speed, Util.field_240973_b_);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        int s3 = this.getAreaWidth(stack);
        String tr = "" + (s3 + s3 + 1) + "";
        TranslationTextComponent area = new TranslationTextComponent(this.func_77658_a() + ".tooltip_area");
        TranslationTextComponent areax = new TranslationTextComponent(this.func_77658_a() + ".tooltip_areax");
        area.func_240702_b_(tr);
        area.func_240702_b_(areax.getString());
        area.func_240702_b_("" + this.getHeight(stack) + "");
        area.func_240702_b_(areax.getString());
        area.func_240702_b_(tr);
        TranslationTextComponent speed = new TranslationTextComponent(this.func_77658_a() + ".tooltip_speed");
        speed.func_240702_b_(this.getOperationSpeedString(stack));
        area.func_240699_a_(TextFormatting.WHITE);
        speed.func_240699_a_(TextFormatting.RED);
        tooltip.add((ITextComponent)area);
        tooltip.add((ITextComponent)speed);
    }

    @SubscribeEvent
    public static void onItemRegistryReady(RegistryEvent.Register<Item> event) {
        event.getRegistry().register((IForgeRegistryEntry)HARVESTER);
    }
}

