/*
 * Decompiled with CFR 0.152.
 */
package com.mowmaster.pedestals.item.pedestalUpgrades;

import com.mowmaster.pedestals.item.pedestalUpgrades.ItemUpgradeBase;
import com.mowmaster.pedestals.pedestals;
import com.mowmaster.pedestals.tiles.PedestalTileEntity;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class ItemUpgradeDropper
extends ItemUpgradeBase {
    public static final Item DROPPER = (Item)new ItemUpgradeDropper(new Item.Properties().func_200917_a(64).func_200916_a(pedestals.PEDESTALS_TAB)).setRegistryName(new ResourceLocation("pedestals", "coin/dropper"));

    public ItemUpgradeDropper(Item.Properties builder) {
        super(builder.func_200916_a(pedestals.PEDESTALS_TAB));
    }

    @Override
    public boolean canAcceptRange() {
        return true;
    }

    @Override
    public boolean canAcceptCapacity() {
        return true;
    }

    @Override
    public int getWorkAreaX(World world, BlockPos pos, ItemStack coin) {
        int range = this.getRangeSmall(coin);
        return this.getPosOfBlockBelow(world, pos, -range).func_177958_n();
    }

    @Override
    public int[] getWorkAreaY(World world, BlockPos pos, ItemStack coin) {
        int range = this.getRangeSmall(coin);
        return new int[]{this.getPosOfBlockBelow(world, pos, -range).func_177956_o(), 1};
    }

    @Override
    public int getWorkAreaZ(World world, BlockPos pos, ItemStack coin) {
        int range = this.getRangeSmall(coin);
        return this.getPosOfBlockBelow(world, pos, -range).func_177952_p();
    }

    @Override
    public void updateAction(World world, PedestalTileEntity pedestal) {
        if (!world.field_72995_K) {
            ItemStack coinInPedestal = pedestal.getCoinOnPedestal();
            ItemStack itemInPedestal = pedestal.getItemInPedestal();
            BlockPos pedestalPos = pedestal.func_174877_v();
            int speed = this.getOperationSpeed(coinInPedestal);
            if (!pedestal.isPedestalBlockPowered(world, pedestalPos) && world.func_82737_E() % (long)speed == 0L) {
                this.upgradeAction(world, pedestalPos, itemInPedestal, coinInPedestal);
            }
        }
    }

    public void upgradeAction(World world, BlockPos posOfPedestal, ItemStack itemInPedestal, ItemStack coinOnPedestal) {
        int rate = this.getItemTransferRate(coinOnPedestal);
        int actualRate = itemInPedestal.func_190916_E() < rate ? itemInPedestal.func_190916_E() : rate;
        int range = this.getRangeSmall(coinOnPedestal);
        if (!this.getStackInPedestal(world, posOfPedestal).func_190926_b()) {
            ItemStack itemToSummon = this.getStackInPedestal(world, posOfPedestal).func_77946_l();
            itemToSummon.func_190920_e(actualRate);
            ItemEntity itemEntity = new ItemEntity(world, (double)this.getPosOfBlockBelow(world, posOfPedestal, -range).func_177958_n() + 0.5, (double)this.getPosOfBlockBelow(world, posOfPedestal, -range).func_177956_o(), (double)this.getPosOfBlockBelow(world, posOfPedestal, -range).func_177952_p() + 0.5, itemToSummon);
            itemEntity.func_213293_j(0.0, 0.0, 0.0);
            world.func_217376_c((Entity)itemEntity);
            this.removeFromPedestal(world, posOfPedestal, itemToSummon.func_190916_E());
        }
    }

    @Override
    public void chatDetails(PlayerEntity player, PedestalTileEntity pedestal) {
        ItemStack stack = pedestal.getCoinOnPedestal();
        TranslationTextComponent name = new TranslationTextComponent(this.func_77658_a() + ".tooltip_name");
        name.func_240699_a_(TextFormatting.GOLD);
        player.func_145747_a((ITextComponent)name, Util.field_240973_b_);
        TranslationTextComponent range = new TranslationTextComponent(this.func_77658_a() + ".chat_range");
        range.func_240702_b_("" + this.getRangeSmall(stack) + "");
        range.func_240699_a_(TextFormatting.WHITE);
        player.func_145747_a((ITextComponent)range, Util.field_240973_b_);
        TranslationTextComponent rate = new TranslationTextComponent(this.func_77658_a() + ".chat_rate");
        rate.func_240702_b_("" + this.getItemTransferRate(stack) + "");
        rate.func_240699_a_(TextFormatting.GRAY);
        player.func_145747_a((ITextComponent)rate, Util.field_240973_b_);
        TranslationTextComponent speed = new TranslationTextComponent(this.func_77658_a() + ".chat_speed");
        speed.func_240702_b_(this.getOperationSpeedString(stack));
        speed.func_240699_a_(TextFormatting.RED);
        player.func_145747_a((ITextComponent)speed, Util.field_240973_b_);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        TranslationTextComponent rate = new TranslationTextComponent(this.func_77658_a() + ".tooltip_rate");
        rate.func_240702_b_("" + this.getItemTransferRate(stack) + "");
        TranslationTextComponent range = new TranslationTextComponent(this.func_77658_a() + ".tooltip_range");
        range.func_240702_b_("" + this.getRangeSmall(stack) + "");
        TranslationTextComponent speed = new TranslationTextComponent(this.func_77658_a() + ".tooltip_speed");
        speed.func_240702_b_(this.getOperationSpeedString(stack));
        rate.func_240699_a_(TextFormatting.GRAY);
        range.func_240699_a_(TextFormatting.WHITE);
        speed.func_240699_a_(TextFormatting.RED);
        tooltip.add((ITextComponent)rate);
        tooltip.add((ITextComponent)range);
        tooltip.add((ITextComponent)speed);
    }

    @SubscribeEvent
    public static void onItemRegistryReady(RegistryEvent.Register<Item> event) {
        event.getRegistry().register((IForgeRegistryEntry)DROPPER);
    }
}

