/*
 * Decompiled with CFR 0.152.
 */
package com.mowmaster.pedestals.item.pedestalUpgrades;

import com.mowmaster.pedestals.item.pedestalUpgrades.ItemUpgradeBaseMachine;
import com.mowmaster.pedestals.pedestals;
import com.mowmaster.pedestals.recipes.CrusherRecipe;
import com.mowmaster.pedestals.recipes.CrusherRecipeAdvanced;
import com.mowmaster.pedestals.tiles.PedestalTileEntity;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Inventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class ItemUpgradeCrusher
extends ItemUpgradeBaseMachine {
    public static final Item CRUSHER = (Item)new ItemUpgradeCrusher(new Item.Properties().func_200917_a(64).func_200916_a(pedestals.PEDESTALS_TAB)).setRegistryName(new ResourceLocation("pedestals", "coin/crusher"));

    public ItemUpgradeCrusher(Item.Properties builder) {
        super(builder.func_200916_a(pedestals.PEDESTALS_TAB));
    }

    @Override
    public boolean canAcceptAdvanced() {
        return true;
    }

    @Nullable
    protected CrusherRecipeAdvanced getRecipeAdvanced(World world, ItemStack stackIn) {
        Inventory inv = new Inventory(new ItemStack[]{stackIn});
        return world == null ? null : (CrusherRecipeAdvanced)world.func_199532_z().func_215371_a(CrusherRecipeAdvanced.recipeType, (IInventory)inv, world).orElse(null);
    }

    protected Collection<ItemStack> getProcessResultsAdvanced(CrusherRecipeAdvanced recipe) {
        return recipe == null ? Arrays.asList(ItemStack.field_190927_a) : Collections.singleton(recipe.getResult());
    }

    @Nullable
    protected CrusherRecipe getRecipe(World world, ItemStack stackIn) {
        Inventory inv = new Inventory(new ItemStack[]{stackIn});
        return world == null ? null : (CrusherRecipe)world.func_199532_z().func_215371_a(CrusherRecipe.recipeType, (IInventory)inv, world).orElse(null);
    }

    protected Collection<ItemStack> getProcessResults(CrusherRecipe recipe) {
        return recipe == null ? Arrays.asList(ItemStack.field_190927_a) : Collections.singleton(recipe.getResult());
    }

    @Override
    public void updateAction(World world, PedestalTileEntity pedestal) {
        if (!world.field_72995_K) {
            ItemStack coinInPedestal = pedestal.getCoinOnPedestal();
            ItemStack itemInPedestal = pedestal.getItemInPedestal();
            BlockPos pedestalPos = pedestal.func_174877_v();
            int getMaxFuelValue = this.getFuelBuffer(coinInPedestal);
            if (!this.hasMaxFuelSet(coinInPedestal) || this.readMaxFuelFromNBT(coinInPedestal) != getMaxFuelValue) {
                this.setMaxFuel(coinInPedestal, getMaxFuelValue);
            }
            int speed = this.getSmeltingSpeed(coinInPedestal);
            if (!pedestal.isPedestalBlockPowered(world, pedestalPos) && world.func_82737_E() % (long)speed == 0L) {
                this.upgradeAction(pedestal, world, pedestalPos, coinInPedestal);
            }
        }
    }

    public void upgradeAction(PedestalTileEntity pedestal, World world, BlockPos posOfPedestal, ItemStack coinInPedestal) {
        boolean isAdvanced = this.hasAdvancedInventoryTargeting(coinInPedestal);
        BlockPos posInventory = this.getPosOfBlockBelow(world, posOfPedestal, 1);
        int itemsPerSmelt = this.getItemTransferRate(coinInPedestal);
        ItemStack itemFromInv = ItemStack.field_190927_a;
        LazyOptional<IItemHandler> cap = ItemUpgradeCrusher.findItemHandlerAtPos(world, posInventory, this.getPedestalFacing(world, posOfPedestal), true);
        if (isAdvanced) {
            cap = ItemUpgradeCrusher.findItemHandlerAtPosAdvanced(world, posInventory, this.getPedestalFacing(world, posOfPedestal), true);
        }
        if (!this.isInventoryEmpty(cap) && cap.isPresent()) {
            int i;
            IItemHandler handler = (IItemHandler)cap.orElse(null);
            TileEntity invToPullFrom = world.func_175625_s(posInventory);
            if (!(isAdvanced && invToPullFrom instanceof PedestalTileEntity || !(invToPullFrom instanceof PedestalTileEntity))) {
                itemFromInv = ItemStack.field_190927_a;
            } else if (handler != null && (i = this.getNextSlotWithItemsCapFiltered(pedestal, cap, this.getStackInPedestal(world, posOfPedestal))) >= 0) {
                ItemStack resultSmeltedAdvanced;
                int maxInSlot = handler.getSlotLimit(i);
                itemFromInv = handler.getStackInSlot(i);
                Collection<ItemStack> jsonResults = this.getProcessResults(this.getRecipe(world, itemFromInv));
                Collection<ItemStack> jsonResultsAdvanced = this.getProcessResultsAdvanced(this.getRecipeAdvanced(world, itemFromInv));
                ItemStack resultSmelted = jsonResults.iterator().next().func_190926_b() ? ItemStack.field_190927_a : jsonResults.iterator().next();
                ItemStack itemStack = resultSmeltedAdvanced = jsonResultsAdvanced.iterator().next().func_190926_b() ? ItemStack.field_190927_a : jsonResultsAdvanced.iterator().next();
                if (isAdvanced && !resultSmeltedAdvanced.equals(ItemStack.field_190927_a)) {
                    resultSmelted = resultSmeltedAdvanced;
                }
                ItemStack itemFromPedestal = this.getStackInPedestal(world, posOfPedestal);
                if (!resultSmelted.equals(ItemStack.field_190927_a)) {
                    if (handler.getStackInSlot(i) != null && !handler.getStackInSlot(i).func_190926_b() && handler.getStackInSlot(i).func_77973_b() != Items.field_190931_a) {
                        int itemInputsPerSmelt;
                        int itemsOutputWhenStackSmelted;
                        int roomLeftInPedestal = 64 - itemFromPedestal.func_190916_E();
                        if (itemFromPedestal.func_190926_b() || itemFromPedestal.equals(ItemStack.field_190927_a)) {
                            roomLeftInPedestal = 64;
                        }
                        if (roomLeftInPedestal < (itemsOutputWhenStackSmelted = (itemInputsPerSmelt = itemsPerSmelt) * resultSmelted.func_190916_E())) {
                            itemInputsPerSmelt = Math.floorDiv(roomLeftInPedestal, resultSmelted.func_190916_E());
                        }
                        if (itemFromInv.func_190916_E() < itemInputsPerSmelt) {
                            itemInputsPerSmelt = itemFromInv.func_190916_E();
                        }
                        itemsOutputWhenStackSmelted = itemInputsPerSmelt * resultSmelted.func_190916_E();
                        ItemStack copyIncoming = resultSmelted.func_77946_l();
                        copyIncoming.func_190920_e(itemsOutputWhenStackSmelted);
                        int fuelToConsume = 200 * itemInputsPerSmelt;
                        if (this.removeFuel(pedestal, fuelToConsume, true)) {
                            if (!handler.extractItem(i, itemInputsPerSmelt, true).func_190926_b()) {
                                handler.extractItem(i, itemInputsPerSmelt, false);
                                this.removeFuel(pedestal, fuelToConsume, false);
                                if (!pedestal.hasMuffler()) {
                                    world.func_184148_a((PlayerEntity)null, (double)posOfPedestal.func_177958_n(), (double)posOfPedestal.func_177956_o(), (double)posOfPedestal.func_177952_p(), SoundEvents.field_219642_eu, SoundCategory.BLOCKS, 0.25f, 1.0f);
                                }
                                pedestal.addItemOverride(copyIncoming);
                            }
                        } else {
                            int fuelLeft = this.getFuelStored(coinInPedestal);
                            if (fuelLeft > 0 && (itemInputsPerSmelt = Math.floorDiv(fuelLeft, 200)) >= 1) {
                                fuelToConsume = 200 * itemInputsPerSmelt;
                                itemsOutputWhenStackSmelted = itemInputsPerSmelt * resultSmelted.func_190916_E();
                                copyIncoming.func_190920_e(itemsOutputWhenStackSmelted);
                                if (!handler.extractItem(i, itemInputsPerSmelt, true).func_190926_b()) {
                                    handler.extractItem(i, itemInputsPerSmelt, false);
                                    this.removeFuel(pedestal, fuelToConsume, false);
                                    if (!pedestal.hasMuffler()) {
                                        world.func_184148_a((PlayerEntity)null, (double)posOfPedestal.func_177958_n(), (double)posOfPedestal.func_177956_o(), (double)posOfPedestal.func_177952_p(), SoundEvents.field_219642_eu, SoundCategory.BLOCKS, 0.25f, 1.0f);
                                    }
                                    pedestal.addItemOverride(copyIncoming);
                                }
                            }
                        }
                    }
                } else if (pedestal.getItemInPedestal().equals(ItemStack.field_190927_a)) {
                    ItemStack copyItemFromInv = itemFromInv.func_77946_l();
                    if (!handler.extractItem(i, itemFromInv.func_190916_E(), true).func_190926_b()) {
                        handler.extractItem(i, itemFromInv.func_190916_E(), false);
                        pedestal.addItemOverride(copyItemFromInv);
                    }
                }
            }
        }
    }

    @SubscribeEvent
    public static void onItemRegistryReady(RegistryEvent.Register<Item> event) {
        event.getRegistry().register((IForgeRegistryEntry)CRUSHER);
    }
}

