/*
 * Decompiled with CFR 0.152.
 */
package com.mowmaster.pedestals.item.pedestalUpgrades;

import com.mowmaster.pedestals.enchants.EnchantmentArea;
import com.mowmaster.pedestals.enchants.EnchantmentCapacity;
import com.mowmaster.pedestals.enchants.EnchantmentOperationSpeed;
import com.mowmaster.pedestals.enchants.EnchantmentRange;
import com.mowmaster.pedestals.item.pedestalUpgrades.ItemUpgradeBase;
import com.mowmaster.pedestals.pedestals;
import com.mowmaster.pedestals.recipes.CobbleGenRecipe;
import com.mowmaster.pedestals.recipes.CobbleGenSilkRecipe;
import com.mowmaster.pedestals.tiles.PedestalTileEntity;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Inventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class ItemUpgradeCobbleGen
extends ItemUpgradeBase {
    private int maxStored = 2000000000;
    public static final Item COBBLE = (Item)new ItemUpgradeCobbleGen(new Item.Properties().func_200917_a(64).func_200916_a(pedestals.PEDESTALS_TAB)).setRegistryName(new ResourceLocation("pedestals", "coin/cobble"));

    public ItemUpgradeCobbleGen(Item.Properties builder) {
        super(builder.func_200916_a(pedestals.PEDESTALS_TAB));
    }

    @Override
    public boolean canAcceptCapacity() {
        return true;
    }

    @Override
    public boolean canAcceptAdvanced() {
        return true;
    }

    @Override
    public int getComparatorRedstoneLevel(World worldIn, BlockPos pos) {
        int intItem = 0;
        TileEntity tileEntity = worldIn.func_175625_s(pos);
        if (tileEntity instanceof PedestalTileEntity) {
            PedestalTileEntity pedestal = (PedestalTileEntity)tileEntity;
            ItemStack coin = pedestal.getCoinOnPedestal();
            if (this.getCobbleStored(pedestal) > 0) {
                float f = (float)this.getCobbleStored(pedestal) / (float)this.maxCobbleStorage(pedestal);
                intItem = MathHelper.func_76141_d((float)(f * 14.0f)) + 1;
            }
        }
        return intItem;
    }

    public int getCobbleGenSpawnRate(ItemStack stack) {
        int intCobbleSpawned = this.getCapacityModifierOverEnchanted(stack) == 0 ? 1 : this.getCapacityModifierOverEnchanted(stack) * 8 + 24;
        switch (this.getCapacityModifierOverEnchanted(stack)) {
            case 0: {
                return 1;
            }
            case 1: {
                return 4;
            }
            case 2: {
                return 8;
            }
            case 3: {
                return 16;
            }
            case 4: {
                return 32;
            }
            case 5: {
                return 64;
            }
        }
        return intCobbleSpawned >= this.maxStored ? this.maxStored : intCobbleSpawned;
    }

    @Nullable
    protected CobbleGenRecipe getRecipeNormal(World world, ItemStack stackIn) {
        Inventory inv = new Inventory(new ItemStack[]{stackIn});
        return world == null ? null : (CobbleGenRecipe)world.func_199532_z().func_215371_a(CobbleGenRecipe.recipeType, (IInventory)inv, world).orElse(null);
    }

    @Nullable
    protected CobbleGenSilkRecipe getRecipeSilk(World world, ItemStack stackIn) {
        Inventory inv = new Inventory(new ItemStack[]{stackIn});
        return world == null ? null : (CobbleGenSilkRecipe)world.func_199532_z().func_215371_a(CobbleGenSilkRecipe.recipeType, (IInventory)inv, world).orElse(null);
    }

    protected Collection<ItemStack> getProcessResultsNormal(CobbleGenRecipe recipe) {
        return recipe == null ? Arrays.asList(ItemStack.field_190927_a) : Collections.singleton(recipe.getResult());
    }

    protected Collection<ItemStack> getProcessResultsSilk(CobbleGenSilkRecipe recipe) {
        return recipe == null ? Arrays.asList(ItemStack.field_190927_a) : Collections.singleton(recipe.getResult());
    }

    public Item getItemToSpawn(PedestalTileEntity pedestal) {
        Block filterBlock;
        ItemStack itemBlockBelow;
        Collection<ItemStack> jsonResults;
        World world = pedestal.func_145831_w();
        ItemStack coinInPedestal = pedestal.getCoinOnPedestal();
        if (!this.hasFilterBlock(coinInPedestal)) {
            this.writeFilterBlockToNBT(pedestal);
        }
        ItemStack resultSmelted = (jsonResults = this.getProcessResultsNormal(this.getRecipeNormal(world, itemBlockBelow = new ItemStack((IItemProvider)(filterBlock = this.readFilterBlockFromNBT(coinInPedestal)))))).iterator().next().func_190926_b() ? ItemStack.field_190927_a : jsonResults.iterator().next();
        Item getItem = resultSmelted.func_77973_b();
        if (resultSmelted.func_190926_b()) {
            getItem = new ItemStack((IItemProvider)Items.field_221585_m).func_77973_b();
        }
        if (this.hasSilk(pedestal)) {
            jsonResults = this.getProcessResultsSilk(this.getRecipeSilk(world, itemBlockBelow));
            resultSmelted = jsonResults.iterator().next().func_190926_b() ? ItemStack.field_190927_a : jsonResults.iterator().next();
            getItem = resultSmelted.func_77973_b();
            if (resultSmelted.func_190926_b()) {
                getItem = new ItemStack((IItemProvider)Items.field_221574_b).func_77973_b();
            }
        }
        return getItem;
    }

    private boolean hasSilk(PedestalTileEntity pedestal) {
        boolean returner = false;
        ItemStack coin = pedestal.getCoinOnPedestal();
        ItemStack tool = pedestal.getToolOnPedestal();
        if (EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185306_r, (ItemStack)coin) > 0 || EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185306_r, (ItemStack)tool) > 0) {
            returner = true;
        }
        return returner;
    }

    @Override
    public ItemStack customExtractItem(PedestalTileEntity pedestal, int amountOut, boolean simulate) {
        ItemStack stackInPed = pedestal.getItemInPedestalOverride();
        ItemStack itemStackToExtract = new ItemStack((IItemProvider)this.getItemToSpawn(pedestal));
        int cobbleToRemove = this.removeCobble(pedestal, amountOut, true);
        int stored = this.getCobbleStored(pedestal);
        if (stored <= 0) {
            return new ItemStack((IItemProvider)Items.field_221747_dJ);
        }
        if (cobbleToRemove == 0) {
            itemStackToExtract.func_190920_e(amountOut);
            if (!simulate) {
                this.removeCobble(pedestal, amountOut, false);
            }
            ItemStack toReturn = new ItemStack((IItemProvider)(stored > 0 ? itemStackToExtract.func_77973_b() : stackInPed.func_77973_b()), amountOut > itemStackToExtract.func_77976_d() ? itemStackToExtract.func_77976_d() : amountOut);
            return toReturn.func_190916_E() > 0 || toReturn.func_190926_b() ? toReturn : ItemStack.field_190927_a;
        }
        itemStackToExtract.func_190920_e(cobbleToRemove);
        if (!simulate) {
            this.removeCobble(pedestal, cobbleToRemove, false);
        }
        return itemStackToExtract;
    }

    @Override
    public ItemStack customInsertItem(PedestalTileEntity pedestal, ItemStack stackIn, boolean simulate) {
        if (stackIn.func_77973_b().equals(this.getItemToSpawn(pedestal))) {
            int cobbleToAdd = this.addCobble(pedestal, stackIn.func_190916_E(), true);
            if (this.availableCobbleStorageSpace(pedestal) > 0) {
                if (cobbleToAdd == 0) {
                    if (!simulate) {
                        this.addCobble(pedestal, stackIn.func_190916_E(), false);
                    }
                    return ItemStack.field_190927_a;
                }
                ItemStack copyStackIn = stackIn.func_77946_l();
                copyStackIn.func_190920_e(cobbleToAdd);
                if (!simulate) {
                    this.addCobble(pedestal, cobbleToAdd, false);
                }
                int currentIn = stackIn.func_190916_E();
                int diff = currentIn - cobbleToAdd;
                copyStackIn.func_190920_e(diff);
                return copyStackIn;
            }
        }
        return stackIn;
    }

    @Override
    public ItemStack customStackInSlot(PedestalTileEntity pedestal, ItemStack stackFromHandler) {
        if (!stackFromHandler.func_190926_b()) {
            Item getItem = this.getItemToSpawn(pedestal);
            ItemStack getItemStackInPedestal = pedestal.getItemInPedestalOverride();
            Item getItemInPedestal = getItemStackInPedestal.func_77973_b();
            int stored = this.getCobbleStored(pedestal);
            if (getItemInPedestal.equals(getItem) || getItemStackInPedestal.func_190926_b() && stored > 0) {
                if (stored > 0) {
                    int amount = this.getCobbleStored(pedestal) + getItemStackInPedestal.func_190916_E();
                    ItemStack getStack = new ItemStack((IItemProvider)getItem, amount);
                    return getStack;
                }
                return getItemStackInPedestal;
            }
            this.removeCobble(pedestal, stored, false);
            return getItemStackInPedestal;
        }
        return ItemStack.field_190927_a;
    }

    @Override
    public int customSlotLimit(PedestalTileEntity pedestal) {
        return this.maxCobbleStorage(pedestal);
    }

    public int addCobble(PedestalTileEntity pedestal, int amountIn, boolean simulate) {
        ItemStack coinInPedestal = pedestal.getCoinOnPedestal();
        int space = this.availableCobbleStorageSpace(pedestal);
        if (space >= amountIn) {
            if (!simulate) {
                int current = this.getCobbleStored(pedestal);
                this.writeStoredIntToNBT(coinInPedestal, current + amountIn);
            }
            return 0;
        }
        return space;
    }

    public int removeCobbleBuffer(PedestalTileEntity pedestal, int amountOut, boolean simulate) {
        ItemStack coinInPedestal = pedestal.getCoinOnPedestal();
        int current = this.getCobbleStored(pedestal);
        if (current - amountOut >= 0) {
            if (!simulate) {
                this.writeStoredIntToNBT(coinInPedestal, current - amountOut);
            }
            return 0;
        }
        return current;
    }

    public int removeCobble(PedestalTileEntity pedestal, int amountOut, boolean simulate) {
        ItemStack coinInPedestal = pedestal.getCoinOnPedestal();
        int current = this.getCobbleStored(pedestal);
        int currentActual = current + pedestal.getItemInPedestalOverride().func_190916_E();
        if (currentActual - amountOut >= 0) {
            if (!simulate) {
                if (current - amountOut >= 0) {
                    this.writeStoredIntToNBT(coinInPedestal, current - amountOut);
                } else {
                    int removeFromPedestal = amountOut - current;
                    this.writeStoredIntToNBT(coinInPedestal, 0);
                    pedestal.removeItemOverride(removeFromPedestal);
                }
            }
            return 0;
        }
        return current;
    }

    public int getCobbleStored(PedestalTileEntity pedestal) {
        return this.readStoredIntFromNBT(pedestal.getCoinOnPedestal());
    }

    public int maxCobbleStorage(PedestalTileEntity pedestal) {
        return this.maxStored;
    }

    public int availableCobbleStorageSpace(PedestalTileEntity pedestal) {
        return this.maxCobbleStorage(pedestal) - this.getCobbleStored(pedestal);
    }

    @Override
    public void updateAction(World world, PedestalTileEntity pedestal) {
        if (!world.field_72995_K) {
            ItemStack coinInPedestal = pedestal.getCoinOnPedestal();
            BlockPos pedestalPos = pedestal.func_174877_v();
            int speed = this.getOperationSpeed(coinInPedestal);
            if (!pedestal.isPedestalBlockPowered(world, pedestalPos)) {
                ItemStack stackInPed;
                if (world.func_82737_E() % 20L == 0L) {
                    int intSpawnRate = this.getCobbleGenSpawnRate(coinInPedestal);
                    int speedMultiplier = 20 / speed;
                    int addAmount = intSpawnRate * speedMultiplier;
                    if (this.availableCobbleStorageSpace(pedestal) > 0) {
                        int cobbleToAdd = this.addCobble(pedestal, addAmount, true);
                        if (cobbleToAdd == 0) {
                            this.addCobble(pedestal, addAmount, false);
                        } else {
                            this.addCobble(pedestal, cobbleToAdd, false);
                        }
                    }
                }
                if ((stackInPed = pedestal.getItemInPedestalOverride()).func_190916_E() < stackInPed.func_77976_d() && this.getCobbleStored(pedestal) > 0) {
                    this.fillPedestalAction(pedestal);
                }
            }
        }
    }

    public void fillPedestalAction(PedestalTileEntity pedestal) {
        ItemStack itemInPedestal = pedestal.getItemInPedestalOverride();
        int intSpace = this.intSpaceLeftInStack(itemInPedestal);
        int cobbleStored = this.getCobbleStored(pedestal);
        ItemStack stackSpawnedItem = new ItemStack((IItemProvider)this.getItemToSpawn(pedestal), intSpace);
        if (intSpace > 0 && cobbleStored > 0) {
            int cobbleToRemove = this.removeCobbleBuffer(pedestal, intSpace, true);
            if (cobbleToRemove == 0) {
                this.removeCobbleBuffer(pedestal, intSpace, false);
                pedestal.addItemOverride(stackSpawnedItem);
            } else {
                stackSpawnedItem.func_190920_e(cobbleToRemove);
                this.removeCobbleBuffer(pedestal, cobbleToRemove, false);
                pedestal.addItemOverride(stackSpawnedItem);
            }
        }
    }

    public void upgradeAction(World world, ItemStack itemInPedestal, ItemStack coinInPedestal, BlockPos pedestalPos) {
    }

    @Override
    public void actionOnCollideWithBlock(World world, PedestalTileEntity tilePedestal, BlockPos posPedestal, BlockState state, Entity entityIn) {
        if (entityIn instanceof ItemEntity) {
            ItemStack coin = tilePedestal.getCoinOnPedestal();
            ItemStack stackCollidedItem = ((ItemEntity)entityIn).func_92059_d();
            if (stackCollidedItem.func_77973_b().equals(this.getItemToSpawn(tilePedestal))) {
                int addAmount = stackCollidedItem.func_190916_E();
                if (this.availableCobbleStorageSpace(tilePedestal) > 0) {
                    int cobbleToAdd = this.addCobble(tilePedestal, addAmount, true);
                    if (cobbleToAdd == 0) {
                        this.addCobble(tilePedestal, addAmount, false);
                        ((ItemEntity)entityIn).func_70106_y();
                    } else {
                        int setEntityStackSize = addAmount - cobbleToAdd;
                        ItemStack stackCollidedItemCopy = stackCollidedItem.func_77946_l();
                        stackCollidedItemCopy.func_190920_e(setEntityStackSize);
                        ((ItemEntity)entityIn).func_92058_a(stackCollidedItemCopy);
                        this.addCobble(tilePedestal, cobbleToAdd, false);
                    }
                }
            }
        }
    }

    @Override
    public void onPedestalBelowNeighborChanged(PedestalTileEntity pedestal, BlockState blockChanged, BlockPos blockChangedPos) {
        BlockPos blockBelow = this.getPosOfBlockBelow(pedestal.func_145831_w(), pedestal.func_174877_v(), 1);
        if (blockBelow.equals((Object)blockChangedPos)) {
            this.writeFilterBlockToNBT(pedestal);
        }
    }

    @Override
    public void chatDetails(PlayerEntity player, PedestalTileEntity pedestal) {
        ItemStack stack = pedestal.getCoinOnPedestal();
        TranslationTextComponent name = new TranslationTextComponent(this.func_77658_a() + ".tooltip_name");
        name.func_240699_a_(TextFormatting.GOLD);
        player.func_145747_a((ITextComponent)name, Util.field_240973_b_);
        TranslationTextComponent rate = new TranslationTextComponent(this.func_77658_a() + ".chat_rate");
        rate.func_240702_b_("" + this.getItemTransferRate(stack) + "");
        rate.func_240699_a_(TextFormatting.GRAY);
        player.func_145747_a((ITextComponent)rate, Util.field_240973_b_);
        TranslationTextComponent stored = new TranslationTextComponent(this.func_77658_a() + ".chat_stored");
        stored.func_240702_b_("" + (this.getCobbleStored(pedestal) + pedestal.getItemInPedestalOverride().func_190916_E()) + "");
        stored.func_240699_a_(TextFormatting.GREEN);
        player.func_145747_a((ITextComponent)stored, Util.field_240973_b_);
        Map map = EnchantmentHelper.func_82781_a((ItemStack)stack);
        if (map.size() > 0 && this.getNumNonPedestalEnchants(map) > 0) {
            TranslationTextComponent enchant = new TranslationTextComponent(this.func_77658_a() + ".chat_enchants");
            enchant.func_240699_a_(TextFormatting.LIGHT_PURPLE);
            player.func_145747_a((ITextComponent)enchant, Util.field_240973_b_);
            for (Map.Entry entry : map.entrySet()) {
                Enchantment enchantment = (Enchantment)entry.getKey();
                Integer integer = (Integer)entry.getValue();
                if (enchantment instanceof EnchantmentCapacity || enchantment instanceof EnchantmentRange || enchantment instanceof EnchantmentOperationSpeed || enchantment instanceof EnchantmentArea) continue;
                TranslationTextComponent enchants = new TranslationTextComponent(" - " + enchantment.func_200305_d(integer.intValue()).getString());
                enchants.func_240699_a_(TextFormatting.GRAY);
                player.func_145747_a((ITextComponent)enchants, Util.field_240973_b_);
            }
        }
        TranslationTextComponent speed = new TranslationTextComponent(this.func_77658_a() + ".chat_speed");
        speed.func_240702_b_(this.getOperationSpeedString(stack));
        speed.func_240699_a_(TextFormatting.RED);
        player.func_145747_a((ITextComponent)speed, Util.field_240973_b_);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        TranslationTextComponent rate = new TranslationTextComponent(this.func_77658_a() + ".tooltip_rate");
        rate.func_240702_b_("" + this.getCobbleGenSpawnRate(stack) + "");
        TranslationTextComponent speed = new TranslationTextComponent(this.func_77658_a() + ".tooltip_speed");
        speed.func_240702_b_(this.getOperationSpeedString(stack));
        rate.func_240699_a_(TextFormatting.GRAY);
        tooltip.add((ITextComponent)rate);
        speed.func_240699_a_(TextFormatting.RED);
        tooltip.add((ITextComponent)speed);
    }

    @SubscribeEvent
    public static void onItemRegistryReady(RegistryEvent.Register<Item> event) {
        event.getRegistry().register((IForgeRegistryEntry)COBBLE);
    }
}

