/*
 * Decompiled with CFR 0.152.
 */
package com.mowmaster.pedestals.item.pedestalUpgrades;

import com.mowmaster.pedestals.api.filter.IFilterBase;
import com.mowmaster.pedestals.enchants.EnchantmentArea;
import com.mowmaster.pedestals.enchants.EnchantmentCapacity;
import com.mowmaster.pedestals.enchants.EnchantmentOperationSpeed;
import com.mowmaster.pedestals.enchants.EnchantmentRange;
import com.mowmaster.pedestals.item.pedestalUpgrades.ItemUpgradeBase;
import com.mowmaster.pedestals.network.PacketHandler;
import com.mowmaster.pedestals.network.PacketParticles;
import com.mowmaster.pedestals.pedestals;
import com.mowmaster.pedestals.tiles.PedestalTileEntity;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ToolType;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class ItemUpgradeChopperShrooms
extends ItemUpgradeBase {
    public static final Item CHOPPER = (Item)new ItemUpgradeChopperShrooms(new Item.Properties().func_200917_a(64).func_200916_a(pedestals.PEDESTALS_TAB)).setRegistryName(new ResourceLocation("pedestals", "coin/choppershrooms"));

    public ItemUpgradeChopperShrooms(Item.Properties builder) {
        super(builder.func_200916_a(pedestals.PEDESTALS_TAB));
    }

    @Override
    public boolean canAcceptRange() {
        return true;
    }

    @Override
    public boolean canAcceptArea() {
        return true;
    }

    @Override
    public boolean canAcceptMagnet() {
        return true;
    }

    public int getAreaWidth(ItemStack stack) {
        int areaWidth = 0;
        int aW = this.getAreaModifier(stack);
        areaWidth = aW + 2;
        return areaWidth;
    }

    public int getRangeHeight(ItemStack stack) {
        return this.getRangeTree(stack);
    }

    @Override
    public int getWorkAreaX(World world, BlockPos pos, ItemStack coin) {
        return this.getAreaWidth(coin);
    }

    @Override
    public int[] getWorkAreaY(World world, BlockPos pos, ItemStack coin) {
        return new int[]{this.getRangeHeight(coin), 0};
    }

    @Override
    public int getWorkAreaZ(World world, BlockPos pos, ItemStack coin) {
        return this.getAreaWidth(coin);
    }

    @Override
    public int getComparatorRedstoneLevel(World worldIn, BlockPos pos) {
        int intItem = 0;
        TileEntity tileEntity = worldIn.func_175625_s(pos);
        if (tileEntity instanceof PedestalTileEntity) {
            PedestalTileEntity pedestal = (PedestalTileEntity)tileEntity;
            ItemStack coin = pedestal.getCoinOnPedestal();
            int width = this.getAreaWidth(pedestal.getCoinOnPedestal());
            int widdth = width * 2 + 1;
            int height = this.getRangeHeight(pedestal.getCoinOnPedestal());
            int amount = this.workQueueSize(coin);
            int area = Math.multiplyExact(Math.multiplyExact(widdth, widdth), height);
            if (amount > 0) {
                float f = (float)amount / (float)area;
                intItem = MathHelper.func_76141_d((float)(f * 14.0f)) + 1;
            }
        }
        return intItem;
    }

    @Override
    public void updateAction(World world, PedestalTileEntity pedestal) {
        if (!world.field_72995_K) {
            ItemStack coinInPedestal = pedestal.getCoinOnPedestal();
            ItemStack itemInPedestal = pedestal.getItemInPedestal();
            BlockPos pedestalPos = pedestal.func_174877_v();
            if (!pedestal.isPedestalBlockPowered(world, pedestalPos)) {
                int val;
                BlockPos posNums;
                BlockState pedestalState;
                Direction enumfacing;
                BlockPos negNums;
                AxisAlignedBB getBox;
                List itemList;
                int rangeWidth = this.getAreaWidth(coinInPedestal);
                int rangeHeight = this.getRangeHeight(coinInPedestal);
                int speed = this.getOperationSpeed(coinInPedestal);
                if (this.hasMagnetEnchant(coinInPedestal) && (itemList = world.func_217357_a(ItemEntity.class, getBox = new AxisAlignedBB(negNums = this.getNegRangePosEntity(world, pedestalPos, rangeWidth, (enumfacing = (pedestalState = world.func_180495_p(pedestalPos)).func_235901_b_((Property)BlockStateProperties.field_208155_H) ? (Direction)pedestalState.func_177229_b((Property)BlockStateProperties.field_208155_H) : Direction.UP) == Direction.NORTH || enumfacing == Direction.EAST || enumfacing == Direction.SOUTH || enumfacing == Direction.WEST ? rangeHeight - 1 : rangeHeight), posNums = this.getPosRangePosEntity(world, pedestalPos, rangeWidth, enumfacing == Direction.NORTH || enumfacing == Direction.EAST || enumfacing == Direction.SOUTH || enumfacing == Direction.WEST ? rangeHeight - 1 : rangeHeight)))).size() > 0) {
                    this.upgradeActionMagnet(pedestal, world, itemList, itemInPedestal, pedestalPos);
                }
                if ((val = this.readStoredIntTwoFromNBT(coinInPedestal)) > 0) {
                    this.writeStoredIntTwoToNBT(coinInPedestal, val - 1);
                } else {
                    if (this.workQueueSize(coinInPedestal) <= 0) {
                        this.buildWorkQueue(pedestal, rangeWidth, rangeHeight);
                    }
                    if (this.workQueueSize(coinInPedestal) > 0) {
                        List<BlockPos> workQueue = this.readWorkQueueFromNBT(coinInPedestal);
                        if (world.func_82737_E() % (long)speed == 0L) {
                            for (int i = 0; i < workQueue.size(); ++i) {
                                BlockPos targetPos = workQueue.get(i);
                                BlockPos blockToMinePos = new BlockPos(targetPos.func_177958_n(), targetPos.func_177956_o(), targetPos.func_177952_p());
                                BlockState targetBlock = world.func_180495_p(blockToMinePos);
                                if (this.canMineBlock(pedestal, blockToMinePos)) {
                                    workQueue.remove(i);
                                    this.writeWorkQueueToNBT(coinInPedestal, workQueue);
                                    this.upgradeAction(pedestal, targetPos, targetBlock);
                                    if (this.hasAdvancedInventoryTargetingTwo(coinInPedestal)) continue;
                                    break;
                                }
                                workQueue.remove(i);
                            }
                            this.writeWorkQueueToNBT(coinInPedestal, workQueue);
                        }
                    } else {
                        this.writeStoredIntTwoToNBT(coinInPedestal, (rangeWidth * 2 + 1) * 20 + 20);
                    }
                }
            }
        }
    }

    public void upgradeAction(PedestalTileEntity pedestal, BlockPos blockToChopPos, BlockState blockToChop) {
        World world = pedestal.func_145831_w();
        ItemStack coinInPedestal = pedestal.getCoinOnPedestal();
        ItemStack toolInPedestal = pedestal.getToolOnPedestal();
        BlockPos posOfPedestal = pedestal.func_174877_v();
        FakePlayer fakePlayer = (FakePlayer)this.fakePedestalPlayer(pedestal).get();
        if (fakePlayer != null) {
            ItemStack choppingAxe;
            fakePlayer.func_174810_b(true);
            if (!fakePlayer.func_233580_cy_().equals((Object)new BlockPos(posOfPedestal.func_177958_n(), posOfPedestal.func_177956_o(), posOfPedestal.func_177952_p()))) {
                fakePlayer.func_70107_b((double)posOfPedestal.func_177958_n(), (double)posOfPedestal.func_177956_o(), (double)posOfPedestal.func_177952_p());
            }
            ItemStack itemStack = choppingAxe = pedestal.hasTool() ? pedestal.getToolOnPedestal() : new ItemStack((IItemProvider)Items.field_151056_x, 1);
            if (!pedestal.hasTool()) {
                choppingAxe = this.getToolDefaultEnchanted(coinInPedestal, choppingAxe);
            }
            if (!fakePlayer.func_184614_ca().equals(choppingAxe)) {
                fakePlayer.func_184201_a(EquipmentSlotType.MAINHAND, choppingAxe);
            }
            ToolType tool = blockToChop.getHarvestTool();
            int toolLevel = fakePlayer.func_184614_ca().getHarvestLevel(tool, (PlayerEntity)fakePlayer, blockToChop);
            ServerWorld sworld = world.func_73046_m().func_71218_a(world.func_234923_W_());
            if (ForgeEventFactory.doPlayerHarvestCheck((PlayerEntity)fakePlayer, (BlockState)blockToChop, (boolean)true)) {
                blockToChop.func_177230_c().func_180657_a(world, (PlayerEntity)fakePlayer, blockToChopPos, blockToChop, null, fakePlayer.func_184614_ca());
                blockToChop.func_177230_c().func_176208_a(world, blockToChopPos, blockToChop, (PlayerEntity)fakePlayer);
                int expdrop = blockToChop.func_177230_c().getExpDrop(blockToChop, (IWorldReader)world, blockToChopPos, EnchantmentHelper.func_82781_a((ItemStack)fakePlayer.func_184614_ca()).containsKey(Enchantments.field_185308_t) ? EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185308_t, (ItemStack)fakePlayer.func_184614_ca()) : 0, EnchantmentHelper.func_82781_a((ItemStack)fakePlayer.func_184614_ca()).containsKey(Enchantments.field_185306_r) ? EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185306_r, (ItemStack)fakePlayer.func_184614_ca()) : 0);
                if (expdrop > 0) {
                    blockToChop.func_177230_c().func_180637_b(sworld, posOfPedestal, expdrop);
                }
                if (!pedestal.hasParticleDiffuser()) {
                    PacketHandler.sendToNearby(world, posOfPedestal, (Object)new PacketParticles(PacketParticles.EffectType.ANY_COLOR, blockToChopPos.func_177958_n(), (double)blockToChopPos.func_177956_o(), (double)blockToChopPos.func_177952_p(), 255, 164, 0));
                }
                world.func_217377_a(blockToChopPos, false);
            }
        }
    }

    @Override
    public boolean canMineBlock(PedestalTileEntity pedestal, BlockPos blockToMinePos, PlayerEntity player) {
        World world = pedestal.func_145831_w();
        ItemStack toolInPedestal = pedestal.getToolOnPedestal();
        BlockState blockStateToChop = world.func_180495_p(blockToMinePos);
        Block blockToChop = blockStateToChop.func_177230_c();
        if (!blockToChop.isAir(blockStateToChop, (IBlockReader)world, blockToMinePos)) {
            ItemStack axe = pedestal.hasTool() ? toolInPedestal : new ItemStack((IItemProvider)Items.field_151056_x, 1);
            ToolType tool = blockStateToChop.getHarvestTool();
            int toolLevel = axe.getHarvestLevel(tool, null, blockStateToChop);
            if ((blockToChop.func_203417_a((ITag)BlockTags.field_232874_ao_) || blockToChop.func_203417_a((ITag)BlockTags.field_232889_z_) || blockToChop.func_203417_a((ITag)BlockTags.field_232888_y_) || blockToChop.equals(Blocks.field_235383_mw_) || blockToChop.equals(Blocks.field_196706_do) || blockToChop.equals(Blocks.field_150420_aW) || blockToChop.equals(Blocks.field_150419_aX)) && this.passesFilter(world, pedestal.func_174877_v(), blockToChop)) {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean canMineBlock(PedestalTileEntity pedestal, BlockPos blockToMinePos) {
        World world = pedestal.func_145831_w();
        ItemStack toolInPedestal = pedestal.getToolOnPedestal();
        BlockState blockStateToChop = world.func_180495_p(blockToMinePos);
        Block blockToChop = blockStateToChop.func_177230_c();
        if (!blockToChop.isAir(blockStateToChop, (IBlockReader)world, blockToMinePos)) {
            ItemStack axe = pedestal.hasTool() ? toolInPedestal : new ItemStack((IItemProvider)Items.field_151056_x, 1);
            ToolType tool = blockStateToChop.getHarvestTool();
            int toolLevel = axe.getHarvestLevel(tool, null, blockStateToChop);
            if ((blockToChop.func_203417_a((ITag)BlockTags.field_232874_ao_) || blockToChop.func_203417_a((ITag)BlockTags.field_232889_z_) || blockToChop.func_203417_a((ITag)BlockTags.field_232888_y_) || blockToChop.equals(Blocks.field_235383_mw_) || blockToChop.equals(Blocks.field_196706_do) || blockToChop.equals(Blocks.field_150420_aW) || blockToChop.equals(Blocks.field_150419_aX)) && this.passesFilter(world, pedestal.func_174877_v(), blockToChop)) {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean passesFilter(World world, BlockPos posPedestal, Block blockIn) {
        Item filterInPedestal;
        PedestalTileEntity pedestal;
        boolean returner = true;
        if (world.func_175625_s(posPedestal) instanceof PedestalTileEntity && (pedestal = (PedestalTileEntity)world.func_175625_s(posPedestal)).hasFilter() && (filterInPedestal = pedestal.getFilterInPedestal().func_77973_b()) instanceof IFilterBase) {
            returner = ((IFilterBase)filterInPedestal).canAcceptItem(pedestal, new ItemStack((IItemProvider)blockIn));
        }
        return returner;
    }

    @Override
    public void chatDetails(PlayerEntity player, PedestalTileEntity pedestal) {
        ItemStack stack = pedestal.getCoinOnPedestal();
        TranslationTextComponent name = new TranslationTextComponent(this.func_77658_a() + ".tooltip_name");
        name.func_240699_a_(TextFormatting.GOLD);
        player.func_145747_a((ITextComponent)name, Util.field_240973_b_);
        int s3 = this.getAreaWidth(stack);
        String tr = "" + (s3 + s3 + 1) + "";
        String trr = "" + (this.getRangeHeight(stack) + 1) + "";
        TranslationTextComponent area = new TranslationTextComponent(this.func_77658_a() + ".chat_area");
        TranslationTextComponent areax = new TranslationTextComponent(this.func_77658_a() + ".chat_areax");
        area.func_240702_b_(tr);
        area.func_240702_b_(areax.getString());
        area.func_240702_b_(trr);
        area.func_240702_b_(areax.getString());
        area.func_240702_b_(tr);
        area.func_240699_a_(TextFormatting.WHITE);
        player.func_145747_a((ITextComponent)area, Util.field_240973_b_);
        TranslationTextComponent btm = new TranslationTextComponent(this.func_77658_a() + ".chat_btm");
        btm.func_240702_b_("" + (this.workQueueSize(stack) > 0 ? this.workQueueSize(stack) : 0) + "");
        btm.func_240699_a_(TextFormatting.YELLOW);
        player.func_145747_a((ITextComponent)btm, Util.field_240973_b_);
        ItemStack toolStack = pedestal.hasTool() ? pedestal.getToolOnPedestal() : new ItemStack((IItemProvider)Items.field_151056_x);
        TranslationTextComponent tool = new TranslationTextComponent(this.func_77658_a() + ".chat_tool");
        tool.func_230529_a_(toolStack.func_200301_q());
        tool.func_240699_a_(TextFormatting.BLUE);
        player.func_145747_a((ITextComponent)tool, Util.field_240973_b_);
        Map map = EnchantmentHelper.func_82781_a((ItemStack)(pedestal.hasTool() ? pedestal.getToolOnPedestal() : stack));
        if (map.size() > 0 && this.getNumNonPedestalEnchants(map) > 0) {
            TranslationTextComponent enchant = new TranslationTextComponent(this.func_77658_a() + ".chat_enchants");
            enchant.func_240699_a_(TextFormatting.LIGHT_PURPLE);
            player.func_145747_a((ITextComponent)enchant, Util.field_240973_b_);
            for (Map.Entry entry : map.entrySet()) {
                Enchantment enchantment = (Enchantment)entry.getKey();
                Integer integer = (Integer)entry.getValue();
                if (enchantment instanceof EnchantmentCapacity || enchantment instanceof EnchantmentRange || enchantment instanceof EnchantmentOperationSpeed || enchantment instanceof EnchantmentArea) continue;
                TranslationTextComponent enchants = new TranslationTextComponent(" - " + enchantment.func_200305_d(integer.intValue()).getString());
                enchants.func_240699_a_(TextFormatting.GRAY);
                player.func_145747_a((ITextComponent)enchants, Util.field_240973_b_);
            }
        }
        TranslationTextComponent speed = new TranslationTextComponent(this.func_77658_a() + ".chat_speed");
        speed.func_240702_b_(this.getOperationSpeedString(stack));
        speed.func_240699_a_(TextFormatting.RED);
        player.func_145747_a((ITextComponent)speed, Util.field_240973_b_);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        int s3 = this.getAreaWidth(stack);
        int s4 = this.getRangeHeight(stack);
        String tr = "" + (s3 + s3 + 1) + "";
        String trr = "" + (s4 + 1) + "";
        TranslationTextComponent area = new TranslationTextComponent(this.func_77658_a() + ".tooltip_area");
        TranslationTextComponent areax = new TranslationTextComponent(this.func_77658_a() + ".tooltip_areax");
        area.func_240702_b_(tr);
        area.func_240702_b_(areax.getString());
        area.func_240702_b_(trr);
        area.func_240702_b_(areax.getString());
        area.func_240702_b_(tr);
        TranslationTextComponent speed = new TranslationTextComponent(this.func_77658_a() + ".tooltip_speed");
        speed.func_240702_b_(this.getOperationSpeedString(stack));
        area.func_240699_a_(TextFormatting.WHITE);
        tooltip.add((ITextComponent)area);
        speed.func_240699_a_(TextFormatting.RED);
        tooltip.add((ITextComponent)speed);
    }

    @SubscribeEvent
    public static void onItemRegistryReady(RegistryEvent.Register<Item> event) {
        event.getRegistry().register((IForgeRegistryEntry)CHOPPER);
    }
}

