/*
 * Decompiled with CFR 0.152.
 */
package com.mowmaster.pedestals.item.pedestalUpgrades;

import com.mowmaster.pedestals.api.filter.IFilterBase;
import com.mowmaster.pedestals.blocks.PedestalBlock;
import com.mowmaster.pedestals.enchants.EnchantmentArea;
import com.mowmaster.pedestals.enchants.EnchantmentCapacity;
import com.mowmaster.pedestals.enchants.EnchantmentOperationSpeed;
import com.mowmaster.pedestals.enchants.EnchantmentRange;
import com.mowmaster.pedestals.enchants.EnchantmentRegistry;
import com.mowmaster.pedestals.item.pedestalUpgrades.ItemUpgradeBase;
import com.mowmaster.pedestals.pedestals;
import com.mowmaster.pedestals.tiles.PedestalTileEntity;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.FlowingFluidBlock;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.ToolType;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fluids.IFluidBlock;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class ItemUpgradeBreaker
extends ItemUpgradeBase {
    public int range = 1;
    public static final Item BREAKER = (Item)new ItemUpgradeBreaker(new Item.Properties().func_200917_a(64).func_200916_a(pedestals.PEDESTALS_TAB)).setRegistryName(new ResourceLocation("pedestals", "coin/breaker"));

    public ItemUpgradeBreaker(Item.Properties builder) {
        super(builder.func_200916_a(pedestals.PEDESTALS_TAB));
    }

    @Override
    public boolean canAcceptRange() {
        return true;
    }

    @Override
    public boolean canAcceptAdvanced() {
        return true;
    }

    @Override
    public boolean canAcceptMagnet() {
        return true;
    }

    public int getRange(ItemStack stack) {
        return this.getRangeSmall(stack);
    }

    @Override
    public int getWorkAreaX(World world, BlockPos pos, ItemStack coin) {
        int range = this.getRange(coin);
        BlockPos posOfBlock = this.getPosOfBlockBelow(world, pos, range);
        return posOfBlock.func_177958_n();
    }

    @Override
    public int[] getWorkAreaY(World world, BlockPos pos, ItemStack coin) {
        int range = this.getRange(coin);
        BlockPos posOfBlock = this.getPosOfBlockBelow(world, pos, range);
        return new int[]{posOfBlock.func_177956_o(), 1};
    }

    @Override
    public int getWorkAreaZ(World world, BlockPos pos, ItemStack coin) {
        int range = this.getRange(coin);
        BlockPos posOfBlock = this.getPosOfBlockBelow(world, pos, range);
        return posOfBlock.func_177952_p();
    }

    @Override
    public void updateAction(World world, PedestalTileEntity pedestal) {
        if (!world.field_72995_K) {
            ItemStack coinInPedestal = pedestal.getCoinOnPedestal();
            ItemStack itemInPedestal = pedestal.getItemInPedestal();
            BlockPos pedestalPos = pedestal.func_174877_v();
            int speed = this.getOperationSpeed(coinInPedestal);
            if (!pedestal.isPedestalBlockPowered(world, pedestalPos)) {
                if (this.hasMagnetEnchant(coinInPedestal)) {
                    BlockPos posNums;
                    int range = this.getRange(coinInPedestal);
                    BlockState pedestalState = world.func_180495_p(pedestalPos);
                    Direction enumfacing = pedestalState.func_235901_b_((Property)BlockStateProperties.field_208155_H) ? (Direction)pedestalState.func_177229_b((Property)BlockStateProperties.field_208155_H) : Direction.UP;
                    BlockPos negNums = this.getNegRangePosEntity(world, pedestalPos, 1, enumfacing == Direction.NORTH || enumfacing == Direction.EAST || enumfacing == Direction.SOUTH || enumfacing == Direction.WEST ? -range - 1 : -range);
                    AxisAlignedBB getBox = new AxisAlignedBB(negNums, posNums = this.getPosRangePosEntity(world, pedestalPos, 1, enumfacing == Direction.NORTH || enumfacing == Direction.EAST || enumfacing == Direction.SOUTH || enumfacing == Direction.WEST ? -range - 1 : -range));
                    List itemList = world.func_217357_a(ItemEntity.class, getBox);
                    if (itemList.size() > 0) {
                        this.upgradeActionMagnet(pedestal, world, itemList, itemInPedestal, pedestalPos);
                    }
                }
                if (world.func_82737_E() % (long)speed == 0L) {
                    int inPed;
                    int maxsize = pedestal.hasItem() ? pedestal.getItemInPedestal().func_77976_d() : 64;
                    int n = inPed = pedestal.hasItem() ? pedestal.getItemInPedestal().func_190916_E() : 0;
                    if (inPed < maxsize) {
                        this.upgradeAction(pedestal);
                    }
                }
            }
        }
    }

    public void upgradeAction(PedestalTileEntity pedestal) {
        World world = pedestal.func_145831_w();
        BlockPos posOfPedestal = pedestal.func_174877_v();
        ItemStack coinInPedestal = pedestal.getCoinOnPedestal();
        ItemStack toolInPedestal = pedestal.getToolOnPedestal();
        int range = this.getRange(coinInPedestal);
        FakePlayer fakePlayer = (FakePlayer)this.fakePedestalPlayer(pedestal).get();
        if (fakePlayer != null) {
            fakePlayer.func_174810_b(true);
            if (!fakePlayer.func_233580_cy_().equals((Object)new BlockPos(posOfPedestal.func_177958_n(), posOfPedestal.func_177956_o(), posOfPedestal.func_177952_p()))) {
                fakePlayer.func_70107_b((double)posOfPedestal.func_177958_n(), (double)posOfPedestal.func_177956_o(), (double)posOfPedestal.func_177952_p());
            }
            ItemStack pickaxe = pedestal.hasTool() ? pedestal.getToolOnPedestal() : new ItemStack((IItemProvider)Items.field_151046_w, 1);
            BlockPos posOfBlock = this.getPosOfBlockBelow(world, posOfPedestal, range);
            BlockState blockToBreak = world.func_180495_p(posOfBlock);
            if (!pedestal.hasTool()) {
                pickaxe = this.getToolDefaultEnchanted(coinInPedestal, pickaxe);
            }
            ToolType tool = blockToBreak.getHarvestTool();
            int toolLevel = pickaxe.getHarvestLevel(tool, null, blockToBreak);
            ServerWorld sworld = world.func_73046_m().func_71218_a(world.func_234923_W_());
            if (!blockToBreak.func_196958_f()) {
                BlockEvent.BreakEvent e;
                if (!this.doItemsMatch(fakePlayer.func_184614_ca(), pickaxe)) {
                    fakePlayer.func_184201_a(EquipmentSlotType.MAINHAND, pickaxe);
                }
                if (this.canMineBlock(pedestal, posOfBlock, (PlayerEntity)fakePlayer) && ForgeEventFactory.doPlayerHarvestCheck((PlayerEntity)fakePlayer, (BlockState)blockToBreak, (boolean)true) && !MinecraftForge.EVENT_BUS.post((Event)(e = new BlockEvent.BreakEvent(world, posOfBlock, blockToBreak, (PlayerEntity)fakePlayer)))) {
                    blockToBreak.func_177230_c().func_180657_a(world, (PlayerEntity)fakePlayer, posOfBlock, blockToBreak, null, fakePlayer.func_184614_ca());
                    blockToBreak.func_177230_c().func_176208_a(world, posOfBlock, blockToBreak, (PlayerEntity)fakePlayer);
                    int expdrop = blockToBreak.func_177230_c().getExpDrop(blockToBreak, (IWorldReader)world, posOfBlock, EnchantmentHelper.func_82781_a((ItemStack)fakePlayer.func_184614_ca()).containsKey(Enchantments.field_185308_t) ? EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185308_t, (ItemStack)fakePlayer.func_184614_ca()) : 0, EnchantmentHelper.func_82781_a((ItemStack)fakePlayer.func_184614_ca()).containsKey(Enchantments.field_185306_r) ? EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185306_r, (ItemStack)fakePlayer.func_184614_ca()) : 0);
                    if (expdrop > 0) {
                        blockToBreak.func_177230_c().func_180637_b(sworld, posOfPedestal, expdrop);
                    }
                    world.func_217377_a(posOfBlock, false);
                }
            }
        }
    }

    @Override
    public boolean canMineBlock(PedestalTileEntity pedestal, BlockPos blockToMinePos, PlayerEntity player) {
        boolean advanced;
        World world = pedestal.func_145831_w();
        BlockPos pedestalPos = pedestal.func_174877_v();
        ItemStack coinInPedestal = pedestal.getCoinOnPedestal();
        BlockState blockToMineState = world.func_180495_p(blockToMinePos);
        Block blockToMine = blockToMineState.func_177230_c();
        ITag ADVANCED = BlockTags.func_199896_a().func_199910_a(new ResourceLocation("pedestals", "quarry/advanced"));
        ITag BLACKLIST = BlockTags.func_199896_a().func_199910_a(new ResourceLocation("pedestals", "quarry/blacklist"));
        boolean bl = ADVANCED.func_230235_a_((Object)blockToMine) ? this.hasAdvancedInventoryTargeting(coinInPedestal) : (advanced = true);
        return !blockToMine.isAir(blockToMineState, (IBlockReader)world, blockToMinePos) && !(blockToMine instanceof PedestalBlock) && this.passesFilter(world, pedestalPos, blockToMine) && !(blockToMine instanceof IFluidBlock) && !(blockToMine instanceof FlowingFluidBlock) && blockToMineState.func_185887_b((IBlockReader)world, blockToMinePos) != -1.0f && !BLACKLIST.func_230235_a_((Object)blockToMine) && advanced;
    }

    @Override
    public boolean canMineBlock(PedestalTileEntity pedestal, BlockPos blockToMinePos) {
        boolean advanced;
        World world = pedestal.func_145831_w();
        BlockPos pedestalPos = pedestal.func_174877_v();
        ItemStack coinInPedestal = pedestal.getCoinOnPedestal();
        BlockState blockToMineState = world.func_180495_p(blockToMinePos);
        Block blockToMine = blockToMineState.func_177230_c();
        ITag ADVANCED = BlockTags.func_199896_a().func_199910_a(new ResourceLocation("pedestals", "quarry/advanced"));
        ITag BLACKLIST = BlockTags.func_199896_a().func_199910_a(new ResourceLocation("pedestals", "quarry/blacklist"));
        boolean bl = ADVANCED.func_230235_a_((Object)blockToMine) ? this.hasAdvancedInventoryTargeting(coinInPedestal) : (advanced = true);
        return !blockToMine.isAir(blockToMineState, (IBlockReader)world, blockToMinePos) && !(blockToMine instanceof PedestalBlock) && this.passesFilter(world, pedestalPos, blockToMine) && !(blockToMine instanceof IFluidBlock) && !(blockToMine instanceof FlowingFluidBlock) && blockToMineState.func_185887_b((IBlockReader)world, blockToMinePos) != -1.0f && !BLACKLIST.func_230235_a_((Object)blockToMine) && advanced;
    }

    @Override
    public boolean passesFilter(World world, BlockPos posPedestal, Block blockIn) {
        Item filterInPedestal;
        PedestalTileEntity pedestal;
        boolean returner = true;
        if (world.func_175625_s(posPedestal) instanceof PedestalTileEntity && (pedestal = (PedestalTileEntity)world.func_175625_s(posPedestal)).hasFilter() && (filterInPedestal = pedestal.getFilterInPedestal().func_77973_b()) instanceof IFilterBase) {
            returner = ((IFilterBase)filterInPedestal).canAcceptItem(pedestal, new ItemStack((IItemProvider)blockIn));
        }
        return returner;
    }

    @Override
    public void chatDetails(PlayerEntity player, PedestalTileEntity pedestal) {
        ItemStack stack = pedestal.getCoinOnPedestal();
        TranslationTextComponent name = new TranslationTextComponent(this.func_77658_a() + ".tooltip_name");
        name.func_240699_a_(TextFormatting.GOLD);
        player.func_145747_a((ITextComponent)name, Util.field_240973_b_);
        TranslationTextComponent range = new TranslationTextComponent(this.func_77658_a() + ".chat_range");
        range.func_240702_b_("" + this.getRange(stack) + "");
        range.func_240699_a_(TextFormatting.WHITE);
        player.func_145747_a((ITextComponent)range, Util.field_240973_b_);
        ItemStack toolStack = pedestal.hasTool() ? pedestal.getToolOnPedestal() : new ItemStack((IItemProvider)Items.field_151046_w);
        TranslationTextComponent tool = new TranslationTextComponent(this.func_77658_a() + ".chat_tool");
        tool.func_230529_a_(toolStack.func_200301_q());
        tool.func_240699_a_(TextFormatting.BLUE);
        player.func_145747_a((ITextComponent)tool, Util.field_240973_b_);
        Map map = EnchantmentHelper.func_82781_a((ItemStack)(pedestal.hasTool() ? pedestal.getToolOnPedestal() : stack));
        if (this.hasAdvancedInventoryTargeting(stack)) {
            map.put(EnchantmentRegistry.ADVANCED, 1);
        }
        if (map.size() > 0 && this.getNumNonPedestalEnchants(map) > 0) {
            TranslationTextComponent enchant = new TranslationTextComponent(this.func_77658_a() + ".chat_enchants");
            enchant.func_240699_a_(TextFormatting.LIGHT_PURPLE);
            player.func_145747_a((ITextComponent)enchant, Util.field_240973_b_);
            for (Map.Entry entry : map.entrySet()) {
                Enchantment enchantment = (Enchantment)entry.getKey();
                Integer integer = (Integer)entry.getValue();
                if (enchantment instanceof EnchantmentCapacity || enchantment instanceof EnchantmentRange || enchantment instanceof EnchantmentOperationSpeed || enchantment instanceof EnchantmentArea) continue;
                TranslationTextComponent enchants = new TranslationTextComponent(" - " + enchantment.func_200305_d(integer.intValue()).getString());
                enchants.func_240699_a_(TextFormatting.GRAY);
                player.func_145747_a((ITextComponent)enchants, Util.field_240973_b_);
            }
        }
        TranslationTextComponent speed = new TranslationTextComponent(this.func_77658_a() + ".chat_speed");
        speed.func_240702_b_(this.getOperationSpeedString(stack));
        speed.func_240699_a_(TextFormatting.RED);
        player.func_145747_a((ITextComponent)speed, Util.field_240973_b_);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        TranslationTextComponent range = new TranslationTextComponent(this.func_77658_a() + ".tooltip_range");
        range.func_240702_b_("" + this.getRange(stack) + "");
        TranslationTextComponent speed = new TranslationTextComponent(this.func_77658_a() + ".tooltip_speed");
        speed.func_240702_b_(this.getOperationSpeedString(stack));
        range.func_240699_a_(TextFormatting.WHITE);
        tooltip.add((ITextComponent)range);
        speed.func_240699_a_(TextFormatting.RED);
        tooltip.add((ITextComponent)speed);
    }

    @SubscribeEvent
    public static void onItemRegistryReady(RegistryEvent.Register<Item> event) {
        event.getRegistry().register((IForgeRegistryEntry)BREAKER);
    }
}

