/*
 * Decompiled with CFR 0.152.
 */
package com.mowmaster.pedestals.item.pedestalUpgrades;

import com.mowmaster.pedestals.api.filter.IFilterBase;
import com.mowmaster.pedestals.api.upgrade.IUpgradeBase;
import com.mowmaster.pedestals.crafting.CalculateColor;
import com.mowmaster.pedestals.item.ItemUpgradeTool;
import com.mowmaster.pedestals.item.pedestalUpgrades.ItemUpgradeBase;
import com.mowmaster.pedestals.pedestals;
import com.mowmaster.pedestals.tiles.PedestalTileEntity;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractRailBlock;
import net.minecraft.block.BlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.BoatEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.Util;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.extensions.IForgeEntityMinecart;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class ItemUpgradeBaseFluid
extends ItemUpgradeBase {
    public ItemUpgradeBaseFluid(Item.Properties builder) {
        super(builder.func_200916_a(pedestals.PEDESTALS_TAB));
    }

    @Override
    public boolean isBookEnchantable(ItemStack stack, ItemStack book) {
        return super.isBookEnchantable(stack, book);
    }

    @Override
    public boolean func_77616_k(ItemStack stack) {
        return true;
    }

    @Override
    public int getComparatorRedstoneLevel(World worldIn, BlockPos pos) {
        PedestalTileEntity pedestal;
        ItemStack coin;
        int intItem = 0;
        TileEntity tileEntity = worldIn.func_175625_s(pos);
        if (tileEntity instanceof PedestalTileEntity && this.hasFluidInCoin(coin = (pedestal = (PedestalTileEntity)tileEntity).getCoinOnPedestal())) {
            float f = (float)this.getFluidStored(coin).getAmount() / (float)this.readMaxFluidFromNBT(coin);
            intItem = MathHelper.func_76141_d((float)(f * 14.0f)) + 1;
        }
        return intItem;
    }

    public void setMaxFluid(ItemStack stack, int value) {
        this.writeMaxFluidToNBT(stack, value);
    }

    public int getFluidTransferRate(ItemStack stack) {
        int fluidTransferRate = this.getCapacityModifierOverEnchanted(stack) * 4000;
        switch (this.getCapacityModifierOverEnchanted(stack)) {
            case 0: {
                fluidTransferRate = 1000;
                break;
            }
            case 1: {
                fluidTransferRate = 2000;
                break;
            }
            case 2: {
                fluidTransferRate = 4000;
                break;
            }
            case 3: {
                fluidTransferRate = 6000;
                break;
            }
            case 4: {
                fluidTransferRate = 10000;
                break;
            }
            case 5: {
                fluidTransferRate = 20000;
                break;
            }
            default: {
                fluidTransferRate = fluidTransferRate > this.maxStored ? this.maxStored : fluidTransferRate;
            }
        }
        return fluidTransferRate;
    }

    public static boolean isFluidItem(ItemStack itemToCheck) {
        LazyOptional cap = itemToCheck.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY);
        return cap.isPresent();
    }

    public boolean fluidMatchFilter(PedestalTileEntity pedestalReceiving, FluidStack incomingFluidStack) {
        if (pedestalReceiving.hasFilter()) {
            ItemStack filter = pedestalReceiving.getFilterInPedestal();
            Item item = incomingFluidStack.getFluid().func_204524_b();
            ItemStack incomingBucket = new ItemStack((IItemProvider)item);
            if (filter.func_77973_b() instanceof IFilterBase) {
                return ((IFilterBase)filter.func_77973_b()).canAcceptItem(pedestalReceiving, incomingBucket);
            }
        }
        return true;
    }

    public static LazyOptional<IFluidHandler> findFluidHandlerAtPos(World world, BlockPos pos, Direction side, boolean allowCart) {
        LazyOptional cap;
        TileEntity neighbourTile = world.func_175625_s(pos);
        if (neighbourTile != null && (cap = neighbourTile.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, side)).isPresent()) {
            return cap;
        }
        if (allowCart) {
            List list;
            if (AbstractRailBlock.func_208488_a((World)world, (BlockPos)pos)) {
                LazyOptional cap2;
                list = world.func_175674_a(null, new AxisAlignedBB(pos), entity -> entity instanceof IForgeEntityMinecart);
                if (!list.isEmpty() && (cap2 = ((Entity)list.get(world.field_73012_v.nextInt(list.size()))).getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY)).isPresent()) {
                    return cap2;
                }
            } else {
                LazyOptional cap3;
                list = world.func_175674_a(null, new AxisAlignedBB(pos), entity -> entity instanceof BoatEntity);
                if (!list.isEmpty() && (cap3 = ((Entity)list.get(world.field_73012_v.nextInt(list.size()))).getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY)).isPresent()) {
                    return cap3;
                }
            }
        }
        return LazyOptional.empty();
    }

    public boolean canRecieveFluid(World world, BlockPos posPedestal, FluidStack fluidIncoming) {
        return true;
    }

    public void upgradeActionSendFluid(PedestalTileEntity pedestal) {
        World world = pedestal.func_145831_w();
        PedestalTileEntity mainPedestalTile = pedestal;
        ItemStack mainPedestalCoin = mainPedestalTile.getCoinOnPedestal();
        BlockPos mainPedestalPos = mainPedestalTile.func_174877_v();
        FluidStack mainPedestalFluid = this.getFluidStored(mainPedestalCoin);
        int mainPedestalFluidAmount = mainPedestalFluid.getAmount();
        if (mainPedestalFluidAmount > 0 && mainPedestalTile.getNumberOfStoredLocations() > 0) {
            for (int i = 0; i < mainPedestalTile.getNumberOfStoredLocations(); ++i) {
                ItemUpgradeBaseFluid storedCoinItem;
                FluidStack storedCoinFluid;
                PedestalTileEntity storedPedestalTile;
                ItemStack storedPedestalCoin;
                TileEntity storedPedestal;
                BlockPos posStoredPedestal = mainPedestalTile.getStoredPositionAt(i);
                if (world.func_175640_z(posStoredPedestal) || !world.func_175667_e(posStoredPedestal) || posStoredPedestal == mainPedestalPos || !((storedPedestal = world.func_175625_s(posStoredPedestal)) instanceof PedestalTileEntity) || !((storedPedestalCoin = (storedPedestalTile = (PedestalTileEntity)storedPedestal).getCoinOnPedestal()).func_77973_b() instanceof ItemUpgradeBaseFluid) || !(storedCoinFluid = (storedCoinItem = (ItemUpgradeBaseFluid)storedPedestalCoin.func_77973_b()).getFluidStored(storedPedestalCoin)).isFluidEqual(mainPedestalFluid) && (!storedCoinFluid.isEmpty() || !storedCoinItem.canRecieveFluid(world, posStoredPedestal, mainPedestalFluid)) || !this.fluidMatchFilter(storedPedestalTile, mainPedestalFluid)) continue;
                int storedCoinFluidSpace = storedCoinItem.availableFluidSpaceInCoin(storedPedestalCoin);
                int storedCoinFluidAmount = storedCoinFluid.getAmount();
                if (storedCoinFluidSpace <= 0) continue;
                int getMainTransferRate = this.getFluidTransferRate(mainPedestalCoin);
                int transferRate = getMainTransferRate <= storedCoinFluidSpace ? getMainTransferRate : storedCoinFluidSpace;
                FluidStack fluidToStore = new FluidStack(mainPedestalFluid.getFluid(), transferRate, mainPedestalFluid.getTag());
                if (this.addFluid(pedestal, storedPedestalCoin, fluidToStore, true) && this.removeFluid(pedestal, mainPedestalCoin, transferRate, true)) {
                    this.removeFluid(pedestal, mainPedestalCoin, transferRate, false);
                    mainPedestalTile.update();
                    this.addFluid(pedestal, storedPedestalCoin, fluidToStore, false);
                    storedPedestalTile.update();
                    if (!(storedPedestalTile.getCoinOnPedestal().func_77973_b() instanceof IUpgradeBase)) continue;
                    ((IUpgradeBase)storedPedestalTile.getCoinOnPedestal().func_77973_b()).notifyTransferUpdate(storedPedestalTile);
                    continue;
                }
                mainPedestalFluid = this.getFluidStored(mainPedestalCoin);
                mainPedestalFluidAmount = mainPedestalFluid.getAmount();
                storedCoinFluid = storedCoinItem.getFluidStored(storedPedestalCoin);
                storedCoinFluidSpace = storedCoinItem.availableFluidSpaceInCoin(storedPedestalCoin);
                storedCoinFluidAmount = storedCoinFluid.getAmount();
                getMainTransferRate = this.getFluidTransferRate(mainPedestalCoin);
                transferRate = getMainTransferRate <= storedCoinFluidSpace ? getMainTransferRate : storedCoinFluidSpace;
                int storedFluidRemaining = storedCoinFluidAmount + transferRate;
                int fluidLeftToSend = mainPedestalFluidAmount <= transferRate ? mainPedestalFluidAmount : transferRate;
                fluidToStore = new FluidStack(mainPedestalFluid.getFluid(), fluidLeftToSend, mainPedestalFluid.getTag());
                if (!this.addFluid(pedestal, storedPedestalCoin, fluidToStore, true) || !this.removeFluid(pedestal, mainPedestalCoin, fluidLeftToSend, true)) continue;
                this.removeFluid(pedestal, mainPedestalCoin, fluidLeftToSend, false);
                mainPedestalTile.update();
                this.addFluid(pedestal, storedPedestalCoin, fluidToStore, false);
                storedPedestalTile.update();
                if (!(storedPedestalTile.getCoinOnPedestal().func_77973_b() instanceof IUpgradeBase)) continue;
                ((IUpgradeBase)storedPedestalTile.getCoinOnPedestal().func_77973_b()).notifyTransferUpdate(storedPedestalTile);
            }
        }
    }

    public ActionResult<ItemStack> func_77659_a(World p_77659_1_, PlayerEntity p_77659_2_, Hand p_77659_3_) {
        if (!p_77659_1_.field_72995_K) {
            FluidStack fluidIn;
            ItemStack wand = p_77659_2_.func_184592_cb();
            ItemStack coin = p_77659_2_.func_184614_ca();
            if (wand.func_77973_b() instanceof ItemUpgradeTool && this.hasFluidInCoin(coin) && this.removeFluidFromItem(coin, (fluidIn = this.getFluidStored(coin)).getAmount(), true)) {
                this.removeFluidFromItem(coin, fluidIn.getAmount(), false);
                p_77659_1_.func_184148_a(p_77659_2_, (double)p_77659_2_.func_233580_cy_().func_177958_n(), (double)p_77659_2_.func_233580_cy_().func_177956_o(), (double)p_77659_2_.func_233580_cy_().func_177952_p(), SoundEvents.field_187624_K, SoundCategory.BLOCKS, 0.25f, 1.0f);
                TranslationTextComponent output = new TranslationTextComponent("Fluid Cleared");
                output.func_240699_a_(TextFormatting.WHITE);
                p_77659_2_.func_145747_a((ITextComponent)output, p_77659_2_.func_110124_au());
            }
        }
        return super.func_77659_a(p_77659_1_, p_77659_2_, p_77659_3_);
    }

    public int availableFluidSpaceInCoin(ItemStack coin) {
        FluidStack currentFluid = this.getFluidStored(coin);
        if (currentFluid.isEmpty()) {
            return this.getFluidbuffer(coin);
        }
        int currentlyStored = currentFluid.getAmount();
        int max = this.readMaxFluidFromNBT(coin);
        return max - currentlyStored;
    }

    public boolean canAddFluidToCoin(PedestalTileEntity pedestal, ItemStack coin, FluidStack fluidIn) {
        FluidStack currentFluid = this.getFluidStored(coin);
        if (currentFluid.isEmpty() || currentFluid.isFluidEqual(fluidIn)) {
            return this.addFluid(pedestal, coin, fluidIn, true);
        }
        return false;
    }

    public boolean removeFluidFromItem(ItemStack stack, int amount, boolean simulate) {
        FluidStack old;
        int currentAmount;
        int newAmount;
        CompoundNBT compound = new CompoundNBT();
        if (stack.func_77942_o()) {
            compound = stack.func_77978_p();
        }
        if ((newAmount = (currentAmount = (old = FluidStack.loadFluidStackFromNBT((CompoundNBT)compound)).getAmount()) - amount) >= 0) {
            if (!simulate) {
                FluidStack newStack = new FluidStack(old.getFluid(), newAmount, old.getTag());
                if (newAmount == 0) {
                    newStack = FluidStack.EMPTY;
                }
                this.setFluidStoredItem(stack, newStack);
            }
            return true;
        }
        return false;
    }

    public boolean removeFluid(PedestalTileEntity pedestal, ItemStack coin, int amount, boolean simulate) {
        FluidStack old;
        int currentAmount;
        int newAmount;
        CompoundNBT compound = new CompoundNBT();
        if (coin.func_77942_o()) {
            compound = coin.func_77978_p();
        }
        if ((newAmount = (currentAmount = (old = FluidStack.loadFluidStackFromNBT((CompoundNBT)compound)).getAmount()) - amount) >= 0) {
            if (!simulate) {
                FluidStack newStack = new FluidStack(old.getFluid(), newAmount, old.getTag());
                if (newAmount == 0) {
                    newStack = FluidStack.EMPTY;
                }
                this.setFluidStored(pedestal, coin, newStack);
            }
            return true;
        }
        return false;
    }

    public boolean removeFluid(PedestalTileEntity pedestal, ItemStack stack, FluidStack fluid, boolean simulate) {
        FluidStack old;
        CompoundNBT compound = new CompoundNBT();
        if (stack.func_77942_o()) {
            compound = stack.func_77978_p();
        }
        if ((old = FluidStack.loadFluidStackFromNBT((CompoundNBT)compound)).isEmpty() || old.isFluidEqual(fluid)) {
            if (!simulate) {
                int currentAmount = old.getAmount();
                int newAmount = fluid.getAmount() + currentAmount;
                FluidStack newStack = new FluidStack(fluid, newAmount);
                this.setFluidStored(pedestal, stack, newStack);
            }
            return true;
        }
        return false;
    }

    public boolean addFluid(PedestalTileEntity pedestal, ItemStack coin, FluidStack fluid, boolean simulate) {
        FluidStack old;
        CompoundNBT compound = new CompoundNBT();
        if (coin.func_77942_o()) {
            compound = coin.func_77978_p();
        }
        if ((old = FluidStack.loadFluidStackFromNBT((CompoundNBT)compound)).isEmpty() || old.isFluidEqual(fluid)) {
            if (!simulate) {
                int currentAmount = old.getAmount();
                int newAmount = fluid.getAmount() + currentAmount;
                FluidStack newStack = new FluidStack(fluid, newAmount);
                this.setFluidStored(pedestal, coin, newStack);
            }
            return true;
        }
        return false;
    }

    public void setFluidStoredItem(ItemStack stack, FluidStack fluid) {
        CompoundNBT compound = new CompoundNBT();
        if (stack.func_77942_o()) {
            compound = stack.func_77978_p();
        }
        compound = fluid.writeToNBT(compound);
        stack.func_77982_d(compound);
    }

    public void setFluidStored(PedestalTileEntity pedestal, ItemStack stack, FluidStack fluid) {
        CompoundNBT compound = new CompoundNBT();
        if (stack.func_77942_o()) {
            compound = stack.func_77978_p();
        }
        compound = fluid.writeToNBT(compound);
        stack.func_77982_d(compound);
        pedestal.update();
    }

    public boolean hasFluidInCoin(ItemStack stack) {
        return !this.getFluidStored(stack).isEmpty();
    }

    public FluidStack getFluidStored(ItemStack stack) {
        if (stack.func_77942_o()) {
            CompoundNBT getCompound = stack.func_77978_p();
            return FluidStack.loadFluidStackFromNBT((CompoundNBT)getCompound);
        }
        return FluidStack.EMPTY;
    }

    public boolean hasMaxFluidSet(ItemStack stack) {
        boolean returner = false;
        CompoundNBT compound = new CompoundNBT();
        if (stack.func_77942_o() && (compound = stack.func_77978_p()).func_74764_b("maxfluid")) {
            returner = true;
        }
        return returner;
    }

    public void writeMaxFluidToNBT(ItemStack stack, int value) {
        CompoundNBT compound = new CompoundNBT();
        if (stack.func_77942_o()) {
            compound = stack.func_77978_p();
        }
        compound.func_74768_a("maxfluid", value);
        stack.func_77982_d(compound);
    }

    public int readMaxFluidFromNBT(ItemStack stack) {
        int maxenergy = 0;
        if (stack.func_77942_o()) {
            CompoundNBT getCompound = stack.func_77978_p();
            maxenergy = getCompound.func_74762_e("maxfluid");
        }
        return maxenergy;
    }

    public int getFluidbuffer(ItemStack stack) {
        int fluidBuffer = 10000;
        switch (this.getCapacityModifier(stack)) {
            case 0: {
                fluidBuffer = 10000;
                break;
            }
            case 1: {
                fluidBuffer = 20000;
                break;
            }
            case 2: {
                fluidBuffer = 40000;
                break;
            }
            case 3: {
                fluidBuffer = 60000;
                break;
            }
            case 4: {
                fluidBuffer = 80000;
                break;
            }
            case 5: {
                fluidBuffer = 100000;
                break;
            }
            default: {
                fluidBuffer = 10000;
            }
        }
        return fluidBuffer;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void onRandomDisplayTick(PedestalTileEntity pedestal, int tick, BlockState stateIn, World world, BlockPos pos, Random rand) {
        if (!pedestal.hasParticleDiffuser() && !world.func_175640_z(pos) && this.hasFluidInCoin(pedestal.getCoinOnPedestal())) {
            int color = this.getFluidStored(pedestal.getCoinOnPedestal()).getFluid().getAttributes().getColor();
            int[] rgb = CalculateColor.getRGBColorFromInt(color);
            this.spawnParticleAroundPedestalBase(world, tick, pos, (float)rgb[0] / 255.0f, (float)rgb[1] / 255.0f, (float)rgb[2] / 255.0f, 1.0f);
        }
    }

    @Override
    public void chatDetails(PlayerEntity player, PedestalTileEntity pedestal) {
        ItemStack stack = pedestal.getCoinOnPedestal();
        TranslationTextComponent name = new TranslationTextComponent(this.func_77658_a() + ".tooltip_name");
        name.func_240699_a_(TextFormatting.GOLD);
        player.func_145747_a((ITextComponent)name, Util.field_240973_b_);
        TranslationTextComponent fluid = new TranslationTextComponent(this.func_77658_a() + ".chat_fluid");
        FluidStack fluidStored = this.getFluidStored(stack);
        fluid.func_240702_b_("" + fluidStored.getDisplayName().toString() + "");
        fluid.func_240702_b_(" : ");
        fluid.func_240702_b_("" + fluidStored.getAmount() + "");
        fluid.func_240702_b_("mb");
        fluid.func_240699_a_(TextFormatting.BLUE);
        player.func_145747_a((ITextComponent)fluid, Util.field_240973_b_);
        TranslationTextComponent energyRate = new TranslationTextComponent(this.func_77658_a() + ".chat_fluidrate");
        energyRate.func_240702_b_("" + this.getFluidTransferRate(stack) + "");
        energyRate.func_240699_a_(TextFormatting.AQUA);
        player.func_145747_a((ITextComponent)energyRate, Util.field_240973_b_);
        TranslationTextComponent speed = new TranslationTextComponent(this.func_77658_a() + ".chat_speed");
        speed.func_240702_b_(this.getOperationSpeedString(stack));
        speed.func_240699_a_(TextFormatting.RED);
        player.func_145747_a((ITextComponent)speed, Util.field_240973_b_);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        TranslationTextComponent xpstored = new TranslationTextComponent(this.func_77658_a() + ".tooltip_fluidstored");
        xpstored.func_240702_b_("" + this.getFluidStored(stack).getAmount() + "");
        xpstored.func_240699_a_(TextFormatting.GREEN);
        tooltip.add((ITextComponent)xpstored);
        TranslationTextComponent xpcapacity = new TranslationTextComponent(this.func_77658_a() + ".tooltip_fluidcapacity");
        xpcapacity.func_240702_b_("" + this.getFluidbuffer(stack) + "");
        xpcapacity.func_240699_a_(TextFormatting.AQUA);
        tooltip.add((ITextComponent)xpcapacity);
        TranslationTextComponent rate = new TranslationTextComponent(this.func_77658_a() + ".tooltip_rate");
        rate.func_240702_b_("" + this.getFluidTransferRate(stack) + "");
        rate.func_240699_a_(TextFormatting.GRAY);
        tooltip.add((ITextComponent)rate);
        TranslationTextComponent speed = new TranslationTextComponent(this.func_77658_a() + ".tooltip_speed");
        speed.func_240702_b_(this.getOperationSpeedString(stack));
        speed.func_240699_a_(TextFormatting.RED);
        tooltip.add((ITextComponent)speed);
    }
}

