/*
 * Decompiled with CFR 0.152.
 */
package com.mowmaster.pedestals.item.pedestalUpgrades;

import com.mowmaster.pedestals.item.pedestalUpgrades.ItemUpgradeBase;
import com.mowmaster.pedestals.pedestals;
import com.mowmaster.pedestals.tiles.PedestalTileEntity;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ExperienceOrbEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ItemUpgradeBaseExp
extends ItemUpgradeBase {
    public ItemUpgradeBaseExp(Item.Properties builder) {
        super(builder.func_200916_a(pedestals.PEDESTALS_TAB));
    }

    @Override
    public boolean isBookEnchantable(ItemStack stack, ItemStack book) {
        return super.isBookEnchantable(stack, book);
    }

    @Override
    public boolean func_77616_k(ItemStack stack) {
        return true;
    }

    @Override
    public int getComparatorRedstoneLevel(World worldIn, BlockPos pos) {
        PedestalTileEntity pedestal;
        ItemStack coin;
        int intItem = 0;
        TileEntity tileEntity = worldIn.func_175625_s(pos);
        if (tileEntity instanceof PedestalTileEntity && this.getXPStored(coin = (pedestal = (PedestalTileEntity)tileEntity).getCoinOnPedestal()) > 0) {
            float f = (float)this.getXPStored(coin) / (float)this.readMaxXpFromNBT(coin);
            intItem = MathHelper.func_76141_d((float)(f * 14.0f)) + 1;
        }
        return intItem;
    }

    public void setMaxXP(ItemStack stack, int value) {
        this.writeMaxXpToNBT(stack, value);
    }

    public int getExpTransferRate(ItemStack stack) {
        int overEnchanted = this.getExpCountByLevel(this.getCapacityModifierOverEnchanted(stack) * 5 + 5);
        return overEnchanted >= 20000 ? 20000 : overEnchanted;
    }

    public int getExpTransferRateLevel(ItemStack stack) {
        int overEnchanted = this.getCapacityModifierOverEnchanted(stack) * 5 + 5;
        return overEnchanted >= 20000 ? 20000 : overEnchanted;
    }

    public String getExpTransferRateString(ItemStack stack) {
        return "" + this.getExpTransferRateLevel(stack) + "";
    }

    public static int removeXp(PlayerEntity player, int amount) {
        int startAmount = amount;
        while (amount > 0) {
            int barCap = player.func_71050_bK();
            int barXp = (int)((float)barCap * player.field_71106_cc);
            int removeXp = Math.min(barXp, amount);
            int newBarXp = barXp - removeXp;
            amount -= removeXp;
            player.field_71067_cb -= removeXp;
            if (player.field_71067_cb < 0) {
                player.field_71067_cb = 0;
            }
            if (newBarXp == 0 && amount > 0) {
                --player.field_71068_ca;
                if (player.field_71068_ca < 0) {
                    player.field_71068_ca = 0;
                    player.field_71067_cb = 0;
                    player.field_71106_cc = 0.0f;
                    break;
                }
                player.field_71106_cc = 1.0f;
                continue;
            }
            player.field_71106_cc = (float)newBarXp / (float)barCap;
        }
        return startAmount - amount;
    }

    public void upgradeActionSendExp(PedestalTileEntity pedestal) {
        World world = pedestal.func_145831_w();
        ItemStack coinMainPedestal = pedestal.getCoinOnPedestal();
        BlockPos posMainPedestal = pedestal.func_174877_v();
        int xpMainPedestal = this.getXPStored(coinMainPedestal);
        if (xpMainPedestal > 0 && pedestal.getNumberOfStoredLocations() > 0) {
            for (int i = 0; i < pedestal.getNumberOfStoredLocations(); ++i) {
                PedestalTileEntity tileStoredPedestal;
                ItemStack coinStoredPedestal;
                TileEntity storedPedestal;
                BlockPos posStoredPedestal = pedestal.getStoredPositionAt(i);
                if (world.func_175640_z(posStoredPedestal) || !world.func_175667_e(posStoredPedestal) || posStoredPedestal == posMainPedestal || !((storedPedestal = world.func_175625_s(posStoredPedestal)) instanceof PedestalTileEntity) || !((coinStoredPedestal = (tileStoredPedestal = (PedestalTileEntity)storedPedestal).getCoinOnPedestal()).func_77973_b() instanceof ItemUpgradeBaseExp)) continue;
                int xpMaxStoredPedestal = ((ItemUpgradeBaseExp)coinStoredPedestal.func_77973_b()).readMaxXpFromNBT(coinStoredPedestal);
                int xpStoredPedestal = this.getXPStored(coinStoredPedestal);
                if (xpStoredPedestal >= xpMaxStoredPedestal) continue;
                int transferRate = this.getExpTransferRate(coinMainPedestal);
                if (xpMainPedestal >= transferRate) {
                    int xpRemainingMainPedestal = xpMainPedestal - transferRate;
                    int xpRemainingStoredPedestal = xpStoredPedestal + transferRate;
                    if (!pedestal.hasMuffler()) {
                        world.func_184148_a((PlayerEntity)null, (double)posMainPedestal.func_177958_n(), (double)posMainPedestal.func_177956_o(), (double)posMainPedestal.func_177952_p(), SoundEvents.field_187601_be, SoundCategory.BLOCKS, 0.05f, 1.0f);
                    }
                    this.setXPStored(coinMainPedestal, xpRemainingMainPedestal);
                    pedestal.update();
                    if (!pedestal.hasMuffler()) {
                        world.func_184148_a((PlayerEntity)null, (double)posStoredPedestal.func_177958_n(), (double)posStoredPedestal.func_177956_o(), (double)posStoredPedestal.func_177952_p(), SoundEvents.field_187604_bf, SoundCategory.BLOCKS, 0.05f, 1.0f);
                    }
                    this.setXPStored(coinStoredPedestal, xpRemainingStoredPedestal);
                    tileStoredPedestal.update();
                    break;
                }
                int xpRemainingMainPedestal = 0;
                int xpRemainingStoredPedestal = xpStoredPedestal + xpMainPedestal;
                if (!pedestal.hasMuffler()) {
                    world.func_184148_a((PlayerEntity)null, (double)posMainPedestal.func_177958_n(), (double)posMainPedestal.func_177956_o(), (double)posMainPedestal.func_177952_p(), SoundEvents.field_187601_be, SoundCategory.BLOCKS, 0.05f, 1.0f);
                }
                this.setXPStored(coinMainPedestal, xpRemainingMainPedestal);
                pedestal.update();
                if (!pedestal.hasMuffler()) {
                    world.func_184148_a((PlayerEntity)null, (double)posStoredPedestal.func_177958_n(), (double)posStoredPedestal.func_177956_o(), (double)posStoredPedestal.func_177952_p(), SoundEvents.field_187604_bf, SoundCategory.BLOCKS, 0.05f, 1.0f);
                }
                this.setXPStored(coinStoredPedestal, xpRemainingStoredPedestal);
                tileStoredPedestal.update();
                break;
            }
        }
    }

    @Override
    public void actionOnCollideWithBlock(World world, PedestalTileEntity tilePedestal, BlockPos posPedestal, BlockState state, Entity entityIn) {
        if (entityIn instanceof ExperienceOrbEntity) {
            int currentlyStoredExp;
            ItemStack coin = tilePedestal.getCoinOnPedestal();
            ExperienceOrbEntity getXPFromList = (ExperienceOrbEntity)entityIn;
            if (!tilePedestal.hasMuffler()) {
                world.func_184148_a((PlayerEntity)null, (double)posPedestal.func_177958_n(), (double)posPedestal.func_177956_o(), (double)posPedestal.func_177952_p(), SoundEvents.field_187604_bf, SoundCategory.BLOCKS, 0.15f, 1.0f);
            }
            if ((currentlyStoredExp = this.getXPStored(coin)) < this.readMaxXpFromNBT(coin)) {
                int value = getXPFromList.func_70526_d();
                getXPFromList.func_70106_y();
                this.setXPStored(coin, currentlyStoredExp + value);
                tilePedestal.update();
            }
        }
    }

    public int getExpCountByLevel(int level) {
        int expUsed = 0;
        if (level <= 16) {
            expUsed = level * level + 6 * level;
        } else if (level > 16 && level <= 31) {
            expUsed = (int)(2.5 * (double)(level * level) - 40.5 * (double)level + 360.0);
        } else if (level > 31) {
            expUsed = (int)(4.5 * (double)(level * level) - 162.5 * (double)level + 2220.0);
        }
        return expUsed;
    }

    public int getExpLevelFromCount(int value) {
        boolean level = false;
        long maths = 0L;
        int i = 0;
        boolean j = false;
        if (value > 0 && value <= 352) {
            maths = (long)Math.sqrt(Math.addExact(36L, Math.addExact(4L, (long)value)));
            i = Math.round(Math.addExact(-6L, maths) / 2L);
        }
        if (value > 352 && value <= 1507) {
            maths = (long)Math.sqrt(Math.subtractExact(164025L, Math.multiplyExact(100L, Math.subtractExact(3600L, Math.multiplyExact(10L, (long)value)))));
            i = (int)(Math.addExact(405L, maths) / 50L);
        }
        if (value > 1507) {
            maths = (long)Math.sqrt(Math.subtractExact(2640625L, Math.multiplyExact(180L, Math.subtractExact(22200L, Math.multiplyExact(10L, (long)value)))));
            i = (int)(Math.addExact(1625L, maths) / 90L);
        }
        return Math.abs(i);
    }

    public int spaceForXP(ItemStack coin) {
        int stored;
        int max = this.readMaxXpFromNBT(coin);
        int space = max - (stored = this.getXPStored(coin));
        return space > 0 ? space : 0;
    }

    public void setXPStored(ItemStack stack, int value) {
        CompoundNBT compound = new CompoundNBT();
        if (stack.func_77942_o()) {
            compound = stack.func_77978_p();
        }
        compound.func_74768_a("xpstored", value);
        stack.func_77982_d(compound);
    }

    public int getXPStored(ItemStack stack) {
        int storedxp = 0;
        if (stack.func_77942_o()) {
            CompoundNBT getCompound = stack.func_77978_p();
            storedxp = getCompound.func_74762_e("xpstored");
        }
        return storedxp;
    }

    public boolean hasMaxXpSet(ItemStack stack) {
        boolean returner = false;
        CompoundNBT compound = new CompoundNBT();
        if (stack.func_77942_o() && (compound = stack.func_77978_p()).func_74764_b("maxxp")) {
            returner = true;
        }
        return returner;
    }

    public void writeMaxXpToNBT(ItemStack stack, int value) {
        CompoundNBT compound = new CompoundNBT();
        if (stack.func_77942_o()) {
            compound = stack.func_77978_p();
        }
        compound.func_74768_a("maxxp", value);
        stack.func_77982_d(compound);
    }

    public int readMaxXpFromNBT(ItemStack stack) {
        int maxxp = 0;
        if (stack.func_77942_o()) {
            CompoundNBT getCompound = stack.func_77978_p();
            maxxp = getCompound.func_74762_e("maxxp");
        }
        return maxxp;
    }

    public int getExpBuffer(ItemStack stack) {
        return 0;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void onRandomDisplayTick(PedestalTileEntity pedestal, int tick, BlockState stateIn, World world, BlockPos pos, Random rand) {
        if (!pedestal.hasParticleDiffuser() && !world.func_175640_z(pos) && this.getXPStored(pedestal.getCoinOnPedestal()) > 0) {
            this.spawnParticleAroundPedestalBase(world, tick, pos, 0.2f, 0.95f, 0.2f, 1.0f);
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        TranslationTextComponent xpstored = new TranslationTextComponent(this.func_77658_a() + ".tooltip_xpstored");
        xpstored.func_240702_b_("" + this.getExpLevelFromCount(this.getXPStored(stack)) + "");
        xpstored.func_240699_a_(TextFormatting.GREEN);
        tooltip.add((ITextComponent)xpstored);
        TranslationTextComponent xpcapacity = new TranslationTextComponent(this.func_77658_a() + ".tooltip_xpcapacity");
        TranslationTextComponent xpcapacitylvl = new TranslationTextComponent(this.func_77658_a() + ".tooltip_xpcapacitylvl");
        xpcapacity.func_240702_b_("" + this.getExpBuffer(stack) + "");
        xpcapacity.func_240702_b_(xpcapacitylvl.getString());
        xpcapacity.func_240699_a_(TextFormatting.AQUA);
        tooltip.add((ITextComponent)xpcapacity);
    }
}

